// Do not edit this file! Generated by Ragel 6.10.
// Ragel.exe -J -o ../../../../../src/com/badlogic/gdx/utils/PatternParser.java PatternParser.rl
/*******************************************************************************
 * Copyright 2025 See AUTHORS file.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/

package com.badlogic.gdx.utils;

import static com.badlogic.gdx.utils.JsonMatcher.*;

import com.badlogic.gdx.utils.JsonMatcher.Match;
import com.badlogic.gdx.utils.JsonMatcher.Node;
import com.badlogic.gdx.utils.JsonMatcher.Pattern;
import com.badlogic.gdx.utils.JsonMatcher.Processor;

/** Parses {@link JsonMatcher} patterns.
 * @author Nathan Sweet */
class PatternParser {
	static Pattern parse (JsonMatcher matcher, String text, @Null Processor processor) {
		char[] data = text.toCharArray();
		int cs, p = 0, pe = data.length, eof = pe;

		int s = 0, e = 0, c = -1;
		boolean escaped = false, quoted = false, brackets = false, at = false, keyCapture = false, star = false, starStar = false;
		Array<Match> matches = new Array(Match[]::new);

		Node root = null, prev = null, backtrack = null;
		boolean processEach = false, hasCapture = false;

		try {
			%%{
				machine parser;

				action nameStart { s = p; }
				action nameEnd { e = p; }
				action escaped { escaped = true; }
				action quoted { quoted = true; }
				action match {
					String name = new String(data, s, e - s);
					if (quoted) name = name.substring(1, name.length() - 1);
					if (escaped) name = name.replace("''", "'");
					Match match = matcher.newMatch(name, brackets, at, processEach, c >= 0, keyCapture, star, starStar);
					matches.add(match);

					// All subsequent matches are processed right away.
					if (starStar && (match.flags & process) != 0) processEach = true;

					escaped = false;
					quoted = false;
					brackets = false;
					at = false;
					keyCapture = false;
					star = false;
					starStar = false;
				}
				action brackets {
					brackets = true;
					if (c < 0) throw new IllegalArgumentException("[] must be within a capture.");
				}
				action at { at = true; }
				action keyCapture {
					star = true;
					keyCapture = true;
					hasCapture = true;
				}
				action star { star = true; }
				action starStar { starStar = true; }

				action startCapture { c = matches.size; }
				action endCapture {
					c = -1;
					hasCapture = true;
				}
				action atCaptures {
					for (int i = c, n = matches.size; i < n; i++)
						matches.get(i).flags |= process;
				}

				action addNode {
					Node node = matcher.newNode(matches.toArray(), processEach, backtrack, prev);
					if (node.starStar) {
						if (matches.size > 1) throw new IllegalArgumentException("** cannot have other matches at the same level.");
						backtrack = node;
					}
					matches.clear();
					if (root == null) root = node.prev != null ? node.prev : node;
					prev = node;
				}

				unquoted = [^*/()[\]@',]+;
				quoted = "'" ([^'] | "''" %escaped)* "'" %quoted;
				name = ("**" @starStar | "*" @star | "()" @keyCapture | unquoted | quoted) >nameStart %nameEnd;
				match = (name "[]"? @brackets "@"? @at) %match;
				captures = ("(" @startCapture match ("," match)* ")" "@"? @atCaptures) %endCapture;
				matches = captures | match;
				node = (matches ("," matches)*) %addNode;
				main := node ("/" node)*;

				write init;
				write exec;
			}%%

			if (p < pe) {
				int start = Math.max(0, p - 32);
				throw new IllegalArgumentException("Error parsing pattern near: " + new String(data, start, p - start) + "ERROR"
					+ new String(data, p, Math.min(64, pe - p)));
			}

			if (!hasCapture) throw new IllegalArgumentException("A capture is required.");
			return matcher.newPattern(root, processor);
		} catch (Exception ex) {
			throw new IllegalArgumentException("Error parsing pattern: " + text, ex);
		}
	}

	%%write data noerror nofinal noentry;
}
