let _ = Mltop.add_known_module "rocq-plugin-tutorial.tuto1"

# 5 "doc/plugin_tutorial/tuto1/src/g_tuto1.mlg"
 

(* If we forget this line and include our own tactic definition using
  TACTIC EXTEND, as below, then we get the strange error message
  no implementation available for Tacentries, only when compiling
  theories/Loader.v
*)
open Ltac_plugin
open Pp
(* This module defines the types of arguments to be used in the
   EXTEND directives below, for example the string one. *)
open Stdarg


# 19 "doc/plugin_tutorial/tuto1/src/g_tuto1.ml"

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-plugin-tutorial.tuto1") ~command:"WhatIsThis" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_query) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("What's",
           Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
           Vernacextend.TyNil)),
          (let coqpp_body e () = Vernactypes.vtdefault (fun () -> 
# 41 "doc/plugin_tutorial/tuto1/src/g_tuto1.mlg"
    
     let env = Global.env () in (* we'll explain later *)
     let sigma = Evd.from_env env in (* we'll explain later *)
     Inspector.print_input e (Ppconstr.pr_constr_expr env sigma) "term"
   
# 35 "doc/plugin_tutorial/tuto1/src/g_tuto1.ml"
) in
            fun e ?loc ~atts () ->
            coqpp_body e (Attributes.unsupported_attributes atts)),
          None));
         (Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("What",
           Vernacextend.TyTerminal
           ("kind",
            Vernacextend.TyTerminal
            ("of",
             Vernacextend.TyTerminal
             ("term",
              Vernacextend.TyTerminal
              ("is",
               Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_string),
               Vernacextend.TyNil)))))),
          (let coqpp_body s () = Vernactypes.vtdefault (fun () -> 
# 47 "doc/plugin_tutorial/tuto1/src/g_tuto1.mlg"
     Inspector.print_input s strbrk "string" 
# 57 "doc/plugin_tutorial/tuto1/src/g_tuto1.ml"
) in
            fun s ?loc ~atts () ->
            coqpp_body s (Attributes.unsupported_attributes atts)),
          None));
         (Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("What",
           Vernacextend.TyTerminal
           ("kind",
            Vernacextend.TyTerminal
            ("of",
             Vernacextend.TyTerminal
             ("term",
              Vernacextend.TyTerminal
              ("is",
               Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_int),
               Vernacextend.TyNil)))))),
          (let coqpp_body i () = Vernactypes.vtdefault (fun () -> 
# 49 "doc/plugin_tutorial/tuto1/src/g_tuto1.mlg"
     Inspector.print_input i Pp.int "int" 
# 79 "doc/plugin_tutorial/tuto1/src/g_tuto1.ml"
) in
            fun i ?loc ~atts () ->
            coqpp_body i (Attributes.unsupported_attributes atts)),
          None));
         (Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("What",
           Vernacextend.TyTerminal
           ("kind",
            Vernacextend.TyTerminal
            ("of",
             Vernacextend.TyTerminal
             ("term",
              Vernacextend.TyTerminal
              ("is",
               Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_ident),
               Vernacextend.TyNil)))))),
          (let coqpp_body id () = Vernactypes.vtdefault (fun () -> 
# 51 "doc/plugin_tutorial/tuto1/src/g_tuto1.mlg"
     Inspector.print_input id Ppconstr.pr_id "identifier" 
# 101 "doc/plugin_tutorial/tuto1/src/g_tuto1.ml"
) in
            fun id ?loc ~atts () ->
            coqpp_body id (Attributes.unsupported_attributes atts)),
          None));
         (Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("What",
           Vernacextend.TyTerminal
           ("kind",
            Vernacextend.TyTerminal
            ("of",
             Vernacextend.TyTerminal
             ("identifier",
              Vernacextend.TyTerminal
              ("is",
               Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_reference),
               Vernacextend.TyNil)))))),
          (let coqpp_body r () = Vernactypes.vtdefault (fun () -> 
# 53 "doc/plugin_tutorial/tuto1/src/g_tuto1.mlg"
     Inspector.print_input r Ppconstr.pr_qualid "reference" 
# 123 "doc/plugin_tutorial/tuto1/src/g_tuto1.ml"
) in
            fun r ?loc ~atts () ->
            coqpp_body r (Attributes.unsupported_attributes atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-plugin-tutorial.tuto1") ~command:"WhatAreThese" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_query) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("What",
           Vernacextend.TyTerminal
           ("is",
            Vernacextend.TyNonTerminal (Extend.TUlist0 (Extend.TUentry (Genarg.get_arg_tag wit_int)),
            Vernacextend.TyTerminal
            ("a",
             Vernacextend.TyTerminal
             ("list", Vernacextend.TyTerminal ("of", Vernacextend.TyNil)))))),
          (let coqpp_body l () = Vernactypes.vtdefault (fun () -> 
# 62 "doc/plugin_tutorial/tuto1/src/g_tuto1.mlg"
    
     let print l = str "[" ++ Pp.prlist_with_sep (fun () -> str ";") Pp.int l ++ str "]" in
     Inspector.print_input l print "int list"
   
# 147 "doc/plugin_tutorial/tuto1/src/g_tuto1.ml"
) in
            fun l ?loc ~atts () ->
            coqpp_body l (Attributes.unsupported_attributes atts)),
          None));
         (Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Is",
           Vernacextend.TyNonTerminal (Extend.TUlist1 (Extend.TUentry (Genarg.get_arg_tag wit_int)),
           Vernacextend.TyTerminal ("nonempty", Vernacextend.TyNil))),
          (let coqpp_body l () = Vernactypes.vtdefault (fun () -> 
# 67 "doc/plugin_tutorial/tuto1/src/g_tuto1.mlg"
    
     let print l = str "[" ++ Pp.prlist_with_sep (fun () -> str ";") Pp.int l ++ str "]" in
     Inspector.print_input l print "nonempty int list"
   
# 164 "doc/plugin_tutorial/tuto1/src/g_tuto1.ml"
) in
            fun l ?loc ~atts () ->
            coqpp_body l (Attributes.unsupported_attributes atts)),
          None));
         (Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("And",
           Vernacextend.TyTerminal
           ("is",
            Vernacextend.TyNonTerminal (Extend.TUopt (Extend.TUentry (Genarg.get_arg_tag wit_int)),
            Vernacextend.TyTerminal ("provided", Vernacextend.TyNil)))),
          (let coqpp_body o () = Vernactypes.vtdefault (fun () -> 
# 72 "doc/plugin_tutorial/tuto1/src/g_tuto1.mlg"
    
     let print o = strbrk (if Option.has_some o then "Yes" else "No") in
     Feedback.msg_notice (print o)
   
# 183 "doc/plugin_tutorial/tuto1/src/g_tuto1.ml"
) in
            fun o ?loc ~atts () ->
            coqpp_body o (Attributes.unsupported_attributes atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-plugin-tutorial.tuto1") ~command:"Intern" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_query) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Intern",
           Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
           Vernacextend.TyNil)),
          (let coqpp_body e () = Vernactypes.vtdefault (fun () -> 
# 118 "doc/plugin_tutorial/tuto1/src/g_tuto1.mlg"
    
     let env = Global.env () in (* use this; never use empty *)
     let sigma = Evd.from_env env in (* use this; never use empty *)
     let debug sigma = Termops.pr_evar_map ~with_univs:true None env sigma in
     Feedback.msg_notice (strbrk "State before intern: " ++ debug sigma);
     let (sigma, t) = Constrintern.interp_constr_evars env sigma e in
     Feedback.msg_notice (strbrk "State after intern: " ++ debug sigma);
     let print t = Printer.pr_econstr_env env sigma t in
     Feedback.msg_notice (strbrk "Interned: " ++ print t)
   
# 208 "doc/plugin_tutorial/tuto1/src/g_tuto1.ml"
) in
            fun e ?loc ~atts () ->
            coqpp_body e (Attributes.unsupported_attributes atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-plugin-tutorial.tuto1") ~command:"MyDefine" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("MyDefine",
           Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_ident),
           Vernacextend.TyTerminal
           (":=",
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
            Vernacextend.TyNil)))),
          (let coqpp_body i e poly = Vernactypes.vtdefault (fun () -> 
# 153 "doc/plugin_tutorial/tuto1/src/g_tuto1.mlg"
    
     let env = Global.env () in
     let sigma = Evd.from_env env in
     let (sigma, t) = Constrintern.interp_constr_evars env sigma e in
     let r = Simple_declare.declare_definition ~poly i sigma t in
     let print r = strbrk "Defined " ++ Printer.pr_global r ++ strbrk "." in
     Feedback.msg_notice (print r)
   
# 234 "doc/plugin_tutorial/tuto1/src/g_tuto1.ml"
) in
            fun i e ?loc ~atts () -> coqpp_body i e (Attributes.parse 
# 152 "doc/plugin_tutorial/tuto1/src/g_tuto1.mlg"
             Attributes.polymorphic
# 239 "doc/plugin_tutorial/tuto1/src/g_tuto1.ml"
 atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-plugin-tutorial.tuto1") ~command:"ExamplePrint" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_query) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("MyPrint",
           Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_reference),
           Vernacextend.TyNil)),
          (let coqpp_body r () =
            Vernactypes.vtopaqueaccess (fun ~opaque_access -> (
# 179 "doc/plugin_tutorial/tuto1/src/g_tuto1.mlg"
     fun ~opaque_access ->
     let env = Global.env () in
     let sigma = Evd.from_env env in
     try
       let t = Simple_print.simple_body_access ~opaque_access (Nametab.global r) in
       Feedback.msg_notice (Printer.pr_econstr_env env sigma t)
     with Failure s ->
       CErrors.user_err (str s)
   
# 262 "doc/plugin_tutorial/tuto1/src/g_tuto1.ml"
)
            ~opaque_access) in fun r ?loc ~atts () ->
            coqpp_body r (Attributes.unsupported_attributes atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-plugin-tutorial.tuto1") ~command:"DefineLookup" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("DefineLookup",
           Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_ident),
           Vernacextend.TyTerminal
           (":=",
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
            Vernacextend.TyNil)))),
          (let coqpp_body i e poly =
            Vernactypes.vtopaqueaccess (fun ~opaque_access -> (
# 207 "doc/plugin_tutorial/tuto1/src/g_tuto1.mlg"
     fun ~opaque_access ->
     let env = Global.env () in
     let sigma = Evd.from_env env in
     let (sigma, t) = Constrintern.interp_constr_evars env sigma e in
     let r = Simple_declare.declare_definition ~poly i sigma t in
     let print r = strbrk "Defined " ++ Printer.pr_global r ++ strbrk "." in
     Feedback.msg_notice (print r);
     let env = Global.env () in
     let sigma = Evd.from_env env in
     let t = Simple_print.simple_body_access ~opaque_access r in
     let print t = strbrk "Found " ++ Printer.pr_econstr_env env sigma t in
     Feedback.msg_notice (print t)
   
# 294 "doc/plugin_tutorial/tuto1/src/g_tuto1.ml"
)
            ~opaque_access) in fun i e ?loc ~atts () ->
            coqpp_body i e (Attributes.parse 
# 206 "doc/plugin_tutorial/tuto1/src/g_tuto1.mlg"
             Attributes.polymorphic
# 300 "doc/plugin_tutorial/tuto1/src/g_tuto1.ml"
 atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-plugin-tutorial.tuto1") ~command:"Check1" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_query) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Check1",
           Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
           Vernacextend.TyNil)),
          (let coqpp_body e () = Vernactypes.vtdefault (fun () -> 
# 231 "doc/plugin_tutorial/tuto1/src/g_tuto1.mlg"
    
     let env = Global.env () in
     let sigma = Evd.from_env env in
     let (sigma, t) = Constrintern.interp_constr_evars env sigma e in
     let (sigma, typ) = Simple_check.simple_check1 env sigma t in
     Feedback.msg_notice (Printer.pr_econstr_env env sigma typ)
   
# 320 "doc/plugin_tutorial/tuto1/src/g_tuto1.ml"
) in
            fun e ?loc ~atts () ->
            coqpp_body e (Attributes.unsupported_attributes atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-plugin-tutorial.tuto1") ~command:"Check2" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_query) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Check2",
           Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
           Vernacextend.TyNil)),
          (let coqpp_body e () = Vernactypes.vtdefault (fun () -> 
# 242 "doc/plugin_tutorial/tuto1/src/g_tuto1.mlg"
    
     let env = Global.env () in
     let sigma = Evd.from_env env in
     let (sigma, t) = Constrintern.interp_constr_evars env sigma e in
     let typ = Simple_check.simple_check2 env sigma t in
     Feedback.msg_notice (Printer.pr_econstr_env env sigma typ)
   
# 342 "doc/plugin_tutorial/tuto1/src/g_tuto1.ml"
) in
            fun e ?loc ~atts () ->
            coqpp_body e (Attributes.unsupported_attributes atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-plugin-tutorial.tuto1") ~command:"Convertible" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_query) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Convertible",
           Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
           Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
           Vernacextend.TyNil))),
          (let coqpp_body e1 e2 () = Vernactypes.vtdefault (fun () -> 
# 260 "doc/plugin_tutorial/tuto1/src/g_tuto1.mlg"
    
     let env = Global.env () in
     let sigma = Evd.from_env env in
     let (sigma, t1) = Constrintern.interp_constr_evars env sigma e1 in
     let (sigma, t2) = Constrintern.interp_constr_evars env sigma e2 in
     match Reductionops.infer_conv env sigma t1 t2 with
     | Some _ ->
        Feedback.msg_notice (strbrk "Yes :)")
     | None ->
        Feedback.msg_notice (strbrk "No :(")
   
# 369 "doc/plugin_tutorial/tuto1/src/g_tuto1.ml"
) in
            fun e1 e2 ?loc ~atts () ->
            coqpp_body e1 e2 (Attributes.unsupported_attributes atts)),
          None))]

let () = Tacentries.tactic_extend "rocq-plugin-tutorial.tuto1" "my_intro" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("my_intro", Tacentries.TyArg (
                                                            Extend.TUentry (Genarg.get_arg_tag wit_ident), 
                                                            Tacentries.TyNil)), 
           (fun i ist -> 
# 281 "doc/plugin_tutorial/tuto1/src/g_tuto1.mlg"
    Tactics.introduction i 
# 382 "doc/plugin_tutorial/tuto1/src/g_tuto1.ml"
)))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-plugin-tutorial.tuto1") ~command:"ExploreProof" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_query) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal ("ExploreProof", Vernacextend.TyNil),
          (let coqpp_body () =
            Vernactypes.vtreadproof (fun ~pstate -> (
# 296 "doc/plugin_tutorial/tuto1/src/g_tuto1.mlg"
    fun ~pstate ->
    let sigma, env = Declare.Proof.get_current_context pstate in
    let pprf = Proof.partial_proof (Declare.Proof.get pstate) in
    Feedback.msg_notice
      (Pp.prlist_with_sep Pp.fnl (Printer.pr_econstr_env env sigma) pprf)
  
# 398 "doc/plugin_tutorial/tuto1/src/g_tuto1.ml"
) ~pstate) in
            fun ?loc ~atts () ->
            coqpp_body (Attributes.unsupported_attributes atts)),
          None))]

