
# 13 "parsing/g_constr.mlg"
 

open Names
open Constr
open Libnames
open Glob_term
open Constrexpr
open Constrexpr_ops
open Util

open Procq
open Procq.Prim
open Procq.Constr

(* TODO: avoid this redefinition without an extra dep to Notation_ops *)
let ldots_var = Id.of_string ".."

let binder_of_name expl { CAst.loc = loc; v = na } =
  CLocalAssum ([CAst.make ?loc na], None, Default expl,
    CAst.make ?loc @@ CHole (Some (GBinderType na)))

let binders_of_names l =
  List.map (binder_of_name Explicit) l

let pat_of_name CAst.{loc;v} = match v with
| Anonymous -> CAst.make ?loc @@ CPatAtom None
| Name id -> CAst.make ?loc @@ CPatAtom (Some (qualid_of_ident id))

(* Hack to parse "(x:=t)" as an explicit argument without conflicts with the *)
(* admissible notation "(x t)" *)
let test_lpar_id_coloneq =
  let open Procq.Lookahead in
  to_entry "test_lpar_id_coloneq" begin
    lk_kw "(" >> lk_ident >> lk_kw ":="
  end

(* Hack to parse "(n:=t)" as an explicit argument without conflicts with the *)
(* syntax "(n t)" *)
let test_lpar_nat_coloneq =
  let open Procq.Lookahead in
  to_entry "test_lpar_id_coloneq" begin
    lk_kw "(" >> lk_nat >> lk_kw ":="
  end

let ensure_fixannot =
  let open Procq.Lookahead in
  to_entry "check_fixannot" begin
    lk_kw "{" >> lk_kws ["wf"; "struct"; "measure"]
  end

let test_name_colon =
  let open Procq.Lookahead in
  to_entry "test_name_colon" begin
    lk_name >> lk_kw ":"
  end

let aliasvar = function { CAst.v = CPatAlias (_, na) } -> Some na | _ -> None

let test_array_opening =
  let open Procq.Lookahead in
  to_entry "test_array_opening" begin
    lk_kw "[" >> lk_kw "|" >> check_no_space
  end

let test_array_closing =
  let open Procq.Lookahead in
  to_entry "test_array_closing" begin
    lk_kw "|" >> lk_kw "]" >> check_no_space
  end

let test_old_sort_qvar =
  let open Procq.Lookahead in
  to_entry "test_old_sort_qvar" begin
    lk_ident >> lk_list lk_field >> lk_kw "|"
  end

let test_sort_qvar =
  let open Procq.Lookahead in
  to_entry "test_sort_qvar" begin
    lk_ident >> lk_list lk_field >> lk_kw ";"
  end

let warn_old_sort_syntax =
  CWarnings.create ~name:"deprecated-sort-poly-syntax" ~category:Deprecation.Version.v9_1
    Pp.(fun () -> fmt "Separating sorts from universes with \"|\" is deprecated.@ Use \";\" instead.")

type univ_level_or_quality =
  | SProp | Prop | Set | Type | Anon of Loc.t | Global of Libnames.qualid

let force_univ_level ?loc = function
  | SProp -> UNamed CSProp
  | Prop -> UNamed CProp
  | Set -> UNamed CSet
  | Type -> UAnonymous {rigid=UnivRigid}
  | Anon _ -> UAnonymous {rigid=UnivFlexible false}
  | Global qid -> UNamed (CType qid)

let force_quality ?loc = function
  | SProp -> CQConstant QSProp
  | Prop -> CQConstant QProp
  | Set -> CErrors.user_err ?loc Pp.(str "Universe levels cannot be Set.")
  | Type -> CQConstant QType
  | Anon loc -> CQualVar (CQAnon (Some loc))
  | Global qid -> CQualVar (CQVar qid)

(* XXX use registered ref? but currently constrexpr doesn't have a node for registered refs
   and we can't do [Rocqlib.lib_ref] at parsing time, it's only available in the interp phase. *)
let sigref loc = Libnames.qualid_of_string ~loc "Corelib.Init.Specif.sig"


# 114 "parsing/g_constr.ml"

let _ =
  let universe_increment = Procq.Entry.make "universe_increment"
  and universe_expr = Procq.Entry.make "universe_expr"
  and universe = Procq.Entry.make "universe"
  and array_elems = Procq.Entry.make "array_elems"
  and fields_def = Procq.Entry.make "fields_def"
  and field_def = Procq.Entry.make "field_def"
  and atomic_constr = Procq.Entry.make "atomic_constr"
  and inst = Procq.Entry.make "inst"
  and evar_instance = Procq.Entry.make "evar_instance"
  and univ_annot = Procq.Entry.make "univ_annot"
  and univ_level_or_quality = Procq.Entry.make "univ_level_or_quality"
  and fix_decls = Procq.Entry.make "fix_decls"
  and cofix_decls = Procq.Entry.make "cofix_decls"
  and fix_decl = Procq.Entry.make "fix_decl"
  and cofix_body = Procq.Entry.make "cofix_body"
  and term_match = Procq.Entry.make "term_match"
  and case_item = Procq.Entry.make "case_item"
  and case_type = Procq.Entry.make "case_type"
  and as_return_type = Procq.Entry.make "as_return_type"
  and branches = Procq.Entry.make "branches"
  and mult_pattern = Procq.Entry.make "mult_pattern"
  and eqn = Procq.Entry.make "eqn"
  and record_pattern = Procq.Entry.make "record_pattern"
  and record_patterns = Procq.Entry.make "record_patterns"
  and fixannot = Procq.Entry.make "fixannot"
  and let_type_cstr = Procq.Entry.make "let_type_cstr"
  in
  let () = assert (Procq.Entry.is_empty Constr.ident) in
  let () =
  Procq.grammar_extend Constr.ident
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm Prim.ident)))
                            (fun id loc -> 
# 132 "parsing/g_constr.mlg"
                             id 
# 155 "parsing/g_constr.ml"
)])]))
  in let () =
  Procq.grammar_extend Prim.name
  (Procq.Reuse (None, [Procq.Production.make
                       (Procq.Rule.next (Procq.Rule.stop)
                        ((Procq.Symbol.token (Tok.PKEYWORD ("_")))))
                       (fun _ loc -> 
# 135 "parsing/g_constr.mlg"
                 CAst.make ~loc Anonymous 
# 165 "parsing/g_constr.ml"
)]))
  in let () = assert (Procq.Entry.is_empty global) in
  let () =
  Procq.grammar_extend global
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm Prim.reference)))
                            (fun r loc -> 
# 138 "parsing/g_constr.mlg"
                                r 
# 178 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty constr_pattern) in
  let () =
  Procq.grammar_extend constr_pattern
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm constr)))
                            (fun c loc -> 
# 141 "parsing/g_constr.mlg"
                        c 
# 191 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty cpattern) in
  let () =
  Procq.grammar_extend cpattern
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm lconstr)))
                            (fun c loc -> 
# 144 "parsing/g_constr.mlg"
                         c 
# 204 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty sort) in
  let () =
  Procq.grammar_extend sort
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PKEYWORD ("Type")))))
                               ((Procq.Symbol.token (Tok.PKEYWORD ("@{")))))
                              ((Procq.Symbol.nterm universe)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("}")))))
                            (fun _ u _ _ loc -> 
# 159 "parsing/g_constr.mlg"
                                             None, u 
# 223 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next
                                 (Procq.Rule.next (Procq.Rule.stop)
                                  ((Procq.Symbol.token (Tok.PKEYWORD ("Type")))))
                                 ((Procq.Symbol.token (Tok.PKEYWORD ("@{")))))
                                ((Procq.Symbol.nterm test_sort_qvar)))
                               ((Procq.Symbol.nterm reference)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (";")))))
                             ((Procq.Symbol.nterm universe)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("}")))))
                           (fun _ u _ q _ _ _ loc -> 
# 156 "parsing/g_constr.mlg"
                                                                                
          Some (CQVar q), u
        
# 245 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next
                                 (Procq.Rule.next (Procq.Rule.stop)
                                  ((Procq.Symbol.token (Tok.PKEYWORD ("Type")))))
                                 ((Procq.Symbol.token (Tok.PKEYWORD ("@{")))))
                                ((Procq.Symbol.nterm test_old_sort_qvar)))
                               ((Procq.Symbol.nterm reference)))
                              ((Procq.Symbol.rules [Procq.Rules.make 
                                                   (Procq.Rule.next_norec
                                                    (Procq.Rule.stop)
                                                    ((Procq.Symbol.token (Tok.PKEYWORD ("|")))))
                                                   (fun _ loc -> 
# 152 "parsing/g_constr.mlg"
                                                                               loc 
# 266 "parsing/g_constr.ml"
)])))
                             ((Procq.Symbol.nterm universe)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("}")))))
                           (fun _ u pipe_loc q _ _ _ loc -> 
# 152 "parsing/g_constr.mlg"
                                                                                                              
          warn_old_sort_syntax ~loc:pipe_loc ();
          Some (CQVar q), u
        
# 276 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PKEYWORD ("Type")))))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("@{")))))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("_")))))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("}")))))
                           (fun _ _ _ _ loc -> 
# 151 "parsing/g_constr.mlg"
                                    None, UAnonymous {rigid=UnivFlexible false} 
# 290 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("Type")))))
                           (fun _ loc -> 
# 150 "parsing/g_constr.mlg"
                    None, UAnonymous {rigid=UnivRigid} 
# 298 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("SProp")))))
                           (fun _ loc -> 
# 149 "parsing/g_constr.mlg"
                     None, UNamed [CSProp, 0] 
# 306 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("Prop")))))
                           (fun _ loc -> 
# 148 "parsing/g_constr.mlg"
                    None, UNamed [CProp, 0] 
# 314 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("Set")))))
                           (fun _ loc -> 
# 147 "parsing/g_constr.mlg"
                    None, UNamed [CSet, 0] 
# 322 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty sort_quality_or_set) in
  let () =
  Procq.grammar_extend sort_quality_or_set
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("Type")))))
                            (fun _ loc -> 
# 165 "parsing/g_constr.mlg"
                    UnivGen.QualityOrSet.qtype 
# 335 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("Set")))))
                           (fun _ loc -> 
# 164 "parsing/g_constr.mlg"
                   UnivGen.QualityOrSet.Set 
# 343 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("SProp")))))
                           (fun _ loc -> 
# 163 "parsing/g_constr.mlg"
                     UnivGen.QualityOrSet.sprop 
# 351 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("Prop")))))
                           (fun _ loc -> 
# 162 "parsing/g_constr.mlg"
                    UnivGen.QualityOrSet.prop 
# 359 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty universe_increment) in
  let () =
  Procq.grammar_extend universe_increment
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 169 "parsing/g_constr.mlg"
             0 
# 370 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("+")))))
                            ((Procq.Symbol.nterm natural)))
                           (fun n _ loc -> 
# 168 "parsing/g_constr.mlg"
                              n 
# 380 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty universe_name) in
  let () =
  Procq.grammar_extend universe_name
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("Prop")))))
                            (fun _ loc -> 
# 174 "parsing/g_constr.mlg"
                    CProp 
# 393 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("Set")))))
                           (fun _ loc -> 
# 173 "parsing/g_constr.mlg"
                    CSet 
# 401 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm global)))
                           (fun id loc -> 
# 172 "parsing/g_constr.mlg"
                         CType id 
# 409 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty universe_expr) in
  let () =
  Procq.grammar_extend universe_expr
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm universe_name)))
                             ((Procq.Symbol.nterm universe_increment)))
                            (fun n id loc -> 
# 177 "parsing/g_constr.mlg"
                                                        (id,n) 
# 424 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty universe) in
  let () =
  Procq.grammar_extend universe
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm universe_expr)))
                            (fun u loc -> 
# 182 "parsing/g_constr.mlg"
                               UNamed [u] 
# 437 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("_")))))
                           (fun _ loc -> 
# 181 "parsing/g_constr.mlg"
                 UAnonymous { rigid = UnivFlexible false } 
# 445 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("max"))))))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                             ((Procq.Symbol.list1sep ((Procq.Symbol.nterm universe_expr)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                           (fun _ ids _ _ loc -> 
# 180 "parsing/g_constr.mlg"
                                                                      UNamed ids 
# 460 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty lconstr) in
  let () =
  Procq.grammar_extend lconstr
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterml term ("200"))))
                            (fun c loc -> 
# 185 "parsing/g_constr.mlg"
                                  c 
# 473 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty constr) in
  let () =
  Procq.grammar_extend constr
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PKEYWORD ("@")))))
                              ((Procq.Symbol.nterm global)))
                             ((Procq.Symbol.nterm univ_annot)))
                            (fun i f _ loc -> 
# 189 "parsing/g_constr.mlg"
                                           CAst.make ~loc @@ CAppExpl((f,i),[]) 
# 490 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterml term ("8"))))
                           (fun c loc -> 
# 188 "parsing/g_constr.mlg"
                                c 
# 498 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty term) in
  let () =
  Procq.grammar_extend term
  (Procq.Fresh
  (Gramlib.Gramext.First, [(Some ("200"), Some (Gramlib.Gramext.RightA), []);
                          (Some ("100"), Some (Gramlib.Gramext.RightA),
                          [Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm term)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                            ((Procq.Symbol.nterml term ("200"))))
                           (fun c2 _ c1 loc -> 
# 201 "parsing/g_constr.mlg"
                   CAst.make ~loc @@ CCast(c1, Some DEFAULTcast, c2) 
# 516 "parsing/g_constr.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm term)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (":>")))))
                           ((Procq.Symbol.nterml term ("200"))))
                          (fun c2 _ c1 loc -> 
# 199 "parsing/g_constr.mlg"
                   CAst.make ~loc @@ CCast(c1, None, c2) 
# 528 "parsing/g_constr.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm term)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("<<:")))))
                           ((Procq.Symbol.nterml term ("200"))))
                          (fun c2 _ c1 loc -> 
# 197 "parsing/g_constr.mlg"
                   CAst.make ~loc @@ CCast(c1, Some NATIVEcast, c2) 
# 540 "parsing/g_constr.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm term)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("<:")))))
                           ((Procq.Symbol.nterml term ("200"))))
                          (fun c2 _ c1 loc -> 
# 195 "parsing/g_constr.mlg"
                   CAst.make ~loc @@ CCast(c1, Some VMcast, c2) 
# 552 "parsing/g_constr.ml"
)]);
                          (Some ("99"), Some (Gramlib.Gramext.RightA), []);
                          (Some ("90"), Some (Gramlib.Gramext.RightA), []);
                          (Some ("10"), Some (Gramlib.Gramext.LeftA),
                          [Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm binder_constr)))
                           (fun c loc -> 
# 211 "parsing/g_constr.mlg"
                               c 
# 563 "parsing/g_constr.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("@")))))
                            ((Procq.Symbol.nterm pattern_ident)))
                           ((Procq.Symbol.list1 ((Procq.Symbol.nterm identref)))))
                          (fun args lid _ loc -> 
# 208 "parsing/g_constr.mlg"
          let { CAst.loc = locid; v = id } = lid in
          let args = List.map (fun x -> CAst.make @@ CRef (qualid_of_ident ?loc:x.CAst.loc x.CAst.v, None), None) args in
          CAst.make ~loc @@ CApp(CAst.make ?loc:locid @@ CPatVar id,args) 
# 577 "parsing/g_constr.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("@")))))
                             ((Procq.Symbol.nterm global)))
                            ((Procq.Symbol.nterm univ_annot)))
                           ((Procq.Symbol.list0 Procq.Symbol.next)))
                          (fun args i f _ loc -> 
# 206 "parsing/g_constr.mlg"
                                                                CAst.make ~loc @@ CAppExpl((f,i),args) 
# 591 "parsing/g_constr.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm term)))
                           ((Procq.Symbol.list1 ((Procq.Symbol.nterm arg)))))
                          (fun args f loc -> 
# 205 "parsing/g_constr.mlg"
                                        CAst.make ~loc @@ CApp(f,args) 
# 601 "parsing/g_constr.ml"
)]);
                          (Some ("9"), None,
                          [Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("..")))))
                             ((Procq.Symbol.nterml term ("0"))))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("..")))))
                           (fun _ c _ loc -> 
# 214 "parsing/g_constr.mlg"
          CAst.make ~loc @@ CAppExpl ((qualid_of_ident ~loc ldots_var, None),[c]) 
# 614 "parsing/g_constr.ml"
)]);
                          (Some ("8"), None, []);
                          (Some ("1"), Some (Gramlib.Gramext.LeftA),
                          [Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm term)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("%_")))))
                            ((Procq.Symbol.token (Tok.PIDENT (None)))))
                           (fun key _ c loc -> 
# 225 "parsing/g_constr.mlg"
          CAst.make ~loc @@ CDelimiters (DelimOnlyTmpScope,key,c) 
# 628 "parsing/g_constr.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm term)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("%")))))
                           ((Procq.Symbol.token (Tok.PIDENT (None)))))
                          (fun key _ c loc -> 
# 223 "parsing/g_constr.mlg"
          CAst.make ~loc @@ CDelimiters (DelimUnboundedScope,key,c) 
# 640 "parsing/g_constr.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.nterm term)))
                                ((Procq.Symbol.token (Tok.PKEYWORD (".(")))))
                               ((Procq.Symbol.token (Tok.PKEYWORD ("@")))))
                              ((Procq.Symbol.nterm global)))
                             ((Procq.Symbol.nterm univ_annot)))
                            ((Procq.Symbol.list0 (Procq.Symbol.nterml term ("9")))))
                           ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                          (fun _ args i f _ _ c loc -> 
# 221 "parsing/g_constr.mlg"
          CAst.make ~loc @@ CProj(true, (f,i), List.map (fun a -> (a,None)) args, c) 
# 660 "parsing/g_constr.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.nterm term)))
                               ((Procq.Symbol.token (Tok.PKEYWORD (".(")))))
                              ((Procq.Symbol.nterm global)))
                             ((Procq.Symbol.nterm univ_annot)))
                            ((Procq.Symbol.list0 (Procq.Symbol.nterm arg))))
                           ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                          (fun _ args i f _ c loc -> 
# 218 "parsing/g_constr.mlg"
          CAst.make ~loc @@ CProj(false, (f,i), args, c) 
# 678 "parsing/g_constr.ml"
)]);
                          (Some ("0"), None,
                          [Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("`(")))))
                             ((Procq.Symbol.nterml term ("200"))))
                            ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                           (fun _ c _ loc -> 
# 249 "parsing/g_constr.mlg"
          CAst.make ~loc @@ CGeneralization (Explicit, c) 
# 691 "parsing/g_constr.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next
                                 (Procq.Rule.next
                                  (Procq.Rule.next
                                   (Procq.Rule.next
                                    (Procq.Rule.next (Procq.Rule.stop)
                                     ((Procq.Symbol.nterm test_array_opening)))
                                    ((Procq.Symbol.token (Tok.PKEYWORD ("[")))))
                                   ((Procq.Symbol.token (Tok.PKEYWORD ("|")))))
                                  ((Procq.Symbol.nterm array_elems)))
                                 ((Procq.Symbol.token (Tok.PKEYWORD ("|")))))
                                ((Procq.Symbol.nterm lconstr)))
                               ((Procq.Symbol.nterm type_cstr)))
                              ((Procq.Symbol.nterm test_array_closing)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("|")))))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                           ((Procq.Symbol.nterm univ_annot)))
                          (fun u _ _ _ ty def _ ls _ _ _ loc -> 
# 244 "parsing/g_constr.mlg"
          let t = Array.make (List.length ls) def in
          List.iteri (fun i e -> t.(i) <- e) ls;
          CAst.make ~loc @@ CArray(u, t, def, ty)
        
# 722 "parsing/g_constr.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("`{")))))
                            ((Procq.Symbol.nterml term ("200"))))
                           ((Procq.Symbol.token (Tok.PKEYWORD ("}")))))
                          (fun _ c _ loc -> 
# 242 "parsing/g_constr.mlg"
          CAst.make ~loc @@ CGeneralization (MaxImplicit, c) 
# 734 "parsing/g_constr.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("{|")))))
                            ((Procq.Symbol.nterm record_declaration)))
                           ((Procq.Symbol.nterm bar_cbrace)))
                          (fun _ c _ loc -> 
# 240 "parsing/g_constr.mlg"
                                                      c 
# 746 "parsing/g_constr.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                            ((Procq.Symbol.nterml term ("200"))))
                           ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                          (fun _ c _ loc -> 
# 234 "parsing/g_constr.mlg"
          (* Preserve parentheses around numbers so that constrintern does not
             collapse -(3) into the number -3. *)
          (match c.CAst.v with
            | CPrim (Number (NumTok.SPlus,n)) ->
                CAst.make ~loc @@ CNotation(None,(InConstrEntry,"( _ )"),([c],[],[],[]))
            | _ -> c) 
# 763 "parsing/g_constr.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next (Procq.Rule.stop)
                           ((Procq.Symbol.nterm string)))
                          (fun s loc -> 
# 232 "parsing/g_constr.mlg"
                        CAst.make ~loc @@ CPrim (String s) 
# 771 "parsing/g_constr.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next (Procq.Rule.stop)
                           ((Procq.Symbol.token (Tok.PNUMBER None))))
                          (fun n loc -> 
# 231 "parsing/g_constr.mlg"
                       CAst.make ~loc @@ CPrim (Number (NumTok.SPlus,n)) 
# 779 "parsing/g_constr.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm reference)))
                           ((Procq.Symbol.nterm univ_annot)))
                          (fun i id loc -> 
# 230 "parsing/g_constr.mlg"
          CAst.make ~loc @@ CRef (id, i) 
# 789 "parsing/g_constr.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next (Procq.Rule.stop)
                           ((Procq.Symbol.nterm term_match)))
                          (fun c loc -> 
# 228 "parsing/g_constr.mlg"
                            c 
# 797 "parsing/g_constr.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next (Procq.Rule.stop)
                           ((Procq.Symbol.nterm atomic_constr)))
                          (fun c loc -> 
# 227 "parsing/g_constr.mlg"
                               c 
# 805 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty array_elems) in
  let () =
  Procq.grammar_extend array_elems
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.list0sep ((Procq.Symbol.nterm lconstr)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (";"))])) false)))
                            (fun fs loc -> 
# 252 "parsing/g_constr.mlg"
                                        fs 
# 818 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty record_declaration) in
  let () =
  Procq.grammar_extend record_declaration
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm fields_def)))
                            (fun fs loc -> 
# 255 "parsing/g_constr.mlg"
                             CAst.make ~loc @@ CRecord fs 
# 831 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty fields_def) in
  let () =
  Procq.grammar_extend fields_def
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 260 "parsing/g_constr.mlg"
             [] 
# 842 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm field_def)))
                           (fun f loc -> 
# 259 "parsing/g_constr.mlg"
                           [f] 
# 850 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm field_def)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (";")))))
                            ((Procq.Symbol.nterm fields_def)))
                           (fun fs _ f loc -> 
# 258 "parsing/g_constr.mlg"
                                                 f :: fs 
# 862 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty field_def) in
  let () =
  Procq.grammar_extend field_def
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.nterm global)))
                               ((Procq.Symbol.nterm binders)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                             ((Procq.Symbol.nterm lconstr)))
                            (fun c _ bl id loc -> 
# 264 "parsing/g_constr.mlg"
          (id, mkLambdaCN ~loc bl c) 
# 881 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty binder_constr) in
  let () =
  Procq.grammar_extend binder_constr
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("cofix")))))
                             ((Procq.Symbol.nterm cofix_decls)))
                            (fun c _ loc -> 
# 308 "parsing/g_constr.mlg"
                                      let (id,dcls) = c in CAst.make ~loc @@ CCoFix (id,dcls) 
# 896 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("fix")))))
                            ((Procq.Symbol.nterm fix_decls)))
                           (fun c _ loc -> 
# 307 "parsing/g_constr.mlg"
                                  let (id,dcls) = c in CAst.make ~loc @@ CFix (id,dcls) 
# 906 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next
                                 (Procq.Rule.next (Procq.Rule.stop)
                                  ((Procq.Symbol.token (Tok.PKEYWORD ("if")))))
                                 ((Procq.Symbol.nterml term ("200"))))
                                ((Procq.Symbol.nterm as_return_type)))
                               ((Procq.Symbol.token (Tok.PKEYWORD ("then")))))
                              ((Procq.Symbol.nterml term ("200"))))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("else")))))
                            ((Procq.Symbol.nterml term ("200"))))
                           (fun b2 _ b1 _ po c _ loc -> 
# 306 "parsing/g_constr.mlg"
          CAst.make ~loc @@ CIf (c, po, b1, b2) 
# 926 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next
                                 (Procq.Rule.next
                                  (Procq.Rule.next
                                   (Procq.Rule.next
                                    (Procq.Rule.next (Procq.Rule.stop)
                                     ((Procq.Symbol.token (Tok.PKEYWORD ("let")))))
                                    ((Procq.Symbol.token (Tok.PKEYWORD ("'")))))
                                   ((Procq.Symbol.nterml pattern ("200"))))
                                  ((Procq.Symbol.token (Tok.PKEYWORD ("in")))))
                                 ((Procq.Symbol.nterml pattern ("200"))))
                                ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                               ((Procq.Symbol.nterml term ("200"))))
                              ((Procq.Symbol.nterm case_type)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("in")))))
                            ((Procq.Symbol.nterml term ("200"))))
                           (fun c2 _ rt c1 _ t _ p _ _ loc -> 
# 301 "parsing/g_constr.mlg"
          CAst.make ~loc @@
          CCases (LetPatternStyle, Some rt, [c1, aliasvar p, Some t], [CAst.make ~loc ([[p]], c2)]) 
# 953 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next
                                 (Procq.Rule.next
                                  (Procq.Rule.next (Procq.Rule.stop)
                                   ((Procq.Symbol.token (Tok.PKEYWORD ("let")))))
                                  ((Procq.Symbol.token (Tok.PKEYWORD ("'")))))
                                 ((Procq.Symbol.nterml pattern ("200"))))
                                ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                               ((Procq.Symbol.nterml term ("200"))))
                              ((Procq.Symbol.nterm case_type)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("in")))))
                            ((Procq.Symbol.nterml term ("200"))))
                           (fun c2 _ rt c1 _ p _ _ loc -> 
# 296 "parsing/g_constr.mlg"
          CAst.make ~loc @@
          CCases (LetPatternStyle, Some rt, [c1, aliasvar p, None], [CAst.make ~loc ([[p]], c2)]) 
# 976 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next
                                 (Procq.Rule.next (Procq.Rule.stop)
                                  ((Procq.Symbol.token (Tok.PKEYWORD ("let")))))
                                 ((Procq.Symbol.token (Tok.PKEYWORD ("'")))))
                                ((Procq.Symbol.nterml pattern ("200"))))
                               ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                              ((Procq.Symbol.nterml term ("200"))))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("in")))))
                            ((Procq.Symbol.nterml term ("200"))))
                           (fun c2 _ c1 _ p _ _ loc -> 
# 292 "parsing/g_constr.mlg"
          CAst.make ~loc @@
          CCases (LetPatternStyle, None,    [c1, None, None],       [CAst.make ~loc ([[p]], c2)]) 
# 997 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next
                                 (Procq.Rule.next (Procq.Rule.stop)
                                  ((Procq.Symbol.token (Tok.PKEYWORD ("let")))))
                                 ((Procq.Symbol.rules [Procq.Rules.make 
                                                      (Procq.Rule.next_norec
                                                       (Procq.Rule.stop)
                                                       ((Procq.Symbol.token (Tok.PKEYWORD ("()")))))
                                                      (fun _ loc -> 
# 286 "parsing/g_constr.mlg"
                                                                         [] 
# 1015 "parsing/g_constr.ml"
);
                                                      Procq.Rules.make 
                                                      (Procq.Rule.next_norec
                                                       (Procq.Rule.next_norec
                                                        (Procq.Rule.next_norec
                                                         (Procq.Rule.stop)
                                                         ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                        ((Procq.Symbol.list0sep ((Procq.Symbol.nterm name)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                                                       ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                                                      (fun _ l _ loc -> 
                                                      
# 286 "parsing/g_constr.mlg"
                                                         l 
# 1029 "parsing/g_constr.ml"
)])))
                                ((Procq.Symbol.nterm as_return_type)))
                               ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                              ((Procq.Symbol.nterml term ("200"))))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("in")))))
                            ((Procq.Symbol.nterml term ("200"))))
                           (fun c2 _ c1 _ po lb _ loc -> 
# 289 "parsing/g_constr.mlg"
          CAst.make ~loc @@ CLetTuple (lb,po,c1,c2) 
# 1039 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PKEYWORD ("let")))))
                               ((Procq.Symbol.token (Tok.PKEYWORD ("cofix")))))
                              ((Procq.Symbol.nterm cofix_body)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("in")))))
                            ((Procq.Symbol.nterml term ("200"))))
                           (fun c _ fx _ _ loc -> 
# 283 "parsing/g_constr.mlg"
          let {CAst.loc=locf;CAst.v=({CAst.loc=li;CAst.v=id} as lid,_,_,_,_ as dcl)} = fx in
          let cofix = CAst.make ?loc:locf @@ CCoFix (lid,[dcl]) in
          CAst.make ~loc @@ CLetIn( CAst.make ?loc:li @@ Name id,cofix,None,c) 
# 1057 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PKEYWORD ("let")))))
                               ((Procq.Symbol.token (Tok.PKEYWORD ("fix")))))
                              ((Procq.Symbol.nterm fix_decl)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("in")))))
                            ((Procq.Symbol.nterml term ("200"))))
                           (fun c _ fx _ _ loc -> 
# 279 "parsing/g_constr.mlg"
          let {CAst.loc=locf;CAst.v=({CAst.loc=li;CAst.v=id} as lid,_,_,_,_,_ as dcl)} = fx in
          let fix = CAst.make ?loc:locf @@ CFix (lid,[dcl]) in
          CAst.make ~loc @@ CLetIn( CAst.make ?loc:li @@ Name id,fix,None,c) 
# 1075 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next
                                 (Procq.Rule.next
                                  (Procq.Rule.next (Procq.Rule.stop)
                                   ((Procq.Symbol.token (Tok.PKEYWORD ("let")))))
                                  ((Procq.Symbol.nterm name)))
                                 ((Procq.Symbol.nterm binders)))
                                ((Procq.Symbol.nterm let_type_cstr)))
                               ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                              ((Procq.Symbol.nterml term ("200"))))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("in")))))
                            ((Procq.Symbol.nterml term ("200"))))
                           (fun c2 _ c1 _ ty bl id _ loc -> 
# 273 "parsing/g_constr.mlg"
          let ty,c1 = match ty, c1 with
          | (_,None), { CAst.v = CCast(c, Some DEFAULTcast, t) } -> (Loc.tag ?loc:(constr_loc t) @@ Some t), c (* Tolerance, see G_vernac.def_body *)
          | _, _ -> ty, c1 in
          CAst.make ~loc @@ CLetIn(id,mkLambdaCN ?loc:(constr_loc c1) bl c1,
                 Option.map (mkProdCN ?loc:(fst ty) bl) (snd ty), c2) 
# 1101 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PKEYWORD ("fun")))))
                              ((Procq.Symbol.nterm open_binders)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("=>")))))
                            ((Procq.Symbol.nterml term ("200"))))
                           (fun c _ bl _ loc -> 
# 270 "parsing/g_constr.mlg"
          mkLambdaCN ~loc bl c 
# 1115 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PKEYWORD ("forall")))))
                              ((Procq.Symbol.nterm open_binders)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (",")))))
                            ((Procq.Symbol.nterml term ("200"))))
                           (fun c _ bl _ loc -> 
# 268 "parsing/g_constr.mlg"
          mkProdCN ~loc bl c 
# 1129 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty arg) in
  let () =
  Procq.grammar_extend arg
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterml term ("9"))))
                            (fun c loc -> 
# 313 "parsing/g_constr.mlg"
                              (c,None) 
# 1142 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.nterm test_lpar_nat_coloneq)))
                                ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                               ((Procq.Symbol.nterm natural)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                             ((Procq.Symbol.nterm lconstr)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                           (fun _ c _ n _ _ loc -> 
# 312 "parsing/g_constr.mlg"
                                                                             (c,Some (CAst.make ~loc @@ ExplByPos n)) 
# 1160 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.nterm test_lpar_id_coloneq)))
                                ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                               ((Procq.Symbol.nterm identref)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                             ((Procq.Symbol.nterm lconstr)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                           (fun _ c _ id _ _ loc -> 
# 311 "parsing/g_constr.mlg"
                                                                              (c,Some (CAst.make ?loc:id.CAst.loc @@ ExplByName id.CAst.v)) 
# 1178 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty atomic_constr) in
  let () =
  Procq.grammar_extend atomic_constr
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm pattern_ident)))
                             ((Procq.Symbol.nterm evar_instance)))
                            (fun inst id loc -> 
# 320 "parsing/g_constr.mlg"
                                                      CAst.make ~loc @@ CEvar(id,inst) 
# 1193 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PKEYWORD ("?")))))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("[")))))
                             ((Procq.Symbol.nterm pattern_ident)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                           (fun _ id _ _ loc -> 
# 319 "parsing/g_constr.mlg"
                                                CAst.make ~loc @@  CHole (Some (GNamedHole (true, id.CAst.v))) 
# 1207 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PKEYWORD ("?")))))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("[")))))
                             ((Procq.Symbol.nterm identref)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                           (fun _ id _ _ loc -> 
# 318 "parsing/g_constr.mlg"
                                           CAst.make ~loc @@  CHole (Some (GNamedHole (false, id.CAst.v))) 
# 1221 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("_")))))
                           (fun _ loc -> 
# 317 "parsing/g_constr.mlg"
                      CAst.make ~loc @@ CHole (None) 
# 1229 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm sort)))
                           (fun s loc -> 
# 316 "parsing/g_constr.mlg"
                        CAst.make ~loc @@ CSort s 
# 1237 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty inst) in
  let () =
  Procq.grammar_extend inst
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.nterm identref)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                             ((Procq.Symbol.nterm lconstr)))
                            (fun c _ id loc -> 
# 323 "parsing/g_constr.mlg"
                                              (id,c) 
# 1254 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty evar_instance) in
  let () =
  Procq.grammar_extend evar_instance
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 327 "parsing/g_constr.mlg"
             [] 
# 1265 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("@{")))))
                             ((Procq.Symbol.list1sep ((Procq.Symbol.nterm inst)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (";"))])) false)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("}")))))
                           (fun _ l _ loc -> 
# 326 "parsing/g_constr.mlg"
                                               l 
# 1277 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty univ_annot) in
  let () =
  Procq.grammar_extend univ_annot
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 340 "parsing/g_constr.mlg"
             None 
# 1288 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PKEYWORD ("@{")))))
                              ((Procq.Symbol.list0 (Procq.Symbol.nterm univ_level_or_quality))))
                             ((Procq.Symbol.opt (Procq.Symbol.rules [Procq.Rules.make 
                                                                    (
                                                                    Procq.Rule.next_norec
                                                                    (
                                                                    Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.rules 
                                                                    [Procq.Rules.make 
                                                                    (
                                                                    Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Tok.PKEYWORD (";")))))
                                                                    (fun _
                                                                    loc -> 
                                                                    
# 330 "parsing/g_constr.mlg"
                                                                                                     None 
# 1314 "parsing/g_constr.ml"
);
                                                                    Procq.Rules.make 
                                                                    (
                                                                    Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Tok.PKEYWORD ("|")))))
                                                                    (fun _
                                                                    loc -> 
                                                                    
# 330 "parsing/g_constr.mlg"
                                                                               Some loc 
# 1326 "parsing/g_constr.ml"
)])))
                                                                    ((Procq.Symbol.list0 (Procq.Symbol.nterm univ_level_or_quality))))
                                                                    (fun l'
                                                                    is_pipe
                                                                    loc -> 
                                                                    
# 330 "parsing/g_constr.mlg"
                                                                                                                                                     is_pipe, l' 
# 1335 "parsing/g_constr.ml"
)]))))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("}")))))
                           (fun _ l' l _ loc -> 
# 331 "parsing/g_constr.mlg"
         
          let l, l' = match l' with
            | None -> [], List.map (force_univ_level ~loc) l
            | Some (is_pipe, l') ->
              let () = Option.iter (fun loc -> warn_old_sort_syntax ~loc ()) is_pipe in
              List.map (force_quality ~loc) l, List.map (force_univ_level ~loc) l'
          in
          Some (l,l')
        
# 1349 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty univ_level_or_quality) in
  let () =
  Procq.grammar_extend univ_level_or_quality
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm global)))
                            (fun id loc -> 
# 348 "parsing/g_constr.mlg"
                         Global id 
# 1362 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("_")))))
                           (fun _ loc -> 
# 347 "parsing/g_constr.mlg"
                 Anon loc 
# 1370 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("Type")))))
                           (fun _ loc -> 
# 346 "parsing/g_constr.mlg"
                    Type 
# 1378 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("Prop")))))
                           (fun _ loc -> 
# 345 "parsing/g_constr.mlg"
                    Prop 
# 1386 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("SProp")))))
                           (fun _ loc -> 
# 344 "parsing/g_constr.mlg"
                     SProp 
# 1394 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("Set")))))
                           (fun _ loc -> 
# 343 "parsing/g_constr.mlg"
                   Set 
# 1402 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty fix_decls) in
  let () =
  Procq.grammar_extend fix_decls
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.nterm fix_decl)))
                                ((Procq.Symbol.token (Tok.PKEYWORD ("with")))))
                               ((Procq.Symbol.list1sep ((Procq.Symbol.nterm fix_decl)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("with"))])) false)))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("for")))))
                             ((Procq.Symbol.nterm identref)))
                            (fun id _ dcls _ dcl loc -> 
# 353 "parsing/g_constr.mlg"
          (id,List.map (fun x -> x.CAst.v) (dcl::dcls)) 
# 1423 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm fix_decl)))
                           (fun dcl loc -> 
# 351 "parsing/g_constr.mlg"
                            let (id,_,_,_,_,_) = dcl.CAst.v in (id,[dcl.CAst.v]) 
# 1431 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty cofix_decls) in
  let () =
  Procq.grammar_extend cofix_decls
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.nterm cofix_body)))
                                ((Procq.Symbol.token (Tok.PKEYWORD ("with")))))
                               ((Procq.Symbol.list1sep ((Procq.Symbol.nterm cofix_body)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("with"))])) false)))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("for")))))
                             ((Procq.Symbol.nterm identref)))
                            (fun id _ dcls _ dcl loc -> 
# 358 "parsing/g_constr.mlg"
          (id,List.map (fun x -> x.CAst.v) (dcl::dcls)) 
# 1452 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm cofix_body)))
                           (fun dcl loc -> 
# 356 "parsing/g_constr.mlg"
                              let (id,_,_,_,_) = dcl.CAst.v in (id,[dcl.CAst.v]) 
# 1460 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty fix_decl) in
  let () =
  Procq.grammar_extend fix_decl
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.nterm identref)))
                                ((Procq.Symbol.nterm binders_fixannot)))
                               ((Procq.Symbol.nterm type_cstr)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                             ((Procq.Symbol.nterml term ("200"))))
                            (fun c _ ty bl id loc -> 
# 363 "parsing/g_constr.mlg"
          CAst.make ~loc (id,None,snd bl,fst bl,ty,c) 
# 1481 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty cofix_body) in
  let () =
  Procq.grammar_extend cofix_body
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.nterm identref)))
                                ((Procq.Symbol.nterm binders)))
                               ((Procq.Symbol.nterm type_cstr)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                             ((Procq.Symbol.nterml term ("200"))))
                            (fun c _ ty bl id loc -> 
# 368 "parsing/g_constr.mlg"
          CAst.make ~loc (id,None,bl,ty,c) 
# 1502 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty term_match) in
  let () =
  Procq.grammar_extend term_match
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next
                                 (Procq.Rule.next (Procq.Rule.stop)
                                  ((Procq.Symbol.token (Tok.PKEYWORD ("match")))))
                                 ((Procq.Symbol.list1sep ((Procq.Symbol.nterm case_item)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                                ((Procq.Symbol.opt (Procq.Symbol.nterm case_type))))
                               ((Procq.Symbol.token (Tok.PKEYWORD ("with")))))
                              ((Procq.Symbol.nterm branches)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("end")))))
                            (fun _ br _ ty ci _ loc -> 
# 372 "parsing/g_constr.mlg"
                                  CAst.make ~loc @@ CCases(RegularStyle,ty,ci,br) 
# 1525 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty case_item) in
  let () =
  Procq.grammar_extend case_item
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.nterml term ("100"))))
                              ((Procq.Symbol.opt (Procq.Symbol.rules 
                              [Procq.Rules.make (Procq.Rule.next_norec
                                                 (Procq.Rule.next_norec
                                                  (Procq.Rule.stop)
                                                  ((Procq.Symbol.token (Tok.PKEYWORD ("as")))))
                                                 ((Procq.Symbol.nterm name)))
                                                (fun id _ loc -> 
# 376 "parsing/g_constr.mlg"
                                        id 
# 1546 "parsing/g_constr.ml"
)]))))
                             ((Procq.Symbol.opt (Procq.Symbol.rules [Procq.Rules.make 
                                                                    (
                                                                    Procq.Rule.next_norec
                                                                    (
                                                                    Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Tok.PKEYWORD ("in")))))
                                                                    ((Procq.Symbol.nterml pattern ("200"))))
                                                                    (fun t _
                                                                    loc -> 
                                                                    
# 377 "parsing/g_constr.mlg"
                                                     t 
# 1561 "parsing/g_constr.ml"
)]))))
                            (fun ty ona c loc -> 
# 378 "parsing/g_constr.mlg"
          (c,ona,ty) 
# 1566 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty case_type) in
  let () =
  Procq.grammar_extend case_type
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("return")))))
                             ((Procq.Symbol.nterml term ("100"))))
                            (fun ty _ loc -> 
# 381 "parsing/g_constr.mlg"
                                             ty 
# 1581 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty as_return_type) in
  let () =
  Procq.grammar_extend as_return_type
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.opt (Procq.Symbol.rules [Procq.Rules.make 
                                                                    (
                                                                    Procq.Rule.next_norec
                                                                    (
                                                                    Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.opt (Procq.Symbol.rules 
                                                                    [Procq.Rules.make 
                                                                    (
                                                                    Procq.Rule.next_norec
                                                                    (
                                                                    Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Tok.PKEYWORD ("as")))))
                                                                    ((Procq.Symbol.nterm name)))
                                                                    (fun na _
                                                                    loc -> 
                                                                    
# 384 "parsing/g_constr.mlg"
                                                 na 
# 1610 "parsing/g_constr.ml"
)]))))
                                                                    ((Procq.Symbol.nterm case_type)))
                                                                    (fun ty
                                                                    na loc ->
                                                                    
# 385 "parsing/g_constr.mlg"
                                      (na,ty) 
# 1618 "parsing/g_constr.ml"
)]))))
                            (fun a loc -> 
# 386 "parsing/g_constr.mlg"
          match a with
          | None -> None, None
          | Some (na,t) -> (na, Some t) 
# 1625 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty branches) in
  let () =
  Procq.grammar_extend branches
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.opt (Procq.Symbol.token (Tok.PKEYWORD ("|"))))))
                             ((Procq.Symbol.list0sep ((Procq.Symbol.nterm eqn)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                            (fun br _ loc -> 
# 391 "parsing/g_constr.mlg"
                                            br 
# 1640 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty mult_pattern) in
  let () =
  Procq.grammar_extend mult_pattern
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.list1sep ((Procq.Symbol.nterml pattern ("200"))) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                            (fun pl loc -> 
# 394 "parsing/g_constr.mlg"
                                                    pl 
# 1653 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty eqn) in
  let () =
  Procq.grammar_extend eqn
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.list1sep ((Procq.Symbol.nterm mult_pattern)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("=>")))))
                             ((Procq.Symbol.nterm lconstr)))
                            (fun rhs _ pll loc -> 
# 398 "parsing/g_constr.mlg"
                                 (CAst.make ~loc (pll,rhs)) 
# 1670 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty record_pattern) in
  let () =
  Procq.grammar_extend record_pattern
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.nterm global)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                             ((Procq.Symbol.nterml pattern ("200"))))
                            (fun pat _ id loc -> 
# 401 "parsing/g_constr.mlg"
                                                          (id, pat) 
# 1687 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty record_patterns) in
  let () =
  Procq.grammar_extend record_patterns
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 406 "parsing/g_constr.mlg"
             [] 
# 1698 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm record_pattern)))
                           (fun p loc -> 
# 405 "parsing/g_constr.mlg"
                               [p] 
# 1706 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm record_pattern)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (";")))))
                            ((Procq.Symbol.nterm record_patterns)))
                           (fun ps _ p loc -> 
# 404 "parsing/g_constr.mlg"
                                                           p :: ps 
# 1718 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty pattern) in
  let () =
  Procq.grammar_extend pattern
  (Procq.Fresh
  (Gramlib.Gramext.First, [(Some ("200"), Some (Gramlib.Gramext.RightA), []);
                          (Some ("100"), Some (Gramlib.Gramext.RightA),
                          [Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm pattern)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                            ((Procq.Symbol.nterml term ("200"))))
                           (fun ty _ p loc -> 
# 412 "parsing/g_constr.mlg"
          CAst.make ~loc @@ CPatCast (p, ty) 
# 1736 "parsing/g_constr.ml"
)]);
                          (Some ("99"), Some (Gramlib.Gramext.RightA), []);
                          (Some ("90"), Some (Gramlib.Gramext.RightA), []);
                          (Some ("10"), Some (Gramlib.Gramext.LeftA),
                          [Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("@")))))
                             ((Procq.Symbol.nterm Prim.reference)))
                            ((Procq.Symbol.list0 Procq.Symbol.next)))
                           (fun lp r _ loc -> 
# 420 "parsing/g_constr.mlg"
          CAst.make ~loc @@ CPatCstr (r, Some lp, []) 
# 1751 "parsing/g_constr.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm pattern)))
                           ((Procq.Symbol.list1 (Procq.Symbol.next))))
                          (fun lp p loc -> 
# 418 "parsing/g_constr.mlg"
                                          mkAppPattern ~loc p lp 
# 1761 "parsing/g_constr.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm pattern)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("as")))))
                           ((Procq.Symbol.nterm name)))
                          (fun na _ p loc -> 
# 417 "parsing/g_constr.mlg"
          CAst.make ~loc @@ CPatAlias (p, na) 
# 1773 "parsing/g_constr.ml"
)]);
                          (Some ("1"), Some (Gramlib.Gramext.LeftA),
                          [Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm pattern)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("%_")))))
                            ((Procq.Symbol.token (Tok.PIDENT (None)))))
                           (fun key _ c loc -> 
# 425 "parsing/g_constr.mlg"
          CAst.make ~loc @@ CPatDelimiters (DelimOnlyTmpScope,key,c) 
# 1786 "parsing/g_constr.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm pattern)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("%")))))
                           ((Procq.Symbol.token (Tok.PIDENT (None)))))
                          (fun key _ c loc -> 
# 423 "parsing/g_constr.mlg"
          CAst.make ~loc @@ CPatDelimiters (DelimUnboundedScope,key,c) 
# 1798 "parsing/g_constr.ml"
)]);
                          (Some ("0"), None,
                          [Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm string)))
                           (fun s loc -> 
# 440 "parsing/g_constr.mlg"
                        CAst.make ~loc @@ CPatPrim (String s) 
# 1807 "parsing/g_constr.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next (Procq.Rule.stop)
                           ((Procq.Symbol.token (Tok.PNUMBER None))))
                          (fun n loc -> 
# 439 "parsing/g_constr.mlg"
                       CAst.make ~loc @@ CPatPrim (Number (NumTok.SPlus,n)) 
# 1815 "parsing/g_constr.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                              ((Procq.Symbol.nterml pattern ("200"))))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("|")))))
                            ((Procq.Symbol.list1sep ((Procq.Symbol.nterml pattern ("200"))) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                           ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                          (fun _ pl _ p _ loc -> 
# 438 "parsing/g_constr.mlg"
          CAst.make ~loc @@ CPatOr (p::pl) 
# 1831 "parsing/g_constr.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                            ((Procq.Symbol.nterml pattern ("200"))))
                           ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                          (fun _ p _ loc -> 
# 431 "parsing/g_constr.mlg"
          (* Preserve parentheses around numbers so that constrintern does not
             collapse -(3) into the number -3. *)
          match p.CAst.v with
          | CPatPrim (Number (NumTok.SPlus,n)) ->
              CAst.make ~loc @@ CPatNotation(None,(InConstrEntry,"( _ )"),([p],[],[]),[])
          | _ -> p 
# 1848 "parsing/g_constr.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next (Procq.Rule.stop)
                           ((Procq.Symbol.token (Tok.PKEYWORD ("_")))))
                          (fun _ loc -> 
# 429 "parsing/g_constr.mlg"
                 CAst.make ~loc @@ CPatAtom None 
# 1856 "parsing/g_constr.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("{|")))))
                            ((Procq.Symbol.nterm record_patterns)))
                           ((Procq.Symbol.nterm bar_cbrace)))
                          (fun _ pat _ loc -> 
# 428 "parsing/g_constr.mlg"
                                                     CAst.make ~loc @@ CPatRecord pat 
# 1868 "parsing/g_constr.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next (Procq.Rule.stop)
                           ((Procq.Symbol.nterm Prim.reference)))
                          (fun r loc -> 
# 427 "parsing/g_constr.mlg"
                                               CAst.make ~loc @@ CPatAtom (Some r) 
# 1876 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty fixannot) in
  let () =
  Procq.grammar_extend fixannot
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next
                                 (Procq.Rule.next (Procq.Rule.stop)
                                  ((Procq.Symbol.token (Tok.PKEYWORD ("{")))))
                                 ((Procq.Symbol.token (Tok.PIDENT (Some
                                 ("measure"))))))
                                ((Procq.Symbol.nterm constr)))
                               ((Procq.Symbol.opt (Procq.Symbol.nterm identref))))
                              ((Procq.Symbol.opt (Procq.Symbol.nterm constr))))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("}")))))
                            (fun _ rel id m _ _ loc -> 
# 446 "parsing/g_constr.mlg"
          CAst.make ~loc @@ CMeasureRec (id,m,rel) 
# 1900 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PKEYWORD ("{")))))
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("wf"))))))
                              ((Procq.Symbol.nterm constr)))
                             ((Procq.Symbol.nterm identref)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("}")))))
                           (fun _ id rel _ _ loc -> 
# 444 "parsing/g_constr.mlg"
                                                               CAst.make ~loc @@ CWfRec(id,rel) 
# 1917 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PKEYWORD ("{")))))
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("struct"))))))
                             ((Procq.Symbol.nterm identref)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("}")))))
                           (fun _ id _ _ loc -> 
# 443 "parsing/g_constr.mlg"
                                                     CAst.make ~loc @@ CStructRec id 
# 1932 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty binders_fixannot) in
  let () =
  Procq.grammar_extend binders_fixannot
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 451 "parsing/g_constr.mlg"
             [], None 
# 1943 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm binder)))
                            ((Procq.Symbol.nterm binders_fixannot)))
                           (fun bl b loc -> 
# 450 "parsing/g_constr.mlg"
                                               b @ fst bl, snd bl 
# 1953 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm ensure_fixannot)))
                            ((Procq.Symbol.nterm fixannot)))
                           (fun f _ loc -> 
# 449 "parsing/g_constr.mlg"
                                           [], Some f 
# 1963 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty open_binders) in
  let () =
  Procq.grammar_extend open_binders
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm closed_binder)))
                             ((Procq.Symbol.nterm binders)))
                            (fun bl' bl loc -> 
# 465 "parsing/g_constr.mlg"
          bl@bl' 
# 1978 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm name)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("..")))))
                            ((Procq.Symbol.nterm name)))
                           (fun id2 _ id1 loc -> 
# 462 "parsing/g_constr.mlg"
          [CLocalAssum ([id1;(CAst.make ~loc (Name ldots_var));id2],
                        None, Default Explicit, CAst.make ~loc @@ CHole (None))] 
# 1991 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm name)))
                             ((Procq.Symbol.list0 (Procq.Symbol.nterm name))))
                            ((Procq.Symbol.nterm binders)))
                           (fun bl idl id loc -> 
# 460 "parsing/g_constr.mlg"
          binders_of_names (id::idl) @ bl 
# 2003 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.nterm name)))
                              ((Procq.Symbol.list0 (Procq.Symbol.nterm name))))
                             ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                            ((Procq.Symbol.nterm lconstr)))
                           (fun c _ idl id loc -> 
# 457 "parsing/g_constr.mlg"
          [CLocalAssum (id::idl,None,Default Explicit,c)] 
# 2017 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty binders) in
  let () =
  Procq.grammar_extend binders
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.list0 (Procq.Symbol.nterm binder))))
                            (fun l loc -> 
# 468 "parsing/g_constr.mlg"
                              List.flatten l 
# 2030 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty binder) in
  let () =
  Procq.grammar_extend binder
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm closed_binder)))
                            (fun bl loc -> 
# 472 "parsing/g_constr.mlg"
                                bl 
# 2043 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm name)))
                           (fun id loc -> 
# 471 "parsing/g_constr.mlg"
                       [CLocalAssum ([id], None, Default Explicit, CAst.make ~loc @@ CHole (None))] 
# 2051 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty closed_binder) in
  let () =
  Procq.grammar_extend closed_binder
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("'")))))
                             ((Procq.Symbol.nterml pattern ("0"))))
                            (fun p _ loc -> 
# 511 "parsing/g_constr.mlg"
                                        [CLocalPattern p] 
# 2066 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("`[")))))
                             ((Procq.Symbol.list1sep ((Procq.Symbol.nterm typeclass_constraint)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                           (fun _ tc _ loc -> 
# 510 "parsing/g_constr.mlg"
          List.map (fun (n, b, t) -> CLocalAssum ([n], None, Generalized (NonMaxImplicit, b), t)) tc 
# 2078 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("`{")))))
                             ((Procq.Symbol.list1sep ((Procq.Symbol.nterm typeclass_constraint)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("}")))))
                           (fun _ tc _ loc -> 
# 508 "parsing/g_constr.mlg"
          List.map (fun (n, b, t) -> CLocalAssum ([n], None, Generalized (MaxImplicit, b), t)) tc 
# 2090 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("`(")))))
                             ((Procq.Symbol.list1sep ((Procq.Symbol.nterm typeclass_constraint)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                           (fun _ tc _ loc -> 
# 506 "parsing/g_constr.mlg"
          List.map (fun (n, b, t) -> CLocalAssum ([n], None, Generalized (Explicit, b), t)) tc 
# 2102 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PKEYWORD ("[")))))
                              ((Procq.Symbol.nterm name)))
                             ((Procq.Symbol.list1 ((Procq.Symbol.nterm name)))))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                           (fun _ idl id _ loc -> 
# 504 "parsing/g_constr.mlg"
          List.map (fun id -> CLocalAssum ([id], None, Default NonMaxImplicit, CAst.make ~loc @@ CHole (None))) (id::idl) 
# 2116 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PKEYWORD ("[")))))
                               ((Procq.Symbol.nterm name)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                             ((Procq.Symbol.nterm lconstr)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                           (fun _ c _ id _ loc -> 
# 502 "parsing/g_constr.mlg"
          [CLocalAssum ([id],None, Default NonMaxImplicit,c)] 
# 2132 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.token (Tok.PKEYWORD ("[")))))
                                ((Procq.Symbol.nterm name)))
                               ((Procq.Symbol.list1 ((Procq.Symbol.nterm name)))))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                             ((Procq.Symbol.nterm lconstr)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                           (fun _ c _ idl id _ loc -> 
# 500 "parsing/g_constr.mlg"
          [CLocalAssum (id::idl,None,Default NonMaxImplicit,c)] 
# 2150 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("[")))))
                             ((Procq.Symbol.nterm name)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                           (fun _ id _ loc -> 
# 498 "parsing/g_constr.mlg"
          [CLocalAssum ([id], None, Default NonMaxImplicit, CAst.make ~loc @@ CHole (None))] 
# 2162 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PKEYWORD ("{")))))
                              ((Procq.Symbol.nterm name)))
                             ((Procq.Symbol.list1 ((Procq.Symbol.nterm name)))))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("}")))))
                           (fun _ idl id _ loc -> 
# 496 "parsing/g_constr.mlg"
          List.map (fun id -> CLocalAssum ([id], None, Default MaxImplicit, CAst.make ~loc @@ CHole (None))) (id::idl) 
# 2176 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PKEYWORD ("{")))))
                               ((Procq.Symbol.nterm name)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                             ((Procq.Symbol.nterm lconstr)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("}")))))
                           (fun _ c _ id _ loc -> 
# 494 "parsing/g_constr.mlg"
          [CLocalAssum ([id],None,Default MaxImplicit,c)] 
# 2192 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.token (Tok.PKEYWORD ("{")))))
                                ((Procq.Symbol.nterm name)))
                               ((Procq.Symbol.list1 ((Procq.Symbol.nterm name)))))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                             ((Procq.Symbol.nterm lconstr)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("}")))))
                           (fun _ c _ idl id _ loc -> 
# 492 "parsing/g_constr.mlg"
          [CLocalAssum (id::idl,None,Default MaxImplicit,c)] 
# 2210 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("{")))))
                             ((Procq.Symbol.nterm name)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("}")))))
                           (fun _ id _ loc -> 
# 490 "parsing/g_constr.mlg"
          [CLocalAssum ([id], None, Default MaxImplicit, CAst.make ~loc @@ CHole (None))] 
# 2222 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next
                                 (Procq.Rule.next (Procq.Rule.stop)
                                  ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                                 ((Procq.Symbol.nterm name)))
                                ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                               ((Procq.Symbol.nterm lconstr)))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("|")))))
                             ((Procq.Symbol.nterm lconstr)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                           (fun _ c _ t _ id _ loc -> 
# 485 "parsing/g_constr.mlg"
                                                              
        let lambda = mkLambdaC ([id], default_binder_kind, t, c) in
        let typ = CAst.make ~loc @@ CAppExpl ((sigref loc,None), [CAst.make @@ CHole None; lambda]) in
          [CLocalAssum ([id], None, default_binder_kind, typ)] 
# 2245 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next
                                 (Procq.Rule.next (Procq.Rule.stop)
                                  ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                                 ((Procq.Symbol.nterm name)))
                                ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                               ((Procq.Symbol.nterm lconstr)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                             ((Procq.Symbol.nterm lconstr)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                           (fun _ c _ t _ id _ loc -> 
# 484 "parsing/g_constr.mlg"
          [CLocalDef (id,None,c,Some t)] 
# 2265 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                               ((Procq.Symbol.nterm name)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                             ((Procq.Symbol.nterm lconstr)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                           (fun _ c _ id _ loc -> 
# 480 "parsing/g_constr.mlg"
          match c.CAst.v with
          | CCast(c, Some DEFAULTcast, t) -> [CLocalDef (id,None,c,Some t)]
          | _ -> [CLocalDef (id,None,c,None)] 
# 2283 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                               ((Procq.Symbol.nterm name)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                             ((Procq.Symbol.nterm lconstr)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                           (fun _ c _ id _ loc -> 
# 478 "parsing/g_constr.mlg"
          [CLocalAssum ([id],None,Default Explicit,c)] 
# 2299 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                                ((Procq.Symbol.nterm name)))
                               ((Procq.Symbol.list1 ((Procq.Symbol.nterm name)))))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                             ((Procq.Symbol.nterm lconstr)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                           (fun _ c _ idl id _ loc -> 
# 476 "parsing/g_constr.mlg"
          [CLocalAssum (id::idl,None,Default Explicit,c)] 
# 2317 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty one_open_binder) in
  let () =
  Procq.grammar_extend one_open_binder
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm one_closed_binder)))
                            (fun b loc -> 
# 516 "parsing/g_constr.mlg"
                                   b 
# 2330 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm name)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                            ((Procq.Symbol.nterm lconstr)))
                           (fun t _ na loc -> 
# 515 "parsing/g_constr.mlg"
                                         (CAst.make ~loc @@ CPatCast (pat_of_name na, t), Explicit) 
# 2342 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm name)))
                           (fun na loc -> 
# 514 "parsing/g_constr.mlg"
                       (pat_of_name na, Explicit) 
# 2350 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty one_closed_binder) in
  let () =
  Procq.grammar_extend one_closed_binder
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("'")))))
                             ((Procq.Symbol.nterml pattern ("0"))))
                            (fun p _ loc -> 
# 524 "parsing/g_constr.mlg"
                                        (p, Explicit) 
# 2365 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PKEYWORD ("[")))))
                               ((Procq.Symbol.nterm name)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                             ((Procq.Symbol.nterm lconstr)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                           (fun _ t _ na _ loc -> 
# 523 "parsing/g_constr.mlg"
                                                   (CAst.make ~loc @@ CPatCast (pat_of_name na, t), NonMaxImplicit) 
# 2381 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("[")))))
                             ((Procq.Symbol.nterm name)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                           (fun _ na _ loc -> 
# 522 "parsing/g_constr.mlg"
                                 (pat_of_name na, NonMaxImplicit) 
# 2393 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PKEYWORD ("{")))))
                               ((Procq.Symbol.nterm name)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                             ((Procq.Symbol.nterm lconstr)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("}")))))
                           (fun _ t _ na _ loc -> 
# 521 "parsing/g_constr.mlg"
                                                   (CAst.make ~loc @@ CPatCast (pat_of_name na, t), MaxImplicit) 
# 2409 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("{")))))
                             ((Procq.Symbol.nterm name)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("}")))))
                           (fun _ na _ loc -> 
# 520 "parsing/g_constr.mlg"
                                 (pat_of_name na, MaxImplicit) 
# 2421 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                               ((Procq.Symbol.nterm name)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                             ((Procq.Symbol.nterm lconstr)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                           (fun _ t _ na _ loc -> 
# 519 "parsing/g_constr.mlg"
                                                   (CAst.make ~loc @@ CPatCast (pat_of_name na, t), Explicit) 
# 2437 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty typeclass_constraint) in
  let () =
  Procq.grammar_extend typeclass_constraint
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterml term ("200"))))
                            (fun c loc -> 
# 533 "parsing/g_constr.mlg"
            (CAst.make ~loc Anonymous), false, c 
# 2450 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.nterm test_name_colon)))
                               ((Procq.Symbol.nterm name)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                             ((Procq.Symbol.rules [Procq.Rules.make (Procq.Rule.stop)
                                                                    (fun
                                                                    loc -> 
                                                                    
# 530 "parsing/g_constr.mlg"
                                                                           false 
# 2467 "parsing/g_constr.ml"
);
                                                  Procq.Rules.make (Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Tok.PKEYWORD ("!")))))
                                                                   (fun _
                                                                   loc -> 
                                                                   
# 530 "parsing/g_constr.mlg"
                                                             true 
# 2477 "parsing/g_constr.ml"
)])))
                            ((Procq.Symbol.nterml term ("200"))))
                           (fun c expl _ iid _ loc -> 
# 531 "parsing/g_constr.mlg"
            iid, expl, c 
# 2483 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.token (Tok.PKEYWORD ("{")))))
                                ((Procq.Symbol.nterm name)))
                               ((Procq.Symbol.token (Tok.PKEYWORD ("}")))))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                             ((Procq.Symbol.rules [Procq.Rules.make (Procq.Rule.stop)
                                                                    (fun
                                                                    loc -> 
                                                                    
# 528 "parsing/g_constr.mlg"
                                                                   false 
# 2502 "parsing/g_constr.ml"
);
                                                  Procq.Rules.make (Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Tok.PKEYWORD ("!")))))
                                                                   (fun _
                                                                   loc -> 
                                                                   
# 528 "parsing/g_constr.mlg"
                                                     true 
# 2512 "parsing/g_constr.ml"
)])))
                            ((Procq.Symbol.nterml term ("200"))))
                           (fun c expl _ _ id _ loc -> 
# 529 "parsing/g_constr.mlg"
            id, expl, c 
# 2518 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("!")))))
                            ((Procq.Symbol.nterml term ("200"))))
                           (fun c _ loc -> 
# 527 "parsing/g_constr.mlg"
                                        (CAst.make ~loc Anonymous), true, c 
# 2528 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty type_cstr) in
  let () =
  Procq.grammar_extend type_cstr
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 537 "parsing/g_constr.mlg"
             CAst.make ~loc @@ CHole (None) 
# 2539 "parsing/g_constr.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                            ((Procq.Symbol.nterm lconstr)))
                           (fun c _ loc -> 
# 536 "parsing/g_constr.mlg"
                              c 
# 2549 "parsing/g_constr.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty let_type_cstr) in
  let () =
  Procq.grammar_extend let_type_cstr
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.opt (Procq.Symbol.rules [Procq.Rules.make 
                                                                    (
                                                                    Procq.Rule.next_norec
                                                                    (
                                                                    Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                                                                    ((Procq.Symbol.nterm lconstr)))
                                                                    (fun c _
                                                                    loc -> 
                                                                    
# 540 "parsing/g_constr.mlg"
                                       c 
# 2571 "parsing/g_constr.ml"
)]))))
                            (fun c loc -> 
# 540 "parsing/g_constr.mlg"
                                                  Loc.tag ~loc c 
# 2576 "parsing/g_constr.ml"
)])]))
  in ()

