(************************************************************************)
(*         *      The Rocq Prover / The Rocq Development Team           *)
(*  v      *         Copyright INRIA, CNRS and contributors             *)
(* <O___,, * (see version control and CREDITS file for authors & dates) *)
(*   \VV/  **************************************************************)
(*    //   *    This file is distributed under the terms of the         *)
(*         *     GNU Lesser General Public License Version 2.1          *)
(*         *     (see LICENSE file for the text of the license)         *)
(************************************************************************)

type t =
  { boot : bool
  ; coqlib : string option
  ; sort : bool
  ; vos : bool
  ; noglob : bool
  ; ml_path : string list
  ; vo_path : (bool * string * string) list
  ; dyndep : string
  ; worker : string option
  ; files : string list
  }

val make : unit -> t
val usage : unit -> 'a
val parse : t -> string list -> t
