/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.exception;

import java.sql.SQLException;
import org.jooq.exception.SQLStateClass;
import org.jooq.exception.SQLStateSubclass;

public class DataAccessException
extends RuntimeException {
    private static final long serialVersionUID = 491834858363345767L;
    private static int maxCauseLookups = 256;

    public DataAccessException(String message) {
        super(message);
    }

    public DataAccessException(String message, Throwable cause) {
        super(message, cause);
    }

    public String sqlState() {
        SQLException e = this.getCause(SQLException.class);
        if (e != null) {
            return e.getSQLState();
        }
        return "00000";
    }

    public SQLStateClass sqlStateClass() {
        SQLException e = this.getCause(SQLException.class);
        if (e != null) {
            return SQLStateClass.fromCode(e.getSQLState());
        }
        return SQLStateClass.NONE;
    }

    public SQLStateSubclass sqlStateSubclass() {
        SQLException e = this.getCause(SQLException.class);
        if (e != null) {
            return SQLStateSubclass.fromCode(e.getSQLState());
        }
        return SQLStateSubclass.NONE;
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        return super.getStackTrace();
    }

    public <T extends Throwable> T getCause(Class<? extends T> type) {
        Throwable next = this.getCause();
        for (int i = 0; i < maxCauseLookups; ++i) {
            if (next == null) {
                return null;
            }
            if (type.isInstance(next)) {
                return (T)next;
            }
            Throwable prev = next;
            if (prev != (next = next.getCause())) continue;
            return null;
        }
        return null;
    }
}

