/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.EntropySource;
import org.bouncycastle.crypto.EntropySourceProvider;
import org.bouncycastle.crypto.SecureRandomProvider;
import org.bouncycastle.crypto.fips.FipsDRBG;
import org.bouncycastle.crypto.fips.FipsNative;
import org.bouncycastle.crypto.fips.FipsSecureRandom;
import org.bouncycastle.crypto.fips.FipsStatus;
import org.bouncycastle.crypto.util.BasicEntropySourceProvider;
import org.bouncycastle.jcajce.provider.AsymmetricKeyInfoConverter;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.EntropyDaemon;
import org.bouncycastle.jcajce.provider.EntropyGatherer;
import org.bouncycastle.jcajce.provider.ProvAES;
import org.bouncycastle.jcajce.provider.ProvARC4;
import org.bouncycastle.jcajce.provider.ProvARIA;
import org.bouncycastle.jcajce.provider.ProvBCFKS;
import org.bouncycastle.jcajce.provider.ProvBlowfish;
import org.bouncycastle.jcajce.provider.ProvCAST5;
import org.bouncycastle.jcajce.provider.ProvCamellia;
import org.bouncycastle.jcajce.provider.ProvChaCha20;
import org.bouncycastle.jcajce.provider.ProvDES;
import org.bouncycastle.jcajce.provider.ProvDESede;
import org.bouncycastle.jcajce.provider.ProvDH;
import org.bouncycastle.jcajce.provider.ProvDSA;
import org.bouncycastle.jcajce.provider.ProvDSTU4145;
import org.bouncycastle.jcajce.provider.ProvEC;
import org.bouncycastle.jcajce.provider.ProvECGOST3410;
import org.bouncycastle.jcajce.provider.ProvEdEC;
import org.bouncycastle.jcajce.provider.ProvElgamal;
import org.bouncycastle.jcajce.provider.ProvFipsKS;
import org.bouncycastle.jcajce.provider.ProvGOST28147;
import org.bouncycastle.jcajce.provider.ProvGOST3410;
import org.bouncycastle.jcajce.provider.ProvIDEA;
import org.bouncycastle.jcajce.provider.ProvJKS;
import org.bouncycastle.jcajce.provider.ProvKMAC;
import org.bouncycastle.jcajce.provider.ProvLMS;
import org.bouncycastle.jcajce.provider.ProvOpenSSLPBKDF;
import org.bouncycastle.jcajce.provider.ProvPBEPBKDF1;
import org.bouncycastle.jcajce.provider.ProvPBEPBKDF2;
import org.bouncycastle.jcajce.provider.ProvPBESCRYPT;
import org.bouncycastle.jcajce.provider.ProvPKCS12;
import org.bouncycastle.jcajce.provider.ProvPKIX;
import org.bouncycastle.jcajce.provider.ProvPoly1305;
import org.bouncycastle.jcajce.provider.ProvRC2;
import org.bouncycastle.jcajce.provider.ProvRSA;
import org.bouncycastle.jcajce.provider.ProvRandom;
import org.bouncycastle.jcajce.provider.ProvSEED;
import org.bouncycastle.jcajce.provider.ProvSHACAL2;
import org.bouncycastle.jcajce.provider.ProvSHS;
import org.bouncycastle.jcajce.provider.ProvSecureHash;
import org.bouncycastle.jcajce.provider.ProvSerpent;
import org.bouncycastle.jcajce.provider.ProvSipHash;
import org.bouncycastle.jcajce.provider.ProvTwofish;
import org.bouncycastle.jcajce.provider.ProvX509;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Properties;
import org.bouncycastle.util.Strings;

public final class BouncyCastleFipsProvider
extends Provider {
    public static final String INFO = "BouncyCastle Security Provider (FIPS edition) v2.1.1";
    public static final String PROVIDER_NAME = "BCFIPS";
    private static final Map<String, FipsDRBG.Base> drbgTable = new HashMap<String, FipsDRBG.Base>();
    private static final Map<String, Integer> drbgStrengthTable = new HashMap<String, Integer>();
    private FipsDRBG.Base providerDefaultRandomBuilder = FipsDRBG.SHA512;
    private int providerDefaultSecurityStrength = 256;
    private boolean providerDefaultPredictionResistance = true;
    private boolean useThreadLocal = false;
    private boolean hybridSource = false;
    private final AtomicInteger providerDefaultRandomSecurityStrength = new AtomicInteger(this.providerDefaultSecurityStrength);
    private final SecureRandomProvider providerDefaultSecureRandomProvider;
    private Map<String, BcService> serviceMap = new ConcurrentHashMap<String, BcService>();
    private Map<String, EngineCreator> creatorMap = new HashMap<String, EngineCreator>();
    private final Map<ASN1ObjectIdentifier, AsymmetricKeyInfoConverter> keyInfoConverters = new HashMap<ASN1ObjectIdentifier, AsymmetricKeyInfoConverter>();
    private WeakReference<Set<Provider.Service>> serviceSetCache = new WeakReference<Object>(null);
    private SecureRandom entopySource = null;
    private Thread entropyThread = null;
    private EntropyDaemon entropyDaemon = null;
    private final Map<Map<String, String>, Map<String, String>> attributeMaps = new HashMap<Map<String, String>, Map<String, String>>();
    static final int POOL_SIZE;

    public static String getInfoString() {
        return INFO;
    }

    public BouncyCastleFipsProvider() {
        this((String)null);
    }

    public BouncyCastleFipsProvider(String string) {
        this(string, null);
    }

    public BouncyCastleFipsProvider(String string, SecureRandom secureRandom) {
        super(PROVIDER_NAME, 2.101, BouncyCastleFipsProvider.getInfoString());
        this.entopySource = secureRandom;
        if (string != null) {
            if (string.startsWith("C:") || string.startsWith("c:")) {
                this.processConfigString(Strings.toUpperCase(string));
            } else {
                throw new IllegalArgumentException("Unrecognized config string passed to BCFIPS provider.");
            }
        }
        this.providerDefaultSecureRandomProvider = this.useThreadLocal ? new ThreadLocalSecureRandomProvider() : new PooledSecureRandomProvider();
        new ProvRandom().configure(this);
        new ProvSHS.SHA1().configure(this);
        new ProvSHS.SHA224().configure(this);
        new ProvSHS.SHA256().configure(this);
        new ProvSHS.SHA384().configure(this);
        new ProvSHS.SHA512().configure(this);
        new ProvSHS.SHA3_224().configure(this);
        new ProvSHS.SHA3_256().configure(this);
        new ProvSHS.SHA3_384().configure(this);
        new ProvSHS.SHA3_512().configure(this);
        new ProvSHS.SHAKE128().configure(this);
        new ProvSHS.SHAKE256().configure(this);
        new ProvKMAC().configure(this);
        if (!this.isDisabled("MD5")) {
            new ProvSecureHash.MD5().configure(this);
        }
        new ProvPBESCRYPT().configure(this);
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            new ProvSecureHash.GOST3411().configure(this);
            new ProvSecureHash.GOST3411_2012_256().configure(this);
            new ProvSecureHash.GOST3411_2012_512().configure(this);
            new ProvSecureHash.RIPEMD128().configure(this);
            new ProvSecureHash.RIPEMD160().configure(this);
            new ProvSecureHash.RIPEMD256().configure(this);
            new ProvSecureHash.RIPEMD320().configure(this);
            new ProvSecureHash.Tiger().configure(this);
            new ProvSecureHash.Whirlpool().configure(this);
        }
        new ProvDH().configure(this);
        new ProvDSA().configure(this);
        if (!Properties.isOverrideSet("org.bouncycastle.ec.disable")) {
            new ProvEC().configure(this);
        }
        new ProvRSA().configure(this);
        new ProvPBEPBKDF2().configure(this);
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            new ProvPBEPBKDF1().configure(this);
            new ProvOpenSSLPBKDF().configure(this);
            new ProvPKCS12().configure(this);
        }
        new ProvAES().configure(this);
        new ProvDESede().configure(this);
        new ProvX509().configure(this);
        new ProvBCFKS().configure(this);
        new ProvFipsKS().configure(this);
        new ProvEdEC().configure(this);
        new ProvLMS().configure(this);
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            new ProvDSTU4145().configure(this);
            new ProvElgamal().configure(this);
            new ProvGOST3410().configure(this);
            new ProvECGOST3410().configure(this);
            new ProvARIA().configure(this);
            new ProvBlowfish().configure(this);
            new ProvCAST5().configure(this);
            new ProvRC2().configure(this);
            new ProvGOST28147().configure(this);
            new ProvSEED().configure(this);
            new ProvCamellia().configure(this);
            new ProvChaCha20().configure(this);
            new ProvDES().configure(this);
            new ProvIDEA().configure(this);
            new ProvSerpent().configure(this);
            new ProvSHACAL2().configure(this);
            new ProvTwofish().configure(this);
            new ProvARC4().configure(this);
            new ProvSipHash().configure(this);
            new ProvPoly1305().configure(this);
        }
        if (!Properties.isOverrideSet("org.bouncycastle.pkix.disable_certpath")) {
            new ProvPKIX().configure(this);
        }
        if (Properties.isOverrideSet("org.bouncycastle.jca.enable_jks")) {
            new ProvJKS().configure(this);
        }
    }

    private EntropySourceProvider getDefaultEntropySourceProvider() {
        EntropySourceProvider entropySourceProvider = FipsNative.isEnabled() ? CryptoServicesRegistrar.getDefaultEntropySourceProvider() : this.getEntropySourceProvider();
        return entropySourceProvider;
    }

    @Override
    public Provider configure(String string) {
        return new BouncyCastleFipsProvider(string);
    }

    private void processConfigString(String string) {
        String[] stringArray = string.substring(2).split(";");
        boolean bl = false;
        for (String string2 : stringArray) {
            if (string2.startsWith("DEFRND")) {
                String string3 = this.extractString('[', ']', string2);
                String string4 = null;
                String string5 = null;
                int n = string3.indexOf(",");
                if (n > 0) {
                    string4 = string3.substring(0, n).trim();
                    string5 = string3.substring(n + 1).trim();
                } else if (string3.equals("TRUE") || string3.equals("FALSE")) {
                    string5 = string3;
                } else if (string3.equals("LOCAL")) {
                    this.useThreadLocal = true;
                } else {
                    string4 = string3;
                }
                if (string5 != null) {
                    this.providerDefaultPredictionResistance = Boolean.valueOf(string5);
                }
                if (string4 == null) continue;
                this.providerDefaultRandomBuilder = drbgTable.get(string4);
                if (drbgStrengthTable.containsKey(string4)) {
                    this.providerDefaultSecurityStrength = drbgStrengthTable.get(string4);
                }
                if (this.providerDefaultRandomBuilder != null) continue;
                throw new IllegalArgumentException("Unknown DEFRND - " + string4 + " - found in config string.");
            }
            if (string2.startsWith("HYBRID")) {
                this.hybridSource = true;
                this.entropyDaemon = new EntropyDaemon();
                this.entropyThread = new Thread((Runnable)this.entropyDaemon, "BC FIPS Entropy Daemon");
                this.entropyThread.setDaemon(true);
                this.entropyThread.start();
                continue;
            }
            if (!string2.startsWith("ENABLE") || !"ENABLE{ALL}".equals(string2)) continue;
            bl = true;
        }
        if (!bl) {
            throw new IllegalArgumentException("No ENABLE command found in config string.");
        }
    }

    private String extractString(char c, char c2, String string) {
        int n = string.indexOf(c);
        int n2 = string.indexOf(c2);
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Unable to parse config: ('" + c + "', '" + c2 + "') missing.");
        }
        return string.substring(n + 1, n2);
    }

    int getProviderDefaultSecurityStrength() {
        return this.providerDefaultSecurityStrength;
    }

    FipsDRBG.Base getProviderDefaultRandomBuilder() {
        return this.providerDefaultRandomBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecureRandom getDefaultSecureRandom() {
        SecureRandom secureRandom = CryptoServicesRegistrar.getSecureRandomIfSet(this.providerDefaultSecureRandomProvider);
        if (secureRandom instanceof FipsSecureRandom) {
            int n;
            int n2 = ((FipsSecureRandom)secureRandom).getSecurityStrength();
            if (n2 < (n = this.providerDefaultRandomSecurityStrength.get())) {
                AtomicInteger atomicInteger = this.providerDefaultRandomSecurityStrength;
                synchronized (atomicInteger) {
                    if (n2 < this.providerDefaultRandomSecurityStrength.get()) {
                        this.providerDefaultRandomSecurityStrength.set(n2);
                    }
                }
            }
        } else {
            this.providerDefaultRandomSecurityStrength.set(-1);
        }
        return secureRandom;
    }

    EntropySourceProvider getEntropySourceProvider() {
        return AccessController.doPrivileged(new PrivilegedAction<EntropySourceProvider>(){

            @Override
            public EntropySourceProvider run() {
                if (BouncyCastleFipsProvider.this.hybridSource) {
                    return new EntropySourceProvider(){

                        @Override
                        public EntropySource get(int n) {
                            return new HybridEntropySource(BouncyCastleFipsProvider.this.entropyDaemon, n, BouncyCastleFipsProvider.this.getCoreSecureRandom());
                        }
                    };
                }
                return new BasicEntropySourceProvider(BouncyCastleFipsProvider.this.getCoreSecureRandom(), true);
            }
        });
    }

    private SecureRandom getCoreSecureRandom() {
        return AccessController.doPrivileged(new PrivilegedAction<SecureRandom>(){

            @Override
            public SecureRandom run() {
                try {
                    return SecureRandom.getInstanceStrong();
                }
                catch (Exception exception) {
                    return new SecureRandom();
                }
            }
        });
    }

    public int getDefaultRandomSecurityStrength() {
        return this.providerDefaultRandomSecurityStrength.get();
    }

    void addAttribute(String string, String string2, String string3) {
        String string4 = string + " " + string2;
        if (this.containsKey(string4)) {
            throw new IllegalStateException("duplicate provider attribute key (" + string4 + ") found");
        }
        this.put(string4, string3);
    }

    void addAttribute(String string, ASN1ObjectIdentifier aSN1ObjectIdentifier, String string2, String string3) {
        String string4 = string + "." + aSN1ObjectIdentifier + " " + string2;
        if (this.containsKey(string4)) {
            throw new IllegalStateException("duplicate provider attribute key (" + string4 + ") found");
        }
        this.put(string4, string3);
    }

    void addAttributes(String string, Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.addAttribute(string, entry.getKey(), entry.getValue());
        }
    }

    void addAttributes(String string, ASN1ObjectIdentifier aSN1ObjectIdentifier, Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.addAttribute(string, aSN1ObjectIdentifier, entry.getKey(), entry.getValue());
        }
    }

    void addAlgorithmImplementation(String string, String string2, Map<String, String> map, EngineCreator engineCreator) {
        if (this.containsKey(string)) {
            throw new IllegalStateException("duplicate provider key (" + string + ") found");
        }
        this.addAttribute(string, "ImplementedIn", "Software");
        this.addAttributes(string, map);
        this.put(string, string2);
        this.creatorMap.put(string2, engineCreator);
    }

    void addAlgorithmImplementation(String string, String string2, EngineCreator engineCreator) {
        if (this.containsKey(string)) {
            throw new IllegalStateException("duplicate provider key (" + string + ") found");
        }
        this.addAttribute(string, "ImplementedIn", "Software");
        this.put(string, string2);
        this.creatorMap.put(string2, engineCreator);
    }

    void addAlgorithmImplementation(String string, ASN1ObjectIdentifier aSN1ObjectIdentifier, String string2, EngineCreator engineCreator) {
        String string3 = string + "." + aSN1ObjectIdentifier;
        if (this.containsKey(string3)) {
            throw new IllegalStateException("duplicate provider key (" + string3 + ") found");
        }
        this.addAttribute(string, aSN1ObjectIdentifier, "ImplementedIn", "Software");
        this.put(string3, string2);
        this.creatorMap.put(string2, engineCreator);
        this.addAlias(string, aSN1ObjectIdentifier.getId(), "OID." + aSN1ObjectIdentifier.getId());
    }

    void addAlgorithmImplementation(String string, ASN1ObjectIdentifier aSN1ObjectIdentifier, String string2, Map<String, String> map, EngineCreator engineCreator) {
        String string3 = string + "." + aSN1ObjectIdentifier;
        if (this.containsKey(string3)) {
            throw new IllegalStateException("duplicate provider key (" + string3 + ") found");
        }
        this.addAttributes(string, aSN1ObjectIdentifier, map);
        this.addAttribute(string, aSN1ObjectIdentifier, "ImplementedIn", "Software");
        this.put(string3, string2);
        this.creatorMap.put(string2, engineCreator);
        this.addAlias(string, aSN1ObjectIdentifier.getId(), "OID." + aSN1ObjectIdentifier.getId());
    }

    void addAlias(String string, String string2) {
        if (this.containsKey(string)) {
            throw new IllegalStateException("duplicate provider key (" + string + ") found");
        }
        this.put(string, string2);
    }

    void addAlias(String string, String string2, String ... stringArray) {
        if (!this.containsKey(string + "." + string2)) {
            throw new IllegalStateException("primary key (" + string + "." + string2 + ") not found");
        }
        for (String string3 : stringArray) {
            this.doPut("Alg.Alias." + string + "." + string3, string2);
        }
    }

    void addAlias(String string, String string2, ASN1ObjectIdentifier ... aSN1ObjectIdentifierArray) {
        if (!this.containsKey(string + "." + string2)) {
            throw new IllegalStateException("primary key (" + string + "." + string2 + ") not found");
        }
        for (ASN1ObjectIdentifier aSN1ObjectIdentifier : aSN1ObjectIdentifierArray) {
            this.doPut("Alg.Alias." + string + "." + aSN1ObjectIdentifier, string2);
            this.doPut("Alg.Alias." + string + ".OID." + aSN1ObjectIdentifier, string2);
        }
    }

    private void doPut(String string, String string2) {
        if (this.containsKey(string)) {
            throw new IllegalStateException("duplicate provider key (" + string + ") found");
        }
        this.put(string, string2);
    }

    @Override
    public final Provider.Service getService(String string, String string2) {
        String string3 = Strings.toUpperCase(string2);
        Object object = this.serviceMap.get(string + "." + string3);
        if (object == null) {
            String string4;
            String string5 = "Alg.Alias." + string + ".";
            String string6 = (String)this.get(string5 + string3);
            if (string6 == null) {
                string6 = string3;
            }
            if ((string4 = (String)this.get(string + "." + string6)) == null) {
                return null;
            }
            String string7 = string + "." + string6 + " ";
            ArrayList<String> arrayList = new ArrayList<String>();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (Map.Entry<Object, Object> entry : this.entrySet()) {
                String string8 = (String)entry.getKey();
                if (string8.startsWith(string5) && entry.getValue().equals(string2)) {
                    arrayList.add(string8.substring(string5.length()));
                }
                if (!string8.startsWith(string7)) continue;
                hashMap.put(string8.substring(string7.length()), (String)entry.getValue());
            }
            object = new BcService(this, string, string3, string4, arrayList, this.getAttributeMap(hashMap), this.creatorMap.get(string4));
            BcService bcService = this.serviceMap.putIfAbsent(string + "." + string3, (BcService)object);
            object = bcService != null ? bcService : object;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Set<Provider.Service> getServices() {
        Set<Provider.Service> set = (LinkedHashSet<Provider.Service>)this.serviceSetCache.get();
        if (set == null) {
            BouncyCastleFipsProvider bouncyCastleFipsProvider = this;
            synchronized (bouncyCastleFipsProvider) {
                Set<Provider.Service> set2 = super.getServices();
                set = new LinkedHashSet<Provider.Service>();
                set.add(this.getService("SecureRandom", "DEFAULT"));
                set.add(this.getService("SecureRandom", "NONCEANDIV"));
                for (Provider.Service service : set2) {
                    Provider.Service service2 = this.getService(service.getType(), service.getAlgorithm());
                    if (service2 == null) continue;
                    set.add(service2);
                }
                set = Collections.unmodifiableSet(set);
                this.serviceSetCache = new WeakReference(set);
            }
        }
        return set;
    }

    void addKeyInfoConverter(ASN1ObjectIdentifier aSN1ObjectIdentifier, AsymmetricKeyInfoConverter asymmetricKeyInfoConverter) {
        this.keyInfoConverters.put(aSN1ObjectIdentifier, asymmetricKeyInfoConverter);
    }

    private boolean isDisabled(String string) {
        String string2 = Properties.getPropertyValue("org.bouncycastle.disabledAlgorithms");
        return string2 != null && string2.indexOf(string) >= 0;
    }

    private byte[] generatePersonalizationString(int n) {
        return Arrays.concatenate(Pack.intToBigEndian(n), Pack.longToBigEndian(Thread.currentThread().getId()), Pack.longToBigEndian(System.currentTimeMillis()));
    }

    private synchronized Map<String, String> getAttributeMap(Map<String, String> map) {
        Map<String, String> map2 = this.attributeMaps.get(map);
        if (map2 != null) {
            return map2;
        }
        this.attributeMaps.put(map, map);
        return map;
    }

    PublicKey getPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        AsymmetricKeyInfoConverter asymmetricKeyInfoConverter = this.keyInfoConverters.get(subjectPublicKeyInfo.getAlgorithm().getAlgorithm());
        if (asymmetricKeyInfoConverter == null) {
            return null;
        }
        return asymmetricKeyInfoConverter.generatePublic(subjectPublicKeyInfo);
    }

    PrivateKey getPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        AsymmetricKeyInfoConverter asymmetricKeyInfoConverter = this.keyInfoConverters.get(privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm());
        if (asymmetricKeyInfoConverter == null) {
            return null;
        }
        return asymmetricKeyInfoConverter.generatePrivate(privateKeyInfo);
    }

    private static int getPoolSize() {
        int n;
        String string = Properties.getPropertyValue("org.bouncycastle.drbg.pool_size");
        if (string != null) {
            n = Integer.parseInt(string);
            if (n < 2) {
                return 2;
            }
        } else {
            n = Runtime.getRuntime().availableProcessors() * 2;
        }
        return Integer.highestOneBit(n);
    }

    static {
        drbgTable.put("SHA1", FipsDRBG.SHA1);
        drbgTable.put("SHA224", FipsDRBG.SHA224);
        drbgTable.put("SHA256", FipsDRBG.SHA256);
        drbgTable.put("SHA384", FipsDRBG.SHA384);
        drbgTable.put("SHA512", FipsDRBG.SHA512);
        drbgTable.put("SHA512(224)", FipsDRBG.SHA512_224);
        drbgTable.put("SHA512(256)", FipsDRBG.SHA512_256);
        drbgTable.put("HMACSHA1", FipsDRBG.SHA1_HMAC);
        drbgTable.put("HMACSHA224", FipsDRBG.SHA224_HMAC);
        drbgTable.put("HMACSHA256", FipsDRBG.SHA256_HMAC);
        drbgTable.put("HMACSHA384", FipsDRBG.SHA384_HMAC);
        drbgTable.put("HMACSHA512", FipsDRBG.SHA512_HMAC);
        drbgTable.put("HMACSHA512(224)", FipsDRBG.SHA512_224_HMAC);
        drbgTable.put("HMACSHA512(256)", FipsDRBG.SHA512_256_HMAC);
        drbgTable.put("CTRAES128", FipsDRBG.CTR_AES_128);
        drbgTable.put("CTRAES192", FipsDRBG.CTR_AES_192);
        drbgTable.put("CTRAES256", FipsDRBG.CTR_AES_256);
        drbgTable.put("CTRDESEDE", FipsDRBG.CTR_Triple_DES_168);
        drbgStrengthTable.put("SHA1", 128);
        drbgStrengthTable.put("SHA224", 192);
        drbgStrengthTable.put("SHA256", 256);
        drbgStrengthTable.put("SHA384", 256);
        drbgStrengthTable.put("SHA512", 256);
        drbgStrengthTable.put("SHA512(224)", 192);
        drbgStrengthTable.put("SHA512(256)", 256);
        drbgStrengthTable.put("HMACSHA1", 128);
        drbgStrengthTable.put("HMACSHA224", 192);
        drbgStrengthTable.put("HMACSHA256", 256);
        drbgStrengthTable.put("HMACSHA384", 256);
        drbgStrengthTable.put("HMACSHA512", 256);
        drbgStrengthTable.put("HMACSHA512(224)", 192);
        drbgStrengthTable.put("HMACSHA512(256)", 256);
        drbgStrengthTable.put("CTRAES128", 128);
        drbgStrengthTable.put("CTRAES192", 192);
        drbgStrengthTable.put("CTRAES256", 256);
        drbgStrengthTable.put("CTRDESEDE", 112);
        POOL_SIZE = BouncyCastleFipsProvider.getPoolSize();
    }

    private static class BcService
    extends Provider.Service {
        private final EngineCreator creator;

        public BcService(Provider provider, String string, String string2, String string3, List<String> list, Map<String, String> map, EngineCreator engineCreator) {
            super(provider, string, string2, string3, list, map);
            this.creator = engineCreator;
        }

        @Override
        public Object newInstance(Object object) throws NoSuchAlgorithmException {
            try {
                FipsStatus.isReady();
                Object object2 = this.creator.createInstance(object);
                if (object2 == null) {
                    throw new NoSuchAlgorithmException("No such algorithm in FIPS approved mode: " + this.getAlgorithm());
                }
                return object2;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw noSuchAlgorithmException;
            }
            catch (Exception exception) {
                throw new NoSuchAlgorithmException("Unable to invoke creator for " + this.getAlgorithm() + ": " + exception.getMessage(), exception);
            }
        }
    }

    private static class HybridEntropySource
    implements EntropySource {
        private final AtomicBoolean seedAvailable = new AtomicBoolean(false);
        private final AtomicInteger samples = new AtomicInteger(0);
        private final FipsSecureRandom drbg;
        private final SignallingEntropySource entropySource;
        private final int bytesRequired;

        HybridEntropySource(EntropyDaemon entropyDaemon, int n, SecureRandom secureRandom) {
            this.bytesRequired = (n + 7) / 8;
            this.entropySource = new SignallingEntropySource(entropyDaemon, this.seedAvailable, secureRandom, 256);
            this.drbg = FipsDRBG.SHA512.fromEntropySource(new EntropySourceProvider(){

                @Override
                public EntropySource get(int n) {
                    return entropySource;
                }
            }).setPersonalizationString(Strings.toByteArray("Bouncy Castle Hybrid Entropy Source")).build(secureRandom.generateSeed(32), false, null);
        }

        @Override
        public boolean isPredictionResistant() {
            return true;
        }

        @Override
        public byte[] getEntropy() {
            byte[] byArray = new byte[this.bytesRequired];
            if (this.samples.getAndIncrement() > 20) {
                if (this.seedAvailable.getAndSet(false)) {
                    this.samples.set(0);
                    this.drbg.reseed();
                } else {
                    this.entropySource.schedule();
                }
            }
            this.drbg.nextBytes(byArray);
            return byArray;
        }

        @Override
        public int entropySize() {
            return this.bytesRequired * 8;
        }

        private class SignallingEntropySource
        implements EntropySource {
            private final EntropyDaemon entropyDaemon;
            private final AtomicBoolean seedAvailable;
            private final SecureRandom baseRandom;
            private final int byteLength;
            private final AtomicReference entropy = new AtomicReference();
            private final AtomicBoolean scheduled = new AtomicBoolean(false);

            SignallingEntropySource(EntropyDaemon entropyDaemon, AtomicBoolean atomicBoolean, SecureRandom secureRandom, int n) {
                this.entropyDaemon = entropyDaemon;
                this.seedAvailable = atomicBoolean;
                this.baseRandom = secureRandom;
                this.byteLength = (n + 7) / 8;
            }

            @Override
            public boolean isPredictionResistant() {
                return true;
            }

            @Override
            public byte[] getEntropy() {
                byte[] byArray = this.entropy.getAndSet(null);
                if (byArray == null || byArray.length != this.byteLength) {
                    byArray = this.baseRandom.generateSeed(this.byteLength);
                } else {
                    this.scheduled.set(false);
                }
                this.schedule();
                return byArray;
            }

            void schedule() {
                if (!this.scheduled.getAndSet(true)) {
                    this.entropyDaemon.addTask(new EntropyGatherer(this.byteLength, this.baseRandom, this.seedAvailable, this.entropy));
                }
            }

            @Override
            public int entropySize() {
                return this.byteLength * 8;
            }
        }
    }

    private class PooledSecureRandomProvider
    implements SecureRandomProvider {
        private final AtomicReference<SecureRandom>[] providerDefaultRandom = new AtomicReference[POOL_SIZE];

        PooledSecureRandomProvider() {
            for (int i = 0; i != this.providerDefaultRandom.length; ++i) {
                this.providerDefaultRandom[i] = new AtomicReference();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public SecureRandom get() {
            int n = (Thread.currentThread().hashCode() & POOL_SIZE - 1) % this.providerDefaultRandom.length;
            if (this.providerDefaultRandom[n].get() != null) return this.providerDefaultRandom[n].get();
            AtomicReference<SecureRandom>[] atomicReferenceArray = this.providerDefaultRandom;
            synchronized (this.providerDefaultRandom) {
                if (this.providerDefaultRandom[n].get() != null) return this.providerDefaultRandom[n].get();
                EntropySourceProvider entropySourceProvider = BouncyCastleFipsProvider.this.getDefaultEntropySourceProvider();
                EntropySource entropySource = entropySourceProvider.get(BouncyCastleFipsProvider.this.providerDefaultSecurityStrength / 2 + 1);
                this.providerDefaultRandom[n].compareAndSet(null, BouncyCastleFipsProvider.this.providerDefaultRandomBuilder.fromEntropySource(entropySourceProvider).setPersonalizationString(BouncyCastleFipsProvider.this.generatePersonalizationString(n)).build(entropySource.getEntropy(), BouncyCastleFipsProvider.this.providerDefaultPredictionResistance, Strings.toByteArray("Bouncy Castle FIPS Provider")));
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.providerDefaultRandom[n].get();
            }
        }
    }

    private class ThreadLocalSecureRandomProvider
    implements SecureRandomProvider {
        final ThreadLocal<FipsSecureRandom> defaultRandoms = new ThreadLocal();

        private ThreadLocalSecureRandomProvider() {
        }

        @Override
        public SecureRandom get() {
            if (this.defaultRandoms.get() == null) {
                EntropySourceProvider entropySourceProvider = BouncyCastleFipsProvider.this.getDefaultEntropySourceProvider();
                EntropySource entropySource = entropySourceProvider.get(BouncyCastleFipsProvider.this.providerDefaultSecurityStrength / 2 + 1);
                this.defaultRandoms.set(BouncyCastleFipsProvider.this.providerDefaultRandomBuilder.fromEntropySource(entropySourceProvider).setPersonalizationString(BouncyCastleFipsProvider.this.generatePersonalizationString((int)Thread.currentThread().getId())).build(entropySource.getEntropy(), BouncyCastleFipsProvider.this.providerDefaultPredictionResistance, Strings.toByteArray("Bouncy Castle FIPS Provider")));
            }
            return this.defaultRandoms.get();
        }
    }
}

