import sys
from _typeshed import ReadOnlyBuffer, SupportsRead, SupportsWrite
from curses import _ncurses_version
from typing import Any, Final, final, overload
from typing_extensions import TypeAlias

# NOTE: This module is ordinarily only available on Unix, but the windows-curses
# package makes it available on Windows as well with the same contents.

# Handled by PyCurses_ConvertToChtype in _cursesmodule.c.
_ChType: TypeAlias = str | bytes | int

# ACS codes are only initialized after initscr is called
ACS_BBSS: Final[int]
ACS_BLOCK: Final[int]
ACS_BOARD: Final[int]
ACS_BSBS: Final[int]
ACS_BSSB: Final[int]
ACS_BSSS: Final[int]
ACS_BTEE: Final[int]
ACS_BULLET: Final[int]
ACS_CKBOARD: Final[int]
ACS_DARROW: Final[int]
ACS_DEGREE: Final[int]
ACS_DIAMOND: Final[int]
ACS_GEQUAL: Final[int]
ACS_HLINE: Final[int]
ACS_LANTERN: Final[int]
ACS_LARROW: Final[int]
ACS_LEQUAL: Final[int]
ACS_LLCORNER: Final[int]
ACS_LRCORNER: Final[int]
ACS_LTEE: Final[int]
ACS_NEQUAL: Final[int]
ACS_PI: Final[int]
ACS_PLMINUS: Final[int]
ACS_PLUS: Final[int]
ACS_RARROW: Final[int]
ACS_RTEE: Final[int]
ACS_S1: Final[int]
ACS_S3: Final[int]
ACS_S7: Final[int]
ACS_S9: Final[int]
ACS_SBBS: Final[int]
ACS_SBSB: Final[int]
ACS_SBSS: Final[int]
ACS_SSBB: Final[int]
ACS_SSBS: Final[int]
ACS_SSSB: Final[int]
ACS_SSSS: Final[int]
ACS_STERLING: Final[int]
ACS_TTEE: Final[int]
ACS_UARROW: Final[int]
ACS_ULCORNER: Final[int]
ACS_URCORNER: Final[int]
ACS_VLINE: Final[int]
ALL_MOUSE_EVENTS: Final[int]
A_ALTCHARSET: Final[int]
A_ATTRIBUTES: Final[int]
A_BLINK: Final[int]
A_BOLD: Final[int]
A_CHARTEXT: Final[int]
A_COLOR: Final[int]
A_DIM: Final[int]
A_HORIZONTAL: Final[int]
A_INVIS: Final[int]
A_ITALIC: Final[int]
A_LEFT: Final[int]
A_LOW: Final[int]
A_NORMAL: Final[int]
A_PROTECT: Final[int]
A_REVERSE: Final[int]
A_RIGHT: Final[int]
A_STANDOUT: Final[int]
A_TOP: Final[int]
A_UNDERLINE: Final[int]
A_VERTICAL: Final[int]
BUTTON1_CLICKED: Final[int]
BUTTON1_DOUBLE_CLICKED: Final[int]
BUTTON1_PRESSED: Final[int]
BUTTON1_RELEASED: Final[int]
BUTTON1_TRIPLE_CLICKED: Final[int]
BUTTON2_CLICKED: Final[int]
BUTTON2_DOUBLE_CLICKED: Final[int]
BUTTON2_PRESSED: Final[int]
BUTTON2_RELEASED: Final[int]
BUTTON2_TRIPLE_CLICKED: Final[int]
BUTTON3_CLICKED: Final[int]
BUTTON3_DOUBLE_CLICKED: Final[int]
BUTTON3_PRESSED: Final[int]
BUTTON3_RELEASED: Final[int]
BUTTON3_TRIPLE_CLICKED: Final[int]
BUTTON4_CLICKED: Final[int]
BUTTON4_DOUBLE_CLICKED: Final[int]
BUTTON4_PRESSED: Final[int]
BUTTON4_RELEASED: Final[int]
BUTTON4_TRIPLE_CLICKED: Final[int]
# Darwin ncurses doesn't provide BUTTON5_* constants prior to 3.12.10 and 3.13.3
if sys.version_info >= (3, 10):
    if sys.version_info >= (3, 12) or sys.platform != "darwin":
        BUTTON5_PRESSED: Final[int]
        BUTTON5_RELEASED: Final[int]
        BUTTON5_CLICKED: Final[int]
        BUTTON5_DOUBLE_CLICKED: Final[int]
        BUTTON5_TRIPLE_CLICKED: Final[int]
BUTTON_ALT: Final[int]
BUTTON_CTRL: Final[int]
BUTTON_SHIFT: Final[int]
COLOR_BLACK: Final[int]
COLOR_BLUE: Final[int]
COLOR_CYAN: Final[int]
COLOR_GREEN: Final[int]
COLOR_MAGENTA: Final[int]
COLOR_RED: Final[int]
COLOR_WHITE: Final[int]
COLOR_YELLOW: Final[int]
ERR: Final[int]
KEY_A1: Final[int]
KEY_A3: Final[int]
KEY_B2: Final[int]
KEY_BACKSPACE: Final[int]
KEY_BEG: Final[int]
KEY_BREAK: Final[int]
KEY_BTAB: Final[int]
KEY_C1: Final[int]
KEY_C3: Final[int]
KEY_CANCEL: Final[int]
KEY_CATAB: Final[int]
KEY_CLEAR: Final[int]
KEY_CLOSE: Final[int]
KEY_COMMAND: Final[int]
KEY_COPY: Final[int]
KEY_CREATE: Final[int]
KEY_CTAB: Final[int]
KEY_DC: Final[int]
KEY_DL: Final[int]
KEY_DOWN: Final[int]
KEY_EIC: Final[int]
KEY_END: Final[int]
KEY_ENTER: Final[int]
KEY_EOL: Final[int]
KEY_EOS: Final[int]
KEY_EXIT: Final[int]
KEY_F0: Final[int]
KEY_F1: Final[int]
KEY_F10: Final[int]
KEY_F11: Final[int]
KEY_F12: Final[int]
KEY_F13: Final[int]
KEY_F14: Final[int]
KEY_F15: Final[int]
KEY_F16: Final[int]
KEY_F17: Final[int]
KEY_F18: Final[int]
KEY_F19: Final[int]
KEY_F2: Final[int]
KEY_F20: Final[int]
KEY_F21: Final[int]
KEY_F22: Final[int]
KEY_F23: Final[int]
KEY_F24: Final[int]
KEY_F25: Final[int]
KEY_F26: Final[int]
KEY_F27: Final[int]
KEY_F28: Final[int]
KEY_F29: Final[int]
KEY_F3: Final[int]
KEY_F30: Final[int]
KEY_F31: Final[int]
KEY_F32: Final[int]
KEY_F33: Final[int]
KEY_F34: Final[int]
KEY_F35: Final[int]
KEY_F36: Final[int]
KEY_F37: Final[int]
KEY_F38: Final[int]
KEY_F39: Final[int]
KEY_F4: Final[int]
KEY_F40: Final[int]
KEY_F41: Final[int]
KEY_F42: Final[int]
KEY_F43: Final[int]
KEY_F44: Final[int]
KEY_F45: Final[int]
KEY_F46: Final[int]
KEY_F47: Final[int]
KEY_F48: Final[int]
KEY_F49: Final[int]
KEY_F5: Final[int]
KEY_F50: Final[int]
KEY_F51: Final[int]
KEY_F52: Final[int]
KEY_F53: Final[int]
KEY_F54: Final[int]
KEY_F55: Final[int]
KEY_F56: Final[int]
KEY_F57: Final[int]
KEY_F58: Final[int]
KEY_F59: Final[int]
KEY_F6: Final[int]
KEY_F60: Final[int]
KEY_F61: Final[int]
KEY_F62: Final[int]
KEY_F63: Final[int]
KEY_F7: Final[int]
KEY_F8: Final[int]
KEY_F9: Final[int]
KEY_FIND: Final[int]
KEY_HELP: Final[int]
KEY_HOME: Final[int]
KEY_IC: Final[int]
KEY_IL: Final[int]
KEY_LEFT: Final[int]
KEY_LL: Final[int]
KEY_MARK: Final[int]
KEY_MAX: Final[int]
KEY_MESSAGE: Final[int]
KEY_MIN: Final[int]
KEY_MOUSE: Final[int]
KEY_MOVE: Final[int]
KEY_NEXT: Final[int]
KEY_NPAGE: Final[int]
KEY_OPEN: Final[int]
KEY_OPTIONS: Final[int]
KEY_PPAGE: Final[int]
KEY_PREVIOUS: Final[int]
KEY_PRINT: Final[int]
KEY_REDO: Final[int]
KEY_REFERENCE: Final[int]
KEY_REFRESH: Final[int]
KEY_REPLACE: Final[int]
KEY_RESET: Final[int]
KEY_RESIZE: Final[int]
KEY_RESTART: Final[int]
KEY_RESUME: Final[int]
KEY_RIGHT: Final[int]
KEY_SAVE: Final[int]
KEY_SBEG: Final[int]
KEY_SCANCEL: Final[int]
KEY_SCOMMAND: Final[int]
KEY_SCOPY: Final[int]
KEY_SCREATE: Final[int]
KEY_SDC: Final[int]
KEY_SDL: Final[int]
KEY_SELECT: Final[int]
KEY_SEND: Final[int]
KEY_SEOL: Final[int]
KEY_SEXIT: Final[int]
KEY_SF: Final[int]
KEY_SFIND: Final[int]
KEY_SHELP: Final[int]
KEY_SHOME: Final[int]
KEY_SIC: Final[int]
KEY_SLEFT: Final[int]
KEY_SMESSAGE: Final[int]
KEY_SMOVE: Final[int]
KEY_SNEXT: Final[int]
KEY_SOPTIONS: Final[int]
KEY_SPREVIOUS: Final[int]
KEY_SPRINT: Final[int]
KEY_SR: Final[int]
KEY_SREDO: Final[int]
KEY_SREPLACE: Final[int]
KEY_SRESET: Final[int]
KEY_SRIGHT: Final[int]
KEY_SRSUME: Final[int]
KEY_SSAVE: Final[int]
KEY_SSUSPEND: Final[int]
KEY_STAB: Final[int]
KEY_SUNDO: Final[int]
KEY_SUSPEND: Final[int]
KEY_UNDO: Final[int]
KEY_UP: Final[int]
OK: Final[int]
REPORT_MOUSE_POSITION: Final[int]
_C_API: Any
version: Final[bytes]

def baudrate() -> int: ...
def beep() -> None: ...
def can_change_color() -> bool: ...
def cbreak(flag: bool = True, /) -> None: ...
def color_content(color_number: int, /) -> tuple[int, int, int]: ...
def color_pair(pair_number: int, /) -> int: ...
def curs_set(visibility: int, /) -> int: ...
def def_prog_mode() -> None: ...
def def_shell_mode() -> None: ...
def delay_output(ms: int, /) -> None: ...
def doupdate() -> None: ...
def echo(flag: bool = True, /) -> None: ...
def endwin() -> None: ...
def erasechar() -> bytes: ...
def filter() -> None: ...
def flash() -> None: ...
def flushinp() -> None: ...
def get_escdelay() -> int: ...
def get_tabsize() -> int: ...
def getmouse() -> tuple[int, int, int, int, int]: ...
def getsyx() -> tuple[int, int]: ...
def getwin(file: SupportsRead[bytes], /) -> window: ...
def halfdelay(tenths: int, /) -> None: ...
def has_colors() -> bool: ...

if sys.version_info >= (3, 10):
    def has_extended_color_support() -> bool: ...

if sys.version_info >= (3, 14):
    def assume_default_colors(fg: int, bg: int, /) -> None: ...

def has_ic() -> bool: ...
def has_il() -> bool: ...
def has_key(key: int, /) -> bool: ...
def init_color(color_number: int, r: int, g: int, b: int, /) -> None: ...
def init_pair(pair_number: int, fg: int, bg: int, /) -> None: ...
def initscr() -> window: ...
def intrflush(flag: bool, /) -> None: ...
def is_term_resized(nlines: int, ncols: int, /) -> bool: ...
def isendwin() -> bool: ...
def keyname(key: int, /) -> bytes: ...
def killchar() -> bytes: ...
def longname() -> bytes: ...
def meta(yes: bool, /) -> None: ...
def mouseinterval(interval: int, /) -> None: ...
def mousemask(newmask: int, /) -> tuple[int, int]: ...
def napms(ms: int, /) -> int: ...
def newpad(nlines: int, ncols: int, /) -> window: ...
def newwin(nlines: int, ncols: int, begin_y: int = 0, begin_x: int = 0, /) -> window: ...
def nl(flag: bool = True, /) -> None: ...
def nocbreak() -> None: ...
def noecho() -> None: ...
def nonl() -> None: ...
def noqiflush() -> None: ...
def noraw() -> None: ...
def pair_content(pair_number: int, /) -> tuple[int, int]: ...
def pair_number(attr: int, /) -> int: ...
def putp(string: ReadOnlyBuffer, /) -> None: ...
def qiflush(flag: bool = True, /) -> None: ...
def raw(flag: bool = True, /) -> None: ...
def reset_prog_mode() -> None: ...
def reset_shell_mode() -> None: ...
def resetty() -> None: ...
def resize_term(nlines: int, ncols: int, /) -> None: ...
def resizeterm(nlines: int, ncols: int, /) -> None: ...
def savetty() -> None: ...
def set_escdelay(ms: int, /) -> None: ...
def set_tabsize(size: int, /) -> None: ...
def setsyx(y: int, x: int, /) -> None: ...
def setupterm(term: str | None = None, fd: int = -1) -> None: ...
def start_color() -> None: ...
def termattrs() -> int: ...
def termname() -> bytes: ...
def tigetflag(capname: str, /) -> int: ...
def tigetnum(capname: str, /) -> int: ...
def tigetstr(capname: str, /) -> bytes | None: ...
def tparm(
    str: ReadOnlyBuffer,
    i1: int = 0,
    i2: int = 0,
    i3: int = 0,
    i4: int = 0,
    i5: int = 0,
    i6: int = 0,
    i7: int = 0,
    i8: int = 0,
    i9: int = 0,
    /,
) -> bytes: ...
def typeahead(fd: int, /) -> None: ...
def unctrl(ch: _ChType, /) -> bytes: ...
def unget_wch(ch: int | str, /) -> None: ...
def ungetch(ch: _ChType, /) -> None: ...
def ungetmouse(id: int, x: int, y: int, z: int, bstate: int, /) -> None: ...
def update_lines_cols() -> None: ...
def use_default_colors() -> None: ...
def use_env(flag: bool, /) -> None: ...

class error(Exception): ...

@final
class window:  # undocumented
    encoding: str
    @overload
    def addch(self, ch: _ChType, attr: int = ...) -> None: ...
    @overload
    def addch(self, y: int, x: int, ch: _ChType, attr: int = ...) -> None: ...
    @overload
    def addnstr(self, str: str, n: int, attr: int = ...) -> None: ...
    @overload
    def addnstr(self, y: int, x: int, str: str, n: int, attr: int = ...) -> None: ...
    @overload
    def addstr(self, str: str, attr: int = ...) -> None: ...
    @overload
    def addstr(self, y: int, x: int, str: str, attr: int = ...) -> None: ...
    def attroff(self, attr: int, /) -> None: ...
    def attron(self, attr: int, /) -> None: ...
    def attrset(self, attr: int, /) -> None: ...
    def bkgd(self, ch: _ChType, attr: int = 0, /) -> None: ...
    def bkgdset(self, ch: _ChType, attr: int = 0, /) -> None: ...
    def border(
        self,
        ls: _ChType = ...,
        rs: _ChType = ...,
        ts: _ChType = ...,
        bs: _ChType = ...,
        tl: _ChType = ...,
        tr: _ChType = ...,
        bl: _ChType = ...,
        br: _ChType = ...,
    ) -> None: ...
    @overload
    def box(self) -> None: ...
    @overload
    def box(self, vertch: _ChType = 0, horch: _ChType = 0) -> None: ...
    @overload
    def chgat(self, attr: int) -> None: ...
    @overload
    def chgat(self, num: int, attr: int) -> None: ...
    @overload
    def chgat(self, y: int, x: int, attr: int) -> None: ...
    @overload
    def chgat(self, y: int, x: int, num: int, attr: int) -> None: ...
    def clear(self) -> None: ...
    def clearok(self, yes: int) -> None: ...
    def clrtobot(self) -> None: ...
    def clrtoeol(self) -> None: ...
    def cursyncup(self) -> None: ...
    @overload
    def delch(self) -> None: ...
    @overload
    def delch(self, y: int, x: int) -> None: ...
    def deleteln(self) -> None: ...
    @overload
    def derwin(self, begin_y: int, begin_x: int) -> window: ...
    @overload
    def derwin(self, nlines: int, ncols: int, begin_y: int, begin_x: int) -> window: ...
    def echochar(self, ch: _ChType, attr: int = 0, /) -> None: ...
    def enclose(self, y: int, x: int, /) -> bool: ...
    def erase(self) -> None: ...
    def getbegyx(self) -> tuple[int, int]: ...
    def getbkgd(self) -> tuple[int, int]: ...
    @overload
    def getch(self) -> int: ...
    @overload
    def getch(self, y: int, x: int) -> int: ...
    @overload
    def get_wch(self) -> int | str: ...
    @overload
    def get_wch(self, y: int, x: int) -> int | str: ...
    @overload
    def getkey(self) -> str: ...
    @overload
    def getkey(self, y: int, x: int) -> str: ...
    def getmaxyx(self) -> tuple[int, int]: ...
    def getparyx(self) -> tuple[int, int]: ...
    @overload
    def getstr(self) -> bytes: ...
    @overload
    def getstr(self, n: int) -> bytes: ...
    @overload
    def getstr(self, y: int, x: int) -> bytes: ...
    @overload
    def getstr(self, y: int, x: int, n: int) -> bytes: ...
    def getyx(self) -> tuple[int, int]: ...
    @overload
    def hline(self, ch: _ChType, n: int) -> None: ...
    @overload
    def hline(self, y: int, x: int, ch: _ChType, n: int) -> None: ...
    def idcok(self, flag: bool) -> None: ...
    def idlok(self, yes: bool) -> None: ...
    def immedok(self, flag: bool) -> None: ...
    @overload
    def inch(self) -> int: ...
    @overload
    def inch(self, y: int, x: int) -> int: ...
    @overload
    def insch(self, ch: _ChType, attr: int = ...) -> None: ...
    @overload
    def insch(self, y: int, x: int, ch: _ChType, attr: int = ...) -> None: ...
    def insdelln(self, nlines: int) -> None: ...
    def insertln(self) -> None: ...
    @overload
    def insnstr(self, str: str, n: int, attr: int = ...) -> None: ...
    @overload
    def insnstr(self, y: int, x: int, str: str, n: int, attr: int = ...) -> None: ...
    @overload
    def insstr(self, str: str, attr: int = ...) -> None: ...
    @overload
    def insstr(self, y: int, x: int, str: str, attr: int = ...) -> None: ...
    @overload
    def instr(self, n: int = 2047) -> bytes: ...
    @overload
    def instr(self, y: int, x: int, n: int = 2047) -> bytes: ...
    def is_linetouched(self, line: int, /) -> bool: ...
    def is_wintouched(self) -> bool: ...
    def keypad(self, yes: bool, /) -> None: ...
    def leaveok(self, yes: bool) -> None: ...
    def move(self, new_y: int, new_x: int) -> None: ...
    def mvderwin(self, y: int, x: int) -> None: ...
    def mvwin(self, new_y: int, new_x: int) -> None: ...
    def nodelay(self, yes: bool) -> None: ...
    def notimeout(self, yes: bool) -> None: ...
    @overload
    def noutrefresh(self) -> None: ...
    @overload
    def noutrefresh(self, pminrow: int, pmincol: int, sminrow: int, smincol: int, smaxrow: int, smaxcol: int) -> None: ...
    @overload
    def overlay(self, destwin: window) -> None: ...
    @overload
    def overlay(
        self, destwin: window, sminrow: int, smincol: int, dminrow: int, dmincol: int, dmaxrow: int, dmaxcol: int
    ) -> None: ...
    @overload
    def overwrite(self, destwin: window) -> None: ...
    @overload
    def overwrite(
        self, destwin: window, sminrow: int, smincol: int, dminrow: int, dmincol: int, dmaxrow: int, dmaxcol: int
    ) -> None: ...
    def putwin(self, file: SupportsWrite[bytes], /) -> None: ...
    def redrawln(self, beg: int, num: int, /) -> None: ...
    def redrawwin(self) -> None: ...
    @overload
    def refresh(self) -> None: ...
    @overload
    def refresh(self, pminrow: int, pmincol: int, sminrow: int, smincol: int, smaxrow: int, smaxcol: int) -> None: ...
    def resize(self, nlines: int, ncols: int) -> None: ...
    def scroll(self, lines: int = 1) -> None: ...
    def scrollok(self, flag: bool) -> None: ...
    def setscrreg(self, top: int, bottom: int, /) -> None: ...
    def standend(self) -> None: ...
    def standout(self) -> None: ...
    @overload
    def subpad(self, begin_y: int, begin_x: int) -> window: ...
    @overload
    def subpad(self, nlines: int, ncols: int, begin_y: int, begin_x: int) -> window: ...
    @overload
    def subwin(self, begin_y: int, begin_x: int) -> window: ...
    @overload
    def subwin(self, nlines: int, ncols: int, begin_y: int, begin_x: int) -> window: ...
    def syncdown(self) -> None: ...
    def syncok(self, flag: bool) -> None: ...
    def syncup(self) -> None: ...
    def timeout(self, delay: int) -> None: ...
    def touchline(self, start: int, count: int, changed: bool = True) -> None: ...
    def touchwin(self) -> None: ...
    def untouchwin(self) -> None: ...
    @overload
    def vline(self, ch: _ChType, n: int) -> None: ...
    @overload
    def vline(self, y: int, x: int, ch: _ChType, n: int) -> None: ...

ncurses_version: _ncurses_version
