# -*- coding:binary -*-

require 'spec_helper'

RSpec.describe Msf::Exploit::Remote::HTTP::Nifi::Dbconnectionpool do
  subject do
    mod = ::Msf::Module.new
    mod.extend described_class
    mod
  end

  let(:valid_code) do
    200
  end

  describe '#nifi Dbconnectionpool stop_dbconnectionpool' do
    it 'raises error if page can not be reached' do
      allow(subject).to receive(:send_request_cgi) do
        res = Rex::Proto::Http::Response::E404.new
        res
      end

      expect { subject.stop_dbconnectionpool('a', 'a') }.to raise_error(Msf::Exploit::Remote::HTTP::Nifi::Dbconnectionpool::DBConnectionPoolError)
    end

    it 'raises error when unexpected response code is received' do
      allow(subject).to receive(:send_request_cgi) do
        res = Rex::Proto::Http::Response.new
        res.code = 400
        res.body = ''
        res
      end

      expect { subject.stop_dbconnectionpool('a', 'a') }.to raise_error(Msf::Exploit::Remote::HTTP::Nifi::Dbconnectionpool::DBConnectionPoolError)
    end

    it 'returns nil when successfull' do
      allow(subject).to receive(:send_request_cgi) do
        res = Rex::Proto::Http::Response.new
        res.code = valid_code
        res.body = ''
        res
      end

      expect(subject.stop_dbconnectionpool('a', 'a')).to be_nil
    end
  end

  describe '#nifi Dbconnectionpool delete_dbconnectionpool' do
    it 'raises error if page can not be reached' do
      allow(subject).to receive(:send_request_cgi) do
        res = Rex::Proto::Http::Response::E404.new
        res
      end

      expect { subject.delete_dbconnectionpool('a', 'a') }.to raise_error(Msf::Exploit::Remote::HTTP::Nifi::Dbconnectionpool::DBConnectionPoolError)
    end

    it 'raises error when unexpected response code is received' do
      allow(subject).to receive(:send_request_cgi) do
        res = Rex::Proto::Http::Response.new
        res.code = 302
        res.body = ''
        res
      end

      expect { subject.delete_dbconnectionpool('a', 'a') }.to raise_error(Msf::Exploit::Remote::HTTP::Nifi::Dbconnectionpool::DBConnectionPoolError)
    end

    it 'raises error after 20 version deletes' do
      allow(subject).to receive(:send_request_cgi) do
        res = Rex::Proto::Http::Response.new
        res.code = 400
        res.body = 'is not the most up-to-date revision'
        res
      end

      expect { subject.delete_dbconnectionpool('a', 'a') }.to raise_error(Msf::Exploit::Remote::HTTP::Nifi::Dbconnectionpool::DBConnectionPoolError)
    end

    it 'returns nil when successfull' do
      allow(subject).to receive(:send_request_cgi) do
        res = Rex::Proto::Http::Response.new
        res.code = valid_code
        res.body = ''
        res
      end

      expect(subject.delete_dbconnectionpool('a', 'a')).to be_nil
    end
  end

  describe '#nifi Dbconnectionpool start_dbconpool' do
    it 'raises error if page can not be reached' do
      allow(subject).to receive(:send_request_cgi) do
        res = Rex::Proto::Http::Response::E404.new
        res
      end

      expect { subject.start_dbconnectionpool('a', 'a') }.to raise_error(Msf::Exploit::Remote::HTTP::Nifi::Dbconnectionpool::DBConnectionPoolError)
    end

    it 'raises error when unexpected response code is received' do
      allow(subject).to receive(:send_request_cgi) do
        res = Rex::Proto::Http::Response.new
        res.code = 400
        res.body = ''
        res
      end

      expect { subject.start_dbconnectionpool('a', 'a') }.to raise_error(Msf::Exploit::Remote::HTTP::Nifi::Dbconnectionpool::DBConnectionPoolError)
    end

    it 'returns nil when successfull' do
      allow(subject).to receive(:send_request_cgi) do
        res = Rex::Proto::Http::Response.new
        res.code = valid_code
        res.body = ''
        res
      end

      expect(subject.start_dbconnectionpool('a', 'a')).to be_nil
    end
  end
end
