# -*- coding: binary -*-

module Msf::Exploit::Remote::HTTP::Gitea::URIs
  # Returns the Gitea Login URL
  #
  # @return [String] Gitea Login URL
  def gitea_url_login
    normalize_uri(target_uri.path, 'user', 'login')
  end

  # Returns the Gitea Create repository URL
  #
  # @return [String] Gitea Create repository URL
  def gitea_url_repo_create
    normalize_uri(target_uri.path, 'repo', 'create')
  end

  # Returns the Gitea Migrate repository URL
  #
  # @return [String] Gitea Migrate repository URL
  def gitea_url_repo_migrate
    normalize_uri(target_uri.path, 'repo', 'migrate')
  end

  # Returns the Gitea Settings repository URL
  #
  # @return [String] Gitea Settings repository URL
  def gitea_url_repo_settings(path)
    normalize_uri(target_uri.path, path, 'settings')
  end
end
