/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.eddsa;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import net.i2p.crypto.eddsa.EdDSAKey;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.math.Curve;
import net.i2p.crypto.eddsa.math.GroupElement;
import net.i2p.crypto.eddsa.math.ScalarOps;
import sun.security.x509.X509Key;

public final class EdDSAEngine
extends Signature {
    public static final String SIGNATURE_ALGORITHM = "NONEwithEdDSA";
    private MessageDigest digest;
    private ByteArrayOutputStream baos;
    private EdDSAKey key;
    private boolean oneShotMode;
    private byte[] oneShotBytes;
    private int oneShotOffset;
    private int oneShotLength;
    public static final AlgorithmParameterSpec ONE_SHOT_MODE = new OneShotSpec();

    public EdDSAEngine() {
        super(SIGNATURE_ALGORITHM);
    }

    public EdDSAEngine(MessageDigest messageDigest) {
        this();
        this.digest = messageDigest;
    }

    private void reset() {
        if (this.digest != null) {
            this.digest.reset();
        }
        if (this.baos != null) {
            this.baos.reset();
        }
        this.oneShotMode = false;
        this.oneShotBytes = null;
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        EdDSAPrivateKey edDSAPrivateKey;
        this.reset();
        if (privateKey instanceof EdDSAPrivateKey) {
            edDSAPrivateKey = (EdDSAPrivateKey)privateKey;
            this.key = edDSAPrivateKey;
            if (this.digest == null) {
                try {
                    this.digest = MessageDigest.getInstance(this.key.getParams().getHashAlgorithm());
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new InvalidKeyException("cannot get required digest " + this.key.getParams().getHashAlgorithm() + " for private key.");
                }
            } else if (!this.key.getParams().getHashAlgorithm().equals(this.digest.getAlgorithm())) {
                throw new InvalidKeyException("Key hash algorithm does not match chosen digest");
            }
        } else {
            throw new InvalidKeyException("cannot identify EdDSA private key: " + privateKey.getClass());
        }
        this.digestInitSign(edDSAPrivateKey);
    }

    private void digestInitSign(EdDSAPrivateKey edDSAPrivateKey) {
        int n = edDSAPrivateKey.getParams().getCurve().getField().getb();
        this.digest.update(edDSAPrivateKey.getH(), n / 8, n / 4 - n / 8);
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.reset();
        if (publicKey instanceof EdDSAPublicKey) {
            this.key = (EdDSAPublicKey)publicKey;
            if (this.digest == null) {
                try {
                    this.digest = MessageDigest.getInstance(this.key.getParams().getHashAlgorithm());
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new InvalidKeyException("cannot get required digest " + this.key.getParams().getHashAlgorithm() + " for private key.");
                }
            } else if (!this.key.getParams().getHashAlgorithm().equals(this.digest.getAlgorithm())) {
                throw new InvalidKeyException("Key hash algorithm does not match chosen digest");
            }
        } else if (publicKey instanceof X509Key) {
            EdDSAPublicKey edDSAPublicKey;
            try {
                edDSAPublicKey = new EdDSAPublicKey(new X509EncodedKeySpec(publicKey.getEncoded()));
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw new InvalidKeyException("cannot handle X.509 EdDSA public key: " + publicKey.getAlgorithm());
            }
            this.engineInitVerify(edDSAPublicKey);
        } else {
            throw new InvalidKeyException("cannot identify EdDSA public key: " + publicKey.getClass());
        }
    }

    @Override
    protected void engineUpdate(byte by) throws SignatureException {
        if (this.oneShotMode) {
            throw new SignatureException("unsupported in one-shot mode");
        }
        if (this.baos == null) {
            this.baos = new ByteArrayOutputStream(256);
        }
        this.baos.write(by);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        if (this.oneShotMode) {
            if (this.oneShotBytes != null) {
                throw new SignatureException("update() already called");
            }
            this.oneShotBytes = byArray;
            this.oneShotOffset = n;
            this.oneShotLength = n2;
        } else {
            if (this.baos == null) {
                this.baos = new ByteArrayOutputStream(256);
            }
            this.baos.write(byArray, n, n2);
        }
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        try {
            byte[] byArray = this.x_engineSign();
            return byArray;
        }
        finally {
            this.reset();
            EdDSAPrivateKey edDSAPrivateKey = (EdDSAPrivateKey)this.key;
            this.digestInitSign(edDSAPrivateKey);
        }
    }

    private byte[] x_engineSign() throws SignatureException {
        int n;
        int n2;
        byte[] byArray;
        Curve curve = this.key.getParams().getCurve();
        ScalarOps scalarOps = this.key.getParams().getScalarOps();
        byte[] byArray2 = ((EdDSAPrivateKey)this.key).geta();
        if (this.oneShotMode) {
            if (this.oneShotBytes == null) {
                throw new SignatureException("update() not called first");
            }
            byArray = this.oneShotBytes;
            n2 = this.oneShotOffset;
            n = this.oneShotLength;
        } else {
            byArray = this.baos == null ? new byte[]{} : this.baos.toByteArray();
            n2 = 0;
            n = byArray.length;
        }
        this.digest.update(byArray, n2, n);
        byte[] byArray3 = this.digest.digest();
        byArray3 = scalarOps.reduce(byArray3);
        GroupElement groupElement = this.key.getParams().getB().scalarMultiply(byArray3);
        byte[] byArray4 = groupElement.toByteArray();
        this.digest.update(byArray4);
        this.digest.update(((EdDSAPrivateKey)this.key).getAbyte());
        this.digest.update(byArray, n2, n);
        byte[] byArray5 = this.digest.digest();
        byArray5 = scalarOps.reduce(byArray5);
        byte[] byArray6 = scalarOps.multiplyAndAdd(byArray5, byArray2, byArray3);
        int n3 = curve.getField().getb();
        ByteBuffer byteBuffer = ByteBuffer.allocate(n3 / 4);
        byteBuffer.put(byArray4).put(byArray6);
        return byteBuffer.array();
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        try {
            boolean bl = this.x_engineVerify(byArray);
            return bl;
        }
        finally {
            this.reset();
        }
    }

    private boolean x_engineVerify(byte[] byArray) throws SignatureException {
        int n;
        int n2;
        byte[] byArray2;
        Curve curve = this.key.getParams().getCurve();
        int n3 = curve.getField().getb();
        if (byArray.length != n3 / 4) {
            throw new SignatureException("signature length is wrong");
        }
        this.digest.update(byArray, 0, n3 / 8);
        this.digest.update(((EdDSAPublicKey)this.key).getAbyte());
        if (this.oneShotMode) {
            if (this.oneShotBytes == null) {
                throw new SignatureException("update() not called first");
            }
            byArray2 = this.oneShotBytes;
            n2 = this.oneShotOffset;
            n = this.oneShotLength;
        } else {
            byArray2 = this.baos == null ? new byte[]{} : this.baos.toByteArray();
            n2 = 0;
            n = byArray2.length;
        }
        this.digest.update(byArray2, n2, n);
        byte[] byArray3 = this.digest.digest();
        byArray3 = this.key.getParams().getScalarOps().reduce(byArray3);
        byte[] byArray4 = Arrays.copyOfRange(byArray, n3 / 8, n3 / 4);
        GroupElement groupElement = this.key.getParams().getB().doubleScalarMultiplyVariableTime(((EdDSAPublicKey)this.key).getNegativeA(), byArray3, byArray4);
        byte[] byArray5 = groupElement.toByteArray();
        for (int i = 0; i < byArray5.length; ++i) {
            if (byArray5[i] == byArray[i]) continue;
            return false;
        }
        return true;
    }

    public byte[] signOneShot(byte[] byArray) throws SignatureException {
        return this.signOneShot(byArray, 0, byArray.length);
    }

    public byte[] signOneShot(byte[] byArray, int n, int n2) throws SignatureException {
        this.oneShotMode = true;
        this.update(byArray, n, n2);
        return this.sign();
    }

    public boolean verifyOneShot(byte[] byArray, byte[] byArray2) throws SignatureException {
        return this.verifyOneShot(byArray, 0, byArray.length, byArray2, 0, byArray2.length);
    }

    public boolean verifyOneShot(byte[] byArray, int n, int n2, byte[] byArray2) throws SignatureException {
        return this.verifyOneShot(byArray, n, n2, byArray2, 0, byArray2.length);
    }

    public boolean verifyOneShot(byte[] byArray, byte[] byArray2, int n, int n2) throws SignatureException {
        return this.verifyOneShot(byArray, 0, byArray.length, byArray2, n, n2);
    }

    public boolean verifyOneShot(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws SignatureException {
        this.oneShotMode = true;
        this.update(byArray, n, n2);
        return this.verify(byArray2, n3, n4);
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec.equals(ONE_SHOT_MODE)) {
            if (this.oneShotBytes != null || this.baos != null && this.baos.size() > 0) {
                throw new InvalidAlgorithmParameterException("update() already called");
            }
            this.oneShotMode = true;
        } else {
            super.engineSetParameter(algorithmParameterSpec);
        }
    }

    @Override
    protected void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String string) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    private static class OneShotSpec
    implements AlgorithmParameterSpec {
        private OneShotSpec() {
        }
    }
}

