/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.util;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;

public final class UrlToFileMapper {
    public static File mapUrlToFile(URL uRL) {
        if (uRL == null) {
            return null;
        }
        try {
            String string = UrlToFileMapper.encode(uRL.toString());
            URI uRI = new URI(string);
            try {
                return new File(uRI);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
    }

    private static String encode(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= '?' && c <= '[' || c >= '$' && c <= ';' || c == '!' || c == '=' || c == ']' || c == '_' || c == '~') {
                stringBuffer.append(c);
                continue;
            }
            if (c == ' ') {
                stringBuffer.append("%20");
                continue;
            }
            try {
                String string2 = URLEncoder.encode(Character.toString(c), "UTF-8");
                stringBuffer.append(string2);
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        }
        return stringBuffer.toString();
    }

    private UrlToFileMapper() {
    }
}

