/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.generated;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class StreamsGroupTopologyValue
implements ApiMessage {
    int epoch;
    List<Subtopology> subtopologies;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("epoch", (Type)Type.INT32, "The epoch of the topology."), new Field("subtopologies", (Type)new CompactArrayOf((Type)Subtopology.SCHEMA_0), "The sub-topologies of the streams application."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public StreamsGroupTopologyValue(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public StreamsGroupTopologyValue() {
        this.epoch = 0;
        this.subtopologies = new ArrayList<Subtopology>(0);
    }

    public short apiKey() {
        return 23;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public final void read(Readable _readable, short _version) {
        this.epoch = _readable.readInt();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field subtopologies was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<Subtopology> newCollection = new ArrayList<Subtopology>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new Subtopology(_readable, _version));
        }
        this.subtopologies = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.epoch);
        _writable.writeUnsignedVarint(this.subtopologies.size() + 1);
        for (Subtopology subtopologiesElement : this.subtopologies) {
            subtopologiesElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.subtopologies.size() + 1)));
        for (Subtopology subtopologiesElement : this.subtopologies) {
            subtopologiesElement.addSize(_size, _cache, _version);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StreamsGroupTopologyValue)) {
            return false;
        }
        StreamsGroupTopologyValue other = (StreamsGroupTopologyValue)obj;
        if (this.epoch != other.epoch) {
            return false;
        }
        if (this.subtopologies == null ? other.subtopologies != null : !this.subtopologies.equals(other.subtopologies)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.epoch;
        hashCode = 31 * hashCode + (this.subtopologies == null ? 0 : this.subtopologies.hashCode());
        return hashCode;
    }

    public StreamsGroupTopologyValue duplicate() {
        StreamsGroupTopologyValue _duplicate = new StreamsGroupTopologyValue();
        _duplicate.epoch = this.epoch;
        ArrayList<Subtopology> newSubtopologies = new ArrayList<Subtopology>(this.subtopologies.size());
        for (Subtopology _element : this.subtopologies) {
            newSubtopologies.add(_element.duplicate());
        }
        _duplicate.subtopologies = newSubtopologies;
        return _duplicate;
    }

    public String toString() {
        return "StreamsGroupTopologyValue(epoch=" + this.epoch + ", subtopologies=" + MessageUtil.deepToString(this.subtopologies.iterator()) + ")";
    }

    public int epoch() {
        return this.epoch;
    }

    public List<Subtopology> subtopologies() {
        return this.subtopologies;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public StreamsGroupTopologyValue setEpoch(int v) {
        this.epoch = v;
        return this;
    }

    public StreamsGroupTopologyValue setSubtopologies(List<Subtopology> v) {
        this.subtopologies = v;
        return this;
    }

    public static class Subtopology
    implements Message {
        String subtopologyId;
        List<String> sourceTopics;
        List<String> sourceTopicRegex;
        List<TopicInfo> stateChangelogTopics;
        List<String> repartitionSinkTopics;
        List<TopicInfo> repartitionSourceTopics;
        List<CopartitionGroup> copartitionGroups;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("subtopology_id", (Type)Type.COMPACT_STRING, "String to uniquely identify the subtopology."), new Field("source_topics", (Type)new CompactArrayOf((Type)Type.COMPACT_STRING), "The topics the topology reads from."), new Field("source_topic_regex", (Type)new CompactArrayOf((Type)Type.COMPACT_STRING), "Regular expressions identifying topics the subtopology reads from."), new Field("state_changelog_topics", (Type)new CompactArrayOf((Type)TopicInfo.SCHEMA_0), "The set of state changelog topics associated with this subtopology."), new Field("repartition_sink_topics", (Type)new CompactArrayOf((Type)Type.COMPACT_STRING), "The repartition topics the subtopology writes to."), new Field("repartition_source_topics", (Type)new CompactArrayOf((Type)TopicInfo.SCHEMA_0), "The set of source topics that are internally created repartition topics."), new Field("copartition_groups", (Type)new CompactArrayOf((Type)CopartitionGroup.SCHEMA_0), "A subset of source topics that must be copartitioned."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public Subtopology(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public Subtopology() {
            this.subtopologyId = "";
            this.sourceTopics = new ArrayList<String>(0);
            this.sourceTopicRegex = new ArrayList<String>(0);
            this.stateChangelogTopics = new ArrayList<TopicInfo>(0);
            this.repartitionSinkTopics = new ArrayList<String>(0);
            this.repartitionSourceTopics = new ArrayList<TopicInfo>(0);
            this.copartitionGroups = new ArrayList<CopartitionGroup>(0);
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 0;
        }

        public final void read(Readable _readable, short _version) {
            int length;
            int i;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of Subtopology");
            }
            int length2 = _readable.readUnsignedVarint() - 1;
            if (length2 < 0) {
                throw new RuntimeException("non-nullable field subtopologyId was serialized as null");
            }
            if (length2 > Short.MAX_VALUE) {
                throw new RuntimeException("string field subtopologyId had invalid length " + length2);
            }
            this.subtopologyId = _readable.readString(length2);
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field sourceTopics was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<String> newCollection = new ArrayList<String>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                length = _readable.readUnsignedVarint() - 1;
                if (length < 0) {
                    throw new RuntimeException("non-nullable field sourceTopics element was serialized as null");
                }
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field sourceTopics element had invalid length " + length);
                }
                newCollection.add(_readable.readString(length));
            }
            this.sourceTopics = newCollection;
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field sourceTopicRegex was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                length = _readable.readUnsignedVarint() - 1;
                if (length < 0) {
                    throw new RuntimeException("non-nullable field sourceTopicRegex element was serialized as null");
                }
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field sourceTopicRegex element had invalid length " + length);
                }
                newCollection.add(_readable.readString(length));
            }
            this.sourceTopicRegex = newCollection;
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field stateChangelogTopics was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((String)((Object)new TopicInfo(_readable, _version)));
            }
            this.stateChangelogTopics = newCollection;
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field repartitionSinkTopics was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                length = _readable.readUnsignedVarint() - 1;
                if (length < 0) {
                    throw new RuntimeException("non-nullable field repartitionSinkTopics element was serialized as null");
                }
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field repartitionSinkTopics element had invalid length " + length);
                }
                newCollection.add(_readable.readString(length));
            }
            this.repartitionSinkTopics = newCollection;
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field repartitionSourceTopics was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((String)((Object)new TopicInfo(_readable, _version)));
            }
            this.repartitionSourceTopics = newCollection;
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field copartitionGroups was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((String)((Object)new CopartitionGroup(_readable, _version)));
            }
            this.copartitionGroups = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            byte[] _stringBytes;
            int _numTaggedFields = 0;
            Object _stringBytes2 = _cache.getSerializedValue((Object)this.subtopologyId);
            _writable.writeUnsignedVarint(((byte[])_stringBytes2).length + 1);
            _writable.writeByteArray((byte[])_stringBytes2);
            _writable.writeUnsignedVarint(this.sourceTopics.size() + 1);
            _stringBytes2 = this.sourceTopics.iterator();
            while (_stringBytes2.hasNext()) {
                String sourceTopicsElement = (String)_stringBytes2.next();
                _stringBytes = _cache.getSerializedValue((Object)sourceTopicsElement);
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            _writable.writeUnsignedVarint(this.sourceTopicRegex.size() + 1);
            for (String sourceTopicRegexElement : this.sourceTopicRegex) {
                _stringBytes = _cache.getSerializedValue((Object)sourceTopicRegexElement);
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            _writable.writeUnsignedVarint(this.stateChangelogTopics.size() + 1);
            for (TopicInfo stateChangelogTopicsElement : this.stateChangelogTopics) {
                stateChangelogTopicsElement.write(_writable, _cache, _version);
            }
            _writable.writeUnsignedVarint(this.repartitionSinkTopics.size() + 1);
            for (String repartitionSinkTopicsElement : this.repartitionSinkTopics) {
                _stringBytes = _cache.getSerializedValue((Object)repartitionSinkTopicsElement);
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            _writable.writeUnsignedVarint(this.repartitionSourceTopics.size() + 1);
            for (TopicInfo repartitionSourceTopicsElement : this.repartitionSourceTopics) {
                repartitionSourceTopicsElement.write(_writable, _cache, _version);
            }
            _writable.writeUnsignedVarint(this.copartitionGroups.size() + 1);
            for (CopartitionGroup copartitionGroupsElement : this.copartitionGroups) {
                copartitionGroupsElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            byte[] _stringBytes;
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of Subtopology");
            }
            byte[] _stringBytes2 = this.subtopologyId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes2.length > Short.MAX_VALUE) {
                throw new RuntimeException("'subtopologyId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.subtopologyId, _stringBytes2);
            _size.addBytes(_stringBytes2.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes2.length + 1)));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.sourceTopics.size() + 1)));
            for (String sourceTopicsElement : this.sourceTopics) {
                _stringBytes = sourceTopicsElement.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'sourceTopicsElement' field is too long to be serialized");
                }
                _cache.cacheSerializedValue((Object)sourceTopicsElement, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.sourceTopicRegex.size() + 1)));
            for (String sourceTopicRegexElement : this.sourceTopicRegex) {
                _stringBytes = sourceTopicRegexElement.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'sourceTopicRegexElement' field is too long to be serialized");
                }
                _cache.cacheSerializedValue((Object)sourceTopicRegexElement, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.stateChangelogTopics.size() + 1)));
            for (TopicInfo stateChangelogTopicsElement : this.stateChangelogTopics) {
                stateChangelogTopicsElement.addSize(_size, _cache, _version);
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.repartitionSinkTopics.size() + 1)));
            for (String repartitionSinkTopicsElement : this.repartitionSinkTopics) {
                _stringBytes = repartitionSinkTopicsElement.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'repartitionSinkTopicsElement' field is too long to be serialized");
                }
                _cache.cacheSerializedValue((Object)repartitionSinkTopicsElement, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.repartitionSourceTopics.size() + 1)));
            for (TopicInfo repartitionSourceTopicsElement : this.repartitionSourceTopics) {
                repartitionSourceTopicsElement.addSize(_size, _cache, _version);
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.copartitionGroups.size() + 1)));
            for (CopartitionGroup copartitionGroupsElement : this.copartitionGroups) {
                copartitionGroupsElement.addSize(_size, _cache, _version);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Subtopology)) {
                return false;
            }
            Subtopology other = (Subtopology)obj;
            if (this.subtopologyId == null ? other.subtopologyId != null : !this.subtopologyId.equals(other.subtopologyId)) {
                return false;
            }
            if (this.sourceTopics == null ? other.sourceTopics != null : !this.sourceTopics.equals(other.sourceTopics)) {
                return false;
            }
            if (this.sourceTopicRegex == null ? other.sourceTopicRegex != null : !this.sourceTopicRegex.equals(other.sourceTopicRegex)) {
                return false;
            }
            if (this.stateChangelogTopics == null ? other.stateChangelogTopics != null : !this.stateChangelogTopics.equals(other.stateChangelogTopics)) {
                return false;
            }
            if (this.repartitionSinkTopics == null ? other.repartitionSinkTopics != null : !this.repartitionSinkTopics.equals(other.repartitionSinkTopics)) {
                return false;
            }
            if (this.repartitionSourceTopics == null ? other.repartitionSourceTopics != null : !this.repartitionSourceTopics.equals(other.repartitionSourceTopics)) {
                return false;
            }
            if (this.copartitionGroups == null ? other.copartitionGroups != null : !this.copartitionGroups.equals(other.copartitionGroups)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.subtopologyId == null ? 0 : this.subtopologyId.hashCode());
            hashCode = 31 * hashCode + (this.sourceTopics == null ? 0 : this.sourceTopics.hashCode());
            hashCode = 31 * hashCode + (this.sourceTopicRegex == null ? 0 : this.sourceTopicRegex.hashCode());
            hashCode = 31 * hashCode + (this.stateChangelogTopics == null ? 0 : this.stateChangelogTopics.hashCode());
            hashCode = 31 * hashCode + (this.repartitionSinkTopics == null ? 0 : this.repartitionSinkTopics.hashCode());
            hashCode = 31 * hashCode + (this.repartitionSourceTopics == null ? 0 : this.repartitionSourceTopics.hashCode());
            hashCode = 31 * hashCode + (this.copartitionGroups == null ? 0 : this.copartitionGroups.hashCode());
            return hashCode;
        }

        public Subtopology duplicate() {
            Subtopology _duplicate = new Subtopology();
            _duplicate.subtopologyId = this.subtopologyId;
            ArrayList<String> newSourceTopics = new ArrayList<String>(this.sourceTopics.size());
            for (String string : this.sourceTopics) {
                newSourceTopics.add(string);
            }
            _duplicate.sourceTopics = newSourceTopics;
            ArrayList<String> newSourceTopicRegex = new ArrayList<String>(this.sourceTopicRegex.size());
            for (String string : this.sourceTopicRegex) {
                newSourceTopicRegex.add(string);
            }
            _duplicate.sourceTopicRegex = newSourceTopicRegex;
            ArrayList<TopicInfo> arrayList = new ArrayList<TopicInfo>(this.stateChangelogTopics.size());
            for (TopicInfo topicInfo : this.stateChangelogTopics) {
                arrayList.add(topicInfo.duplicate());
            }
            _duplicate.stateChangelogTopics = arrayList;
            ArrayList<String> arrayList2 = new ArrayList<String>(this.repartitionSinkTopics.size());
            for (String string : this.repartitionSinkTopics) {
                arrayList2.add(string);
            }
            _duplicate.repartitionSinkTopics = arrayList2;
            ArrayList<TopicInfo> arrayList3 = new ArrayList<TopicInfo>(this.repartitionSourceTopics.size());
            for (TopicInfo _element : this.repartitionSourceTopics) {
                arrayList3.add(_element.duplicate());
            }
            _duplicate.repartitionSourceTopics = arrayList3;
            ArrayList<CopartitionGroup> arrayList4 = new ArrayList<CopartitionGroup>(this.copartitionGroups.size());
            for (CopartitionGroup _element : this.copartitionGroups) {
                arrayList4.add(_element.duplicate());
            }
            _duplicate.copartitionGroups = arrayList4;
            return _duplicate;
        }

        public String toString() {
            return "Subtopology(subtopologyId=" + (String)(this.subtopologyId == null ? "null" : "'" + this.subtopologyId.toString() + "'") + ", sourceTopics=" + MessageUtil.deepToString(this.sourceTopics.iterator()) + ", sourceTopicRegex=" + MessageUtil.deepToString(this.sourceTopicRegex.iterator()) + ", stateChangelogTopics=" + MessageUtil.deepToString(this.stateChangelogTopics.iterator()) + ", repartitionSinkTopics=" + MessageUtil.deepToString(this.repartitionSinkTopics.iterator()) + ", repartitionSourceTopics=" + MessageUtil.deepToString(this.repartitionSourceTopics.iterator()) + ", copartitionGroups=" + MessageUtil.deepToString(this.copartitionGroups.iterator()) + ")";
        }

        public String subtopologyId() {
            return this.subtopologyId;
        }

        public List<String> sourceTopics() {
            return this.sourceTopics;
        }

        public List<String> sourceTopicRegex() {
            return this.sourceTopicRegex;
        }

        public List<TopicInfo> stateChangelogTopics() {
            return this.stateChangelogTopics;
        }

        public List<String> repartitionSinkTopics() {
            return this.repartitionSinkTopics;
        }

        public List<TopicInfo> repartitionSourceTopics() {
            return this.repartitionSourceTopics;
        }

        public List<CopartitionGroup> copartitionGroups() {
            return this.copartitionGroups;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public Subtopology setSubtopologyId(String v) {
            this.subtopologyId = v;
            return this;
        }

        public Subtopology setSourceTopics(List<String> v) {
            this.sourceTopics = v;
            return this;
        }

        public Subtopology setSourceTopicRegex(List<String> v) {
            this.sourceTopicRegex = v;
            return this;
        }

        public Subtopology setStateChangelogTopics(List<TopicInfo> v) {
            this.stateChangelogTopics = v;
            return this;
        }

        public Subtopology setRepartitionSinkTopics(List<String> v) {
            this.repartitionSinkTopics = v;
            return this;
        }

        public Subtopology setRepartitionSourceTopics(List<TopicInfo> v) {
            this.repartitionSourceTopics = v;
            return this;
        }

        public Subtopology setCopartitionGroups(List<CopartitionGroup> v) {
            this.copartitionGroups = v;
            return this;
        }
    }

    public static class TopicInfo
    implements Message {
        String name;
        int partitions;
        short replicationFactor;
        List<TopicConfig> topicConfigs;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("name", (Type)Type.COMPACT_STRING, "The name of the topic."), new Field("partitions", (Type)Type.INT32, "The number of partitions in the topic. Can be 0 if no specific number of partitions is enforced. Always 0 for changelog topics."), new Field("replication_factor", (Type)Type.INT16, "The replication factor of the topic. Can be 0 if the default replication factor should be used."), new Field("topic_configs", (Type)new CompactArrayOf((Type)TopicConfig.SCHEMA_0), "Topic-level configurations as key-value pairs."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public TopicInfo(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public TopicInfo() {
            this.name = "";
            this.partitions = 0;
            this.replicationFactor = 0;
            this.topicConfigs = new ArrayList<TopicConfig>(0);
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        public final void read(Readable _readable, short _version) {
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            this.partitions = _readable.readInt();
            this.replicationFactor = _readable.readShort();
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topicConfigs was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<TopicConfig> newCollection = new ArrayList<TopicConfig>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new TopicConfig(_readable, _version));
            }
            this.topicConfigs = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue((Object)this.name);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.partitions);
            _writable.writeShort(this.replicationFactor);
            _writable.writeUnsignedVarint(this.topicConfigs.size() + 1);
            _stringBytes = this.topicConfigs.iterator();
            while (_stringBytes.hasNext()) {
                TopicConfig topicConfigsElement = (TopicConfig)_stringBytes.next();
                topicConfigsElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.name, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            _size.addBytes(4);
            _size.addBytes(2);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.topicConfigs.size() + 1)));
            for (TopicConfig topicConfigsElement : this.topicConfigs) {
                topicConfigsElement.addSize(_size, _cache, _version);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TopicInfo)) {
                return false;
            }
            TopicInfo other = (TopicInfo)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.partitions != other.partitions) {
                return false;
            }
            if (this.replicationFactor != other.replicationFactor) {
                return false;
            }
            if (this.topicConfigs == null ? other.topicConfigs != null : !this.topicConfigs.equals(other.topicConfigs)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + this.partitions;
            hashCode = 31 * hashCode + this.replicationFactor;
            hashCode = 31 * hashCode + (this.topicConfigs == null ? 0 : this.topicConfigs.hashCode());
            return hashCode;
        }

        public TopicInfo duplicate() {
            TopicInfo _duplicate = new TopicInfo();
            _duplicate.name = this.name;
            _duplicate.partitions = this.partitions;
            _duplicate.replicationFactor = this.replicationFactor;
            ArrayList<TopicConfig> newTopicConfigs = new ArrayList<TopicConfig>(this.topicConfigs.size());
            for (TopicConfig _element : this.topicConfigs) {
                newTopicConfigs.add(_element.duplicate());
            }
            _duplicate.topicConfigs = newTopicConfigs;
            return _duplicate;
        }

        public String toString() {
            return "TopicInfo(name=" + (String)(this.name == null ? "null" : "'" + this.name.toString() + "'") + ", partitions=" + this.partitions + ", replicationFactor=" + this.replicationFactor + ", topicConfigs=" + MessageUtil.deepToString(this.topicConfigs.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public int partitions() {
            return this.partitions;
        }

        public short replicationFactor() {
            return this.replicationFactor;
        }

        public List<TopicConfig> topicConfigs() {
            return this.topicConfigs;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TopicInfo setName(String v) {
            this.name = v;
            return this;
        }

        public TopicInfo setPartitions(int v) {
            this.partitions = v;
            return this;
        }

        public TopicInfo setReplicationFactor(short v) {
            this.replicationFactor = v;
            return this;
        }

        public TopicInfo setTopicConfigs(List<TopicConfig> v) {
            this.topicConfigs = v;
            return this;
        }
    }

    public static class TopicConfig
    implements Message {
        String key;
        String value;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("key", (Type)Type.COMPACT_STRING, "The key of the topic-level configuration."), new Field("value", (Type)Type.COMPACT_STRING, "The value of the topic-level configuration."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public TopicConfig(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public TopicConfig() {
            this.key = "";
            this.value = "";
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        public final void read(Readable _readable, short _version) {
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field key was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field key had invalid length " + length);
            }
            this.key = _readable.readString(length);
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field value was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field value had invalid length " + length);
            }
            this.value = _readable.readString(length);
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.key);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _stringBytes = _cache.getSerializedValue((Object)this.value);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = this.key.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'key' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.key, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            _stringBytes = this.value.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'value' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.value, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TopicConfig)) {
                return false;
            }
            TopicConfig other = (TopicConfig)obj;
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.key == null ? 0 : this.key.hashCode());
            hashCode = 31 * hashCode + (this.value == null ? 0 : this.value.hashCode());
            return hashCode;
        }

        public TopicConfig duplicate() {
            TopicConfig _duplicate = new TopicConfig();
            _duplicate.key = this.key;
            _duplicate.value = this.value;
            return _duplicate;
        }

        public String toString() {
            return "TopicConfig(key=" + (String)(this.key == null ? "null" : "'" + this.key.toString() + "'") + ", value=" + (String)(this.value == null ? "null" : "'" + this.value.toString() + "'") + ")";
        }

        public String key() {
            return this.key;
        }

        public String value() {
            return this.value;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TopicConfig setKey(String v) {
            this.key = v;
            return this;
        }

        public TopicConfig setValue(String v) {
            this.value = v;
            return this;
        }
    }

    public static class CopartitionGroup
    implements Message {
        List<Short> sourceTopics;
        List<Short> sourceTopicRegex;
        List<Short> repartitionSourceTopics;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("source_topics", (Type)new CompactArrayOf((Type)Type.INT16), "The topics the topology reads from. Index into the array on the subtopology level."), new Field("source_topic_regex", (Type)new CompactArrayOf((Type)Type.INT16), "Regular expressions identifying topics the subtopology reads from. Index into the array on the subtopology level."), new Field("repartition_source_topics", (Type)new CompactArrayOf((Type)Type.INT16), "The set of source topics that are internally created repartition topics. Index into the array on the subtopology level."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public CopartitionGroup(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public CopartitionGroup() {
            this.sourceTopics = new ArrayList<Short>(0);
            this.sourceTopicRegex = new ArrayList<Short>(0);
            this.repartitionSourceTopics = new ArrayList<Short>(0);
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 0;
        }

        public final void read(Readable _readable, short _version) {
            int i;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of CopartitionGroup");
            }
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field sourceTopics was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<Short> newCollection = new ArrayList<Short>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readShort());
            }
            this.sourceTopics = newCollection;
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field sourceTopicRegex was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readShort());
            }
            this.sourceTopicRegex = newCollection;
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field repartitionSourceTopics was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readShort());
            }
            this.repartitionSourceTopics = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeUnsignedVarint(this.sourceTopics.size() + 1);
            for (Short sourceTopicsElement : this.sourceTopics) {
                _writable.writeShort(sourceTopicsElement.shortValue());
            }
            _writable.writeUnsignedVarint(this.sourceTopicRegex.size() + 1);
            for (Short sourceTopicRegexElement : this.sourceTopicRegex) {
                _writable.writeShort(sourceTopicRegexElement.shortValue());
            }
            _writable.writeUnsignedVarint(this.repartitionSourceTopics.size() + 1);
            for (Short repartitionSourceTopicsElement : this.repartitionSourceTopics) {
                _writable.writeShort(repartitionSourceTopicsElement.shortValue());
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of CopartitionGroup");
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.sourceTopics.size() + 1)));
            _size.addBytes(this.sourceTopics.size() * 2);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.sourceTopicRegex.size() + 1)));
            _size.addBytes(this.sourceTopicRegex.size() * 2);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.repartitionSourceTopics.size() + 1)));
            _size.addBytes(this.repartitionSourceTopics.size() * 2);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CopartitionGroup)) {
                return false;
            }
            CopartitionGroup other = (CopartitionGroup)obj;
            if (this.sourceTopics == null ? other.sourceTopics != null : !this.sourceTopics.equals(other.sourceTopics)) {
                return false;
            }
            if (this.sourceTopicRegex == null ? other.sourceTopicRegex != null : !this.sourceTopicRegex.equals(other.sourceTopicRegex)) {
                return false;
            }
            if (this.repartitionSourceTopics == null ? other.repartitionSourceTopics != null : !this.repartitionSourceTopics.equals(other.repartitionSourceTopics)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.sourceTopics == null ? 0 : this.sourceTopics.hashCode());
            hashCode = 31 * hashCode + (this.sourceTopicRegex == null ? 0 : this.sourceTopicRegex.hashCode());
            hashCode = 31 * hashCode + (this.repartitionSourceTopics == null ? 0 : this.repartitionSourceTopics.hashCode());
            return hashCode;
        }

        public CopartitionGroup duplicate() {
            CopartitionGroup _duplicate = new CopartitionGroup();
            ArrayList<Short> newSourceTopics = new ArrayList<Short>(this.sourceTopics.size());
            for (Short s : this.sourceTopics) {
                newSourceTopics.add(s);
            }
            _duplicate.sourceTopics = newSourceTopics;
            ArrayList<Short> newSourceTopicRegex = new ArrayList<Short>(this.sourceTopicRegex.size());
            for (Short _element : this.sourceTopicRegex) {
                newSourceTopicRegex.add(_element);
            }
            _duplicate.sourceTopicRegex = newSourceTopicRegex;
            ArrayList<Short> arrayList = new ArrayList<Short>(this.repartitionSourceTopics.size());
            for (Short _element : this.repartitionSourceTopics) {
                arrayList.add(_element);
            }
            _duplicate.repartitionSourceTopics = arrayList;
            return _duplicate;
        }

        public String toString() {
            return "CopartitionGroup(sourceTopics=" + MessageUtil.deepToString(this.sourceTopics.iterator()) + ", sourceTopicRegex=" + MessageUtil.deepToString(this.sourceTopicRegex.iterator()) + ", repartitionSourceTopics=" + MessageUtil.deepToString(this.repartitionSourceTopics.iterator()) + ")";
        }

        public List<Short> sourceTopics() {
            return this.sourceTopics;
        }

        public List<Short> sourceTopicRegex() {
            return this.sourceTopicRegex;
        }

        public List<Short> repartitionSourceTopics() {
            return this.repartitionSourceTopics;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public CopartitionGroup setSourceTopics(List<Short> v) {
            this.sourceTopics = v;
            return this;
        }

        public CopartitionGroup setSourceTopicRegex(List<Short> v) {
            this.sourceTopicRegex = v;
            return this;
        }

        public CopartitionGroup setRepartitionSourceTopics(List<Short> v) {
            this.repartitionSourceTopics = v;
            return this;
        }
    }
}

