/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class ConsumerProtocolAssignment
implements ApiMessage {
    TopicPartitionCollection assignedPartitions;
    ByteBuffer userData;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 3;

    public ConsumerProtocolAssignment(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public ConsumerProtocolAssignment() {
        this.assignedPartitions = new TopicPartitionCollection(0);
        this.userData = null;
    }

    @Override
    public short apiKey() {
        return -1;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 3;
    }

    @Override
    public final void read(Readable _readable, short _version) {
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field assignedPartitions was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        TopicPartitionCollection newCollection = new TopicPartitionCollection(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new TopicPartition(_readable, _version));
        }
        this.assignedPartitions = newCollection;
        int length = _readable.readInt();
        this.userData = length < 0 ? null : _readable.readByteBuffer(length);
        this._unknownTaggedFields = null;
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.assignedPartitions.size());
        for (TopicPartition assignedPartitionsElement : this.assignedPartitions) {
            assignedPartitionsElement.write(_writable, _cache, _version);
        }
        if (this.userData == null) {
            _writable.writeInt(-1);
        } else {
            _writable.writeInt(this.userData.remaining());
            _writable.writeByteBuffer(this.userData);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        for (TopicPartition assignedPartitionsElement : this.assignedPartitions) {
            assignedPartitionsElement.addSize(_size, _cache, _version);
        }
        if (this.userData == null) {
            _size.addBytes(4);
        } else {
            _size.addZeroCopyBytes(this.userData.remaining());
            _size.addBytes(4);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConsumerProtocolAssignment)) {
            return false;
        }
        ConsumerProtocolAssignment other = (ConsumerProtocolAssignment)obj;
        if (this.assignedPartitions == null ? other.assignedPartitions != null : !this.assignedPartitions.equals(other.assignedPartitions)) {
            return false;
        }
        if (!Objects.equals(this.userData, other.userData)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.assignedPartitions == null ? 0 : this.assignedPartitions.hashCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.userData);
        return hashCode;
    }

    @Override
    public ConsumerProtocolAssignment duplicate() {
        ConsumerProtocolAssignment _duplicate = new ConsumerProtocolAssignment();
        TopicPartitionCollection newAssignedPartitions = new TopicPartitionCollection(this.assignedPartitions.size());
        for (TopicPartition _element : this.assignedPartitions) {
            newAssignedPartitions.add(_element.duplicate());
        }
        _duplicate.assignedPartitions = newAssignedPartitions;
        _duplicate.userData = this.userData == null ? null : this.userData.duplicate();
        return _duplicate;
    }

    public String toString() {
        return "ConsumerProtocolAssignment(assignedPartitions=" + MessageUtil.deepToString(this.assignedPartitions.iterator()) + ", userData=" + String.valueOf(this.userData) + ")";
    }

    public TopicPartitionCollection assignedPartitions() {
        return this.assignedPartitions;
    }

    public ByteBuffer userData() {
        return this.userData;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ConsumerProtocolAssignment setAssignedPartitions(TopicPartitionCollection v) {
        this.assignedPartitions = v;
        return this;
    }

    public ConsumerProtocolAssignment setUserData(ByteBuffer v) {
        this.userData = v;
        return this;
    }

    static {
        SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("assigned_partitions", new ArrayOf(TopicPartition.SCHEMA_0), "The list of topics and partitions assigned to this consumer."), new Field("user_data", Type.NULLABLE_BYTES, "User data."))));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
    }

    public static class TopicPartitionCollection
    extends ImplicitLinkedHashMultiCollection<TopicPartition> {
        public TopicPartitionCollection() {
        }

        public TopicPartitionCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public TopicPartitionCollection(Iterator<TopicPartition> iterator) {
            super(iterator);
        }

        @Override
        public TopicPartition find(String topic) {
            TopicPartition _key = new TopicPartition();
            _key.setTopic(topic);
            return this.find(_key);
        }

        @Override
        public List<TopicPartition> findAll(String topic) {
            TopicPartition _key = new TopicPartition();
            _key.setTopic(topic);
            return this.findAll(_key);
        }

        public TopicPartitionCollection duplicate() {
            TopicPartitionCollection _duplicate = new TopicPartitionCollection(this.size());
            for (TopicPartition _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class TopicPartition
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String topic;
        List<Integer> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 3;

        public TopicPartition(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public TopicPartition() {
            this.topic = "";
            this.partitions = new ArrayList<Integer>(0);
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 3;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TopicPartition");
            }
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field topic was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topic had invalid length " + length);
            }
            this.topic = _readable.readString(length);
            int arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.topic);
            _writable.writeShort((short)((byte[])_stringBytes).length);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.partitions.size());
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                Integer partitionsElement = (Integer)_stringBytes.next();
                _writable.writeInt(partitionsElement);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TopicPartition");
            }
            byte[] _stringBytes = this.topic.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topic' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topic, _stringBytes);
            _size.addBytes(_stringBytes.length + 2);
            _size.addBytes(4);
            _size.addBytes(this.partitions.size() * 4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof TopicPartition)) {
                return false;
            }
            TopicPartition other = (TopicPartition)obj;
            return !(this.topic == null ? other.topic != null : !this.topic.equals(other.topic));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TopicPartition)) {
                return false;
            }
            TopicPartition other = (TopicPartition)obj;
            if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topic == null ? 0 : this.topic.hashCode());
            return hashCode;
        }

        @Override
        public TopicPartition duplicate() {
            TopicPartition _duplicate = new TopicPartition();
            _duplicate.topic = this.topic;
            ArrayList<Integer> newPartitions = new ArrayList<Integer>(this.partitions.size());
            for (Integer _element : this.partitions) {
                newPartitions.add(_element);
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "TopicPartition(topic=" + (String)(this.topic == null ? "null" : "'" + this.topic.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String topic() {
            return this.topic;
        }

        public List<Integer> partitions() {
            return this.partitions;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TopicPartition setTopic(String v) {
            this.topic = v;
            return this;
        }

        public TopicPartition setPartitions(List<Integer> v) {
            this.partitions = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("topic", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(Type.INT32), "The list of partitions assigned to this consumer."))));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
        }
    }
}

