/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.tracermi.connection;

import ghidra.app.plugin.core.debug.event.TraceActivatedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceInactiveCoordinatesPluginEvent;
import ghidra.app.plugin.core.debug.gui.tracermi.connection.TraceRmiConnectionManagerProvider;
import ghidra.app.services.TraceRmiService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;

@PluginInfo(shortDescription="GUI elements to manage Trace RMI connections", description="Provides a panel for managing Trace RMI connections. The panel also allows users to\ncontrol the Trace RMI server and/or create manual connections.\n", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={TraceActivatedPluginEvent.class, TraceInactiveCoordinatesPluginEvent.class}, servicesRequired={TraceRmiService.class})
public class TraceRmiConnectionManagerPlugin
extends Plugin {
    private final TraceRmiConnectionManagerProvider provider = new TraceRmiConnectionManagerProvider(this);

    public TraceRmiConnectionManagerPlugin(PluginTool tool) {
        super(tool);
    }

    public void processEvent(PluginEvent event) {
        TraceActivatedPluginEvent evt;
        super.processEvent(event);
        if (event instanceof TraceActivatedPluginEvent) {
            evt = (TraceActivatedPluginEvent)event;
            this.provider.coordinates(evt.getActiveCoordinates());
        }
        if (event instanceof TraceInactiveCoordinatesPluginEvent) {
            evt = (TraceInactiveCoordinatesPluginEvent)event;
            this.provider.coordinates(evt.getCoordinates());
        }
    }
}

