/*
 * Decompiled with CFR 0.152.
 */
package docking.actions.dialog;

import docking.ActionContext;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.actions.dialog.ActionDisplayLevel;
import docking.actions.dialog.ActionGroup;
import docking.widgets.searchlist.DefaultSearchListModel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ActionsModel
extends DefaultSearchListModel<DockingActionIf> {
    private Set<DockingActionIf> localActions;
    private Set<DockingActionIf> globalActions;
    private ActionDisplayLevel displayLevel = ActionDisplayLevel.LOCAL;
    private ActionContext context;
    private Comparator<DockingActionIf> nameComparator = new ActionNameComparator(this);
    private Comparator<DockingActionIf> menuPathComparator = new ActionMenuPathComparator(this);
    private Comparator<DockingActionIf> popupPathComparator = new ActionPopupPathComparator(this);

    ActionsModel(Set<DockingActionIf> localActions, Set<DockingActionIf> globalActions, ActionContext context) {
        this.context = context;
        this.localActions = localActions;
        this.globalActions = globalActions;
        this.populateActions();
    }

    public void setDisplayLevel(ActionDisplayLevel level) {
        this.displayLevel = level;
        this.populateActions();
        this.fireDataChanged();
    }

    public ActionDisplayLevel getActionDisplayLevel() {
        return this.displayLevel;
    }

    @Override
    public void dispose() {
        this.localActions.clear();
        this.globalActions.clear();
        this.context = null;
    }

    public boolean isDisposed() {
        return this.context == null;
    }

    private void populateActions() {
        this.clearData();
        switch (this.displayLevel) {
            case LOCAL: {
                this.addLocalActions(ActionGroup.LOCAL_TOOLBAR, a -> this.isValidToolbar((DockingActionIf)a));
                this.addLocalActions(ActionGroup.LOCAL_MENU, a -> this.isValidMenu((DockingActionIf)a));
                this.addLocalActions(ActionGroup.POPUP, a -> this.isValidPopup((DockingActionIf)a));
                this.addGlobalActions(ActionGroup.POPUP, a -> this.isValidPopup((DockingActionIf)a));
                this.addLocalActions(ActionGroup.KEYBINDING_ONLY, a -> this.isValidKeybindingOnly((DockingActionIf)a));
                this.addGlobalActions(ActionGroup.KEYBINDING_ONLY, a -> this.isValidKeybindingOnly((DockingActionIf)a));
                break;
            }
            case GLOBAL: {
                this.addLocalActions(ActionGroup.LOCAL_TOOLBAR, a -> this.isValidToolbar((DockingActionIf)a));
                this.addGlobalActions(ActionGroup.GLOBAL_TOOLBAR, a -> this.isValidToolbar((DockingActionIf)a));
                this.addLocalActions(ActionGroup.LOCAL_MENU, a -> this.isValidMenu((DockingActionIf)a));
                this.addGlobalActions(ActionGroup.GLOBAL_MENU, a -> this.isValidMenu((DockingActionIf)a));
                this.addLocalActions(ActionGroup.POPUP, a -> this.isValidPopup((DockingActionIf)a));
                this.addGlobalActions(ActionGroup.POPUP, a -> this.isValidPopup((DockingActionIf)a));
                this.addLocalActions(ActionGroup.KEYBINDING_ONLY, a -> this.isValidKeybindingOnly((DockingActionIf)a));
                this.addGlobalActions(ActionGroup.KEYBINDING_ONLY, a -> this.isValidKeybindingOnly((DockingActionIf)a));
                break;
            }
            case ALL: {
                this.addLocalActions(ActionGroup.LOCAL_TOOLBAR, a -> this.isToolbar((DockingActionIf)a));
                this.addGlobalActions(ActionGroup.GLOBAL_TOOLBAR, a -> this.isToolbar((DockingActionIf)a));
                this.addLocalActions(ActionGroup.LOCAL_MENU, a -> this.isMenu((DockingActionIf)a));
                this.addGlobalActions(ActionGroup.GLOBAL_MENU, a -> this.isMenu((DockingActionIf)a));
                this.addLocalActions(ActionGroup.POPUP, a -> this.isPopup((DockingActionIf)a));
                this.addGlobalActions(ActionGroup.POPUP, a -> this.isPopup((DockingActionIf)a));
                this.addLocalActions(ActionGroup.KEYBINDING_ONLY, a -> this.isKeybindingOnly((DockingActionIf)a));
                this.addGlobalActions(ActionGroup.KEYBINDING_ONLY, a -> this.isKeybindingOnly((DockingActionIf)a));
            }
        }
    }

    ActionContext getContext() {
        return this.context;
    }

    private boolean isToolbar(DockingActionIf a) {
        return a.getToolBarData() != null;
    }

    private boolean isValidToolbar(DockingActionIf a) {
        return this.isToolbar(a) && a.isValidContext(this.context);
    }

    private boolean isMenu(DockingActionIf a) {
        return a.getMenuBarData() != null;
    }

    private boolean isValidMenu(DockingActionIf a) {
        return this.isMenu(a) && a.isValidContext(this.context);
    }

    private boolean isPopup(DockingActionIf a) {
        return a.getPopupMenuData() != null;
    }

    private boolean isValidPopup(DockingActionIf a) {
        return this.isPopup(a) && a.isValidContext(this.context) && a.isAddToPopup(this.context);
    }

    private boolean isKeybindingOnly(DockingActionIf a) {
        return a.getToolBarData() == null && a.getMenuBarData() == null && a.getPopupMenuData() == null;
    }

    private boolean isValidKeybindingOnly(DockingActionIf a) {
        return this.isKeybindingOnly(a) && a.isValidContext(this.context) && a.isEnabledForContext(this.context);
    }

    private void addLocalActions(ActionGroup actionGroup, Predicate<DockingActionIf> filter) {
        List actions = this.localActions.stream().filter(filter).collect(Collectors.toCollection(ArrayList::new));
        actions.sort(this.getSorter(actionGroup));
        this.add(actionGroup.getDisplayName(), actions);
    }

    private void addGlobalActions(ActionGroup actionGroup, Predicate<DockingActionIf> filter) {
        List actions = this.globalActions.stream().filter(filter).collect(Collectors.toCollection(ArrayList::new));
        actions.sort(this.getSorter(actionGroup));
        this.add(actionGroup.getDisplayName(), actions);
    }

    private Comparator<? super DockingActionIf> getSorter(ActionGroup actionGroup) {
        switch (actionGroup) {
            case GLOBAL_MENU: 
            case LOCAL_MENU: {
                return this.menuPathComparator;
            }
            case POPUP: {
                return this.popupPathComparator;
            }
        }
        return this.nameComparator;
    }

    private class ActionNameComparator
    implements Comparator<DockingActionIf> {
        private ActionNameComparator(ActionsModel actionsModel) {
        }

        @Override
        public int compare(DockingActionIf a1, DockingActionIf a2) {
            return a1.getName().compareTo(a2.getName());
        }
    }

    private class ActionMenuPathComparator
    implements Comparator<DockingActionIf> {
        private ActionMenuPathComparator(ActionsModel actionsModel) {
        }

        @Override
        public int compare(DockingActionIf a1, DockingActionIf a2) {
            MenuData menuData1 = a1.getMenuBarData();
            MenuData menuData2 = a2.getMenuBarData();
            String path1 = menuData1 != null ? menuData1.getMenuPathAsString() : "";
            String path2 = menuData2 != null ? menuData2.getMenuPathAsString() : "";
            return path1.compareTo(path2);
        }
    }

    private class ActionPopupPathComparator
    implements Comparator<DockingActionIf> {
        private ActionPopupPathComparator(ActionsModel actionsModel) {
        }

        @Override
        public int compare(DockingActionIf a1, DockingActionIf a2) {
            MenuData menuData1 = a1.getPopupMenuData();
            MenuData menuData2 = a2.getPopupMenuData();
            String path1 = menuData1 != null ? menuData1.getMenuPathAsString() : "";
            String path2 = menuData2 != null ? menuData2.getMenuPathAsString() : "";
            return path1.compareTo(path2);
        }
    }
}

