/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.project.tool;

import docking.widgets.OptionDialog;
import generic.json.Json;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginConfigurationModel;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.PluginsConfiguration;
import ghidra.framework.plugintool.dialog.PluginInstallerDialog;
import ghidra.framework.plugintool.util.PluginDescription;
import ghidra.util.NumericUtilities;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.extensions.ExtensionDetails;
import ghidra.util.extensions.ExtensionUtils;
import ghidra.util.xml.XmlUtilities;
import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jdom.Content;
import org.jdom.Element;
import utilities.util.FileUtilities;

class ExtensionManager {
    private static final String EXTENSION_ATTRIBUTE_NAME_ENCODED = "ENCODED_NAME";
    private static final String EXTENSION_ATTRIBUTE_NAME = "NAME";
    private static final String EXTENSIONS_XML_NAME = "EXTENSIONS";
    private static final String EXTENSION_ELEMENT_NAME = "EXTENSION";
    private PluginTool tool;
    private Set<Class<?>> newExtensionPlugins = new HashSet();

    ExtensionManager(PluginTool tool) {
        this.tool = tool;
    }

    void checkForNewExtensions() {
        if (this.newExtensionPlugins.isEmpty()) {
            return;
        }
        this.propmtToConfigureNewPlugins(this.newExtensionPlugins);
        this.newExtensionPlugins.clear();
    }

    private void propmtToConfigureNewPlugins(Set<Class<?>> plugins) {
        int option = OptionDialog.showYesNoDialog((Component)this.tool.getToolFrame(), (String)"New Plugins Found!", (String)"New extension plugins detected. Would you like to configure them?");
        if (option == 1) {
            List<PluginDescription> pluginDescriptions = this.getPluginDescriptions(plugins);
            PluginInstallerDialog pluginInstaller = new PluginInstallerDialog("New Plugins Found!", this.tool, new PluginConfigurationModel(this.tool), pluginDescriptions);
            this.tool.showDialog(pluginInstaller);
        }
    }

    void saveToXml(Element xml) {
        Set installedExtensions = ExtensionUtils.getActiveInstalledExtensions();
        Element extensionsParent = new Element(EXTENSIONS_XML_NAME);
        for (ExtensionDetails ext : installedExtensions) {
            Element child = new Element(EXTENSION_ELEMENT_NAME);
            String name = ext.getName();
            if (XmlUtilities.hasInvalidXMLCharacters((String)name)) {
                child.setAttribute(EXTENSION_ATTRIBUTE_NAME_ENCODED, NumericUtilities.convertBytesToString((byte[])name.getBytes(StandardCharsets.UTF_8)));
            } else {
                child.setAttribute(EXTENSION_ATTRIBUTE_NAME, name);
            }
            extensionsParent.addContent((Content)child);
        }
        xml.addContent((Content)extensionsParent);
    }

    void restoreFromXml(Element xml) {
        Set<ExtensionDetails> installedExtensions = this.getExtensions();
        if (installedExtensions.isEmpty()) {
            return;
        }
        Set<String> knownExtensionNames = this.getKnownExtensions(xml);
        HashSet<ExtensionDetails> newExtensions = new HashSet<ExtensionDetails>(installedExtensions);
        for (ExtensionDetails ext : installedExtensions) {
            if (!knownExtensionNames.contains(ext.getName())) continue;
            newExtensions.remove(ext);
        }
        Set<Class<?>> newPlugins = ExtensionManager.findLoadedPlugins(newExtensions);
        this.newExtensionPlugins.addAll(newPlugins);
    }

    private Set<ExtensionDetails> getExtensions() {
        Set installedExtensions = ExtensionUtils.getActiveInstalledExtensions();
        return installedExtensions.stream().filter(e -> !e.isInstalledInInstallationFolder()).collect(Collectors.toSet());
    }

    private Set<String> getKnownExtensions(Element xml) {
        HashSet<String> knownExtensionNames = new HashSet<String>();
        Element extensionsParent = xml.getChild(EXTENSIONS_XML_NAME);
        if (extensionsParent == null) {
            return knownExtensionNames;
        }
        for (Element child : extensionsParent.getChildren(EXTENSION_ELEMENT_NAME)) {
            String encodedValue = child.getAttributeValue(EXTENSION_ATTRIBUTE_NAME_ENCODED);
            if (encodedValue != null) {
                byte[] bytes = NumericUtilities.convertStringToBytes((String)encodedValue);
                String decoded = new String(bytes, StandardCharsets.UTF_8);
                knownExtensionNames.add(decoded);
                continue;
            }
            String name = child.getAttributeValue(EXTENSION_ATTRIBUTE_NAME);
            knownExtensionNames.add(name);
        }
        return knownExtensionNames;
    }

    private List<PluginDescription> getPluginDescriptions(Set<Class<?>> plugins) {
        ArrayList<PluginDescription> descriptions = new ArrayList<PluginDescription>();
        PluginsConfiguration pluginsConfiguration = this.tool.getPluginsConfiguration();
        List<PluginDescription> allPluginDescriptions = pluginsConfiguration.getManagedPluginDescriptions();
        for (Class<?> plugin : plugins) {
            String pluginName = plugin.getSimpleName();
            Optional<PluginDescription> desc = allPluginDescriptions.stream().filter(d -> pluginName.equals(d.getName())).findAny();
            if (!desc.isPresent()) continue;
            descriptions.add(desc.get());
        }
        return descriptions;
    }

    private static Set<Class<?>> findLoadedPlugins(Set<ExtensionDetails> extensions) {
        Set<PluginPath> pluginPaths = ExtensionManager.getPluginPaths();
        HashSet extensionPlugins = new HashSet();
        for (ExtensionDetails extension : extensions) {
            Set<Class<?>> classes = ExtensionManager.findPluginsLoadedFromExtension(extension, pluginPaths);
            extensionPlugins.addAll(classes);
        }
        return extensionPlugins;
    }

    private static Set<PluginPath> getPluginPaths() {
        HashSet<PluginPath> paths = new HashSet<PluginPath>();
        List plugins = ClassSearcher.getClasses(Plugin.class);
        for (Class plugin : plugins) {
            paths.add(new PluginPath(plugin));
        }
        return paths;
    }

    private static Set<Class<?>> findPluginsLoadedFromExtension(ExtensionDetails extension, Set<PluginPath> pluginPaths) {
        if (!extension.isInstalled()) {
            return Collections.emptySet();
        }
        Set jarPaths = extension.getLibraries();
        HashSet result = new HashSet();
        for (PluginPath pluginPath : pluginPaths) {
            if (pluginPath.isFrom(extension.getInstallDir())) {
                result.add(pluginPath.getPluginClass());
                continue;
            }
            for (URL jarUrl : jarPaths) {
                if (!pluginPath.isFrom(jarUrl)) continue;
                result.add(pluginPath.getPluginClass());
            }
        }
        return result;
    }

    private static class PluginPath {
        private Class<? extends Plugin> pluginClass;
        private String pluginLocation;
        private File pluginFile;

        PluginPath(Class<? extends Plugin> pluginClass) {
            this.pluginClass = pluginClass;
            String name = pluginClass.getName();
            URL url = pluginClass.getResource("/" + name.replace('.', '/') + ".class");
            this.pluginLocation = url.getPath();
            this.pluginFile = new File(this.pluginLocation);
        }

        public boolean isFrom(File dir) {
            return FileUtilities.isPathContainedWithin((File)dir, (File)this.pluginFile);
        }

        boolean isFrom(URL jarUrl) {
            String jarPath = jarUrl.getPath();
            return this.pluginLocation.contains(jarPath);
        }

        Class<? extends Plugin> getPluginClass() {
            return this.pluginClass;
        }

        public String toString() {
            return Json.toString((Object)this);
        }
    }
}

