/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.project;

import ghidra.framework.GenericRunInfo;
import ghidra.framework.ToolUtils;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.client.RepositoryServerAdapter;
import ghidra.framework.data.TransientDataManager;
import ghidra.framework.main.AppInfo;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.model.ProjectManager;
import ghidra.framework.model.ServerInfo;
import ghidra.framework.model.ToolChest;
import ghidra.framework.model.ToolTemplate;
import ghidra.framework.preferences.Preferences;
import ghidra.framework.project.DefaultProject;
import ghidra.framework.project.ToolChestImpl;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.framework.store.LockException;
import ghidra.util.Msg;
import ghidra.util.NotOwnerException;
import ghidra.util.ReadOnlyException;
import ghidra.util.exception.NotFoundException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import utilities.util.FileUtilities;

public class DefaultProjectManager
implements ProjectManager {
    private static final String LAST_OPENED_PROJECT = "LastOpenedProject";
    private static final Logger LOG = LogManager.getLogger(DefaultProjectManager.class);
    private static final String RECENT_PROJECTS = "RecentProjects";
    private static final String VIEWED_PROJECTS = "ViewedProjects";
    private static final String SERVER_INFO = "ServerInfo";
    private static final int RECENT_PROJECTS_LIMIT = 6;
    private static String PROJECT_PATH_SEPARATOR = ";";
    private List<ProjectLocator> recentlyOpenedProjectsList = new ArrayList<ProjectLocator>();
    private List<URL> recentlyViewedProjectsList = new ArrayList<URL>();
    private ToolChest userToolChest = this.createUserToolChest();
    private ServerInfo serverInfo;
    private ProjectLocator lastOpenedProject = this.getLastOpenedProject();
    private Project currentProject;

    protected DefaultProjectManager() {
        this.populateProjectLocatorList(this.recentlyOpenedProjectsList, RECENT_PROJECTS);
        this.populateProjectURLList(this.recentlyViewedProjectsList, VIEWED_PROJECTS);
        this.updatePreferences();
        this.serverInfo = this.getServerInfo(Preferences.getProperty((String)SERVER_INFO));
    }

    @Override
    public Project getActiveProject() {
        return this.currentProject;
    }

    @Override
    public Project createProject(ProjectLocator projectLocator, RepositoryAdapter repAdapter, boolean remember) throws IOException {
        if (this.currentProject != null) {
            Msg.error((Object)this, (Object)"Current project must be closed before establishing a new active project");
            return null;
        }
        if (!projectLocator.getMarkerFile().getParentFile().isDirectory()) {
            throw new FileNotFoundException("Directory not found: " + String.valueOf(projectLocator.getMarkerFile().getParentFile()));
        }
        try {
            this.currentProject = new DefaultProject(this, projectLocator, repAdapter);
        }
        catch (LockException e) {
            throw new IOException(e.getMessage());
        }
        if (remember) {
            this.addProjectToList(this.recentlyOpenedProjectsList, projectLocator);
            this.lastOpenedProject = projectLocator;
            this.updatePreferences();
        }
        AppInfo.setActiveProject(this.currentProject);
        return this.currentProject;
    }

    @Override
    public Project openProject(ProjectLocator projectLocator, boolean doRestore, boolean resetOwner) throws NotFoundException, NotOwnerException, LockException, IOException {
        if (this.currentProject != null) {
            String msg = "Current project must be closed before establishing a new active project";
            Msg.error((Object)this, (Object)msg);
            throw new LockException(msg);
        }
        if (!projectLocator.getMarkerFile().exists()) {
            this.forgetProject(projectLocator);
            throw new NotFoundException("Project marker file not found: " + String.valueOf(projectLocator.getMarkerFile()));
        }
        if (!projectLocator.getProjectDir().isDirectory()) {
            this.forgetProject(projectLocator);
            throw new NotFoundException("Project directory not found: " + String.valueOf(projectLocator.getProjectDir()));
        }
        try {
            this.currentProject = new DefaultProject(this, projectLocator, resetOwner);
            AppInfo.setActiveProject(this.currentProject);
            if (doRestore) {
                this.currentProject.restore();
            }
            this.addProjectToList(this.recentlyOpenedProjectsList, projectLocator);
            this.lastOpenedProject = projectLocator;
            this.updatePreferences();
            Project msg = this.currentProject;
            return msg;
        }
        catch (LockException e) {
            throw e;
        }
        catch (ReadOnlyException e) {
            Msg.showError((Object)LOG, null, (String)"Read-only Project!", (Object)("Could not open project for update: " + String.valueOf(projectLocator)), (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            Msg.showError((Object)LOG, null, (String)"Open Project Failed!", (Object)("Could not open project " + String.valueOf(projectLocator) + "\n \nCAUSE: " + e.getMessage()), (Throwable)e);
            throw e;
        }
        finally {
            File dirFile;
            if (!(this.currentProject != null || (dirFile = projectLocator.getProjectDir()).exists() && dirFile.isDirectory())) {
                this.forgetProject(projectLocator);
            }
        }
    }

    @Override
    public ProjectLocator[] getRecentProjects() {
        ProjectLocator[] projectLocators = new ProjectLocator[this.recentlyOpenedProjectsList.size()];
        return this.recentlyOpenedProjectsList.toArray(projectLocators);
    }

    @Override
    public URL[] getRecentViewedProjects() {
        URL[] urls = new URL[this.recentlyViewedProjectsList.size()];
        return this.recentlyViewedProjectsList.toArray(urls);
    }

    @Override
    public ProjectLocator getLastOpenedProject() {
        String projectPath = Preferences.getProperty((String)LAST_OPENED_PROJECT, null, (boolean)true);
        if (projectPath == null || projectPath.trim().length() == 0) {
            return null;
        }
        return this.getLocatorFromProjectPath(projectPath);
    }

    @Override
    public void setLastOpenedProject(ProjectLocator projectLocator) {
        Preferences.setProperty((String)LAST_OPENED_PROJECT, (String)(projectLocator != null ? projectLocator.toString() : null));
        Preferences.store();
    }

    @Override
    public boolean deleteProject(ProjectLocator projectLocator) {
        File dir = projectLocator.getProjectDir();
        File file = projectLocator.getMarkerFile();
        if (!dir.exists()) {
            throw new RuntimeException(file.getAbsolutePath() + " does not exist");
        }
        if (!dir.isDirectory()) {
            return false;
        }
        boolean didDelete = FileUtilities.deleteDir((File)dir) && (!file.exists() || file.delete());
        this.forgetProject(projectLocator);
        return didDelete;
    }

    private void forgetProject(ProjectLocator projectLocator) {
        if (projectLocator == null) {
            return;
        }
        if (projectLocator.equals(this.lastOpenedProject)) {
            this.lastOpenedProject = null;
        }
        this.recentlyOpenedProjectsList.remove(projectLocator);
        this.updatePreferences();
    }

    @Override
    public void rememberProject(ProjectLocator projectLocator) {
        if (!this.recentlyOpenedProjectsList.contains(projectLocator)) {
            this.addProjectToList(this.recentlyOpenedProjectsList, projectLocator);
            this.updatePreferences();
        }
    }

    @Override
    public void forgetViewedProject(URL url) {
        if (url == null) {
            return;
        }
        this.recentlyViewedProjectsList.remove(url);
        this.updatePreferences();
    }

    @Override
    public void rememberViewedProject(URL url) {
        if (!this.recentlyViewedProjectsList.contains(url)) {
            this.recentlyViewedProjectsList.add(0, url);
            if (this.recentlyViewedProjectsList.size() > 6) {
                this.recentlyViewedProjectsList.remove(this.recentlyViewedProjectsList.size() - 1);
            }
            this.updatePreferences();
        }
    }

    @Override
    public boolean projectExists(ProjectLocator projectLocator) {
        return projectLocator.getProjectDir().exists();
    }

    @Override
    public RepositoryServerAdapter getRepositoryServerAdapter(String host, int portNumber, boolean forceConnect) {
        RepositoryServerAdapter rsh = ClientUtil.getRepositoryServer((String)host, (int)portNumber, (boolean)forceConnect);
        this.serverInfo = rsh.getServerInfo();
        this.updatePreferences();
        return rsh;
    }

    @Override
    public ServerInfo getMostRecentServerInfo() {
        return this.serverInfo;
    }

    public void addDefaultTools(ToolChest toolChest) {
        Set<ToolTemplate> tools = ToolUtils.getDefaultApplicationTools();
        if (tools == null || tools.isEmpty()) {
            Msg.showError((Object)LOG, null, (String)"Default Tools Not Found", (Object)"Could not find default tools for project.");
            return;
        }
        for (ToolTemplate template : tools) {
            this.addDefaultTool(toolChest, template);
        }
    }

    private void installTools(ToolChest toolChest) {
        LOG.debug("No tools found; Installing default tools");
        File recoveryDirectory = this.getMostRecentValidProjectDirectory();
        if (recoveryDirectory == null) {
            LOG.debug("\tno recent project directories found");
            this.addDefaultTools(toolChest);
            return;
        }
        Set<ToolTemplate> tools = ToolUtils.getDefaultApplicationTools();
        if (tools == null || tools.isEmpty()) {
            Msg.showError((Object)LOG, null, (String)"Default Tools Not Found", (Object)"Could not find default tools for project.");
            return;
        }
        Set<ToolTemplate> preExistingUserTools = this.getPreExistingUserTools(recoveryDirectory);
        Collection<ToolTemplate> mergedTools = this.mergeDefaultToolsIntoExisting(tools, preExistingUserTools);
        for (ToolTemplate toolTemplate : mergedTools) {
            this.addDefaultTool(toolChest, toolTemplate);
        }
    }

    private File getMostRecentValidProjectDirectory() {
        List ghidraUserDirsByTime = GenericRunInfo.getPreviousApplicationSettingsDirsByTime();
        if (ghidraUserDirsByTime.size() == 0) {
            return null;
        }
        for (File ghidraUserDir : ghidraUserDirsByTime) {
            File[] listFiles = ghidraUserDir.listFiles();
            if (listFiles == null) continue;
            for (File ghidraDirSubFile : listFiles) {
                if (!ghidraDirSubFile.getName().equals("tools")) continue;
                return ghidraUserDir;
            }
        }
        return null;
    }

    private Collection<ToolTemplate> mergeDefaultToolsIntoExisting(Set<ToolTemplate> defaultTools, Set<ToolTemplate> userTools) {
        if (userTools.isEmpty()) {
            return new HashSet<ToolTemplate>(defaultTools);
        }
        LOG.debug("Found the following default tools: ");
        for (ToolTemplate tool : defaultTools) {
            LOG.debug("-" + String.valueOf(tool));
        }
        LOG.debug("Found existing tools; merging existing tools: ");
        for (ToolTemplate tool : userTools) {
            LOG.debug("-" + String.valueOf(tool));
        }
        HashMap allTools = new HashMap();
        Map defaultMap = defaultTools.stream().collect(Collectors.toMap(t -> t.getName(), Function.identity()));
        Map userMap = userTools.stream().collect(Collectors.toMap(t -> t.getName(), Function.identity()));
        allTools.putAll(defaultMap);
        allTools.putAll(userMap);
        return allTools.values();
    }

    private URL saveTool(ToolTemplate toolTemplate) throws Exception {
        if (!ToolUtils.writeToolTemplate(toolTemplate)) {
            return null;
        }
        File newFile = ToolUtils.getToolFile(toolTemplate.getName());
        if (newFile == null) {
            return null;
        }
        return newFile.toURI().toURL();
    }

    private Set<ToolTemplate> getPreExistingUserTools(File previousUserDir) {
        if (previousUserDir == null) {
            return Collections.emptySet();
        }
        FileFilter dirFilter = file -> file.isDirectory() && file.getName().equals("tools");
        File[] toolDirs = previousUserDir.listFiles(dirFilter);
        if (toolDirs == null || toolDirs.length != 1) {
            LOG.debug("No user tools found in '" + String.valueOf(previousUserDir) + "'");
            return Collections.emptySet();
        }
        File toolsDir = toolDirs[0];
        FileFilter filter = file -> file.getAbsolutePath().endsWith(".tcd");
        File[] toolFiles = toolsDir.listFiles(filter);
        HashSet<ToolTemplate> set = new HashSet<ToolTemplate>();
        for (File toolFile : toolFiles) {
            ToolTemplate template = ToolUtils.readToolTemplate(toolFile);
            this.scrubUserTool(template);
            set.add(template);
        }
        return set;
    }

    private void scrubUserTool(ToolTemplate template) {
        ToolUtils.removeInvalidPlugins(template);
        try {
            this.saveTool(template);
        }
        catch (Exception e) {
            Msg.error((Object)LOG, (Object)("Unable to save user tool '" + template.getName() + "': " + e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public ToolChest getUserToolChest() {
        return this.userToolChest;
    }

    private void addDefaultTool(ToolChest toolChest, ToolTemplate template) {
        if (toolChest.getToolTemplate(template.getName()) != null) {
            Msg.showWarn((Object)LOG, null, (String)"Error Adding Tool", (Object)("Found multiple default tools with the same name: " + template.getName() + ".\nCheck the classpath for entries that contain tools that share the same tool name"));
        }
        toolChest.replaceToolTemplate(template);
    }

    protected ToolChest createUserToolChest() {
        ToolChestImpl toolChest = new ToolChestImpl();
        try {
            if (toolChest.getToolCount() == 0) {
                this.installTools(toolChest);
            }
        }
        catch (Exception e) {
            Msg.showError((Object)LOG, null, (String)"Tool Chest Error", (Object)"Failed to create tool chest.", (Throwable)e);
        }
        return toolChest;
    }

    private boolean addProjectToList(List<ProjectLocator> list, ProjectLocator projectLocator) {
        File file = projectLocator.getMarkerFile();
        if (!file.exists()) {
            return false;
        }
        File dirFile = projectLocator.getProjectDir();
        if (!dirFile.exists()) {
            return false;
        }
        list.remove(projectLocator);
        list.add(0, projectLocator);
        if (list.size() > 6) {
            list.remove(list.size() - 1);
        }
        return true;
    }

    private void populateProjectLocatorList(List<ProjectLocator> list, String propertyName) {
        String projectNames = Preferences.getProperty((String)propertyName, null, (boolean)true);
        if (projectNames == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(projectNames, PROJECT_PATH_SEPARATOR);
        while (st.hasMoreElements()) {
            String path = (String)st.nextElement();
            ProjectLocator projectLocator = this.getLocatorFromProjectPath(path);
            if (projectLocator == null) continue;
            list.add(projectLocator);
            if (list.size() != 6) continue;
            break;
        }
    }

    private ProjectLocator getLocatorFromProjectPath(String path) {
        try {
            URL url = GhidraURL.toURL(path);
            if (GhidraURL.localProjectExists(url)) {
                return GhidraURL.getProjectStorageLocator(url);
            }
        }
        catch (IllegalArgumentException e) {
            Msg.error((Object)this, (Object)("Invalid project path: " + path));
        }
        return null;
    }

    private void populateProjectURLList(List<URL> list, String propertyName) {
        String projectNames = Preferences.getProperty((String)propertyName, null, (boolean)true);
        if (projectNames == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(projectNames, PROJECT_PATH_SEPARATOR);
        while (st.hasMoreElements()) {
            String urlStr = (String)st.nextElement();
            try {
                URL url = GhidraURL.toURL(urlStr);
                if (GhidraURL.isLocalProjectURL(url) && !GhidraURL.localProjectExists(url)) continue;
                list.add(url);
                if (list.size() != 6) continue;
                break;
            }
            catch (IllegalArgumentException e) {
                Msg.error((Object)this, (Object)("Invalid project path/URL: " + urlStr));
            }
        }
    }

    void updatePreferences() {
        this.setProjectLocatorProperty(this.recentlyOpenedProjectsList, RECENT_PROJECTS);
        this.setProjectURLProperty(this.recentlyViewedProjectsList, VIEWED_PROJECTS);
        if (this.serverInfo != null) {
            Preferences.setProperty((String)SERVER_INFO, (String)(this.serverInfo.getServerName() + ":" + this.serverInfo.getPortNumber()));
        }
        Preferences.setProperty((String)LAST_OPENED_PROJECT, this.lastOpenedProject != null ? this.lastOpenedProject.toString() : null);
        Preferences.store();
    }

    private void setProjectLocatorProperty(List<ProjectLocator> list, String propertyName) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            ProjectLocator projectLocator = list.get(i);
            sb.append(projectLocator.toString());
            if (i >= list.size() - 1) continue;
            sb.append(PROJECT_PATH_SEPARATOR);
        }
        Preferences.setProperty((String)propertyName, (String)sb.toString());
    }

    private void setProjectURLProperty(List<URL> list, String propertyName) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            URL url = list.get(i);
            sb.append(url.toExternalForm());
            if (i >= list.size() - 1) continue;
            sb.append(PROJECT_PATH_SEPARATOR);
        }
        Preferences.setProperty((String)propertyName, (String)sb.toString());
    }

    private ServerInfo getServerInfo(String str) {
        if (str == null) {
            return null;
        }
        String host = null;
        String portStr = null;
        StringTokenizer st = new StringTokenizer(str, ":");
        while (st.hasMoreTokens()) {
            if (host == null) {
                host = st.nextToken();
                continue;
            }
            portStr = st.nextToken();
        }
        if (host != null && portStr != null) {
            try {
                return new ServerInfo(host, Integer.parseInt(portStr));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    void projectClosed(DefaultProject project) {
        if (project == this.currentProject) {
            this.currentProject = null;
        }
        TransientDataManager.clearAll();
    }
}

