/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.widgets.OptionDialogBuilder;
import ghidra.framework.main.projectdata.actions.FileCountStatistics;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.LinkedDomainFile;
import ghidra.framework.model.LinkedDomainFolder;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class DeleteProjectFilesTask
extends Task {
    private Component parent;
    private Set<DomainFile> selectedFiles;
    private Set<DomainFolder> selectedFolders;
    private OptionDialogBuilder readOnlyDialogBuilder;
    private OptionDialogBuilder checkedOutDialogBuilder;
    private OptionDialogBuilder versionedDialogBuilder;
    private OptionDialogBuilder fileInUseDialogBuilder;
    private FileCountStatistics statistics;
    private static final Comparator<DomainFile> FILE_PATH_COMPARATOR = new Comparator<DomainFile>(){

        @Override
        public int compare(DomainFile o1, DomainFile o2) {
            boolean isLink1 = o1.isLink();
            boolean isLink2 = o2.isLink();
            if (isLink1) {
                if (!isLink2) {
                    return 1;
                }
            } else if (isLink2) {
                return -1;
            }
            String path1 = o1.getPathname();
            String path2 = o2.getPathname();
            return path2.compareTo(path1);
        }
    };

    public DeleteProjectFilesTask(Set<DomainFolder> folders, Set<DomainFile> files, int fileCount, Component parent) {
        super("Delete Files", true, true, true);
        this.parent = parent;
        this.selectedFiles = Objects.requireNonNull(files);
        this.selectedFolders = Objects.requireNonNull(folders);
        this.statistics = new FileCountStatistics(fileCount);
    }

    public void run(TaskMonitor monitor) {
        this.initializeMonitor(monitor);
        Set<DomainFile> resolvedFiles = this.resolveLinkedFiles(this.selectedFiles);
        Set<DomainFolder> resolvedFolders = this.resolveLinkedFolders(this.selectedFolders);
        try {
            this.deleteFiles(resolvedFiles, monitor);
            this.deleteFolders(resolvedFolders, monitor);
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
    }

    public void showReport() {
        this.statistics.showReport(this.parent);
    }

    private void initializeMonitor(TaskMonitor monitor) {
        monitor.setMessage("Deleting Files...");
        monitor.initialize((long)this.statistics.getFileCount());
    }

    private Set<DomainFile> resolveLinkedFiles(Set<DomainFile> files) {
        HashSet<DomainFile> resolvedFiles = new HashSet<DomainFile>();
        for (DomainFile file : files) {
            if (file instanceof LinkedDomainFile) {
                LinkedDomainFile linkedFile = (LinkedDomainFile)file;
                try {
                    file = linkedFile.getRealFile();
                }
                catch (IOException e) {
                    continue;
                }
            }
            resolvedFiles.add(file);
        }
        return resolvedFiles;
    }

    private Set<DomainFolder> resolveLinkedFolders(Set<DomainFolder> folders) {
        HashSet<DomainFolder> resolvedFolders = new HashSet<DomainFolder>();
        for (DomainFolder folder : folders) {
            if (folder instanceof LinkedDomainFolder) {
                LinkedDomainFolder linkedFolder = (LinkedDomainFolder)folder;
                try {
                    folder = linkedFolder.getRealFolder();
                }
                catch (IOException e) {
                    continue;
                }
            }
            resolvedFolders.add(folder);
        }
        return resolvedFolders;
    }

    private void deleteFiles(Set<DomainFile> files, TaskMonitor monitor) throws CancelledException {
        ArrayList<DomainFile> sortedFiles = new ArrayList<DomainFile>(files);
        Collections.sort(sortedFiles, FILE_PATH_COMPARATOR);
        for (DomainFile file : sortedFiles) {
            monitor.checkCancelled();
            this.deleteFile(file, monitor);
        }
    }

    private void deleteFolders(Set<DomainFolder> folders, TaskMonitor monitor) throws CancelledException {
        for (DomainFolder folder : folders) {
            monitor.checkCancelled();
            this.deleteFolder(folder, monitor);
        }
    }

    private void deleteFolder(DomainFolder folder, TaskMonitor monitor) throws CancelledException {
        for (DomainFolder domainFolder : folder.getFolders()) {
            monitor.checkCancelled();
            this.deleteFolder(domainFolder, monitor);
        }
        for (Comparable<DomainFolder> comparable : folder.getFiles()) {
            monitor.checkCancelled();
            if (this.selectedFiles.contains(comparable)) continue;
            this.deleteFile((DomainFile)comparable, monitor);
            monitor.incrementProgress(1L);
        }
        this.deleteEmptyFolder(folder);
    }

    private void deleteEmptyFolder(DomainFolder folder) {
        if (folder.isEmpty()) {
            try {
                folder.delete();
            }
            catch (IOException e) {
                Msg.error((Object)((Object)this), (Object)("Unexpected error deleting empty folder: " + folder.getName()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFile(DomainFile file, TaskMonitor monitor) throws CancelledException {
        if (!file.exists()) {
            return;
        }
        try {
            int result;
            if (file.isOpen()) {
                this.statistics.incrementFileInUse();
                this.showFileInUseDialog(file);
                return;
            }
            if (file.isVersioned() && file.isCheckedOut()) {
                this.showCheckedOutVersionedDialog(file);
                this.statistics.incrementCheckedOutVersioned();
                return;
            }
            if (file.isReadOnly()) {
                result = this.showConfirmReadOnlyDialog(file);
                if (result == 0) {
                    throw new CancelledException();
                }
                if (result != 1) {
                    this.statistics.incrementReadOnly();
                    return;
                }
            }
            if (file.isVersioned()) {
                result = this.showConfirmDeleteVersionedDialog(file);
                if (result == 0) {
                    throw new CancelledException();
                }
                if (result != 1) {
                    this.statistics.incrementVersioned();
                    return;
                }
            }
            file.delete();
            this.statistics.incrementDeleted();
        }
        catch (IOException e) {
            this.statistics.incrementGeneralFailure();
            OptionDialogBuilder builder = new OptionDialogBuilder("Delete File Failed", file.getName() + ": " + e.getMessage());
            int result = builder.addCancel().setMessageType(0).show(this.parent);
            if (result == 0) {
                throw new CancelledException();
            }
        }
        finally {
            monitor.increment();
        }
    }

    private int showConfirmDeleteVersionedDialog(DomainFile file) {
        if (this.versionedDialogBuilder == null) {
            this.versionedDialogBuilder = new OptionDialogBuilder("Confirm Delete Versioned File").addOption("Yes").addOption("No").addCancel().setMessageType(2);
            if (this.getFileCount() > 1) {
                this.versionedDialogBuilder.addApplyToAllOption();
            }
        }
        String msg = "The file \"" + file.getName() + "\" is a versioned file and if you continue\nit (and all its versions) will be PERMANENTLY deleted!\nIf this is a shared project, it will be deleted on the server\nfor ALL users (if permitted)!\n\nAre you sure you want to delete it?";
        this.versionedDialogBuilder.setMessage(msg);
        return this.versionedDialogBuilder.show(this.parent);
    }

    private void showCheckedOutVersionedDialog(DomainFile file) throws CancelledException {
        if (this.checkedOutDialogBuilder == null) {
            this.checkedOutDialogBuilder = new OptionDialogBuilder("Delete Not Allowed").addOption("OK").addCancel().setMessageType(0);
            if (this.getFileCount() > 1) {
                this.checkedOutDialogBuilder.addDontShowAgainOption();
            }
        }
        String msg = "The file \"" + file.getName() + "\" is a versioned file that you have\n checked out. It can't be deleted!";
        this.checkedOutDialogBuilder.setMessage(msg);
        if (this.checkedOutDialogBuilder.show(this.parent) == 0) {
            throw new CancelledException();
        }
    }

    private void showFileInUseDialog(DomainFile file) throws CancelledException {
        if (this.fileInUseDialogBuilder == null) {
            this.fileInUseDialogBuilder = new OptionDialogBuilder("Delete Not Allowed").addOption("OK").setMessageType(0).addCancel();
            if (this.getFileCount() > 1) {
                this.fileInUseDialogBuilder.addDontShowAgainOption();
            }
        }
        String msg = "The file \"" + file.getName() + "\" is currently in use. It can't \nbe deleted!";
        this.fileInUseDialogBuilder.setMessage(msg);
        if (this.fileInUseDialogBuilder.show(this.parent) == 0) {
            throw new CancelledException();
        }
    }

    private int showConfirmReadOnlyDialog(DomainFile file) {
        if (this.readOnlyDialogBuilder == null) {
            this.readOnlyDialogBuilder = new OptionDialogBuilder("Confirm Delete Read-only File").addOption("Yes").addOption("No").addCancel().setMessageType(2).setDefaultButton("No");
            if (this.getFileCount() > 1) {
                this.readOnlyDialogBuilder.addApplyToAllOption();
            }
        }
        String msg = "The file \"" + file.getName() + "\" is marked as \"Read-Only\". \nAre you sure you want to delete it?";
        this.readOnlyDialogBuilder.setMessage(msg);
        return this.readOnlyDialogBuilder.show(this.parent);
    }

    public synchronized int getFileCount() {
        return this.statistics.getFileCount();
    }

    public synchronized int getTotalDeleted() {
        return this.statistics.getTotalDeleted();
    }
}

