/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.logviewer.ui;

import docking.widgets.table.GTable;
import ghidra.framework.main.logviewer.event.ArrowDownAction;
import ghidra.framework.main.logviewer.event.ArrowDownSelectionAction;
import ghidra.framework.main.logviewer.event.ArrowUpAction;
import ghidra.framework.main.logviewer.event.ArrowUpSelectionAction;
import ghidra.framework.main.logviewer.event.EndAction;
import ghidra.framework.main.logviewer.event.FVEvent;
import ghidra.framework.main.logviewer.event.FVEventListener;
import ghidra.framework.main.logviewer.event.HomeAction;
import ghidra.framework.main.logviewer.event.PageDownAction;
import ghidra.framework.main.logviewer.event.PageDownSelectionAction;
import ghidra.framework.main.logviewer.event.PageUpAction;
import ghidra.framework.main.logviewer.event.PageUpSelectionAction;
import ghidra.framework.main.logviewer.model.Chunk;
import ghidra.framework.main.logviewer.model.ChunkModel;
import ghidra.framework.main.logviewer.model.ChunkReader;
import ghidra.framework.main.logviewer.model.Pair;
import ghidra.framework.main.logviewer.ui.FVTableModel;
import ghidra.framework.main.logviewer.ui.LogLevelTableCellRenderer;
import ghidra.framework.main.logviewer.ui.ViewportUtility;
import ghidra.util.Msg;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.util.List;
import java.util.stream.IntStream;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class FVTable
extends GTable
implements MouseMotionListener,
MouseListener {
    private ChunkReader reader;
    private ViewportUtility viewportUtility;
    private ChunkModel model;
    private boolean shiftDown = false;
    private boolean mouseDragging = false;
    private FVEventListener eventListener;
    private TableColumn dateCol;
    private TableColumn timeCol;
    private TableColumn levelCol;
    private TableColumn messageCol;

    public FVTable(ChunkReader reader, ViewportUtility viewportUtility, ChunkModel model, FVEventListener eventListener) {
        this.reader = reader;
        this.viewportUtility = viewportUtility;
        this.model = model;
        this.eventListener = eventListener;
        this.setModel(new FVTableModel());
        this.setSelectionMode(2);
        this.dateCol = this.getColumnModel().getColumn(0);
        this.dateCol.setPreferredWidth(100);
        this.timeCol = this.getColumnModel().getColumn(1);
        this.timeCol.setPreferredWidth(75);
        this.levelCol = this.getColumnModel().getColumn(2);
        this.levelCol.setPreferredWidth(60);
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.getColumnModel().getColumn(2).setCellRenderer((TableCellRenderer)((Object)new LogLevelTableCellRenderer()));
        this.getSelectionModel().addListSelectionListener((ListSelectionListener)((Object)this));
        this.createKeyBindings(reader, model, eventListener);
        this.setAutoResizeMode(0);
        this.getTableHeader().setResizingAllowed(false);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.setAutoscrolls(false);
    }

    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component prepareRenderer = super.prepareRenderer(renderer, row, column);
        TableColumn tableColumn = this.getColumnModel().getColumn(column);
        tableColumn.setPreferredWidth(Math.max(prepareRenderer.getPreferredSize().width, tableColumn.getPreferredWidth()));
        return prepareRenderer;
    }

    public void setShiftDown(boolean isDown) {
        this.shiftDown = isDown;
    }

    public void setMouseDragging(boolean isMouseDragging) {
        this.mouseDragging = isMouseDragging;
    }

    public void addRow(String row) {
        ((FVTableModel)this.getModel()).addRow(row, true);
    }

    public void addRows(List<String> rows) {
        ((FVTableModel)this.getModel()).addRowsToBottom(rows);
    }

    public void restoreSelection() {
        int rowEnd;
        if (this.model.getNumChunks() <= 0) {
            return;
        }
        Chunk firstRowChunk = this.model.get(0);
        Chunk lastRowChunk = this.model.get(this.model.getNumChunks() - 1);
        if (firstRowChunk == null || lastRowChunk == null) {
            return;
        }
        long firstRowStart = firstRowChunk.start;
        long lastRowEnd = lastRowChunk.end;
        if (this.model.selectedByteStart <= firstRowStart && this.model.selectedByteEnd >= lastRowEnd) {
            this.setRowSelectionInterval(0, this.getRowCount() - 1);
        } else if (this.model.selectedByteStart >= firstRowStart && this.model.selectedByteStart <= lastRowEnd && this.model.selectedByteEnd > lastRowEnd) {
            int rowEnd2;
            int rowStart = this.model.getRowForBytePos(this.model.selectedByteStart);
            if (this.checkBounds(rowStart, rowEnd2 = this.getRowCount() - 1)) {
                this.setRowSelectionInterval(rowStart, rowEnd2);
            }
        } else if (this.model.selectedByteStart >= firstRowStart && this.model.selectedByteStart <= lastRowEnd && this.model.selectedByteEnd >= firstRowStart && this.model.selectedByteEnd <= lastRowEnd) {
            int rowEnd3;
            int rowStart = this.model.getRowForBytePos(this.model.selectedByteStart);
            if (this.checkBounds(rowStart, rowEnd3 = this.model.getRowForBytePos(this.model.selectedByteEnd))) {
                this.setRowSelectionInterval(rowStart, rowEnd3);
            }
        } else if (this.model.selectedByteStart < firstRowStart && this.model.selectedByteEnd >= firstRowStart && this.model.selectedByteEnd <= lastRowEnd && this.checkBounds(0, rowEnd = this.model.getRowForBytePos(this.model.selectedByteEnd))) {
            this.setRowSelectionInterval(0, rowEnd);
        }
    }

    public void clear() {
        ((FVTableModel)this.getModel()).clear();
    }

    public void incrementAndAddSelection(int rows) {
        int[] rowsSelected = this.getSelectedRows();
        if (rowsSelected[rowsSelected.length - 1] + rows < this.getRowCount()) {
            if (rowsSelected.length > 0) {
                Pair filePos = this.model.getFilePositionForRow(rowsSelected[rowsSelected.length - 1] + rows);
                if (filePos == null) {
                    return;
                }
                this.model.selectedByteEnd = filePos.getEnd();
                if (!this.viewportUtility.isInViewport(rowsSelected[rowsSelected.length - 1] + rows)) {
                    this.viewportUtility.scrollViewportTo(rowsSelected[rowsSelected.length - 1] + rows);
                }
            }
        } else {
            try {
                List<String> lines = this.reader.readNextChunk();
                if (lines.size() == 0) {
                    return;
                }
                ((FVTableModel)this.getModel()).addRowsToBottom(lines);
                Pair filePos = this.model.getFilePositionForRow(rowsSelected[rowsSelected.length - 1] + rows);
                if (filePos == null) {
                    return;
                }
                this.model.selectedByteEnd = filePos.getEnd();
                SwingUtilities.invokeLater(() -> {
                    if (this.model.getSize() > this.model.MAX_VISIBLE_CHUNKS) {
                        Chunk chunk = this.model.remove(0);
                        if (chunk == null) {
                            return;
                        }
                        ((FVTableModel)this.getModel()).removeRowsFromTop(chunk.linesInChunk);
                        this.viewportUtility.moveViewportUp(chunk.linesInChunk, false);
                    }
                });
            }
            catch (IOException e) {
                Msg.error((Object)this, (Object)"Error reading next chunk of data", (Throwable)e);
            }
        }
    }

    public void incrementSelection(int rows) {
        int rowSelected = this.getSelectedRow();
        if (rowSelected < 0 && this.model.selectedByteStart >= 0L) {
            try {
                this.model.clear();
                this.clear();
                List<String> lines = this.reader.readNextChunkFrom(this.model.selectedByteStart);
                ((FVTableModel)this.getModel()).addRowsToTop(lines);
            }
            catch (IOException e) {
                Msg.error((Object)this, (Object)("Error reading next chunk of data starting from byte " + this.model.selectedByteStart), (Throwable)e);
            }
        } else if (rowSelected + rows < this.getRowCount()) {
            Pair byteRange = this.model.getFilePositionForRow(rowSelected + rows);
            if (byteRange == null) {
                return;
            }
            this.model.selectedByteStart = byteRange.getStart();
            this.model.selectedByteEnd = byteRange.getEnd();
            if (!this.viewportUtility.isInViewport(rowSelected + rows)) {
                this.viewportUtility.scrollViewportTo(rowSelected + rows);
            }
        } else {
            try {
                List<String> lines = this.reader.readNextChunk();
                if (lines.size() == 0) {
                    return;
                }
                ((FVTableModel)this.getModel()).addRowsToBottom(lines);
                Pair byteRange = this.model.getFilePositionForRow(rowSelected + rows);
                if (byteRange == null) {
                    return;
                }
                this.model.selectedByteStart = byteRange.getStart();
                this.model.selectedByteEnd = byteRange.getEnd();
                SwingUtilities.invokeLater(() -> {
                    if (this.model.getSize() > this.model.MAX_VISIBLE_CHUNKS) {
                        Chunk chunk = this.model.remove(0);
                        if (chunk == null) {
                            return;
                        }
                        ((FVTableModel)this.getModel()).removeRowsFromTop(chunk.linesInChunk);
                        this.viewportUtility.moveViewportUp(chunk.linesInChunk, false);
                    }
                });
            }
            catch (IOException e) {
                Msg.error((Object)this, (Object)"Error reading next chunk of data", (Throwable)e);
            }
        }
    }

    public void decrementAndAddSelection(int rows) {
        int[] rowsSelected = this.getSelectedRows();
        if (rowsSelected[0] - rows >= 0) {
            if (rowsSelected.length > 0) {
                Pair filePos = this.model.getFilePositionForRow(rowsSelected[0] - rows);
                if (filePos == null) {
                    return;
                }
                this.model.selectedByteStart = filePos.getStart();
                if (!this.viewportUtility.isInViewport(rowsSelected[0] - rows)) {
                    this.viewportUtility.scrollViewportTo(rowsSelected[0] - rows);
                }
            }
        } else {
            try {
                List<String> lines = this.reader.readPreviousChunk();
                if (lines.size() == 0) {
                    return;
                }
                ((FVTableModel)this.getModel()).addRowsToTop(lines);
                Pair filePos = this.model.getFilePositionForRow(lines.size() - rows);
                if (filePos == null) {
                    return;
                }
                this.model.selectedByteStart = filePos.getStart();
                SwingUtilities.invokeLater(() -> {
                    this.viewportUtility.moveViewportDown(lines.size(), false);
                    if (this.model.getSize() > this.model.MAX_VISIBLE_CHUNKS) {
                        Chunk chunk = this.model.remove(this.model.getSize() - 1);
                        if (chunk == null) {
                            return;
                        }
                        ((FVTableModel)this.getModel()).removeRowsFromBottom(chunk.linesInChunk);
                    }
                });
            }
            catch (IOException e) {
                Msg.error((Object)this, (Object)"Error reading next chunk of data", (Throwable)e);
            }
        }
    }

    public void decrementSelection(int rows) {
        int rowSelected = this.getSelectedRow();
        if (rowSelected < 0 && this.model.selectedByteStart >= 0L) {
            try {
                this.model.clear();
                this.clear();
                List<String> lines = this.reader.readNextChunkFrom(this.model.selectedByteStart);
                ((FVTableModel)this.getModel()).addRowsToTop(lines);
            }
            catch (IOException e) {
                Msg.error((Object)this, (Object)("Error reading next chunk of data starting from byte " + this.model.selectedByteStart), (Throwable)e);
            }
        } else if (rowSelected - rows >= 0) {
            Pair byteRange = this.model.getFilePositionForRow(rowSelected - rows);
            if (byteRange == null) {
                return;
            }
            this.model.selectedByteStart = byteRange.getStart();
            this.model.selectedByteEnd = byteRange.getEnd();
            if (!this.viewportUtility.isInViewport(rowSelected - rows)) {
                this.viewportUtility.scrollViewportTo(rowSelected - rows);
            }
        } else {
            try {
                List<String> lines = this.reader.readPreviousChunk();
                if (lines.size() == 0) {
                    return;
                }
                ((FVTableModel)this.getModel()).addRowsToTop(lines);
                Pair byteRange = this.model.getFilePositionForRow(rowSelected + lines.size() - rows);
                this.model.selectedByteStart = byteRange.getStart();
                this.model.selectedByteEnd = byteRange.getEnd();
                SwingUtilities.invokeLater(() -> {
                    this.viewportUtility.moveViewportDown(lines.size(), false);
                    if (this.model.getSize() > this.model.MAX_VISIBLE_CHUNKS) {
                        Chunk chunk = this.model.remove(this.model.getSize() - 1);
                        if (chunk == null) {
                            return;
                        }
                        ((FVTableModel)this.getModel()).removeRowsFromBottom(chunk.linesInChunk);
                    }
                });
            }
            catch (IOException e) {
                Msg.error((Object)this, (Object)"Error reading previous chunk of data", (Throwable)e);
            }
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        if (e.getValueIsAdjusting() && this.getSelectedRow() >= 0) {
            int[] selectedRows = this.getSelectedRows();
            if (!this.shiftDown && !this.mouseDragging) {
                Pair filePos = this.model.getFilePositionForRow(selectedRows[0]);
                if (filePos == null) {
                    return;
                }
                this.model.selectedByteStart = filePos.getStart();
                this.model.selectedByteEnd = filePos.getEnd();
            } else {
                Pair filePosFirstRow = this.model.getFilePositionForRow(selectedRows[0]);
                Pair filePosLastRow = this.model.getFilePositionForRow(selectedRows[selectedRows.length - 1]);
                if (filePosFirstRow == null || filePosLastRow == null) {
                    return;
                }
                long newFilePosStart = filePosFirstRow.getStart();
                long newFilePosEnd = filePosLastRow.getEnd();
                if (newFilePosStart <= this.model.selectedByteStart) {
                    this.model.selectedByteStart = newFilePosStart;
                }
                if (newFilePosEnd >= this.model.selectedByteEnd) {
                    this.model.selectedByteEnd = newFilePosEnd;
                }
                this.restoreSelection();
            }
        }
    }

    private void createKeyBindings(final ChunkReader reader, final ChunkModel model, final FVEventListener eventListener) {
        InputMap im_table = this.getInputMap();
        ActionMap am_table = this.getActionMap();
        im_table.put(KeyStroke.getKeyStroke(40, 0), "DownArrow");
        am_table.put("DownArrow", new ArrowDownAction(eventListener));
        im_table.put(KeyStroke.getKeyStroke(38, 0), "UpArrow");
        am_table.put("UpArrow", new ArrowUpAction(eventListener));
        im_table.put(KeyStroke.getKeyStroke(34, 0), "PageDown");
        am_table.put("PageDown", new PageDownAction(eventListener));
        im_table.put(KeyStroke.getKeyStroke(33, 0), "PageUp");
        am_table.put("PageUp", new PageUpAction(eventListener));
        im_table.put(KeyStroke.getKeyStroke(36, 0), "Home");
        am_table.put("Home", new HomeAction(eventListener));
        im_table.put(KeyStroke.getKeyStroke(35, 0), "End");
        am_table.put("End", new EndAction(eventListener));
        im_table.put(KeyStroke.getKeyStroke(40, 64), "DownArrowSelection");
        am_table.put("DownArrowSelection", new ArrowDownSelectionAction(eventListener));
        im_table.put(KeyStroke.getKeyStroke(38, 64), "UpArrowSelection");
        am_table.put("UpArrowSelection", new ArrowUpSelectionAction(eventListener));
        im_table.put(KeyStroke.getKeyStroke(34, 64), "PageDownSelection");
        am_table.put("PageDownSelection", new PageDownSelectionAction(eventListener));
        im_table.put(KeyStroke.getKeyStroke(33, 64), "PageUpSelection");
        am_table.put("PageUpSelection", new PageUpSelectionAction(eventListener));
        im_table.put(KeyStroke.getKeyStroke(67, 128), "copyText");
        im_table.put(KeyStroke.getKeyStroke(67, 256), "copyText");
        am_table.put("copyText", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FVEvent copyEvt = new FVEvent(FVEvent.EventType.COPY_SELECTION, null);
                eventListener.send(copyEvt);
            }
        });
        im_table.put(KeyStroke.getKeyStroke(16, 64, false), "ShiftPressed");
        am_table.put("ShiftPressed", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FVTable.this.shiftDown = true;
            }
        });
        im_table.put(KeyStroke.getKeyStroke("released SHIFT"), "ShiftReleased");
        am_table.put("ShiftReleased", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FVTable.this.shiftDown = false;
            }
        });
        im_table.put(KeyStroke.getKeyStroke(65, 128, false), "SelectAll");
        im_table.put(KeyStroke.getKeyStroke(65, 256, false), "SelectAll");
        am_table.put("SelectAll", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    model.selectedByteStart = 0L;
                    model.selectedByteEnd = reader.getFileSize() - 1L;
                    FVEvent copyEvt = new FVEvent(FVEvent.EventType.COPY_SELECTION, null);
                    eventListener.send(copyEvt);
                    FVTable.this.restoreSelection();
                }
                catch (IOException e1) {
                    Msg.error((Object)this, (Object)("error reading file size: " + String.valueOf(e)));
                }
            }
        });
    }

    private boolean checkBounds(int rowStart, int rowEnd) {
        return rowStart >= 0 && rowStart < this.getRowCount() && rowEnd >= 0 && rowEnd < this.getRowCount();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseDragging = true;
        int[] selectedRows = this.getSelectedRows();
        int tableTop = (int)this.getParent().getLocationOnScreen().getY();
        int tableBottom = (int)((double)tableTop + this.getSize().getHeight());
        if (e.getLocationOnScreen().getY() < (double)tableTop) {
            if (IntStream.of(selectedRows).anyMatch(x -> x == 0)) {
                FVEvent decrementEvt = new FVEvent(FVEvent.EventType.DECREMENT_AND_ADD_SELECTION, 1);
                this.eventListener.send(decrementEvt);
                return;
            }
        } else if (e.getLocationOnScreen().getY() > (double)tableBottom && IntStream.of(selectedRows).anyMatch(x -> x == this.getRowCount() - 1)) {
            FVEvent incrementEvt = new FVEvent(FVEvent.EventType.INCREMENT_AND_ADD_SELECTION, 1);
            this.eventListener.send(incrementEvt);
            return;
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mouseDragging = false;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

