/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import generic.theme.GIcon;
import ghidra.framework.data.ContentHandler;
import ghidra.framework.data.DomainObjectAdapter;
import ghidra.framework.data.DomainObjectAdapterDB;
import ghidra.framework.data.DomainObjectMergeManager;
import ghidra.framework.data.GhidraFileData;
import ghidra.framework.model.ChangeSet;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.LinkFileInfo;
import ghidra.framework.model.LinkedDomainFile;
import ghidra.framework.model.LinkedDomainFolder;
import ghidra.framework.model.ProjectData;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.framework.protocol.ghidra.GhidraURLQuery;
import ghidra.framework.protocol.ghidra.GhidraURLResultHandlerAdapter;
import ghidra.framework.store.FileIDFactory;
import ghidra.framework.store.FileSystem;
import ghidra.framework.store.FolderItem;
import ghidra.framework.store.TextDataItem;
import ghidra.framework.store.local.LocalFileSystem;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.BadLinkException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.swing.Icon;
import org.apache.commons.lang3.StringUtils;
import utility.function.Dummy;

public abstract class LinkHandler<T extends DomainObjectAdapterDB>
implements ContentHandler<T> {
    public static final String URL_METADATA_KEY = "link.url";
    public static final Icon LINK_ICON = new GIcon("icon.content.handler.link.overlay");

    @Override
    public LinkHandler<?> getLinkHandler() {
        return this;
    }

    protected final void createLink(String linkPath, LocalFileSystem fs, String folderPath, String linkFilename) throws IOException, InvalidNameException {
        fs.createTextDataItem(folderPath, linkFilename, FileIDFactory.createFileID(), this.getContentType(), linkPath, null, null);
    }

    @Override
    public final long createFile(FileSystem fs, FileSystem userfs, String path, String name, DomainObject domainObject, TaskMonitor monitor) throws IOException, InvalidNameException, CancelledException {
        throw new UnsupportedOperationException("createLink must be used for link-file");
    }

    @Override
    public final T getDomainObject(FolderItem item, FileSystem userfs, long checkoutId, boolean okToUpgrade, boolean okToRecover, Object consumer, TaskMonitor monitor) throws IOException, CancelledException, VersionException {
        throw new UnsupportedOperationException("getObject must be used for link-file");
    }

    @Override
    public final T getReadOnlyObject(FolderItem item, int version, boolean okToUpgrade, Object consumer, TaskMonitor monitor) throws IOException, VersionException, CancelledException {
        throw new UnsupportedOperationException("getObject must be used for link-file");
    }

    @Override
    public T getImmutableObject(FolderItem item, Object consumer, int version, int minChangeVersion, TaskMonitor monitor) throws IOException, CancelledException, VersionException {
        throw new UnsupportedOperationException("getObject must be used for link-file");
    }

    T getObject(URL ghidraUrl, final int version, final Object consumer, final TaskMonitor monitor, final boolean immutable) throws IOException, VersionException, CancelledException {
        Class domainObjectClass = this.getDomainObjectClass();
        if (domainObjectClass == null) {
            throw new UnsupportedOperationException("");
        }
        final AtomicReference verExcRef = new AtomicReference();
        final AtomicReference domainObjectRef = new AtomicReference();
        GhidraURLQuery.queryUrl(ghidraUrl, this.getDomainObjectClass(), new GhidraURLResultHandlerAdapter(true){

            @Override
            public void processResult(DomainFile domainFile, URL url, TaskMonitor m) throws IOException, CancelledException {
                if (!LinkHandler.this.getDomainObjectClass().isAssignableFrom(domainFile.getDomainObjectClass())) {
                    throw new BadLinkException("Expected " + String.valueOf(LinkHandler.this.getDomainObjectClass()) + " but linked to " + String.valueOf(domainFile.getDomainObjectClass()));
                }
                try {
                    DomainObjectAdapterDB linkedObject = immutable ? (DomainObjectAdapterDB)domainFile.getImmutableDomainObject(consumer, version, monitor) : (DomainObjectAdapterDB)domainFile.getReadOnlyDomainObject(consumer, version, monitor);
                    domainObjectRef.set(linkedObject);
                }
                catch (VersionException e) {
                    verExcRef.set(e);
                }
            }

            @Override
            public void handleUnauthorizedAccess(URL url) throws IOException {
                throw new IOException("Authorization failure");
            }
        }, GhidraURLQuery.LinkFileControl.FOLLOW_EXTERNAL, monitor);
        VersionException versionException = (VersionException)((Object)verExcRef.get());
        if (versionException != null) {
            throw versionException;
        }
        DomainObjectAdapterDB domainObj = (DomainObjectAdapterDB)domainObjectRef.get();
        if (domainObj == null) {
            throw new IOException("Failed to obtain linked object for unknown reason: " + String.valueOf(ghidraUrl));
        }
        return (T)domainObj;
    }

    @Override
    public final ChangeSet getChangeSet(FolderItem versionedFolderItem, int olderVersion, int newerVersion) throws VersionException, IOException {
        return null;
    }

    @Override
    public final DomainObjectMergeManager getMergeManager(DomainObject resultsObj, DomainObject sourceObj, DomainObject originalObj, DomainObject latestObj) {
        return null;
    }

    @Override
    public final boolean isPrivateContentType() {
        throw new UnsupportedOperationException("Link file requires checking server vs local URL");
    }

    @Override
    public abstract Icon getIcon();

    static boolean canShareLink(FolderItem linkFile) {
        try {
            String linkPath = LinkHandler.getLinkPath(linkFile);
            return !GhidraURL.isLocalGhidraURL(linkPath);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    static String getLinkPath(FolderItem linkFile) throws IOException {
        String contentType = linkFile.getContentType();
        ContentHandler<?> ch = DomainObjectAdapter.getContentHandler(contentType);
        if (ch instanceof LinkHandler) {
            String linkPath = null;
            if (linkFile instanceof TextDataItem) {
                TextDataItem textItem = (TextDataItem)linkFile;
                linkPath = textItem.getTextData();
            }
            if (linkPath == null) {
                Map<String, String> metadata = GhidraFileData.getMetadata(linkFile);
                linkPath = metadata.get(URL_METADATA_KEY);
            }
            if (StringUtils.isBlank(linkPath)) {
                throw new IOException("Invalid link-file: " + linkFile.getPathName());
            }
            return linkPath;
        }
        throw new IOException("Invalid link-file content: " + linkFile.getPathName());
    }

    public static URL getLinkURL(DomainFile linkFile) throws IOException {
        String linkPath = LinkHandler.getAbsoluteLinkPath(linkFile);
        if (linkPath == null) {
            return null;
        }
        try {
            if (!GhidraURL.isGhidraURL(linkPath)) {
                ProjectData projectData = linkFile.getParent().getProjectData();
                return GhidraURL.makeURL(projectData.getProjectLocator(), linkPath, null);
            }
            return new URL(linkPath);
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            throw new IOException("Failed to form URL from linkPath: " + linkPath, e);
        }
    }

    public static String getAbsoluteLinkPath(DomainFile linkFile) throws IOException {
        LinkFileInfo linkInfo = linkFile.getLinkInfo();
        if (linkInfo == null) {
            return null;
        }
        String linkPath = linkInfo.getLinkPath();
        if (StringUtils.isBlank((CharSequence)linkPath)) {
            return null;
        }
        Object path = linkPath;
        boolean isRelative = false;
        if (!GhidraURL.isGhidraURL((String)path)) {
            if (!linkPath.startsWith(FileSystem.SEPARATOR)) {
                DomainFolder parent;
                isRelative = true;
                if (linkFile instanceof LinkedDomainFile) {
                    LinkedDomainFile linkedFile = (LinkedDomainFile)linkFile;
                    parent = linkedFile.getRealFile().getParent();
                } else {
                    parent = linkFile.getParent();
                }
                path = parent.getPathname();
                if (!((String)path).endsWith(FileSystem.SEPARATOR)) {
                    path = (String)path + FileSystem.SEPARATOR;
                }
                path = (String)path + linkPath;
            }
            try {
                return FileSystem.normalizePath((String)path);
            }
            catch (IllegalArgumentException e) {
                String hint = "";
                if (isRelative && linkFile instanceof LinkedDomainFile) {
                    hint = " (relative to real link-file)";
                }
                throw new IOException("Invalid link path: " + (String)path + hint);
            }
        }
        return path;
    }

    public static LinkStatus getLinkFileStatus(DomainFile file, Consumer<String> errorConsumer) {
        AtomicReference status = new AtomicReference();
        LinkHandler.followInternalLinkage(file, s -> status.set(s), errorConsumer);
        return (LinkStatus)((Object)status.get());
    }

    private static boolean addLinkPath(Set<String> pathSet, String linkPath) {
        if (!((String)linkPath).endsWith(FileSystem.SEPARATOR)) {
            linkPath = (String)linkPath + FileSystem.SEPARATOR;
        }
        for (String path : pathSet) {
            if (!path.startsWith((String)linkPath)) continue;
            return false;
        }
        pathSet.add((String)linkPath);
        return true;
    }

    public static DomainFile followInternalLinkage(DomainFile file, Consumer<LinkStatus> statusConsumer, Consumer<String> errorConsumer) {
        ProjectData projectData;
        Objects.requireNonNull(statusConsumer, "Status consumer is required");
        errorConsumer = Dummy.ifNull(errorConsumer);
        LinkFileInfo linkInfo = file.getLinkInfo();
        if (linkInfo == null) {
            statusConsumer.accept(LinkStatus.NON_LINK);
            return null;
        }
        HashSet<String> linkPathsVisited = new HashSet<String>();
        DomainFolder parent = file.getParent();
        if (parent instanceof LinkedDomainFolder) {
            LinkedDomainFolder lf = (LinkedDomainFolder)parent;
            try {
                projectData = lf.getLinkedProjectData();
                LinkHandler.addLinkPath(linkPathsVisited, lf.getLinkedPathname());
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected", e);
            }
        } else {
            projectData = parent.getProjectData();
            LinkHandler.addLinkPath(linkPathsVisited, file.getPathname());
        }
        String contentType = file.getContentType();
        Class<? extends DomainObject> domainObjectClass = file.getDomainObjectClass();
        boolean isFolderLink = "FolderLink".equals(contentType);
        DomainFile nextLinkFile = file;
        while (true) {
            String linkPath = null;
            try {
                linkPath = LinkHandler.getAbsoluteLinkPath(nextLinkFile);
            }
            catch (IOException e) {
                errorConsumer.accept(e.getMessage());
                break;
            }
            if (linkPath == null) {
                errorConsumer.accept("Invalid link-path storage");
                break;
            }
            if (isFolderLink) {
                String name = nextLinkFile.getName();
                if (nextLinkFile.getParent().getFolder(name) != null) {
                    errorConsumer.accept("Folder name conflicts with this folder-link in same folder: " + name);
                    break;
                }
            }
            if (GhidraURL.isGhidraURL(linkPath)) {
                statusConsumer.accept(LinkStatus.EXTERNAL);
                return nextLinkFile;
            }
            DomainFile linkedFile = null;
            if (!linkPath.endsWith(FileSystem.SEPARATOR)) {
                linkedFile = projectData.getFile(linkPath);
            }
            DomainFolder linkedFolder = null;
            if (isFolderLink) {
                linkedFolder = LinkHandler.getNonLinkedFolder(projectData, linkPath);
            }
            if (linkedFolder == null && !LinkHandler.addLinkPath(linkPathsVisited, linkPath)) {
                errorConsumer.accept("Link has a circular reference");
                break;
            }
            if (isFolderLink && linkedFolder != null) {
                LinkFileInfo linkedFileLinkInfo;
                if (linkedFile != null && (linkedFileLinkInfo = linkedFile.getLinkInfo()) != null && linkedFileLinkInfo.isFolderLink()) {
                    errorConsumer.accept("Referenced folder name conflicts with folder-link in the same folder: " + linkPath);
                    break;
                }
                statusConsumer.accept(LinkStatus.INTERNAL);
                return nextLinkFile;
            }
            if (linkedFile == null) {
                String acceptableType = isFolderLink ? "folder" : "file";
                errorConsumer.accept("Broken " + contentType + " - " + acceptableType + " not found: " + linkPath);
                break;
            }
            if (!domainObjectClass.isAssignableFrom(linkedFile.getDomainObjectClass())) {
                errorConsumer.accept("Broken " + contentType + " - incompatible content-type: " + linkPath);
                break;
            }
            if (!linkedFile.isLink()) {
                statusConsumer.accept(LinkStatus.INTERNAL);
                return linkedFile;
            }
            nextLinkFile = linkedFile;
        }
        statusConsumer.accept(LinkStatus.BROKEN);
        return nextLinkFile;
    }

    private static DomainFolder getNonLinkedFolder(ProjectData projectData, String path) {
        int len = path.length();
        if (len == 0 || path.charAt(0) != '/') {
            throw new IllegalArgumentException("Absolute path must begin with '/'");
        }
        DomainFolder folder = projectData.getRootFolder();
        String[] split = path.split(FileSystem.SEPARATOR);
        if (split.length == 0) {
            return folder;
        }
        for (int i = 1; i < split.length; ++i) {
            DomainFolder subFolder = folder.getFolder(split[i]);
            if (subFolder == null) {
                return null;
            }
            folder = subFolder;
        }
        return folder;
    }

    public static enum LinkStatus {
        BROKEN,
        INTERNAL,
        EXTERNAL,
        NON_LINK;

    }
}

