/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.store;

import db.buffers.BufferFile;
import db.buffers.ManagedBufferFile;
import ghidra.framework.store.DataFileItem;
import ghidra.framework.store.DatabaseItem;
import ghidra.framework.store.FileSystemListener;
import ghidra.framework.store.FolderItem;
import ghidra.framework.store.TextDataItem;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public interface FileSystem {
    public static final char SEPARATOR_CHAR = '/';
    public static final String SEPARATOR = Character.toString('/');

    public String getUserName();

    public boolean isVersioned();

    public boolean isOnline();

    public boolean isReadOnly() throws IOException;

    public int getItemCount() throws IOException, UnsupportedOperationException;

    public String[] getItemNames(String var1) throws IOException;

    public FolderItem[] getItems(String var1) throws IOException;

    public FolderItem getItem(String var1, String var2) throws IOException;

    public FolderItem getItem(String var1) throws IOException, UnsupportedOperationException;

    public String[] getFolderNames(String var1) throws IOException;

    public void createFolder(String var1, String var2) throws InvalidNameException, IOException;

    public boolean isSupportedItemType(FolderItem var1);

    public DatabaseItem createDatabase(String var1, String var2, String var3, BufferFile var4, String var5, String var6, boolean var7, TaskMonitor var8, String var9) throws InvalidNameException, IOException, CancelledException;

    public ManagedBufferFile createDatabase(String var1, String var2, String var3, String var4, int var5, String var6, String var7) throws InvalidNameException, IOException;

    public DataFileItem createDataFile(String var1, String var2, InputStream var3, String var4, String var5, TaskMonitor var6) throws InvalidNameException, IOException, CancelledException;

    public TextDataItem createTextDataItem(String var1, String var2, String var3, String var4, String var5, String var6, String var7) throws InvalidNameException, IOException;

    public FolderItem createFile(String var1, String var2, File var3, TaskMonitor var4, String var5) throws InvalidNameException, IOException, CancelledException;

    public void deleteFolder(String var1) throws IOException;

    public void moveFolder(String var1, String var2, String var3) throws InvalidNameException, IOException;

    public void renameFolder(String var1, String var2, String var3) throws InvalidNameException, IOException;

    public void moveItem(String var1, String var2, String var3, String var4) throws IOException, InvalidNameException;

    public void addFileSystemListener(FileSystemListener var1);

    public void removeFileSystemListener(FileSystemListener var1);

    public boolean folderExists(String var1) throws IOException;

    public boolean fileExists(String var1, String var2) throws IOException;

    public boolean isShared();

    public void dispose();

    public static String normalizePath(String path) throws IllegalArgumentException {
        if (!path.startsWith(SEPARATOR)) {
            throw new IllegalArgumentException("Absolute path required: " + path);
        }
        String[] split = path.split(SEPARATOR);
        ArrayList<String> elements = new ArrayList<String>();
        elements.add(SEPARATOR);
        for (int i = 1; i < split.length; ++i) {
            Object e = split[i];
            if (((String)e).length() == 0) {
                throw new IllegalArgumentException("Invalid path with empty element: " + path);
            }
            if ("..".equals(e)) {
                elements.removeLast();
                if (elements.size() != 0) continue;
                throw new IllegalArgumentException("Invalid path: " + path);
            }
            if (".".equals(e)) continue;
            if (i < split.length - 1) {
                e = (String)e + SEPARATOR;
            }
            elements.add((String)e);
        }
        if (elements.isEmpty()) {
            return SEPARATOR;
        }
        StringBuilder buf = new StringBuilder();
        for (String e : elements) {
            buf.append(e);
        }
        if (path.endsWith(SEPARATOR)) {
            buf.append(SEPARATOR);
        }
        return buf.toString();
    }
}

