/*
 * Decompiled with CFR 0.152.
 */
package datagraph.graph.explore;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class GraphLocationMap<V> {
    private Map<V, Point> vertexPoints = new HashMap<V, Point>();
    private int minX;
    private int maxX;
    private int minY;
    private int maxY;

    public GraphLocationMap(V vertex, int width, int height) {
        this.vertexPoints.put((Point)vertex, new Point(0, 0));
        this.maxX = (width + 1) / 2;
        this.minX = -width / 2;
        this.maxY = (height + 1) / 2;
        this.minY = -height / 2;
    }

    public void merge(GraphLocationMap<V> other, int xShift, int yShift) {
        other.shift(xShift, yShift);
        this.vertexPoints.putAll(other.vertexPoints);
        this.minX = Math.min(this.minX, other.minX);
        this.maxX = Math.max(this.maxX, other.maxX);
        this.minY = Math.min(this.minY, other.minY);
        this.maxY = Math.max(this.maxY, other.maxY);
        other.dispose();
    }

    private void dispose() {
        this.vertexPoints.clear();
    }

    private void shift(int xShift, int yShift) {
        Collection<Point> values = this.vertexPoints.values();
        for (Point point : values) {
            point.x += xShift;
            point.y += yShift;
        }
        this.maxX += xShift;
        this.minX += xShift;
        this.maxY += yShift;
        this.minY += yShift;
    }

    public int getWidth() {
        return this.maxX - this.minX;
    }

    public int getHeight() {
        return this.maxY - this.minY;
    }

    public Point get(V v) {
        return this.vertexPoints.get(v);
    }

    public Map<V, Point2D> getVertexLocations() {
        HashMap<V, Point> points = new HashMap<V, Point>();
        points.putAll(this.vertexPoints);
        return points;
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMaxX() {
        return this.maxX;
    }
}

