/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.mapping;

import ghidra.app.plugin.core.debug.mapping.AbstractDebuggerPlatformMapper;
import ghidra.app.plugin.core.debug.mapping.DebuggerPlatformOffer;
import ghidra.app.plugin.core.debug.mapping.DebuggerPlatformOpinion;
import ghidra.debug.api.platform.DebuggerPlatformMapper;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Processor;
import ghidra.trace.model.Trace;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.target.TraceObject;
import java.util.Set;

public class HostDebuggerPlatformOpinion
implements DebuggerPlatformOpinion {
    public static final int CONFIDENCE_HOST_KNOWN = 10000;

    @Override
    public Set<DebuggerPlatformOffer> getOffers(Trace trace, TraceObject focus, long snap, boolean includeOverrides) {
        Processor procDATA;
        Processor processor = trace.getBaseLanguage().getProcessor();
        if (processor == (procDATA = Processor.findOrPossiblyCreateProcessor((String)"DATA"))) {
            return Set.of(Offers.HOST_UNKNOWN);
        }
        return Set.of(Offers.HOST_KNOWN);
    }

    static enum Offers implements DebuggerPlatformOffer
    {
        HOST_UNKNOWN{

            @Override
            public String getDescription() {
                return "Host/base (back end defaulted to DATA)";
            }

            @Override
            public int getConfidence() {
                return 1;
            }
        }
        ,
        HOST_KNOWN{

            @Override
            public String getDescription() {
                return "Host/base (back end chose the language)";
            }

            @Override
            public int getConfidence() {
                return 10000;
            }
        };


        @Override
        public CompilerSpec getCompilerSpec() {
            return null;
        }

        @Override
        public DebuggerPlatformMapper take(PluginTool tool, Trace trace) {
            return new HostDebuggerPlatformMapper(tool, trace);
        }

        @Override
        public boolean isCreatorOf(DebuggerPlatformMapper mapper) {
            return mapper.getClass() == HostDebuggerPlatformMapper.class;
        }
    }

    protected static class HostDebuggerPlatformMapper
    extends AbstractDebuggerPlatformMapper {
        public HostDebuggerPlatformMapper(PluginTool tool, Trace trace) {
            super(tool, trace);
        }

        public CompilerSpec getCompilerSpec(TraceObject object, long snap) {
            return this.trace.getBaseCompilerSpec();
        }

        public TracePlatform addToTrace(TraceObject newFocus, long snap) {
            return this.trace.getPlatformManager().getHostPlatform();
        }

        @Override
        public boolean canInterpret(TraceObject newFocus, long snap) {
            return true;
        }
    }
}

