/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.visualization.BasicVisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.control.EdgeEffects;
import edu.uci.ics.jung.visualization.util.ArrowFactory;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;

public class CubicCurveEdgeEffects<V, E>
implements EdgeEffects<V, E> {
    protected CubicCurve2D rawEdge = new CubicCurve2D.Float();
    protected Shape edgeShape;
    protected Shape rawArrowShape;
    protected Shape arrowShape;
    protected VisualizationServer.Paintable edgePaintable;
    protected VisualizationServer.Paintable arrowPaintable;

    public CubicCurveEdgeEffects() {
        this.rawEdge.setCurve(0.0, 0.0, 0.33f, 100.0, 0.66f, -50.0, 1.0, 0.0);
        this.rawArrowShape = ArrowFactory.getNotchedArrow(20.0f, 16.0f, 8.0f);
        this.edgePaintable = new EdgePaintable();
        this.arrowPaintable = new ArrowPaintable();
    }

    @Override
    public void startEdgeEffects(BasicVisualizationServer<V, E> vv, Point2D down, Point2D out) {
        this.transformEdgeShape(down, out);
        vv.addPostRenderPaintable(this.edgePaintable);
    }

    @Override
    public void midEdgeEffects(BasicVisualizationServer<V, E> vv, Point2D down, Point2D out) {
        this.transformEdgeShape(down, out);
    }

    @Override
    public void endEdgeEffects(BasicVisualizationServer<V, E> vv) {
        vv.removePostRenderPaintable(this.edgePaintable);
    }

    @Override
    public void startArrowEffects(BasicVisualizationServer<V, E> vv, Point2D down, Point2D out) {
        this.transformArrowShape(down, out);
        vv.addPostRenderPaintable(this.arrowPaintable);
    }

    @Override
    public void midArrowEffects(BasicVisualizationServer<V, E> vv, Point2D down, Point2D out) {
        this.transformArrowShape(down, out);
    }

    @Override
    public void endArrowEffects(BasicVisualizationServer<V, E> vv) {
        vv.removePostRenderPaintable(this.arrowPaintable);
    }

    private void transformEdgeShape(Point2D down, Point2D out) {
        float x1 = (float)down.getX();
        float y1 = (float)down.getY();
        float x2 = (float)out.getX();
        float y2 = (float)out.getY();
        AffineTransform xform = AffineTransform.getTranslateInstance(x1, y1);
        float dx = x2 - x1;
        float dy = y2 - y1;
        float thetaRadians = (float)Math.atan2(dy, dx);
        xform.rotate(thetaRadians);
        float dist = (float)Math.sqrt(dx * dx + dy * dy);
        xform.scale((double)dist / this.rawEdge.getBounds().getWidth(), 1.0);
        this.edgeShape = xform.createTransformedShape(this.rawEdge);
    }

    private void transformArrowShape(Point2D down, Point2D out) {
        float x1 = (float)down.getX();
        float y1 = (float)down.getY();
        float x2 = (float)out.getX();
        float y2 = (float)out.getY();
        AffineTransform xform = AffineTransform.getTranslateInstance(x2, y2);
        float dx = x2 - x1;
        float dy = y2 - y1;
        float thetaRadians = (float)Math.atan2(dy, dx);
        xform.rotate(thetaRadians);
        this.arrowShape = xform.createTransformedShape(this.rawArrowShape);
    }

    class ArrowPaintable
    implements VisualizationServer.Paintable {
        ArrowPaintable() {
        }

        @Override
        public void paint(Graphics g) {
            if (CubicCurveEdgeEffects.this.arrowShape != null) {
                Color oldColor = g.getColor();
                g.setColor(Color.black);
                ((Graphics2D)g).fill(CubicCurveEdgeEffects.this.arrowShape);
                g.setColor(oldColor);
            }
        }

        @Override
        public boolean useTransform() {
            return false;
        }
    }

    class EdgePaintable
    implements VisualizationServer.Paintable {
        EdgePaintable() {
        }

        @Override
        public void paint(Graphics g) {
            if (CubicCurveEdgeEffects.this.edgeShape != null) {
                Color oldColor = g.getColor();
                g.setColor(Color.black);
                ((Graphics2D)g).draw(CubicCurveEdgeEffects.this.edgeShape);
                g.setColor(oldColor);
            }
        }

        @Override
        public boolean useTransform() {
            return false;
        }
    }
}

