/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pyghidra;

import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.CancelledListener;
import ghidra.util.task.TaskMonitor;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang3.function.TriConsumer;

public class PyGhidraTaskMonitor
implements TaskMonitor {
    private String message;
    private long progress;
    private long maxProgress;
    private boolean isIndeterminate;
    private volatile boolean isCancelled = false;
    private Timer timer;
    private WeakSet<CancelledListener> listeners = WeakDataStructureFactory.createCopyOnReadWeakSet();
    private TriConsumer<String, Long, Long> changeCallback;

    public PyGhidraTaskMonitor(Integer timeoutSecs, TriConsumer<String, Long, Long> changeCallback) {
        if (timeoutSecs != null) {
            this.timer = new Timer(true);
            this.timer.schedule((TimerTask)new PyGhidraTimeOutTask(), timeoutSecs * 1000);
        }
        this.changeCallback = changeCallback;
    }

    public void initialize(long maxValue) {
        this.setMaximum(maxValue);
        this.setProgress(0L);
        this.setIndeterminate(false);
    }

    public void setMessage(String message) {
        this.message = message;
        if (this.changeCallback != null) {
            this.changeCallback.accept((Object)message, (Object)this.progress, (Object)this.maxProgress);
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void incrementProgress(long incrementAmount) {
        this.setProgress(this.progress + incrementAmount);
    }

    public void setProgress(long value) {
        this.progress = value;
        if (this.changeCallback != null) {
            this.changeCallback.accept((Object)this.message, (Object)this.progress, (Object)this.maxProgress);
        }
    }

    public long getProgress() {
        return this.progress;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setMaximum(long max) {
        this.maxProgress = max;
        if (this.progress > max) {
            this.progress = max;
        }
        if (this.changeCallback != null) {
            this.changeCallback.accept((Object)this.message, (Object)this.progress, (Object)this.maxProgress);
        }
    }

    public long getMaximum() {
        return this.maxProgress;
    }

    public void setIndeterminate(boolean indeterminate) {
        this.isIndeterminate = indeterminate;
    }

    public boolean isIndeterminate() {
        return this.isIndeterminate;
    }

    public void checkCanceled() throws CancelledException {
        if (this.isCancelled()) {
            throw new CancelledException();
        }
    }

    public void clearCanceled() {
        this.isCancelled = false;
    }

    public void cancel() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.isCancelled = true;
    }

    public void setCancelEnabled(boolean enable) {
    }

    public boolean isCancelEnabled() {
        return true;
    }

    public void setShowProgressValue(boolean showProgressValue) {
    }

    public void addCancelledListener(CancelledListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeCancelledListener(CancelledListener listener) {
        this.listeners.remove((Object)listener);
    }

    private class PyGhidraTimeOutTask
    extends TimerTask {
        private PyGhidraTimeOutTask() {
        }

        @Override
        public void run() {
            PyGhidraTaskMonitor.this.cancel();
        }
    }
}

