/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.symbol;

import db.DBHandle;
import db.DBRecord;
import db.StringField;
import ghidra.framework.data.OpenMode;
import ghidra.lifecycle.Internal;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.ProgramArchitecture;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceManager;
import ghidra.trace.database.address.DBTraceOverlaySpaceAdapter;
import ghidra.trace.database.data.DBTraceDataTypeManager;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMap;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapSpace;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.trace.database.symbol.AbstractDBTraceSymbol;
import ghidra.trace.database.symbol.AbstractDBTraceSymbolSingleTypeView;
import ghidra.trace.database.symbol.DBTraceClassSymbol;
import ghidra.trace.database.symbol.DBTraceClassSymbolView;
import ghidra.trace.database.symbol.DBTraceLabelSymbol;
import ghidra.trace.database.symbol.DBTraceLabelSymbolView;
import ghidra.trace.database.symbol.DBTraceNamespaceSymbol;
import ghidra.trace.database.symbol.DBTraceNamespaceSymbolView;
import ghidra.trace.database.symbol.DBTraceSymbolMultipleTypesNoDuplicatesView;
import ghidra.trace.database.symbol.DBTraceSymbolMultipleTypesView;
import ghidra.trace.database.thread.DBTraceThreadManager;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.symbol.TraceSymbolManager;
import ghidra.trace.model.symbol.TraceSymbolNoDuplicatesView;
import ghidra.trace.model.symbol.TraceSymbolView;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceEvents;
import ghidra.util.LockHold;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectIndex;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class DBTraceSymbolManager
implements TraceSymbolManager,
DBTraceManager {
    private static final long TYPE_MASK = 255L;
    private static final int TYPE_SHIFT = 56;
    private static final long KEY_MASK = 0xFFFFFFFFFFFFFFL;
    private static final int KEY_SHIFT = 0;
    protected final DBTrace trace;
    protected final ReadWriteLock lock;
    protected final DBTraceThreadManager threadManager;
    protected final DBTraceDataTypeManager dataTypeManager;
    protected final DBTraceOverlaySpaceAdapter overlayAdapter;
    protected final DBTraceAddressSnapRangePropertyMap<Long, DBTraceSymbolIDEntry> idMap;
    protected final DBCachedObjectStore<DBTraceVariableStorageEntry> storageStore;
    protected final DBCachedObjectIndex<VariableStorage, DBTraceVariableStorageEntry> storageByStorage;
    protected final DBCachedObjectStore<DBTraceLabelSymbol> labelStore;
    protected final DBCachedObjectStore<DBTraceNamespaceSymbol> namespaceStore;
    protected final DBCachedObjectStore<DBTraceClassSymbol> classStore;
    protected final DBTraceNamespaceSymbol globalNamespace;
    protected final DBTraceLabelSymbolView labels;
    protected final DBTraceNamespaceSymbolView namespaces;
    protected final DBTraceClassSymbolView classes;
    protected final DBTraceSymbolMultipleTypesView<? extends DBTraceNamespaceSymbol> allNamespaces;
    protected final DBTraceSymbolMultipleTypesNoDuplicatesView<? extends DBTraceNamespaceSymbol> uniqueNamespaces;
    protected final DBTraceSymbolMultipleTypesNoDuplicatesView<?> notLabels;
    protected final DBTraceSymbolMultipleTypesView<?> allSymbols;
    protected final Map<Byte, AbstractDBTraceSymbolSingleTypeView<?>> symbolViews = new HashMap();

    public DBTraceSymbolManager(DBHandle dbh, OpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, Language baseLanguage, DBTrace trace, DBTraceThreadManager threadManager, DBTraceDataTypeManager dataTypeManager, DBTraceOverlaySpaceAdapter overlayAdapter) throws VersionException, IOException {
        this.trace = trace;
        this.lock = lock;
        this.threadManager = threadManager;
        this.dataTypeManager = dataTypeManager;
        this.overlayAdapter = overlayAdapter;
        DBCachedObjectStoreFactory factory = trace.getStoreFactory();
        this.idMap = new DBTraceAddressSnapRangePropertyMap("SymbolIDs", dbh, openMode, lock, monitor, baseLanguage, trace, threadManager, DBTraceSymbolIDEntry.class, DBTraceSymbolIDEntry::new);
        this.storageStore = factory.getOrCreateCachedStore("VariableStorage", DBTraceVariableStorageEntry.class, (s, r) -> new DBTraceVariableStorageEntry(this, s, r), true);
        this.storageByStorage = this.storageStore.getIndex(VariableStorage.class, DBTraceVariableStorageEntry.STORAGE_COLUMN);
        this.labelStore = factory.getOrCreateCachedStore("Labels", DBTraceLabelSymbol.class, (s, r) -> new DBTraceLabelSymbol(this, s, r), true);
        this.namespaceStore = factory.getOrCreateCachedStore("Namespaces", DBTraceNamespaceSymbol.class, (s, r) -> new DBTraceNamespaceSymbol(this, s, r), true);
        this.classStore = factory.getOrCreateCachedStore("Classes", DBTraceClassSymbol.class, (s, r) -> new DBTraceClassSymbol(this, s, r), true);
        this.globalNamespace = this.getOrCreateGlobalNamespace();
        this.labels = this.putInMap(new DBTraceLabelSymbolView(this));
        this.namespaces = this.putInMap(new DBTraceNamespaceSymbolView(this));
        this.classes = this.putInMap(new DBTraceClassSymbolView(this));
        this.allNamespaces = new DBTraceSymbolMultipleTypesView(this, this.namespaces, this.classes);
        this.uniqueNamespaces = new DBTraceSymbolMultipleTypesNoDuplicatesView(this, this.namespaces, this.classes);
        this.notLabels = new DBTraceSymbolMultipleTypesNoDuplicatesView(this, this.namespaces, this.classes);
        this.allSymbols = new DBTraceSymbolMultipleTypesView(this, this.labels, this.namespaces, this.classes);
    }

    protected DataType checkIndirection(VariableStorage s, DataType formal) {
        if (!s.isForcedIndirect()) {
            return formal;
        }
        int ptrSize = s.size();
        if (ptrSize != this.dataTypeManager.getDataOrganization().getPointerSize()) {
            return this.dataTypeManager.getPointer(formal, ptrSize);
        }
        return this.dataTypeManager.getPointer(formal);
    }

    protected <T extends AbstractDBTraceSymbolSingleTypeView<?>> T putInMap(T view) {
        this.symbolViews.put(view.typeID, view);
        return view;
    }

    protected DBTraceNamespaceSymbol getOrCreateGlobalNamespace() {
        DBTraceNamespaceSymbol global = (DBTraceNamespaceSymbol)this.namespaceStore.getObjectAt(0L);
        if (global != null) {
            assert (global.parentID == -1L);
            assert ("Global".equals(global.name));
            return global;
        }
        global = (DBTraceNamespaceSymbol)this.namespaceStore.create(0L);
        global.rawSet("Global", -1L);
        return global;
    }

    protected static long packID(byte typeID, long key) {
        assert ((long)(typeID + 1) <= 255L);
        assert (key <= 0xFFFFFFFFFFFFFFL);
        return ((long)(typeID + 1) & 0xFFL) << 56 | (key & 0xFFFFFFFFFFFFFFL) << 0;
    }

    protected static byte unpackTypeID(long symbolID) {
        return (byte)((symbolID >> 56 & 0xFFL) - 1L);
    }

    protected static long unpackKey(long symbolID) {
        return symbolID >> 0 & 0xFFFFFFFFFFFFFFL;
    }

    protected int findOrRecordVariableStorage(VariableStorage storage) {
        DBTraceVariableStorageEntry entry = (DBTraceVariableStorageEntry)this.storageByStorage.getOne((Object)storage);
        if (entry == null) {
            entry = (DBTraceVariableStorageEntry)this.storageStore.create();
            entry.set(storage);
        }
        return (int)entry.getKey();
    }

    public void dbError(IOException e) {
        this.trace.dbError(e);
    }

    @Override
    public void invalidateCache(boolean all) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            this.idMap.invalidateCache(all);
            for (AbstractDBTraceSymbolSingleTypeView<?> view : this.symbolViews.values()) {
                view.invalidateCache();
            }
            if (this.globalNamespace.isDeleted()) {
                throw new AssertionError();
            }
        }
    }

    public void replaceDataTypes(Map<Long, Long> dataTypeReplacementMap) {
    }

    protected void assertValidThreadAddress(TraceThread thread, Address address) {
        if (thread != null && address.isMemoryAddress()) {
            throw new IllegalArgumentException("Memory addresses cannot be associated with a thread");
        }
    }

    @Override
    public Trace getTrace() {
        return this.trace;
    }

    @Override
    public AbstractDBTraceSymbol getSymbolByID(long symbolID) {
        if (symbolID == 0L) {
            return this.globalNamespace;
        }
        byte typeID = DBTraceSymbolManager.unpackTypeID(symbolID);
        AbstractDBTraceSymbolSingleTypeView<?> view = this.symbolViews.get(typeID);
        if (view == null) {
            return null;
        }
        return (AbstractDBTraceSymbol)view.store.getObjectAt(DBTraceSymbolManager.unpackKey(symbolID));
    }

    @Override
    public DBTraceNamespaceSymbol getGlobalNamespace() {
        return this.globalNamespace;
    }

    @Override
    public DBTraceLabelSymbolView labels() {
        return this.labels;
    }

    @Override
    public DBTraceNamespaceSymbolView namespaces() {
        return this.namespaces;
    }

    @Override
    public DBTraceClassSymbolView classes() {
        return this.classes;
    }

    public TraceSymbolView<? extends DBTraceNamespaceSymbol> allNamespaces() {
        return this.allNamespaces;
    }

    public TraceSymbolNoDuplicatesView<? extends DBTraceNamespaceSymbol> uniqueNamespaces() {
        return this.uniqueNamespaces;
    }

    public TraceSymbolNoDuplicatesView<? extends AbstractDBTraceSymbol> notLabels() {
        return this.notLabels;
    }

    public TraceSymbolView<? extends AbstractDBTraceSymbol> allSymbols() {
        return this.allSymbols;
    }

    public DBTraceNamespaceSymbol checkIsMine(Namespace ns) {
        DBTraceClassSymbol dbcs;
        if (!(ns instanceof DBTraceNamespaceSymbol)) {
            return null;
        }
        DBTraceNamespaceSymbol dbns = (DBTraceNamespaceSymbol)ns;
        if (dbns.manager != this) {
            return null;
        }
        if (dbns.isDeleted()) {
            return null;
        }
        if (this.namespaceStore.contains((DBAnnotatedObject)dbns)) {
            return dbns;
        }
        if (dbns instanceof DBTraceClassSymbol && this.classStore.contains((DBAnnotatedObject)(dbcs = (DBTraceClassSymbol)dbns))) {
            return dbns;
        }
        return null;
    }

    public AbstractDBTraceSymbol checkIsMine(Symbol symbol) {
        if (!(symbol instanceof AbstractDBTraceSymbol)) {
            return null;
        }
        AbstractDBTraceSymbol dbSym = (AbstractDBTraceSymbol)symbol;
        if (dbSym.manager != this) {
            return null;
        }
        if (dbSym.isDeleted()) {
            return null;
        }
        long symbolID = dbSym.getID();
        byte tid = DBTraceSymbolManager.unpackTypeID(symbolID);
        AbstractDBTraceSymbolSingleTypeView<?> view = this.symbolViews.get(tid);
        if (view == null) {
            return null;
        }
        if (!view.store.containsKey(DBTraceSymbolManager.unpackKey(symbolID))) {
            return null;
        }
        return dbSym;
    }

    @Internal
    public DBTraceNamespaceSymbol assertIsMine(Namespace ns) {
        DBTraceNamespaceSymbol dbns = this.checkIsMine(ns);
        if (dbns == null) {
            throw new IllegalArgumentException("Given namespace is not in this trace");
        }
        return dbns;
    }

    @Internal
    public AbstractDBTraceSymbol assertIsMine(Symbol symbol) {
        AbstractDBTraceSymbol dbSym = this.checkIsMine(symbol);
        if (dbSym == null) {
            throw new IllegalArgumentException("Given symbol is not in this trace");
        }
        return dbSym;
    }

    protected static void assertValidName(String name) throws InvalidInputException {
        if (name == null || name.length() == 0 || !name.matches("\\p{Graph}+")) {
            throw new InvalidInputException(name);
        }
    }

    protected void assertUniqueName(String name, DBTraceNamespaceSymbol parent) throws DuplicateNameException {
        for (AbstractDBTraceSymbol symbol : this.notLabels.getChildren(parent)) {
            if (!name.equals(symbol.name)) continue;
            throw new DuplicateNameException(name);
        }
    }

    protected boolean doDeleteSymbol(AbstractDBTraceSymbol symbol) {
        byte typeID = symbol.getSymbolType().getID();
        TraceThread thread = symbol.getThread();
        AbstractDBTraceSymbol deleted = (AbstractDBTraceSymbol)this.symbolViews.get((Object)Byte.valueOf((byte)typeID)).store.deleteKey(symbol.getKey());
        if (deleted == null) {
            return false;
        }
        if (symbol.getAddress().isMemoryAddress()) {
            this.delID(thread, symbol.getAddress().getAddressSpace(), symbol.getID());
        }
        this.trace.setChanged(new TraceChangeRecord<AbstractDBTraceSymbol, Object>(TraceEvents.SYMBOL_DELETED, symbol.getAddressSpace(), symbol, null, null));
        return true;
    }

    protected void putID(Lifespan lifespan, Address address, long id) {
        ((DBTraceAddressSnapRangePropertyMapSpace)this.idMap.get(address.getAddressSpace(), true)).put(address, lifespan, id);
    }

    protected void putID(Lifespan lifespan, TraceThread thread, AddressRange rng, long id) {
        ((DBTraceAddressSnapRangePropertyMapSpace)this.idMap.get(rng.getAddressSpace(), true)).put(rng, lifespan, id);
    }

    protected void delID(TraceThread thread, AddressSpace addressSpace, long id) {
        DBTraceAddressSnapRangePropertyMapSpace space = (DBTraceAddressSnapRangePropertyMapSpace)this.idMap.get(addressSpace, false);
        if (space == null) {
            return;
        }
        DBCachedObjectIndex byID = space.getUserIndex(Long.TYPE, DBTraceSymbolIDEntry.ID_COLUMN);
        for (DBTraceSymbolIDEntry entry : byID.get((Object)id)) {
            space.deleteData(entry);
        }
    }

    protected void assertNotDuplicate(AbstractDBTraceSymbol exclude, Lifespan lifespan, Address address, String name, DBTraceNamespaceSymbol parent) throws DuplicateNameException {
        if (address.isMemoryAddress()) {
            for (AbstractDBTraceSymbol duplicate : this.labels.getIntersecting(lifespan, (AddressRange)new AddressRangeImpl(address, address), false, true)) {
                if (duplicate == exclude || duplicate.getParentNamespace() != parent || !name.contentEquals(duplicate.getName())) continue;
                throw new DuplicateNameException(name);
            }
        }
        this.assertNotDuplicate(exclude, name, parent);
    }

    protected void assertNotDuplicate(AbstractDBTraceSymbol exclude, String name, DBTraceNamespaceSymbol parent) throws DuplicateNameException {
        for (AbstractDBTraceSymbol duplicate : this.notLabels.getChildrenNamed(name, parent)) {
            if (duplicate == exclude) continue;
            throw new DuplicateNameException(name);
        }
    }

    @Override
    public Collection<Long> getIDsAdded(long from, long to) {
        if (from == to) {
            return Collections.emptySet();
        }
        ArrayList<Long> result = new ArrayList<Long>();
        for (DBTraceAddressSnapRangePropertyMapSpace space : this.idMap.getActiveSpaces()) {
            result.addAll(space.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.added(from, to, space.getAddressSpace())).values());
        }
        return result;
    }

    @Override
    public Collection<Long> getIDsRemoved(long from, long to) {
        if (from == to) {
            return Collections.emptySet();
        }
        ArrayList<Long> result = new ArrayList<Long>();
        for (DBTraceAddressSnapRangePropertyMapSpace space : this.idMap.getActiveSpaces()) {
            result.addAll(space.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.removed(from, to, space.getAddressSpace())).values());
        }
        return result;
    }

    @DBAnnotatedObjectInfo(version=0)
    public static class DBTraceSymbolIDEntry
    extends DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData<Long> {
        static final String ID_COLUMN_NAME = "ID";
        @DBAnnotatedColumn(value="ID")
        static DBObjectColumn ID_COLUMN;
        @DBAnnotatedField(column="ID", indexed=true)
        long symbolID;

        public DBTraceSymbolIDEntry(DBTraceAddressSnapRangePropertyMapTree<Long, ?> tree, DBCachedObjectStore<?> store, DBRecord record) {
            super(tree, store, record);
        }

        protected void setRecordValue(Long symbolID) {
            assert (symbolID != null);
            this.symbolID = symbolID;
            this.update(ID_COLUMN);
        }

        protected Long getRecordValue() {
            return this.symbolID;
        }
    }

    @DBAnnotatedObjectInfo(version=0)
    public static class DBTraceVariableStorageEntry
    extends DBAnnotatedObject {
        static final String TABLE_NAME = "VariableStorage";
        static final String STORAGE_COLUMN_NAME = "Storage";
        @DBAnnotatedColumn(value="Storage")
        static DBObjectColumn STORAGE_COLUMN;
        @DBAnnotatedField(column="Storage", indexed=true, codec=VariableStorageDBFieldCodec.class)
        private VariableStorage storage;
        protected final DBTraceSymbolManager manager;

        public DBTraceVariableStorageEntry(DBTraceSymbolManager manager, DBCachedObjectStore<?> store, DBRecord record) {
            super(store, record);
            this.manager = manager;
        }

        void set(VariableStorage storage) {
            this.storage = storage;
            this.update(STORAGE_COLUMN);
        }

        public Program getProgram() {
            return this.manager.trace.getProgramView();
        }

        public VariableStorage getStorage() {
            return this.storage;
        }
    }

    public static enum MySymbolTypes {
        LABEL{

            @Override
            boolean isValidParent(DBTraceNamespaceSymbol parent) {
                return true;
            }
        }
        ,
        NO_LIBRARY{

            @Override
            boolean isValidParent(DBTraceNamespaceSymbol parent) {
                return false;
            }
        }
        ,
        NO_NULL{

            @Override
            boolean isValidParent(DBTraceNamespaceSymbol parent) {
                return false;
            }
        }
        ,
        NAMESPACE{

            @Override
            boolean isValidParent(DBTraceNamespaceSymbol parent) {
                return true;
            }
        }
        ,
        CLASS{

            @Override
            boolean isValidParent(DBTraceNamespaceSymbol parent) {
                return true;
            }
        }
        ,
        GLOBAL_VAR{

            @Override
            boolean isValidParent(DBTraceNamespaceSymbol parent) {
                return parent.getSymbolType() == SymbolType.GLOBAL;
            }
        };

        public static final List<MySymbolTypes> VALUES;

        abstract boolean isValidParent(DBTraceNamespaceSymbol var1);

        static {
            VALUES = List.of(MySymbolTypes.values());
        }
    }

    public static class VariableStorageDBFieldCodec
    extends DBCachedObjectStoreFactory.AbstractDBFieldCodec<VariableStorage, DBTraceVariableStorageEntry, StringField> {
        public VariableStorageDBFieldCodec(Class<DBTraceVariableStorageEntry> objectType, Field field, int column) {
            super(VariableStorage.class, objectType, StringField.class, field, column);
        }

        public void store(VariableStorage value, StringField f) {
            f.setString(value == null ? null : value.getSerializationString());
        }

        protected void doStore(DBTraceVariableStorageEntry obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            VariableStorage value = (VariableStorage)this.getValue(obj);
            record.setString(this.column, value == null ? null : value.getSerializationString());
        }

        protected void doLoad(DBTraceVariableStorageEntry obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            String serial = record.getString(this.column);
            try {
                this.setValue(obj, serial == null ? null : VariableStorage.deserialize((ProgramArchitecture)obj.getProgram(), (String)serial));
            }
            catch (InvalidInputException e) {
                throw new AssertionError("Database corruption", e);
            }
        }
    }
}

