/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec.trace.data;

import ghidra.pcode.emu.PcodeThread;
import ghidra.pcode.exec.trace.data.PcodeTraceAccess;
import ghidra.pcode.exec.trace.data.PcodeTraceMemoryAccess;
import ghidra.pcode.exec.trace.data.PcodeTraceRegistersAccess;
import ghidra.program.model.lang.Language;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceTimeViewport;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.thread.TraceThread;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractPcodeTraceAccess<S extends PcodeTraceMemoryAccess, L extends PcodeTraceRegistersAccess>
implements PcodeTraceAccess {
    protected final TracePlatform platform;
    protected final long threadsSnap;
    protected final long snap;
    protected final TraceTimeViewport viewport;
    protected S dataForSharedState;
    protected final Map<Pair<TraceThread, Integer>, L> dataForLocalStateByThreadAndFrame = new HashMap<Pair<TraceThread, Integer>, L>();

    public AbstractPcodeTraceAccess(TracePlatform platform, long snap, long threadsSnap) {
        this.platform = platform;
        this.snap = snap;
        this.threadsSnap = threadsSnap;
        TraceTimeViewport viewport = this.getTrace().createTimeViewport();
        viewport.setSnap(snap);
        this.viewport = viewport;
    }

    public AbstractPcodeTraceAccess(TracePlatform platform, long snap) {
        this(platform, snap, snap);
    }

    protected Trace getTrace() {
        return this.platform.getTrace();
    }

    protected TraceThread getTraceThread(PcodeThread<?> thread) {
        return this.getTrace().getThreadManager().getLiveThreadByPath(this.threadsSnap, thread.getName());
    }

    @Override
    public Language getLanguage() {
        return this.platform.getLanguage();
    }

    protected abstract S newDataForSharedState();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S getDataForSharedState() {
        Map<Pair<TraceThread, Integer>, L> map = this.dataForLocalStateByThreadAndFrame;
        synchronized (map) {
            if (this.dataForSharedState == null) {
                this.dataForSharedState = this.newDataForSharedState();
            }
            return this.dataForSharedState;
        }
    }

    protected abstract L newDataForLocalState(TraceThread var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public L getDataForLocalState(TraceThread thread, int frame) {
        if (thread == null) {
            return null;
        }
        Map<Pair<TraceThread, Integer>, L> map = this.dataForLocalStateByThreadAndFrame;
        synchronized (map) {
            return (L)this.dataForLocalStateByThreadAndFrame.computeIfAbsent((Pair<TraceThread, Integer>)Pair.of((Object)thread, (Object)frame), p -> this.newDataForLocalState((TraceThread)p.getLeft(), (Integer)p.getRight()));
        }
    }

    public L getDataForLocalState(PcodeThread<?> thread, int frame) {
        return this.getDataForLocalState(this.getTraceThread(thread), frame);
    }
}

