/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.cart;

import docking.widgets.OptionDialog;
import ghidra.util.Msg;
import ghidra.util.StringUtilities;
import ghidra.util.SystemUtilities;

public class CartCancelDialogs {
    public static final int WRAP_WIDTH_CHARACTERS = 80;

    private static final String wrapHtml(String message) {
        String wrapped = StringUtilities.wrapToWidth((String)message, (int)80);
        return "<html>" + wrapped.replace("\n", "<br>") + "</html>";
    }

    public static final boolean promptContinue(String title, String message, int messageType) {
        if (SystemUtilities.isInHeadlessMode()) {
            message = title + " : " + (String)message;
            switch (messageType) {
                case 2: {
                    Msg.warn(CartCancelDialogs.class, (Object)message);
                    break;
                }
                case 0: {
                    Msg.error(CartCancelDialogs.class, (Object)message);
                    break;
                }
                default: {
                    Msg.info(CartCancelDialogs.class, (Object)message);
                }
            }
            Msg.info(CartCancelDialogs.class, (Object)"User can't respond to message, treating as cancellation.");
            return false;
        }
        return OptionDialog.showOptionDialogWithCancelAsDefaultButton(null, (String)title, (String)CartCancelDialogs.wrapHtml((String)message), (String)"Continue", (int)messageType) == 1;
    }

    public static final boolean promptWarningContinue(String title, String message) {
        return CartCancelDialogs.promptContinue(title, message, 2);
    }

    public static final boolean promptErrorContinue(String title, String message) {
        return CartCancelDialogs.promptContinue(title, message, 0);
    }
}

