/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AddressMsSymbol;

public abstract class AbstractWithMsSymbol
extends AbstractMsSymbol
implements AddressMsSymbol {
    protected long parentPointer;
    protected long endPointer;
    protected long length;
    protected long offset;
    protected int segment;
    protected String expression;

    public AbstractWithMsSymbol(AbstractPdb pdb, PdbByteReader reader, int offsetSize, StringParseType strType) throws PdbException {
        super(pdb, reader);
        this.parentPointer = reader.parseUnsignedIntVal();
        this.endPointer = reader.parseUnsignedIntVal();
        this.length = reader.parseVarSizedOffset(offsetSize);
        this.offset = reader.parseVarSizedOffset(offsetSize);
        this.segment = pdb.parseSegment(reader);
        this.expression = reader.parseString(pdb, strType);
        reader.align4();
    }

    public long getParentPointer() {
        return this.parentPointer;
    }

    public long getEndPointer() {
        return this.endPointer;
    }

    public long getLength() {
        return this.length;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public int getSegment() {
        return this.segment;
    }

    public String getExpression() {
        return this.expression;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(this.getSymbolTypeName());
        builder.append(String.format(": [%04X:%08X], Length: %08X, %s\n", this.segment, this.offset, this.length, this.expression));
        builder.append(String.format("   Parent: %08X, End: %08X\n", this.parentPointer, this.endPointer));
    }
}

