/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.map;

import ghidra.util.LongIterator;
import ghidra.util.datastruct.NoSuchIndexException;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.NoValueException;
import ghidra.util.map.LongIteratorImpl;
import ghidra.util.map.ValueStoragePage;
import ghidra.util.map.ValueStoragePageIndex;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public abstract class ValueMap<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final NoValueException noValueException = new NoValueException();
    private static final int DEFAULT_NUMBER_PAGE_BITS = 12;
    private static final int MIN_NUMBER_PAGE_BITS = 8;
    private static final int MAX_NUMBER_PAGE_BITS = 15;
    private String name;
    protected ValueStoragePageIndex propertyPageIndex;
    private int numPageBits;
    private long pageMask;
    protected short pageSize;
    protected int numProperties;
    private Map<Long, ValueStoragePage<T>> ht;
    private Class<T> objectClass;

    protected ValueMap(String name, Class<T> objectClass) {
        this(name, 12, objectClass);
    }

    protected ValueMap(String name, int numPageBits, Class<T> objectClass) {
        this.objectClass = objectClass;
        this.ht = new HashMap<Long, ValueStoragePage<T>>();
        this.name = name;
        if (numPageBits > 15) {
            numPageBits = 15;
        } else if (numPageBits < 8) {
            numPageBits = 8;
        }
        this.numPageBits = numPageBits;
        this.pageMask = -1L;
        this.pageMask >>>= 64 - numPageBits;
        this.pageSize = (short)(this.pageMask + 1L);
        this.propertyPageIndex = new ValueStoragePageIndex();
    }

    public abstract int getDataSize();

    public synchronized String getName() {
        return this.name;
    }

    public Class<T> getObjectClass() {
        return this.objectClass;
    }

    protected ValueStoragePage<T> getPage(long pageId) {
        return this.ht.get(pageId);
    }

    protected ValueStoragePage<T> getOrCreatePage(long pageID) {
        ValueStoragePage<T> page = this.getPage(pageID);
        if (page == null) {
            page = new ValueStoragePage<T>(this.pageSize, pageID, this.getDataSize(), this.objectClass);
            this.ht.put(pageID, page);
            this.propertyPageIndex.add(pageID);
        }
        return page;
    }

    public boolean intersects(long start, long end) {
        if (this.hasProperty(start)) {
            return true;
        }
        try {
            long index = this.getNextPropertyIndex(start);
            if (index <= end) {
                return true;
            }
        }
        catch (NoSuchIndexException e) {
            return false;
        }
        return false;
    }

    public synchronized boolean removeRange(long start, long end) {
        boolean status = false;
        while (start <= end) {
            short offset;
            long nextPageId;
            long pageID = this.getPageID(start);
            ValueStoragePage<T> page = this.getPage(pageID);
            if (page == null) {
                nextPageId = this.propertyPageIndex.getNext(pageID);
                if (nextPageId < 0L) break;
                start = nextPageId << this.numPageBits;
                continue;
            }
            if (offset == 0 && (long)this.pageSize + start <= end) {
                this.numProperties -= page.getSize();
                this.ht.remove(pageID);
                this.propertyPageIndex.remove(pageID);
                status = true;
                nextPageId = this.propertyPageIndex.getNext(pageID);
                start = nextPageId << this.numPageBits;
                continue;
            }
            for (offset = this.getPageOffset(start); offset < this.pageSize && start <= end; offset = (short)(offset + 1), ++start) {
                status |= this.removeFromPage(page, pageID, offset);
            }
        }
        return status;
    }

    public synchronized boolean remove(long index) {
        long pageID = this.getPageID(index);
        short offset = this.getPageOffset(index);
        ValueStoragePage<T> page = this.getPage(pageID);
        return this.removeFromPage(page, pageID, offset);
    }

    private boolean removeFromPage(ValueStoragePage<T> page, long pageID, short offset) {
        if (page != null) {
            boolean removed = page.remove(offset);
            if (removed) {
                --this.numProperties;
            }
            if (page.isEmpty()) {
                this.ht.remove(pageID);
                this.propertyPageIndex.remove(pageID);
            }
            return removed;
        }
        return false;
    }

    public synchronized boolean hasProperty(long index) {
        ValueStoragePage<T> page = this.getPage(this.getPageID(index));
        if (page == null) {
            return false;
        }
        return page.hasProperty(this.getPageOffset(index));
    }

    public synchronized long getNextPropertyIndex(long index) throws NoSuchIndexException {
        short nextOffset;
        long pageID = this.getPageID(index);
        short offset = this.getPageOffset(index);
        ValueStoragePage<T> page = this.getPage(pageID);
        if (page != null && (nextOffset = page.getNext(offset)) >= 0) {
            return this.getIndex(pageID, nextOffset);
        }
        if ((pageID = this.propertyPageIndex.getNext(pageID)) >= 0L && (page = this.getPage(pageID)) != null) {
            nextOffset = page.getFirst();
            if (nextOffset < 0) {
                throw new AssertException("Page (" + pageID + ") exists but there is no 'first' offset");
            }
            return this.getIndex(pageID, nextOffset);
        }
        throw NoSuchIndexException.noSuchIndexException;
    }

    public synchronized long getPreviousPropertyIndex(long index) throws NoSuchIndexException {
        short prevOffset;
        long pageID = this.getPageID(index);
        short offset = this.getPageOffset(index);
        ValueStoragePage<T> page = this.getPage(pageID);
        if (page != null && (prevOffset = page.getPrevious(offset)) >= 0) {
            return this.getIndex(pageID, prevOffset);
        }
        if ((pageID = this.propertyPageIndex.getPrevious(pageID)) >= 0L && (page = this.getPage(pageID)) != null) {
            prevOffset = page.getLast();
            if (prevOffset < 0) {
                throw new AssertException("Page (" + pageID + ") exists but there is no 'last' offset");
            }
            return this.getIndex(pageID, prevOffset);
        }
        throw NoSuchIndexException.noSuchIndexException;
    }

    public synchronized long getFirstPropertyIndex() throws NoSuchIndexException {
        if (this.hasProperty(0L)) {
            return 0L;
        }
        return this.getNextPropertyIndex(0L);
    }

    public synchronized long getLastPropertyIndex() throws NoSuchIndexException {
        if (this.hasProperty(-1L)) {
            return -1L;
        }
        return this.getPreviousPropertyIndex(-1L);
    }

    public int getSize() {
        return this.numProperties;
    }

    protected final long getPageID(long index) {
        return index >>> this.numPageBits;
    }

    protected final short getPageOffset(long index) {
        return (short)(index & this.pageMask);
    }

    protected final long getIndex(long pageID, short offset) {
        return pageID << this.numPageBits | (long)offset;
    }

    public void moveRange(long start, long end, long newStart) {
        if (newStart < start) {
            long offset = start - newStart;
            long clearSize = end - start + 1L;
            if (offset < clearSize) {
                clearSize = offset;
            }
            this.removeRange(newStart, newStart + clearSize - 1L);
            LongIterator it = this.getPropertyIterator(start, end);
            while (it.hasNext()) {
                long index = it.next();
                this.moveIndex(index, index - offset);
            }
        } else {
            long index;
            long offset = newStart - start;
            long clearSize = end - start + 1L;
            if (offset < clearSize) {
                clearSize = offset;
            }
            if (newStart > end) {
                this.removeRange(newStart, newStart + clearSize - 1L);
            } else {
                this.removeRange(end + 1L, end + clearSize);
            }
            LongIterator it = this.getPropertyIterator(end + 1L);
            while (it.hasPrevious() && (index = it.previous()) >= start) {
                this.moveIndex(index, index + offset);
            }
        }
    }

    protected abstract void moveIndex(long var1, long var3);

    protected abstract void saveProperty(ObjectOutputStream var1, long var2) throws IOException;

    protected abstract void restoreProperty(ObjectInputStream var1, long var2) throws IOException, ClassNotFoundException;

    public LongIterator getPropertyIterator(long start, long end) {
        return new LongIteratorImpl(this, start, end);
    }

    public LongIterator getPropertyIterator(long start, long end, boolean atStart) {
        return new LongIteratorImpl(this, start, end, atStart);
    }

    public LongIterator getPropertyIterator() {
        return new LongIteratorImpl(this);
    }

    public LongIterator getPropertyIterator(long start) {
        return new LongIteratorImpl(this, start, true);
    }

    public LongIterator getPropertyIterator(long start, boolean before) {
        return new LongIteratorImpl(this, start, before);
    }

    public void saveProperties(ObjectOutputStream oos, long start, long end) throws IOException {
        oos.writeLong(start);
        oos.writeLong(end);
        if (this.hasProperty(start)) {
            oos.writeByte(1);
            oos.writeLong(start);
            this.saveProperty(oos, start);
        }
        try {
            long index = start;
            while ((index = this.getNextPropertyIndex(index)) <= end) {
                oos.writeByte(1);
                oos.writeLong(index);
                this.saveProperty(oos, index);
            }
        }
        catch (NoSuchIndexException noSuchIndexException) {
            // empty catch block
        }
        oos.writeByte(0);
    }

    public void restoreProperties(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        long start = ois.readLong();
        long end = ois.readLong();
        this.removeRange(start, end);
        while (ois.readByte() != 0) {
            long index = ois.readLong();
            this.restoreProperty(ois, index);
        }
    }
}

