/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.correlator.address;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.util.AddressCorrelation;
import ghidra.program.util.AddressCorrelationRange;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.HashMap;
import java.util.Map;

public class StraightLineCorrelation
implements AddressCorrelation {
    public static final String NAME = "StraightLineCorrelation";
    private Map<Address, AddressRange> cachedForwardAddressMap;
    private final Function sourceFunction;
    private final Function destinationFunction;

    public StraightLineCorrelation(Function sourceFunction, Function destinationFunction) {
        this.sourceFunction = sourceFunction;
        this.destinationFunction = destinationFunction;
    }

    public String getName() {
        return NAME;
    }

    public AddressCorrelationRange getCorrelatedDestinationRange(Address sourceAddress, TaskMonitor monitor) throws CancelledException {
        this.initialize(monitor);
        AddressRange range = this.cachedForwardAddressMap.get(sourceAddress);
        if (range == null) {
            return null;
        }
        return new AddressCorrelationRange(range, this.getName());
    }

    private void initialize(TaskMonitor monitor) throws CancelledException {
        AddressSetView destinationAddressSet;
        if (this.cachedForwardAddressMap != null) {
            return;
        }
        this.cachedForwardAddressMap = new HashMap<Address, AddressRange>();
        AddressSetView sourceAddressSet = this.sourceFunction != null ? this.sourceFunction.getBody() : null;
        AddressSetView addressSetView = destinationAddressSet = this.destinationFunction != null ? this.destinationFunction.getBody() : null;
        if (sourceAddressSet == null || destinationAddressSet == null) {
            return;
        }
        CodeUnitIterator srcIter = this.sourceFunction.getProgram().getListing().getCodeUnits(sourceAddressSet, true);
        CodeUnitIterator destIter = this.destinationFunction.getProgram().getListing().getCodeUnits(destinationAddressSet, true);
        monitor.setMessage("Defining address ranges...");
        monitor.initialize(sourceAddressSet.getNumAddresses());
        while (srcIter.hasNext() && destIter.hasNext()) {
            String destMnemonic;
            CodeUnit srcCodeUnit = srcIter.next();
            CodeUnit destCodeUnit = destIter.next();
            String srcMnemonic = srcCodeUnit.getMnemonicString();
            if (!srcMnemonic.equals(destMnemonic = destCodeUnit.getMnemonicString())) break;
            monitor.checkCancelled();
            monitor.incrementProgress((long)srcCodeUnit.getLength());
            StraightLineCorrelation.defineRange(this.cachedForwardAddressMap, srcCodeUnit, destCodeUnit);
        }
        this.computeParamCorrelation();
    }

    private void computeParamCorrelation() {
        Parameter[] destinationParameters;
        Parameter[] sourceParameters = this.sourceFunction.getParameters();
        if (sourceParameters.length != (destinationParameters = this.destinationFunction.getParameters()).length) {
            return;
        }
        HashMap<Address, AddressRangeImpl> map = new HashMap<Address, AddressRangeImpl>();
        for (int i = 0; i < sourceParameters.length; ++i) {
            VariableStorage destParamStorage;
            Parameter sourceParameter = sourceParameters[i];
            Parameter destinationParameter = destinationParameters[i];
            if (!sourceParameter.isValid() || !destinationParameter.isValid()) {
                return;
            }
            VariableStorage sourceParamStorage = sourceParameter.getVariableStorage();
            if (!sourceParamStorage.equals((Object)(destParamStorage = destinationParameter.getVariableStorage()))) {
                return;
            }
            Address dest = sourceParamStorage.getMinAddress();
            Address src = destParamStorage.getMinAddress();
            map.put(src, new AddressRangeImpl(dest, dest));
        }
        this.cachedForwardAddressMap.putAll(map);
    }

    private static void defineRange(Map<Address, AddressRange> map, CodeUnit sourceCodeUnit, CodeUnit destinationCodeUnit) {
        Address minAddress = sourceCodeUnit.getMinAddress();
        Address maxAddress = sourceCodeUnit.getMaxAddress();
        AddressRangeImpl toRange = new AddressRangeImpl(destinationCodeUnit.getMinAddress(), destinationCodeUnit.getMaxAddress());
        while (!minAddress.equals((Object)maxAddress)) {
            map.put(minAddress, (AddressRange)toRange);
            minAddress = minAddress.next();
        }
        map.put(maxAddress, (AddressRange)toRange);
    }
}

