/*
 * Decompiled with CFR 0.152.
 */
package ghidra.server;

import ghidra.server.CommandProcessor;
import ghidra.server.RepositoryManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;

public class CommandWatcher
implements Runnable {
    private RepositoryManager repositoryMgr;
    private Path cmdDirPath;
    private WatchService watcher;

    CommandWatcher(RepositoryManager repositoryMgr) throws IOException {
        this.repositoryMgr = repositoryMgr;
        this.watcher = FileSystems.getDefault().newWatchService();
        this.cmdDirPath = CommandProcessor.getOrCreateCommandDir(repositoryMgr).toPath();
        this.cmdDirPath.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE);
    }

    void dispose() {
        try {
            this.watcher.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        WatchKey key;
        boolean valid;
        RepositoryManager.log.info("Command watcher started");
        do {
            try {
                key = this.watcher.take();
            }
            catch (InterruptedException | ClosedWatchServiceException e) {
                break;
            }
            boolean processCommands = false;
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW) {
                    processCommands = true;
                    continue;
                }
                WatchEvent<?> ev = event;
                Path filename = (Path)ev.context();
                Path child = this.cmdDirPath.resolve(filename);
                File file = child.toFile();
                if (!CommandProcessor.CMD_FILE_FILTER.accept(child.toFile()) || !file.exists()) continue;
                processCommands = true;
            }
            if (!processCommands) continue;
            try {
                this.repositoryMgr.processCommandQueue();
            }
            catch (Exception e) {
                RepositoryManager.log.error("Command processing failure: " + e.toString(), (Throwable)e);
            }
        } while (valid = key.reset());
        RepositoryManager.log.info("Command watcher terminated.");
    }
}

