/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.plugin.core.analysis.AbstractDemanglerAnalyzer;
import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.DemangledObject;
import ghidra.app.util.demangler.DemanglerOptions;
import ghidra.app.util.demangler.MangledContext;
import ghidra.app.util.demangler.microsoft.MicrosoftDemangler;
import ghidra.app.util.demangler.microsoft.MicrosoftDemanglerOptions;
import ghidra.app.util.demangler.microsoft.MsCInterpretation;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.options.Options;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;

public class MicrosoftDemanglerAnalyzer
extends AbstractDemanglerAnalyzer {
    public static final String NAME = "Demangler Microsoft";
    private static final String DESCRIPTION = "After a function is created, this analyzer will attempt to demangle the name and apply datatypes to parameters.";
    public static final String OPTION_NAME_APPLY_SIGNATURE = "Apply Function Signatures";
    private static final String OPTION_DESCRIPTION_APPLY_SIGNATURE = "Apply any recovered function signature, in addition to the function name";
    public static final String OPTION_NAME_APPLY_CALLING_CONVENTION = "Apply Function Calling Conventions";
    private static final String OPTION_DESCRIPTION_APPLY_CALLING_CONVENTION = "Apply any recovered function signature calling convention";
    private static final String OPTION_NAME_DEMANGLE_USE_KNOWN_PATTERNS = "Demangle Only Known Mangled Symbols";
    private static final String OPTION_DESCRIPTION_USE_KNOWN_PATTERNS = "Only demangle symbols that follow known compiler mangling patterns. Leaving this option off may cause non-mangled symbols to get demangled.";
    public static final String OPTION_NAME_MS_C_INTERPRETATION = "C-Style Symbol Interpretation";
    private static final String OPTION_DESCRIPTION_MS_C_INTERPRETATION = "When ambiguous, treat C-Style mangled symbol as: function, variable, or function if a function exists";
    private boolean applyFunctionSignature = true;
    private boolean applyCallingConvention = true;
    private boolean demangleOnlyKnownPatterns = false;
    private MsCInterpretation interpretation = MsCInterpretation.FUNCTION_IF_EXISTS;

    public MicrosoftDemanglerAnalyzer() {
        super(NAME, DESCRIPTION);
        this.demangler = new MicrosoftDemangler();
        this.setDefaultEnablement(true);
    }

    public boolean canAnalyze(Program program) {
        return this.demangler.canDemangle(program);
    }

    public void registerOptions(Options options, Program program) {
        HelpLocation help = new HelpLocation("AutoAnalysisPlugin", "Demangler_Analyzer");
        options.registerOption(OPTION_NAME_APPLY_SIGNATURE, (Object)this.applyFunctionSignature, help, OPTION_DESCRIPTION_APPLY_SIGNATURE);
        options.registerOption(OPTION_NAME_APPLY_CALLING_CONVENTION, (Object)this.applyCallingConvention, help, OPTION_DESCRIPTION_APPLY_CALLING_CONVENTION);
        options.registerOption(OPTION_NAME_DEMANGLE_USE_KNOWN_PATTERNS, (Object)this.demangleOnlyKnownPatterns, help, OPTION_DESCRIPTION_USE_KNOWN_PATTERNS);
        options.registerOption(OPTION_NAME_MS_C_INTERPRETATION, (Object)this.interpretation, help, OPTION_DESCRIPTION_MS_C_INTERPRETATION);
    }

    public void optionsChanged(Options options, Program program) {
        this.applyFunctionSignature = options.getBoolean(OPTION_NAME_APPLY_SIGNATURE, this.applyFunctionSignature);
        this.applyCallingConvention = options.getBoolean(OPTION_NAME_APPLY_CALLING_CONVENTION, this.applyCallingConvention);
        this.demangleOnlyKnownPatterns = options.getBoolean(OPTION_NAME_DEMANGLE_USE_KNOWN_PATTERNS, this.demangleOnlyKnownPatterns);
        this.interpretation = (MsCInterpretation)options.getEnum(OPTION_NAME_MS_C_INTERPRETATION, (Enum)this.interpretation);
    }

    protected DemanglerOptions getOptions() {
        MicrosoftDemanglerOptions options = new MicrosoftDemanglerOptions();
        options.setApplySignature(this.applyFunctionSignature);
        options.setApplyCallingConvention(this.applyCallingConvention);
        options.setDemangleOnlyKnownPatterns(this.demangleOnlyKnownPatterns);
        options.setInterpretation(this.interpretation);
        options.setErrorOnRemainingChars(true);
        return options;
    }

    protected DemangledObject doDemangle(MangledContext context, MessageLog log) throws DemangledException {
        DemangledObject demangled = this.demangler.demangle(context);
        return demangled;
    }
}

