/*
 * Decompiled with CFR 0.152.
 */
package ghidra.base.graph;

import docking.widgets.EmptyBorderButton;
import docking.widgets.label.GDLabel;
import generic.theme.GColor;
import generic.theme.GThemeDefaults;
import ghidra.base.graph.VertexExpansionListener;
import ghidra.graph.viewer.vertex.VertexShapeProvider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import resources.Icons;
import resources.ResourceManager;

public class CircleWithLabelVertexShapeProvider
implements VertexShapeProvider {
    public static final Color DEFAULT_VERTEX_SHAPE_COLOR = new GColor("color.bg.graph.vertex.function");
    protected static final Icon EXPAND_ICON = ResourceManager.getScaledIcon((Icon)Icons.EXPAND_ALL_ICON, (int)10, (int)10);
    protected static final Icon COLLAPSE_ICON = ResourceManager.getScaledIcon((Icon)Icons.COLLAPSE_ALL_ICON, (int)10, (int)10);
    protected static final Integer VERTEX_SHAPE_LAYER = 100;
    protected static final Integer TOGGLE_BUTTON_LAYER = 200;
    protected static final Integer LABEL_LAYER = 300;
    protected static final int GAP = 2;
    protected static final int VERTEX_SHAPE_SIZE = 50;
    protected static final int MAX_NAME_LENGTH = 30;
    protected JLayeredPane layeredPane;
    protected JButton toggleInsButton = new EmptyBorderButton(EXPAND_ICON);
    protected JButton toggleOutsButton = new EmptyBorderButton(EXPAND_ICON);
    protected JLabel nameLabel = new GDLabel();
    protected JLabel vertexImageLabel = new GDLabel();
    protected Ellipse2D.Double vertexShape;
    protected Ellipse2D.Double compactShape;
    protected Shape fullShape;
    protected boolean incomingExpanded;
    protected boolean outgoingExpanded;
    protected boolean useDebugBorders = false;
    private String fullLabelText;
    private int circleCenterYOffset;

    public CircleWithLabelVertexShapeProvider(String label) {
        this.fullLabelText = label;
        this.buildUi();
    }

    public CircleWithLabelVertexShapeProvider(String label, VertexExpansionListener expansionListener) {
        this.fullLabelText = label;
        this.buildUi();
    }

    public int getCircleCenterYOffset() {
        return this.circleCenterYOffset;
    }

    protected void buildUi() {
        String name = this.generateLabelText();
        this.nameLabel.setText(name);
        this.buildVertexShape();
        this.layeredPane = new JLayeredPane();
        Border border = this.createDebugBorder(new LineBorder((Color)GThemeDefaults.Colors.Palette.GOLD, 1));
        this.layeredPane.setBorder(border);
        this.updateLayeredPaneSize();
        this.addVertexShape();
        this.addToggleButtons();
        this.addNameLabel();
        this.buildFullShape();
    }

    protected String generateLabelText() {
        return this.fullLabelText;
    }

    private Border createDebugBorder(Border border) {
        if (this.useDebugBorders) {
            return border;
        }
        return BorderFactory.createEmptyBorder();
    }

    private void buildFullShape() {
        Area parent = new Area();
        Area v = new Area(this.vertexShape);
        Area name = new Area(this.nameLabel.getBounds());
        parent.add(v);
        parent.add(name);
        Area in = new Area(this.toggleInsButton.getBounds());
        Area out = new Area(this.toggleOutsButton.getBounds());
        parent.add(in);
        parent.add(out);
        this.fullShape = parent;
    }

    private void updateLayeredPaneSize() {
        Dimension shapeSize = this.vertexImageLabel.getPreferredSize();
        Dimension nameLabelSize = this.nameLabel.getPreferredSize();
        int height = shapeSize.height + 2 + nameLabelSize.height;
        Dimension insSize = this.toggleInsButton.getPreferredSize();
        Dimension outsSize = this.toggleOutsButton.getPreferredSize();
        int buttonWidth = Math.max(insSize.width, outsSize.width);
        int offset = buttonWidth / 3;
        int width = offset + shapeSize.width;
        width = Math.max(width, nameLabelSize.width);
        this.layeredPane.setPreferredSize(new Dimension(width, height));
    }

    private void buildVertexShape() {
        int w = 50;
        int h = 50;
        Ellipse2D.Double circle = new Ellipse2D.Double(0.0, 0.0, w, h);
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setPaint(this.getVertexShapePaint());
        g2.fill(circle);
        g2.dispose();
        this.vertexShape = circle;
        this.compactShape = (Ellipse2D.Double)this.vertexShape.clone();
        this.vertexImageLabel.setIcon(new ImageIcon(image));
        Border border = this.createDebugBorder(new LineBorder((Color)GThemeDefaults.Colors.Palette.PINK, 1));
        this.vertexImageLabel.setBorder(border);
    }

    protected Paint getVertexShapePaint() {
        return this.getDefaultVertexShapeColor();
    }

    protected Color getDefaultVertexShapeColor() {
        return DEFAULT_VERTEX_SHAPE_COLOR;
    }

    private void addVertexShape() {
        Dimension parentSize = this.layeredPane.getPreferredSize();
        Dimension size = this.vertexImageLabel.getPreferredSize();
        int x = parentSize.width / 2 - size.width / 2;
        int y = 0;
        this.vertexImageLabel.setBounds(x, y, size.width, size.height);
        Dimension shapeSize = this.vertexShape.getBounds().getSize();
        this.circleCenterYOffset = shapeSize.height / 2 - parentSize.height / 2;
        this.vertexShape.setFrame(x, y, shapeSize.width, shapeSize.height);
        this.layeredPane.add((Component)this.vertexImageLabel, VERTEX_SHAPE_LAYER);
    }

    private void addNameLabel() {
        Border border = this.createDebugBorder(new LineBorder((Color)GThemeDefaults.Colors.Palette.GREEN, 1));
        this.nameLabel.setBorder(border);
        Rectangle parentBounds = this.vertexImageLabel.getBounds();
        Dimension size = this.nameLabel.getPreferredSize();
        int x = parentBounds.x + parentBounds.width / 2 - size.width / 2;
        int y = parentBounds.y + parentBounds.height + 2;
        this.nameLabel.setBounds(x, y, size.width, size.height);
        this.layeredPane.add((Component)this.nameLabel, LABEL_LAYER);
    }

    private void addToggleButtons() {
        this.toggleInsButton.setBackground(GThemeDefaults.Colors.Palette.NO_COLOR);
        this.toggleOutsButton.setBackground(GThemeDefaults.Colors.Palette.NO_COLOR);
        this.toggleInsButton.setOpaque(false);
        this.toggleOutsButton.setOpaque(false);
        Rectangle parentBounds = this.vertexImageLabel.getBounds();
        Dimension size = this.toggleInsButton.getPreferredSize();
        int x = parentBounds.x - size.width / 3;
        int y = 0;
        this.toggleInsButton.setBounds(x, y, size.width, size.height);
        this.layeredPane.add((Component)this.toggleInsButton, TOGGLE_BUTTON_LAYER);
        size = this.toggleOutsButton.getPreferredSize();
        Dimension vertexSize = parentBounds.getSize();
        y = vertexSize.height - size.height;
        this.toggleOutsButton.setBounds(x, y, size.width, size.height);
        this.layeredPane.add((Component)this.toggleOutsButton, TOGGLE_BUTTON_LAYER);
    }

    public String getName() {
        return this.fullLabelText;
    }

    public JButton getIncomingToggleButton() {
        return this.toggleInsButton;
    }

    public JButton getOutgoingToggleButton() {
        return this.toggleOutsButton;
    }

    public void setIncomingExpanded(boolean setExpanded) {
        this.incomingExpanded = setExpanded;
        this.toggleInsButton.setIcon(setExpanded ? COLLAPSE_ICON : EXPAND_ICON);
        String hideShow = setExpanded ? "hide" : "show";
        this.toggleInsButton.setToolTipText("Click to " + hideShow + " incoming edges");
    }

    public boolean isIncomingExpanded() {
        return this.incomingExpanded;
    }

    public void setOutgoingExpanded(boolean setExpanded) {
        this.outgoingExpanded = setExpanded;
        this.toggleOutsButton.setIcon(setExpanded ? COLLAPSE_ICON : EXPAND_ICON);
        String hideShow = setExpanded ? "hide" : "show";
        this.toggleInsButton.setToolTipText("Click to " + hideShow + " outgoing edges");
    }

    public boolean isOutgoingExpanded() {
        return this.outgoingExpanded;
    }

    public boolean isExpanded() {
        return this.isIncomingExpanded() && this.isOutgoingExpanded();
    }

    public boolean canExpand() {
        return false;
    }

    protected boolean hasIncomingEdges() {
        return false;
    }

    protected boolean hasOutgoingEdges() {
        return false;
    }

    public void setTogglesVisible(boolean visible) {
        this.toggleInsButton.setVisible(visible);
        this.toggleOutsButton.setVisible(visible);
    }

    public JComponent getComponent() {
        return this.layeredPane;
    }

    public Shape getCompactShape() {
        return this.compactShape;
    }

    public Shape getFullShape() {
        return this.fullShape;
    }

    public String toString() {
        return this.getName();
    }
}

