/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.datatype;

import ghidra.app.services.DataTypeManagerService;
import ghidra.program.model.data.BuiltInDataTypeManager;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypePath;
import ghidra.util.UniversalID;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataTypeUrl {
    private static String PROTOCOL = "datatype";
    private static Pattern URL_PATTERN = Pattern.compile(PROTOCOL + ":/(\\d+)\\?uid=(\\d*)&name=(.+)");
    private UniversalID dataTypeManagerId;
    private UniversalID dataTypeId;
    private String dataTypeName;

    public DataTypeUrl(DataType dt) {
        DataTypeManager dtm = dt.getDataTypeManager();
        if (dtm == null) {
            dtm = BuiltInDataTypeManager.getDataTypeManager();
        }
        this.dataTypeManagerId = dtm.getUniversalID();
        this.dataTypeId = dt.getUniversalID();
        this.dataTypeName = Objects.requireNonNull(dt.getName());
    }

    public DataTypeUrl(String url) throws IllegalArgumentException {
        Matcher matcher = URL_PATTERN.matcher(url);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid data type URL '" + url + "'");
        }
        String dtmId = matcher.group(1);
        String dtId = matcher.group(2);
        this.dataTypeName = matcher.group(3);
        this.dataTypeManagerId = new UniversalID(Long.parseLong(dtmId));
        if (!dtId.isBlank()) {
            this.dataTypeId = new UniversalID(Long.parseLong(dtId));
        }
    }

    public UniversalID getDataTypeManagerId() {
        return this.dataTypeManagerId;
    }

    public UniversalID getDataTypeId() {
        return this.dataTypeId;
    }

    public String getDataTypeName() {
        return this.dataTypeName;
    }

    public DataType getDataType(DataTypeManagerService service) {
        DataTypeManager manager = this.findManager(service);
        if (manager == null) {
            return null;
        }
        if (this.dataTypeId == null) {
            return manager.getDataType(new DataTypePath(CategoryPath.ROOT, this.dataTypeName));
        }
        DataType dt = manager.findDataTypeForID(this.dataTypeId);
        return dt;
    }

    private DataTypeManager findManager(DataTypeManagerService service) {
        return this.getManagerById(service);
    }

    private DataTypeManager getManagerById(DataTypeManagerService service) {
        DataTypeManager[] mgs;
        for (DataTypeManager dtm : mgs = service.getDataTypeManagers()) {
            if (!dtm.getUniversalID().equals((Object)this.dataTypeManagerId)) continue;
            return dtm;
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dataTypeId == null ? 0 : this.dataTypeId.hashCode());
        result = 31 * result + (this.dataTypeManagerId == null ? 0 : this.dataTypeManagerId.hashCode());
        result = 31 * result + (this.dataTypeName == null ? 0 : this.dataTypeName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataTypeUrl other = (DataTypeUrl)obj;
        if (!Objects.equals(this.dataTypeId, other.dataTypeId)) {
            return false;
        }
        if (!Objects.equals(this.dataTypeManagerId, other.dataTypeManagerId)) {
            return false;
        }
        return Objects.equals(this.dataTypeName, other.dataTypeName);
    }

    public String toString() {
        return PROTOCOL + ":/" + this.dataTypeManagerId.toString() + "?uid=" + Objects.toString(this.dataTypeId, "") + "&name=" + this.dataTypeName;
    }
}

