/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc2;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.dyld.LibObjcOptimization;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_Constants;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_Implementation;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_State;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Utilities;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC_Method;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC_MethodType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.PointerType;
import ghidra.program.model.data.PointerTypedef;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ObjectiveC2_Method
extends ObjectiveC_Method {
    private String name;
    private String types;
    private ObjectiveC2_Implementation imp;
    private LibObjcOptimization libObjcOptimization;
    private boolean isSmall;

    public ObjectiveC2_Method(ObjectiveC2_State state, BinaryReader reader, ObjectiveC_MethodType methodType, boolean isSmallList) throws IOException {
        super(state, reader, methodType);
        this.libObjcOptimization = state.libObjcOptimization;
        this.isSmall = isSmallList;
        if (isSmallList) {
            int nameOffset = (int)ObjectiveC1_Utilities.readNextIndex(reader, true);
            long namePtr = state.is32bit ? (long)reader.readInt(this._index + (long)nameOffset) : (this.libObjcOptimization != null ? (this.libObjcOptimization.getRelativeSelectorBaseAddressOffset() > 0L ? this.libObjcOptimization.getAddr() + this.libObjcOptimization.getRelativeSelectorBaseAddressOffset() + (long)nameOffset : this._index + (long)nameOffset) : reader.readLong(this._index + (long)nameOffset));
            this.name = reader.readAsciiString(namePtr);
            int typesOffset = (int)ObjectiveC1_Utilities.readNextIndex(reader, true);
            this.types = reader.readAsciiString(this._index + 4L + (long)typesOffset);
        } else {
            long nameIndex = ObjectiveC1_Utilities.readNextIndex(reader, state.is32bit);
            this.name = reader.readAsciiString(nameIndex);
            long typesIndex = ObjectiveC1_Utilities.readNextIndex(reader, state.is32bit);
            this.types = reader.readAsciiString(typesIndex);
        }
        this.imp = new ObjectiveC2_Implementation(state, reader, isSmallList);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTypes() {
        return this.types;
    }

    @Override
    public long getImplementation() {
        return this.imp.getImplementation();
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("method" + (this.isSmall ? "_small" : "") + "_t", 0);
        if (this.isSmall) {
            String comment = "RelativePointer";
            PointerType REL = PointerType.RELATIVE;
            if (this.libObjcOptimization != null) {
                if (this.libObjcOptimization.getRelativeSelectorBaseAddressOffset() > 0L) {
                    struct.add(DWORD, "name", comment + " + " + Long.toHexString(this.libObjcOptimization.getAddr() + this.libObjcOptimization.getRelativeSelectorBaseAddressOffset()));
                } else {
                    struct.add((DataType)new PointerTypedef(null, (DataType)new PointerDataType(STRING), 4, null, PointerType.RELATIVE), "name", comment);
                }
            } else {
                struct.add((DataType)new PointerTypedef(null, (DataType)new PointerDataType(STRING), 4, null, REL), "name", comment);
            }
            struct.add((DataType)new PointerTypedef(null, STRING, 4, null, REL), "types", comment);
            struct.add((DataType)new PointerTypedef(null, VOID, 4, null, REL), "imp", comment);
        } else {
            struct.add((DataType)new PointerDataType(STRING), this._state.pointerSize, "name", null);
            struct.add((DataType)new PointerDataType(STRING), this._state.pointerSize, "types", null);
            struct.add((DataType)new PointerDataType(VOID), this._state.pointerSize, "imp", null);
        }
        struct.setCategoryPath(ObjectiveC2_Constants.CATEGORY_PATH);
        return struct;
    }
}

