/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.string;

import ghidra.app.plugin.core.string.FoundDefinedStringIterator;
import ghidra.app.plugin.core.string.FoundStringWithWordStatus;
import ghidra.app.plugin.core.string.NGramUtils;
import ghidra.app.plugin.core.string.StringAndScores;
import ghidra.app.plugin.core.string.StringTableOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.util.string.AbstractStringSearcher;
import ghidra.program.util.string.FoundString;
import ghidra.program.util.string.FoundStringCallback;
import ghidra.program.util.string.PascalStringSearcher;
import ghidra.program.util.string.StringSearcher;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import org.apache.commons.lang3.StringUtils;

public class CombinedStringSearcher {
    private FoundDefinedStringIterator definedStringIterator;
    private FoundString nextDefinedString;
    private Program program;
    private StringTableOptions options;
    private Accumulator<FoundString> accumulator;

    public CombinedStringSearcher(Program program, StringTableOptions options, Accumulator<FoundString> accumulator) {
        this.program = program;
        this.options = options;
        this.accumulator = accumulator;
        this.definedStringIterator = new FoundDefinedStringIterator(program, options.getWordModelInitialized());
    }

    private FoundString findNextDefinedString() {
        if (this.definedStringIterator.hasNext()) {
            return this.definedStringIterator.next();
        }
        return null;
    }

    private void add(FoundString string) {
        if (this.passesLengthFilter(string)) {
            this.accumulator.add((Object)string);
        }
    }

    private boolean passesLengthFilter(FoundString foundString) {
        String string = StringUtils.defaultString((String)foundString.getString(this.program.getMemory()));
        return string.length() >= this.options.getMinStringSize();
    }

    public void search(TaskMonitor monitor) throws CancelledException {
        AbstractStringSearcher searcher = this.createSearcher();
        AddressSetView updatedAddressSet = this.options.getAddressSet();
        this.updateNextString();
        if (this.options.includeUndefinedStrings() || this.options.includePartiallyDefinedStrings() || this.options.includeConflictingStrings()) {
            updatedAddressSet = searcher.search(this.options.getAddressSet(), new AccumulatorAdapter(), this.options.useLoadedBlocksOnly(), monitor);
        }
        if (!this.options.includeDefinedStrings()) {
            return;
        }
        monitor.setIndeterminate(true);
        while (this.nextDefinedString != null) {
            monitor.checkCancelled();
            if (!this.inRange(updatedAddressSet, this.nextDefinedString)) {
                this.updateNextString();
                continue;
            }
            if (!this.onlyShowWordStrings() || ((FoundStringWithWordStatus)this.nextDefinedString).isHighConfidenceWord()) {
                this.add(this.nextDefinedString);
            }
            this.updateNextString();
        }
    }

    private void updateNextString() {
        this.nextDefinedString = this.findNextDefinedString();
    }

    private AbstractStringSearcher createSearcher() {
        if (this.options.isPascalRequired()) {
            return new PascalStringSearcher(this.program, this.options.getMinStringSize(), this.options.getAlignment(), false);
        }
        return new StringSearcher(this.program, this.options.getMinStringSize(), this.options.getAlignment(), this.options.getIncludeAllCharSizes(), this.options.isNullTerminationRequired());
    }

    private boolean inRange(AddressSetView addrSet, FoundString string) {
        if (addrSet == null) {
            return true;
        }
        return addrSet.contains(this.nextDefinedString.getAddress());
    }

    private int compareRange(FoundString string1, FoundString string2) {
        Address start2;
        if (string1 == null) {
            return 1;
        }
        if (string2 == null) {
            return -1;
        }
        Address end1 = string1.getEndAddress();
        if (end1.compareTo((Object)(start2 = string2.getAddress())) < 0) {
            return -1;
        }
        Address start1 = string1.getAddress();
        Address end2 = string2.getEndAddress();
        if (end2.compareTo((Object)start1) < 0) {
            return 1;
        }
        return 0;
    }

    public boolean shouldAddDefinedString(FoundString string) {
        if (!this.options.includeDefinedStrings()) {
            return false;
        }
        AddressSetView addrSet = this.options.getAddressSet();
        return addrSet == null || addrSet.contains(string.getAddress());
    }

    public boolean onlyShowWordStrings() {
        return this.options.onlyShowWordStrings() ? this.options.getWordModelInitialized() : false;
    }

    private void setIsWordStatus(FoundStringWithWordStatus foundString) {
        StringAndScores candidateString = new StringAndScores(foundString.getString(this.program.getMemory()), NGramUtils.isLowerCaseModel());
        if (candidateString.getScoredStringLength() >= NGramUtils.getMinimumStringLength()) {
            NGramUtils.scoreString(candidateString);
            foundString.setIsHighConfidenceWord(candidateString.isScoreAboveThreshold());
        }
    }

    private class AccumulatorAdapter
    implements FoundStringCallback {
        private AccumulatorAdapter() {
        }

        @Override
        public void stringFound(FoundString foundString) {
            this.gatherStringsUpTo(foundString);
            int result = CombinedStringSearcher.this.compareRange(foundString, CombinedStringSearcher.this.nextDefinedString);
            if (result == 0) {
                FoundString.DefinedState state = this.isFoundStringCovered(CombinedStringSearcher.this.nextDefinedString, foundString) ? FoundString.DefinedState.DEFINED : FoundString.DefinedState.PARTIALLY_DEFINED;
                foundString.setDefinedState(state);
                CombinedStringSearcher.this.updateNextString();
            } else {
                CodeUnit cu = CombinedStringSearcher.this.program.getListing().getCodeUnitAt(foundString.getAddress());
                if (!this.isUndefined(cu)) {
                    foundString.setDefinedState(FoundString.DefinedState.CONFLICTS);
                }
            }
            if (!this.shouldAddFoundString(foundString.getDefinedState())) {
                return;
            }
            FoundStringWithWordStatus wordString = new FoundStringWithWordStatus(foundString);
            CombinedStringSearcher.this.setIsWordStatus(wordString);
            if (wordString.isHighConfidenceWord()) {
                CombinedStringSearcher.this.add(wordString);
            } else if (!CombinedStringSearcher.this.onlyShowWordStrings()) {
                CombinedStringSearcher.this.add(wordString);
            }
        }

        private void gatherStringsUpTo(FoundString foundString) {
            int result = CombinedStringSearcher.this.compareRange(foundString, CombinedStringSearcher.this.nextDefinedString);
            while (result > 0) {
                if (CombinedStringSearcher.this.shouldAddDefinedString(CombinedStringSearcher.this.nextDefinedString) && (!CombinedStringSearcher.this.onlyShowWordStrings() || ((FoundStringWithWordStatus)CombinedStringSearcher.this.nextDefinedString).isHighConfidenceWord())) {
                    CombinedStringSearcher.this.add(CombinedStringSearcher.this.nextDefinedString);
                }
                CombinedStringSearcher.this.updateNextString();
                result = CombinedStringSearcher.this.compareRange(foundString, CombinedStringSearcher.this.nextDefinedString);
            }
        }

        private boolean shouldAddFoundString(FoundString.DefinedState definedState) {
            switch (definedState) {
                case DEFINED: {
                    return CombinedStringSearcher.this.options.includeDefinedStrings();
                }
                case NOT_DEFINED: {
                    return CombinedStringSearcher.this.options.includeUndefinedStrings();
                }
                case CONFLICTS: {
                    return CombinedStringSearcher.this.options.includeConflictingStrings();
                }
                case PARTIALLY_DEFINED: {
                    return CombinedStringSearcher.this.options.includePartiallyDefinedStrings();
                }
            }
            return true;
        }

        private boolean isUndefined(CodeUnit cu) {
            if (cu == null) {
                return false;
            }
            if (cu instanceof Instruction) {
                return false;
            }
            Data data = (Data)cu;
            return Undefined.isUndefined((DataType)data.getDataType());
        }

        private boolean isFoundStringCovered(FoundString definedString, FoundString newString) {
            if (!definedString.getAddress().equals((Object)newString.getAddress())) {
                return false;
            }
            if (definedString.getLength() == newString.getLength()) {
                return true;
            }
            String stringFromExisting = definedString.getString(CombinedStringSearcher.this.program.getMemory());
            String stringFromNew = newString.getString(CombinedStringSearcher.this.program.getMemory());
            return stringFromExisting != null && stringFromNew != null && stringFromExisting.length() == stringFromNew.length();
        }
    }
}

