/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.programtree;

import ghidra.app.plugin.core.programtree.ProgramDnDTree;
import ghidra.app.plugin.core.programtree.ProgramNode;
import ghidra.app.plugin.core.programtree.ProgramTreeActionManager;
import ghidra.app.plugin.core.programtree.ProgramTreePlugin;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.EventType;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.util.ProgramChangeRecord;
import ghidra.program.util.ProgramEvent;
import ghidra.util.Msg;
import ghidra.util.datastruct.StringKeyIndexer;
import ghidra.util.task.SwingUpdateManager;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreePath;
import util.CollectionUtils;

class ProgramListener
implements DomainObjectListener {
    private static int THRESHOLD_FOR_RELOAD = 10;
    private ProgramTreeActionManager actionManager;
    private ProgramTreePlugin plugin;
    private ProgramDnDTree tree;
    private SwingUpdateManager updateManager;

    ProgramListener(ProgramTreePlugin plugin) {
        this.plugin = plugin;
        this.actionManager = plugin.getActionManager();
        this.updateManager = new SwingUpdateManager(1000, 30000, () -> plugin.reloadProgram(false));
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        this.update(ev);
    }

    private void update(DomainObjectChangedEvent event) {
        if (this.willReloadProgram(event)) {
            return;
        }
        boolean viewChanged = false;
        for (int i = 0; i < event.numRecords(); ++i) {
            DomainObjectChangeRecord rec = event.getChangeRecord(i);
            if (!(rec instanceof ProgramChangeRecord)) continue;
            ProgramChangeRecord record = (ProgramChangeRecord)rec;
            EventType eventType = rec.getEventType();
            if (eventType == ProgramEvent.PROGRAM_TREE_RENAMED) {
                this.plugin.treeRenamed((String)record.getOldValue(), (String)record.getNewValue());
            } else if (eventType == ProgramEvent.GROUP_ADDED) {
                this.processGroupAdded(record);
            } else if (eventType == ProgramEvent.GROUP_REMOVED) {
                this.processGroupRemoved(record);
            } else if (eventType == ProgramEvent.GROUP_RENAMED) {
                this.processGroupRenamed(record);
            } else if (eventType == ProgramEvent.MODULE_REORDERED) {
                this.processModuleReordered(record);
            } else if (eventType == ProgramEvent.GROUP_REPARENTED) {
                this.processGroupReparented(record);
            } else if (eventType == ProgramEvent.FRAGMENT_MOVED) {
                this.plugin.fragmentMoved();
            } else if (eventType == ProgramEvent.MEMORY_BLOCKS_JOINED) {
                viewChanged |= this.processBlockJoined(record);
            }
            if (!viewChanged) continue;
            this.tree.fireTreeViewChanged();
        }
    }

    private boolean processBlockJoined(ProgramChangeRecord record) {
        ProgramNode root;
        this.tree = this.plugin.getCurrentProvider().getProgramDnDTree();
        List<TreePath> viewList = this.tree.getViewList();
        if (viewList.contains((root = (ProgramNode)this.tree.getModel().getRoot()).getTreePath())) {
            return true;
        }
        Address oldStartAddr = (Address)record.getOldValue();
        return this.plugin.getView().contains(oldStartAddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGroupReparented(ProgramChangeRecord record) {
        try {
            Group child = (Group)record.getObject();
            this.tree = this.plugin.getTree(child.getTreeName());
            if (this.tree == null) {
                return;
            }
            Object object = this.tree.getModel().getRoot();
            synchronized (object) {
                ProgramNode[] nodes;
                String oldParentName = (String)record.getOldValue();
                String newParentName = (String)record.getNewValue();
                String childName = child.getName();
                int[] viewedIndexes = this.findViewedIndexes(oldParentName, childName);
                for (ProgramNode node : nodes = this.tree.findNodes(childName)) {
                    this.tree.groupRemoved(node, oldParentName, false);
                }
                try {
                    this.tree.groupAdded(child, true);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    return;
                }
                nodes = this.tree.findNodes(childName);
                List<TreePath> viewList = this.tree.getViewList();
                int idx = 0;
                for (int i = 0; i < nodes.length; ++i) {
                    if (!nodes[i].getParentModule().getName().equals(newParentName)) continue;
                    TreePath nodePath = nodes[i].getTreePath();
                    for (int j = idx; j < viewedIndexes.length; ++j) {
                        TreePath p = nodePath;
                        TreePath vp = viewList.get(viewedIndexes[j]);
                        ProgramNode programNode = (ProgramNode)vp.getLastPathComponent();
                        String vname = programNode.getName();
                        if (!vname.equals(childName)) {
                            TreePath descPath = this.findDescendant(nodePath, vname);
                            if (descPath == null) continue;
                            viewList.remove(viewedIndexes[j]);
                            this.tree.addToView(p, viewedIndexes[j]);
                            ++idx;
                            continue;
                        }
                        viewList.remove(viewedIndexes[j]);
                        this.tree.addToView(p, viewedIndexes[j]);
                        ++idx;
                    }
                }
                if (childName.equals(this.actionManager.getLastGroupPasted())) {
                    this.tree.setBusyCursor(false);
                }
                this.tree.fireTreeViewChanged();
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGroupAdded(ProgramChangeRecord record) {
        ProgramModule parentModule = (ProgramModule)record.getOldValue();
        this.tree = this.plugin.getTree(parentModule.getTreeName());
        if (this.tree == null) {
            return;
        }
        Object object = this.tree.getModel().getRoot();
        synchronized (object) {
            Group child = (Group)record.getNewValue();
            try {
                this.tree.groupAdded(child);
            }
            catch (ConcurrentModificationException e) {
                return;
            }
            if (child.getName().equals(this.actionManager.getLastGroupPasted())) {
                this.tree.setBusyCursor(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processModuleReordered(ProgramChangeRecord record) {
        ProgramModule parent = (ProgramModule)record.getObject();
        this.tree = this.plugin.getTree(parent.getTreeName());
        if (this.tree == null) {
            return;
        }
        Object object = this.tree.getModel().getRoot();
        synchronized (object) {
            Group child = (Group)record.getNewValue();
            TreePath[] selectedPaths = this.tree.getSelectionPaths();
            this.tree.reorder(child, parent);
            this.tree.buildNodeList();
            String childName = child.getName();
            ProgramNode[] nodes = this.tree.findNodes(childName);
            this.tree.addSelectionPaths(selectedPaths);
            if (childName.equals(this.actionManager.getLastGroupPasted())) {
                this.tree.setBusyCursor(false);
            }
            List<TreePath> list = this.tree.getViewList();
            for (ProgramNode node : nodes) {
                if (!list.contains(node.getTreePath())) continue;
                this.tree.fireTreeViewChanged();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGroupRenamed(ProgramChangeRecord record) {
        Group group = (Group)record.getNewValue();
        String treeName = group.getTreeName();
        this.tree = this.plugin.getTree(treeName);
        if (this.tree == null) {
            return;
        }
        Object object = this.tree.getModel().getRoot();
        synchronized (object) {
            ProgramNode[] nodes;
            Enumeration<TreePath> it = this.tree.getExpandedDescendants(((ProgramNode)this.tree.getModel().getRoot()).getTreePath());
            List expandedPaths = CollectionUtils.asList(it);
            String oldName = (String)record.getOldValue();
            String newName = group.getName();
            Listing listing = this.tree.getProgram().getListing();
            ProgramModule g = listing.getModule(treeName, newName);
            if (g == null) {
                g = listing.getFragment(treeName, newName);
            }
            for (ProgramNode node : nodes = this.tree.findNodes(oldName)) {
                node.setName(newName);
                node.setGroup((Group)g);
                this.tree.updateGroupPath(node);
            }
            this.tree.expandPaths(expandedPaths);
            StringKeyIndexer nameIndexer = this.tree.getNameIndexer();
            nameIndexer.remove(oldName);
            nameIndexer.put(newName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGroupRemoved(ProgramChangeRecord record) {
        try {
            ProgramModule parent = (ProgramModule)record.getOldValue();
            this.tree = this.plugin.getTree(parent.getTreeName());
            if (this.tree == null) {
                return;
            }
            Object object = this.tree.getModel().getRoot();
            synchronized (object) {
                ProgramNode[] nodes;
                try {
                    parent.getName();
                }
                catch (ConcurrentModificationException e) {
                    return;
                }
                String childName = (String)record.getNewValue();
                for (ProgramNode node : nodes = this.tree.findNodes(childName)) {
                    this.tree.groupRemoved(node, parent.getName(), true);
                }
                if (childName.equals(this.actionManager.getLastGroupPasted())) {
                    this.tree.setBusyCursor(false);
                }
                this.tree.fireTreeViewChanged();
            }
        }
        catch (ConcurrentModificationException parent) {
        }
        catch (Exception e) {
            Msg.showError((Object)this, null, (String)"Error", (Object)"Error processing group removed event", (Throwable)e);
        }
    }

    private boolean willReloadProgram(DomainObjectChangedEvent event) {
        if (this.updateManager.isBusy()) {
            this.updateManager.updateLater();
            return true;
        }
        if (this.rootNameChanged(event)) {
            this.updateManager.updateLater();
            return true;
        }
        int changeCnt = 0;
        int recordCount = event.numRecords();
        for (int i = 0; i < recordCount; ++i) {
            DomainObjectChangeRecord rec = event.getChangeRecord(i);
            EventType eventType = rec.getEventType();
            if (eventType == DomainObjectEvent.RESTORED || eventType == ProgramEvent.MEMORY_BLOCK_REMOVED) {
                this.plugin.reloadProgram(eventType == DomainObjectEvent.RESTORED);
                return true;
            }
            if (eventType == ProgramEvent.GROUP_ADDED || eventType == ProgramEvent.GROUP_REMOVED || eventType == ProgramEvent.FRAGMENT_MOVED || eventType == ProgramEvent.MODULE_REORDERED) {
                ++changeCnt;
                continue;
            }
            if (eventType == ProgramEvent.PROGRAM_TREE_REMOVED) {
                this.plugin.treeRemoved((String)rec.getOldValue());
                continue;
            }
            if (eventType != ProgramEvent.PROGRAM_TREE_CREATED) continue;
            this.plugin.treeViewAdded((String)rec.getNewValue());
        }
        if (changeCnt > THRESHOLD_FOR_RELOAD) {
            this.updateManager.updateLater();
            return true;
        }
        return false;
    }

    private boolean rootNameChanged(DomainObjectChangedEvent event) {
        Program sourceProgram = (Program)event.getSource();
        if (this.plugin.getCurrentProgram() != sourceProgram) {
            return false;
        }
        return event.contains(new EventType[]{ProgramEvent.PROGRAM_TREE_RENAMED, DomainObjectEvent.RENAMED});
    }

    private int[] findViewedIndexes(String oldParentName, String childName) {
        List<TreePath> viewList = this.tree.getViewList();
        int[] indexes = new int[viewList.size()];
        int idx = 0;
        block0: for (int i = 0; i < viewList.size(); ++i) {
            TreePath path = viewList.get(i);
            String[] names = this.getNames(path);
            for (int j = 0; j < names.length; ++j) {
                if (!names[j].equals(childName) || j <= 0 || !names[j - 1].equals(oldParentName)) continue;
                indexes[idx] = i;
                ++idx;
                continue block0;
            }
        }
        if (idx <= indexes.length - 1) {
            int[] temp = new int[idx];
            for (int i = 0; i < idx; ++i) {
                temp[i] = indexes[i];
            }
            indexes = temp;
        }
        return indexes;
    }

    private String[] getNames(TreePath path) {
        int count = path.getPathCount();
        String[] names = new String[count];
        for (int i = 0; i < count; ++i) {
            ProgramNode node = (ProgramNode)path.getPathComponent(i);
            names[i] = node.getName();
        }
        return names;
    }

    private TreePath findDescendant(TreePath path, String name) {
        ProgramNode node = (ProgramNode)path.getLastPathComponent();
        if (node.getName().equals(name)) {
            return node.getTreePath();
        }
        if (node.getAllowsChildren() && !node.wasVisited()) {
            this.tree.visitNode(node);
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            ProgramNode child = (ProgramNode)node.getChildAt(i);
            TreePath p = this.findDescendant(child.getTreePath(), name);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    void dispose() {
        this.updateManager.dispose();
    }
}

