/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.hover;

import ghidra.app.services.HoverService;
import ghidra.framework.plugintool.PluginTool;
import javax.swing.JComponent;
import javax.swing.JToolTip;

public abstract class AbstractHover
implements HoverService {
    protected final PluginTool tool;
    protected boolean enabled;
    protected final int priority;

    protected AbstractHover(PluginTool tool, int priority) {
        this.tool = tool;
        this.priority = priority;
    }

    @Override
    public final int getPriority() {
        return this.priority;
    }

    @Override
    public final boolean hoverModeSelected() {
        return this.enabled;
    }

    protected boolean isValidTooltipContent(String content) {
        return content != null && content.length() != 0;
    }

    protected JComponent createTooltipComponent(String content) {
        if (!this.isValidTooltipContent(content)) {
            return null;
        }
        JToolTip tt = new JToolTip();
        tt.setTipText(content);
        return tt;
    }

    @Override
    public void scroll(int amount) {
    }

    @Override
    public void componentHidden() {
    }

    @Override
    public void componentShown() {
    }
}

