/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.database.symbol.CodeSymbol;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.AddressXML;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;
import java.util.ArrayList;

public class JumpTable {
    private AddressSpace preferredSpace;
    private Address opAddress;
    private Address[] addressTable;
    private Integer[] labelTable;
    private LoadTable[] loadTable;
    private BasicOverride override;

    public JumpTable(AddressSpace preferredSpace) {
        this.preferredSpace = preferredSpace;
        this.opAddress = null;
        this.addressTable = null;
        this.labelTable = null;
        this.loadTable = null;
        this.override = null;
    }

    public JumpTable(Address addr, ArrayList<Address> destlist, boolean override) {
        this.opAddress = addr;
        this.preferredSpace = this.opAddress.getAddressSpace();
        this.labelTable = null;
        this.loadTable = null;
        if (override) {
            this.addressTable = null;
            this.override = new BasicOverride(this, destlist);
        } else {
            this.addressTable = new Address[destlist.size()];
            destlist.toArray(this.addressTable);
            this.override = null;
        }
    }

    public boolean isEmpty() {
        if (this.addressTable == null) {
            return true;
        }
        return this.addressTable.length == 0;
    }

    public void decode(Decoder decoder) throws DecoderException {
        int subel;
        int el = decoder.openElement(ElementId.ELEM_JUMPTABLE);
        if (decoder.peekElement() == 0) {
            decoder.closeElement(el);
            return;
        }
        ArrayList<Address> aTable = new ArrayList<Address>();
        ArrayList<Integer> lTable = new ArrayList<Integer>();
        ArrayList<LoadTable> ldTable = new ArrayList<LoadTable>();
        Address switchAddr = AddressXML.decode(decoder);
        while ((subel = decoder.peekElement()) != 0) {
            if (subel == ElementId.ELEM_DEST.id()) {
                int attribId;
                decoder.openElement();
                Address caseAddr = AddressXML.decodeFromAttributes(decoder);
                aTable.add(caseAddr);
                decoder.rewindAttributes();
                while ((attribId = decoder.getNextAttributeId()) != 0) {
                    if (attribId != AttributeId.ATTRIB_LABEL.id()) continue;
                    int label = (int)decoder.readUnsignedInteger();
                    lTable.add(label);
                }
                decoder.closeElement(subel);
                continue;
            }
            if (subel == ElementId.ELEM_LOADTABLE.id()) {
                LoadTable loadtable = new LoadTable(this);
                loadtable.decode(decoder);
                ldTable.add(loadtable);
                continue;
            }
            decoder.skipElement();
        }
        this.opAddress = switchAddr;
        this.addressTable = new Address[aTable.size()];
        aTable.toArray(this.addressTable);
        this.labelTable = new Integer[lTable.size()];
        lTable.toArray(this.labelTable);
        this.loadTable = new LoadTable[ldTable.size()];
        ldTable.toArray(this.loadTable);
        decoder.closeElement(el);
    }

    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(ElementId.ELEM_JUMPTABLE);
        AddressXML.encode(encoder, this.opAddress);
        if (this.addressTable != null) {
            for (Address element : this.addressTable) {
                encoder.openElement(ElementId.ELEM_DEST);
                AddressXML.encodeAttributes(encoder, element);
                encoder.closeElement(ElementId.ELEM_DEST);
            }
        }
        if (this.override != null) {
            this.override.encode(encoder);
        }
        encoder.closeElement(ElementId.ELEM_JUMPTABLE);
    }

    public Address getSwitchAddress() {
        return this.opAddress;
    }

    public Address[] getCases() {
        return (Address[])this.addressTable.clone();
    }

    public Integer[] getLabelValues() {
        return (Integer[])this.labelTable.clone();
    }

    public LoadTable[] getLoadTables() {
        return (LoadTable[])this.loadTable.clone();
    }

    public void writeOverride(Function func) throws InvalidInputException {
        if (this.override == null) {
            throw new InvalidInputException("Jumptable is not an override");
        }
        Address[] destlist = this.override.getDestinations();
        if (destlist.length == 0) {
            throw new InvalidInputException("Jumptable has no destinations");
        }
        if (!func.getBody().contains(this.opAddress)) {
            throw new InvalidInputException("Switch is not in function body");
        }
        Program program = func.getProgram();
        SymbolTable symtab = program.getSymbolTable();
        Namespace space = HighFunction.findCreateOverrideSpace(func);
        if (space == null) {
            throw new InvalidInputException("Could not create \"override\" namespace");
        }
        if (!HighFunction.clearNamespace(symtab, space = HighFunction.findCreateNamespace(symtab, space, "jmp_" + this.opAddress.toString()))) {
            throw new InvalidInputException("Jumptable override namespace contains non-label symbols.");
        }
        HighFunction.createLabelSymbol(symtab, this.opAddress, "switch", space, SourceType.USER_DEFINED, false);
        for (int i = 0; i < destlist.length; ++i) {
            String nm = "case_" + Integer.toString(i);
            HighFunction.createLabelSymbol(symtab, destlist[i], nm, space, SourceType.USER_DEFINED, false);
        }
    }

    public static JumpTable readOverride(Namespace space, SymbolTable symtab) {
        Address branchind = null;
        ArrayList<Address> destlist = new ArrayList<Address>();
        SymbolIterator iter = symtab.getSymbols(space);
        while (iter.hasNext()) {
            Symbol sym = iter.next();
            if (!(sym instanceof CodeSymbol)) continue;
            Address addr = sym.getAddress();
            if (sym.getName().equals("switch")) {
                branchind = addr;
                continue;
            }
            if (!sym.getName().startsWith("case")) continue;
            destlist.add(addr);
        }
        if (branchind != null && destlist.size() > 0) {
            return new JumpTable(branchind, destlist, true);
        }
        return null;
    }

    public class LoadTable {
        Address addr;
        int size;
        int num;

        LoadTable(JumpTable this$0) {
        }

        public Address getAddress() {
            return this.addr;
        }

        public int getSize() {
            return this.size;
        }

        public int getNum() {
            return this.num;
        }

        public void decode(Decoder decoder) throws DecoderException {
            int el = decoder.openElement(ElementId.ELEM_LOADTABLE);
            this.size = (int)decoder.readSignedInteger(AttributeId.ATTRIB_SIZE);
            this.num = (int)decoder.readSignedInteger(AttributeId.ATTRIB_NUM);
            this.addr = AddressXML.decode(decoder);
            decoder.closeElement(el);
        }
    }

    public class BasicOverride {
        private Address[] destlist;

        public BasicOverride(JumpTable this$0, ArrayList<Address> dlist) {
            this.destlist = new Address[dlist.size()];
            dlist.toArray(this.destlist);
        }

        public Address[] getDestinations() {
            return this.destlist;
        }

        public void encode(Encoder encoder) throws IOException {
            encoder.openElement(ElementId.ELEM_BASICOVERRIDE);
            for (Address element : this.destlist) {
                encoder.openElement(ElementId.ELEM_DEST);
                AddressXML.encodeAttributes(encoder, element);
                encoder.closeElement(ElementId.ELEM_DEST);
            }
            encoder.closeElement(ElementId.ELEM_BASICOVERRIDE);
        }
    }
}

