/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slgh_compile;

import generic.stl.IteratorSTL;
import generic.stl.VectorSTL;
import ghidra.pcodeCPort.context.SleighError;
import ghidra.pcodeCPort.opcodes.OpCode;
import ghidra.pcodeCPort.semantics.ConstTpl;
import ghidra.pcodeCPort.semantics.ConstructTpl;
import ghidra.pcodeCPort.semantics.HandleTpl;
import ghidra.pcodeCPort.semantics.OpTpl;
import ghidra.pcodeCPort.semantics.VarnodeTpl;
import ghidra.pcodeCPort.slgh_compile.OptimizeRecord;
import ghidra.pcodeCPort.slgh_compile.SleighCompile;
import ghidra.pcodeCPort.slghsymbol.Constructor;
import ghidra.pcodeCPort.slghsymbol.OperandSymbol;
import ghidra.pcodeCPort.slghsymbol.SubtableSymbol;
import ghidra.pcodeCPort.slghsymbol.TripleSymbol;
import ghidra.pcodeCPort.space.AddrSpace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;

class ConsistencyChecker {
    private int unnecessarypcode;
    private int readnowrite;
    private int writenoread;
    private boolean printextwarning;
    private boolean printdeadwarning;
    private SleighCompile compiler;
    private SubtableSymbol root_symbol;
    private List<SubtableSymbol> postorder = new ArrayList<SubtableSymbol>();
    private Map<SubtableSymbol, Integer> sizemap = new HashMap<SubtableSymbol, Integer>();

    private OperandSymbol getOperandSymbol(int slot, OpTpl op, Constructor ct) {
        OperandSymbol opsym = null;
        VarnodeTpl vn = slot == -1 ? op.getOut() : op.getIn(slot);
        switch (vn.getSize().getType()) {
            case handle: {
                int handindex = vn.getSize().getHandleIndex();
                opsym = ct.getOperand(handindex);
                break;
            }
        }
        return opsym;
    }

    private boolean sizeRestriction(OpTpl op, Constructor ct) {
        switch (op.getOpcode()) {
            case CPUI_COPY: 
            case CPUI_INT_2COMP: 
            case CPUI_INT_NEGATE: 
            case CPUI_FLOAT_NEG: 
            case CPUI_FLOAT_ABS: 
            case CPUI_FLOAT_SQRT: 
            case CPUI_FLOAT_CEIL: 
            case CPUI_FLOAT_FLOOR: 
            case CPUI_FLOAT_ROUND: {
                int vnout = this.recoverSize(op.getOut().getSize(), ct);
                if (vnout == -1) {
                    this.printOpError(op, ct, -1, -1, "Using subtable with exports in expression");
                    return false;
                }
                int vn0 = this.recoverSize(op.getIn(0).getSize(), ct);
                if (vn0 == -1) {
                    this.printOpError(op, ct, 0, 0, "Using subtable with exports in expression");
                    return false;
                }
                if (vnout == vn0) {
                    return true;
                }
                if (vnout == 0 || vn0 == 0) {
                    return true;
                }
                this.printOpError(op, ct, -1, 0, "Input and output sizes must match; " + String.valueOf(op.getIn(0).getSize()) + " != " + String.valueOf(op.getOut().getSize()));
                return false;
            }
            case CPUI_INT_ADD: 
            case CPUI_INT_SUB: 
            case CPUI_INT_XOR: 
            case CPUI_INT_AND: 
            case CPUI_INT_OR: 
            case CPUI_INT_MULT: 
            case CPUI_INT_DIV: 
            case CPUI_INT_SDIV: 
            case CPUI_INT_REM: 
            case CPUI_INT_SREM: 
            case CPUI_FLOAT_ADD: 
            case CPUI_FLOAT_DIV: 
            case CPUI_FLOAT_MULT: 
            case CPUI_FLOAT_SUB: {
                int vnout = this.recoverSize(op.getOut().getSize(), ct);
                if (vnout == -1) {
                    this.printOpError(op, ct, -1, -1, "Using subtable with exports in expression");
                    return false;
                }
                int vn0 = this.recoverSize(op.getIn(0).getSize(), ct);
                if (vn0 == -1) {
                    this.printOpError(op, ct, 0, 0, "Using subtable with exports in expression");
                    return false;
                }
                int vn1 = this.recoverSize(op.getIn(1).getSize(), ct);
                if (vn1 == -1) {
                    this.printOpError(op, ct, 1, 1, "Using subtable with exports in expression");
                    return false;
                }
                if (vnout != 0 && vn0 != 0 && vnout != vn0) {
                    this.printOpError(op, ct, -1, 0, "The output and all input sizes must match");
                    return false;
                }
                if (vnout != 0 && vn1 != 0 && vnout != vn1) {
                    this.printOpError(op, ct, -1, 1, "The output and all input sizes must match");
                    return false;
                }
                if (vn0 != 0 && vn1 != 0 && vn0 != vn1) {
                    this.printOpError(op, ct, 0, 1, "The output and all input sizes must match");
                    return false;
                }
                return true;
            }
            case CPUI_FLOAT_NAN: {
                int vnout = this.recoverSize(op.getOut().getSize(), ct);
                if (vnout == -1) {
                    this.printOpError(op, ct, -1, -1, "Using subtable with exports in expression");
                    return false;
                }
                if (vnout == 1) break;
                this.printOpError(op, ct, -1, -1, "Output must be a boolean (size 1)");
                return false;
            }
            case CPUI_INT_EQUAL: 
            case CPUI_INT_NOTEQUAL: 
            case CPUI_INT_SLESS: 
            case CPUI_INT_SLESSEQUAL: 
            case CPUI_INT_LESS: 
            case CPUI_INT_LESSEQUAL: 
            case CPUI_INT_CARRY: 
            case CPUI_INT_SCARRY: 
            case CPUI_INT_SBORROW: 
            case CPUI_FLOAT_EQUAL: 
            case CPUI_FLOAT_NOTEQUAL: 
            case CPUI_FLOAT_LESS: 
            case CPUI_FLOAT_LESSEQUAL: {
                int vnout = this.recoverSize(op.getOut().getSize(), ct);
                if (vnout == -1) {
                    this.printOpError(op, ct, -1, -1, "Using subtable with exports in expression");
                    return false;
                }
                if (vnout != 1) {
                    this.printOpError(op, ct, -1, -1, "Output must be a boolean (size 1)");
                    return false;
                }
                int vn0 = this.recoverSize(op.getIn(0).getSize(), ct);
                if (vn0 == -1) {
                    this.printOpError(op, ct, 0, 0, "Using subtable with exports in expression");
                    return false;
                }
                int vn1 = this.recoverSize(op.getIn(1).getSize(), ct);
                if (vn1 == -1) {
                    this.printOpError(op, ct, 1, 1, "Using subtable with exports in expression");
                    return false;
                }
                if (vn0 == 0 || vn1 == 0) {
                    return true;
                }
                if (vn0 != vn1) {
                    this.printOpError(op, ct, 0, 1, "Inputs must be the same size");
                    return false;
                }
                return true;
            }
            case CPUI_BOOL_XOR: 
            case CPUI_BOOL_AND: 
            case CPUI_BOOL_OR: {
                int vnout = this.recoverSize(op.getOut().getSize(), ct);
                if (vnout == -1) {
                    this.printOpError(op, ct, -1, -1, "Using subtable with exports in expression");
                    return false;
                }
                if (vnout != 1) {
                    this.printOpError(op, ct, -1, -1, "Output must be a boolean (size 1)");
                    return false;
                }
                int vn0 = this.recoverSize(op.getIn(0).getSize(), ct);
                if (vn0 == -1) {
                    this.printOpError(op, ct, 0, 0, "Using subtable with exports in expression");
                    return false;
                }
                if (vn0 != 1) {
                    this.printOpError(op, ct, 0, 0, "Input must be a boolean (size 1)");
                    return false;
                }
                return true;
            }
            case CPUI_BOOL_NEGATE: {
                int vnout = this.recoverSize(op.getOut().getSize(), ct);
                if (vnout == -1) {
                    this.printOpError(op, ct, -1, -1, "Using subtable with exports in expression");
                    return false;
                }
                if (vnout != 1) {
                    this.printOpError(op, ct, -1, -1, "Output must be a boolean (size 1)");
                    return false;
                }
                int vn0 = this.recoverSize(op.getIn(0).getSize(), ct);
                if (vn0 == -1) {
                    this.printOpError(op, ct, 0, 0, "Using subtable with exports in expression");
                    return false;
                }
                if (vn0 != 1) {
                    this.printOpError(op, ct, 0, 0, "Input must be a boolean (size 1)");
                    return false;
                }
                return true;
            }
            case CPUI_INT_LEFT: 
            case CPUI_INT_RIGHT: 
            case CPUI_INT_SRIGHT: {
                int vnout = this.recoverSize(op.getOut().getSize(), ct);
                if (vnout == -1) {
                    this.printOpError(op, ct, -1, -1, "Using subtable with exports in expression");
                    return false;
                }
                int vn0 = this.recoverSize(op.getIn(0).getSize(), ct);
                if (vn0 == -1) {
                    this.printOpError(op, ct, 0, 0, "Using subtable with exports in expression");
                    return false;
                }
                if (vnout == 0 || vn0 == 0) {
                    return true;
                }
                if (vnout != vn0) {
                    this.printOpError(op, ct, -1, 0, "Output and first input must be the same size");
                    return false;
                }
                return true;
            }
            case CPUI_INT_ZEXT: 
            case CPUI_INT_SEXT: {
                int vnout = this.recoverSize(op.getOut().getSize(), ct);
                if (vnout == -1) {
                    this.printOpError(op, ct, -1, -1, "Using subtable with exports in expression");
                    return false;
                }
                int vn0 = this.recoverSize(op.getIn(0).getSize(), ct);
                if (vn0 == -1) {
                    this.printOpError(op, ct, 0, 0, "Using subtable with exports in expression");
                    return false;
                }
                if (vnout == 0 || vn0 == 0) {
                    return true;
                }
                if (vnout == vn0) {
                    this.dealWithUnnecessaryExt(op, ct);
                    return true;
                }
                if (vnout < vn0) {
                    this.printOpError(op, ct, -1, 0, "Output size must be strictly bigger than input size");
                    return false;
                }
                return true;
            }
            case CPUI_CBRANCH: {
                int vn1 = this.recoverSize(op.getIn(1).getSize(), ct);
                if (vn1 == -1) {
                    this.printOpError(op, ct, 1, 1, "Using subtable with exports in expression");
                    return false;
                }
                if (vn1 != 1) {
                    this.printOpError(op, ct, 1, 1, "Input must be a boolean (size 1)");
                    return false;
                }
                return true;
            }
            case CPUI_LOAD: 
            case CPUI_STORE: {
                if (op.getIn(0).getOffset().getType() != ConstTpl.const_type.spaceid) {
                    return true;
                }
                AddrSpace spc = op.getIn(0).getOffset().getSpace();
                int vn1 = this.recoverSize(op.getIn(1).getSize(), ct);
                if (vn1 == -1) {
                    this.printOpError(op, ct, 1, 1, "Using subtable with exports in expression");
                    return false;
                }
                if (vn1 != 0 && vn1 != spc.getAddrSize()) {
                    this.printOpError(op, ct, 1, 1, "Pointer size must match size of space");
                    return false;
                }
                return true;
            }
            case CPUI_SUBPIECE: {
                int vnout = this.recoverSize(op.getOut().getSize(), ct);
                if (vnout == -1) {
                    this.printOpError(op, ct, -1, -1, "Using subtable with exports in expression");
                    return false;
                }
                int vn0 = this.recoverSize(op.getIn(0).getSize(), ct);
                if (vn0 == -1) {
                    this.printOpError(op, ct, 0, 0, "Using subtable with exports in expression");
                    return false;
                }
                int vn1 = (int)op.getIn(1).getOffset().getReal();
                if (vnout == 0 || vn0 == 0) {
                    return true;
                }
                if (vnout == vn0 && vn1 == 0) {
                    this.dealWithUnnecessaryTrunc(op, ct);
                    return true;
                }
                if (vnout >= vn0) {
                    this.printOpError(op, ct, -1, 0, "Output must be strictly smaller than input");
                    return false;
                }
                if (vnout > vn0 - vn1) {
                    this.printOpError(op, ct, -1, 0, "Too much truncation");
                    return false;
                }
                return true;
            }
        }
        return true;
    }

    private String getOpName(OpTpl op) {
        switch (op.getOpcode()) {
            case CPUI_COPY: {
                return "Copy(=)";
            }
            case CPUI_LOAD: {
                return "Load(*)";
            }
            case CPUI_STORE: {
                return "Store(*)";
            }
            case CPUI_BRANCH: {
                return "Branch(goto)";
            }
            case CPUI_CBRANCH: {
                return "Conditional branch(if)";
            }
            case CPUI_BRANCHIND: {
                return "Indirect branch(goto[])";
            }
            case CPUI_CALL: {
                return "Call";
            }
            case CPUI_CALLIND: {
                return "Indirect Call";
            }
            case CPUI_CALLOTHER: {
                return "User defined";
            }
            case CPUI_RETURN: {
                return "Return";
            }
            case CPUI_INT_EQUAL: {
                return "Equality(==)";
            }
            case CPUI_INT_NOTEQUAL: {
                return "Notequal(!=)";
            }
            case CPUI_INT_SLESS: {
                return "Signed less than(s<)";
            }
            case CPUI_INT_SLESSEQUAL: {
                return "Signed less than or equal(s<=)";
            }
            case CPUI_INT_LESS: {
                return "Less than(<)";
            }
            case CPUI_INT_LESSEQUAL: {
                return "Less than or equal(<=)";
            }
            case CPUI_INT_ZEXT: {
                return "Zero extension(zext)";
            }
            case CPUI_INT_SEXT: {
                return "Signed extension(sext)";
            }
            case CPUI_INT_ADD: {
                return "Addition(+)";
            }
            case CPUI_INT_SUB: {
                return "Subtraction(-)";
            }
            case CPUI_INT_CARRY: {
                return "Carry";
            }
            case CPUI_INT_SCARRY: {
                return "Signed carry";
            }
            case CPUI_INT_SBORROW: {
                return "Signed borrow";
            }
            case CPUI_INT_2COMP: {
                return "Twos complement(-)";
            }
            case CPUI_INT_NEGATE: {
                return "Negate(~)";
            }
            case CPUI_INT_XOR: {
                return "Exclusive or(^)";
            }
            case CPUI_INT_AND: {
                return "And(&)";
            }
            case CPUI_INT_OR: {
                return "Or(|)";
            }
            case CPUI_INT_LEFT: {
                return "Left shift(<<)";
            }
            case CPUI_INT_RIGHT: {
                return "Right shift(>>)";
            }
            case CPUI_INT_SRIGHT: {
                return "Signed right shift(s>>)";
            }
            case CPUI_INT_MULT: {
                return "Multiplication(*)";
            }
            case CPUI_INT_DIV: {
                return "Division(/)";
            }
            case CPUI_INT_SDIV: {
                return "Signed division(s/)";
            }
            case CPUI_INT_REM: {
                return "Remainder(%)";
            }
            case CPUI_INT_SREM: {
                return "Signed remainder(s%)";
            }
            case CPUI_BOOL_NEGATE: {
                return "Boolean negate(!)";
            }
            case CPUI_BOOL_XOR: {
                return "Boolean xor(^^)";
            }
            case CPUI_BOOL_AND: {
                return "Boolean and(&&)";
            }
            case CPUI_BOOL_OR: {
                return "Boolean or(||)";
            }
            case CPUI_FLOAT_EQUAL: {
                return "Float equal(f==)";
            }
            case CPUI_FLOAT_NOTEQUAL: {
                return "Float notequal(f!=)";
            }
            case CPUI_FLOAT_LESS: {
                return "Float less than(f<)";
            }
            case CPUI_FLOAT_LESSEQUAL: {
                return "Float less than or equal(f<=)";
            }
            case CPUI_FLOAT_NAN: {
                return "Not a number(nan)";
            }
            case CPUI_FLOAT_ADD: {
                return "Float addition(f+)";
            }
            case CPUI_FLOAT_DIV: {
                return "Float division(f/)";
            }
            case CPUI_FLOAT_MULT: {
                return "Float multiplication(f*)";
            }
            case CPUI_FLOAT_SUB: {
                return "Float subtractions(f-)";
            }
            case CPUI_FLOAT_NEG: {
                return "Float minus(f-)";
            }
            case CPUI_FLOAT_ABS: {
                return "Absolute value(abs)";
            }
            case CPUI_FLOAT_SQRT: {
                return "Square root";
            }
            case CPUI_FLOAT_INT2FLOAT: {
                return "Integer to float conversion(int2float)";
            }
            case CPUI_FLOAT_FLOAT2FLOAT: {
                return "Float to float conversion(float2float)";
            }
            case CPUI_FLOAT_TRUNC: {
                return "Float truncation(trunc)";
            }
            case CPUI_FLOAT_CEIL: {
                return "Ceiling(ceil)";
            }
            case CPUI_FLOAT_FLOOR: {
                return "Floor";
            }
            case CPUI_FLOAT_ROUND: {
                return "Round";
            }
            case CPUI_MULTIEQUAL: {
                return "Build";
            }
            case CPUI_INDIRECT: {
                return "Delay";
            }
            case CPUI_SUBPIECE: {
                return "Truncation(:)";
            }
            case CPUI_SEGMENTOP: {
                return "Segment table(segment)";
            }
            case CPUI_CPOOLREF: {
                return "Constant Pool(cpool)";
            }
            case CPUI_NEW: {
                return "New object(newobject)";
            }
        }
        return "";
    }

    private void printOpError(OpTpl op, Constructor ct, int err1, int err2, String message) {
        SubtableSymbol sym = ct.getParent();
        OperandSymbol op1 = this.getOperandSymbol(err1, op, ct);
        OperandSymbol op2 = err2 != err1 ? this.getOperandSymbol(err2, op, ct) : null;
        StringBuilder sb = new StringBuilder();
        sb.append("Size restriction error in table '").append(sym.getName()).append("' in constructor at ").append(ct.location).append("\n");
        sb.append("  Problem");
        if (op1 != null && op2 != null) {
            sb.append(" with '" + op1.getName() + "' and '" + op2.getName() + "'");
        } else if (op1 != null) {
            sb.append(" with '" + op1.getName() + "'");
        } else if (op2 != null) {
            sb.append(" with '" + op2.getName() + "'");
        }
        sb.append(" in '" + this.getOpName(op) + "' operator");
        sb.append("\n  ").append(message);
        this.compiler.reportError(op.location, sb.toString());
    }

    private int recoverSize(ConstTpl sizeconst, Constructor ct) {
        return switch (sizeconst.getType()) {
            case ConstTpl.const_type.real -> (int)sizeconst.getReal();
            case ConstTpl.const_type.handle -> {
                int handindex = sizeconst.getHandleIndex();
                OperandSymbol opsym = ct.getOperand(handindex);
                int size = opsym.getSize();
                if (size != -1) {
                    yield size;
                }
                TripleSymbol definingSymbol = opsym.getDefiningSymbol();
                if (!(definingSymbol instanceof SubtableSymbol)) {
                    throw new SleighError("Could not recover varnode template size", ct.location);
                }
                SubtableSymbol tabsym = (SubtableSymbol)definingSymbol;
                Integer symsize = this.sizemap.get(tabsym);
                if (symsize == null) {
                    throw new SleighError("Subtable out of order", ct.location);
                }
                yield symsize;
            }
            default -> throw new SleighError("Bad constant type as varnode template size", ct.location);
        };
    }

    private void handle(String msg, Constructor ct) {
        this.compiler.reportWarning(ct.location, " Unsigned comparison with " + msg + " in constructor");
    }

    private void handleZero(String trueOrFalse, Constructor ct) {
        this.handle("zero is always " + trueOrFalse, ct);
    }

    private void handleConstants(Constructor ct) {
        this.handle("constants should be pre-computed", ct);
    }

    private void handleBetter(String msg, Constructor ct) {
        this.handle("zero might be better written as \"" + msg + "\" (or did you mean to use signed comparison?)", ct);
    }

    private boolean checkOpMisuse(OpTpl op, Constructor ct) {
        switch (op.getOpcode()) {
            case CPUI_INT_LESS: {
                VarnodeTpl vn0 = op.getIn(0);
                VarnodeTpl vn1 = op.getIn(1);
                if (vn1.getSpace().isConstSpace()) {
                    if (vn1.getOffset().isZero()) {
                        this.handleZero("false", ct);
                        break;
                    }
                    if (!vn0.getSpace().isConstSpace()) break;
                    if (vn0.getOffset().isZero()) {
                        this.handleZero("true", ct);
                        break;
                    }
                    this.handleConstants(ct);
                    break;
                }
                if (!vn0.getSpace().isConstSpace() || !vn0.getOffset().isZero()) break;
                this.handleBetter("!= 0", ct);
                break;
            }
            case CPUI_INT_LESSEQUAL: {
                VarnodeTpl vn0 = op.getIn(0);
                VarnodeTpl vn1 = op.getIn(1);
                if (vn0.getSpace().isConstSpace()) {
                    if (vn0.getOffset().isZero()) {
                        this.handleZero("true", ct);
                        break;
                    }
                    if (!vn1.getSpace().isConstSpace()) break;
                    if (vn1.getOffset().isZero()) {
                        this.handleZero("false", ct);
                        break;
                    }
                    this.handleConstants(ct);
                    break;
                }
                if (!vn1.getSpace().isConstSpace() || !vn1.getOffset().isZero()) break;
                this.handleBetter("== 0", ct);
                break;
            }
        }
        return true;
    }

    private boolean checkConstructorSection(Constructor ct, ConstructTpl cttpl) {
        if (cttpl == null) {
            return true;
        }
        VectorSTL<OpTpl> ops = cttpl.getOpvec();
        boolean testresult = true;
        IteratorSTL iter = ops.begin();
        while (!iter.isEnd()) {
            if (!this.sizeRestriction((OpTpl)iter.get(), ct)) {
                testresult = false;
            }
            if (!this.checkOpMisuse((OpTpl)iter.get(), ct)) {
                testresult = false;
            }
            iter.increment();
        }
        return testresult;
    }

    private boolean hasLargeTemporary(OpTpl opTpl) {
        VarnodeTpl out = opTpl.getOut();
        if (out != null && this.isTemporaryAndTooBig(out)) {
            return true;
        }
        for (int i = 0; i < opTpl.numInput(); ++i) {
            VarnodeTpl in = opTpl.getIn(i);
            if (!this.isTemporaryAndTooBig(in)) continue;
            return true;
        }
        return false;
    }

    private boolean isTemporaryAndTooBig(VarnodeTpl vn) {
        return vn.getSpace().isUniqueSpace() && vn.getSize().getReal() > 256L;
    }

    private boolean checkVarnodeTruncation(Constructor ct, int slot, OpTpl op, VarnodeTpl vn, boolean isbigendian) {
        ConstTpl off = vn.getOffset();
        if (off.getType() != ConstTpl.const_type.handle) {
            return true;
        }
        if (off.getSelect() != ConstTpl.v_field.v_offset_plus) {
            return true;
        }
        ConstTpl.const_type sztype = vn.getSize().getType();
        if (sztype != ConstTpl.const_type.real && sztype != ConstTpl.const_type.handle) {
            this.printOpError(op, ct, slot, slot, "Bad truncation expression");
            return false;
        }
        int sz = this.recoverSize(off, ct);
        if (sz <= 0) {
            this.printOpError(op, ct, slot, slot, "Could not recover size");
            return false;
        }
        boolean res = vn.adjustTruncation(sz, isbigendian);
        if (!res) {
            this.printOpError(op, ct, slot, slot, "Truncation operator out of bounds");
            return false;
        }
        return true;
    }

    private boolean checkSectionTruncations(Constructor ct, ConstructTpl cttpl, boolean isbigendian) {
        VectorSTL<OpTpl> ops = cttpl.getOpvec();
        boolean testresult = true;
        for (OpTpl op : ops) {
            VarnodeTpl outvn = op.getOut();
            if (outvn != null && !this.checkVarnodeTruncation(ct, -1, op, outvn, isbigendian)) {
                testresult = false;
            }
            for (int i = 0; i < op.numInput(); ++i) {
                if (this.checkVarnodeTruncation(ct, i, op, op.getIn(i), isbigendian)) continue;
                testresult = false;
            }
        }
        return testresult;
    }

    private boolean checkSubtable(SubtableSymbol sym) {
        int tablesize = -1;
        int numconstruct = sym.getNumConstructors();
        boolean testresult = true;
        boolean seenemptyexport = false;
        boolean seennonemptyexport = false;
        for (int i = 0; i < numconstruct; ++i) {
            Constructor ct = sym.getConstructor(i);
            if (!this.checkConstructorSection(ct, ct.getTempl())) {
                testresult = false;
            }
            int numsection = ct.getNumSections();
            for (int j = 0; j < numsection; ++j) {
                if (this.checkConstructorSection(ct, ct.getNamedTempl(j))) continue;
                testresult = false;
            }
            if (ct.getTempl() == null) continue;
            HandleTpl exportres = ct.getTempl().getResult();
            if (exportres != null) {
                if (seenemptyexport && !seennonemptyexport) {
                    this.compiler.reportError(ct.location, String.format("Table '%s' exports inconsistently; Constructor at %s is first inconsitency", sym.getName(), ct.location));
                    testresult = false;
                }
                seennonemptyexport = true;
                int exsize = this.recoverSize(exportres.getSize(), ct);
                if (tablesize == -1) {
                    tablesize = exsize;
                }
                if (exsize == tablesize) continue;
                this.compiler.reportError(ct.location, String.format("Table '%s' has inconsistent export size; Constructor at %s is first conflict", sym.getName(), ct.location));
                testresult = false;
                continue;
            }
            if (seennonemptyexport && !seenemptyexport) {
                this.compiler.reportError(ct.location, String.format("Table '%s' exports inconsistently; Constructor at %s is first inconsitency", sym.getName(), ct.location));
                testresult = false;
            }
            seenemptyexport = true;
        }
        if (seennonemptyexport) {
            if (tablesize == 0) {
                this.compiler.reportWarning(sym.location, "Table '" + sym.getName() + "' exports size 0");
            }
            this.sizemap.put(sym, tablesize);
        } else {
            this.sizemap.put(sym, -1);
        }
        return testresult;
    }

    private void dealWithUnnecessaryExt(OpTpl op, Constructor ct) {
        if (this.printextwarning) {
            this.compiler.reportWarning(op.location, "Unnecessary '" + this.getOpName(op) + "'");
        }
        op.setOpcode(OpCode.CPUI_COPY);
        ++this.unnecessarypcode;
    }

    private void dealWithUnnecessaryTrunc(OpTpl op, Constructor ct) {
        if (this.printextwarning) {
            this.compiler.reportWarning(op.location, "Unnecessary '" + this.getOpName(op) + "'");
        }
        op.setOpcode(OpCode.CPUI_COPY);
        op.removeInput(1);
        ++this.unnecessarypcode;
    }

    private void setPostOrder(SubtableSymbol root) {
        this.postorder.clear();
        this.sizemap.clear();
        VectorSTL path = new VectorSTL();
        VectorSTL state = new VectorSTL();
        VectorSTL ctstate = new VectorSTL();
        this.sizemap.put(root, -1);
        path.push_back((Object)root);
        state.push_back((Object)0);
        ctstate.push_back((Object)0);
        while (!path.empty()) {
            SubtableSymbol subsym;
            Integer symsize;
            SubtableSymbol cur = (SubtableSymbol)path.back();
            int ctind = (Integer)state.back();
            if (ctind >= cur.getNumConstructors()) {
                path.pop_back();
                state.pop_back();
                ctstate.pop_back();
                this.postorder.add(cur);
                continue;
            }
            Constructor ct = cur.getConstructor(ctind);
            int oper = (Integer)ctstate.back();
            if (oper >= ct.getNumOperands()) {
                state.setBack((Object)(ctind + 1));
                ctstate.setBack((Object)0);
                continue;
            }
            ctstate.setBack((Object)(oper + 1));
            OperandSymbol opsym = ct.getOperand(oper);
            TripleSymbol definingSymbol = opsym.getDefiningSymbol();
            if (!(definingSymbol instanceof SubtableSymbol) || (symsize = this.sizemap.get(subsym = (SubtableSymbol)definingSymbol)) != null) continue;
            this.sizemap.put(subsym, -1);
            path.push_back((Object)subsym);
            state.push_back((Object)0);
            ctstate.push_back((Object)0);
        }
    }

    private static void examineVn(UniqueState state, VarnodeTpl vn, int i, int inslot, int secnum) {
        if (vn == null) {
            return;
        }
        if (!vn.getSpace().isUniqueSpace()) {
            return;
        }
        if (vn.getOffset().getType() != ConstTpl.const_type.real) {
            return;
        }
        long offset = vn.getOffset().getReal();
        int size = (int)vn.getSize().getReal();
        if (inslot >= 0) {
            for (OptimizeRecord rec : state.getDefinitions(offset, size)) {
                rec.updateRead(i, inslot, secnum);
            }
        } else {
            OptimizeRecord rec = new OptimizeRecord(offset, size);
            rec.updateWrite(i, secnum);
            state.set(offset, size, rec);
        }
    }

    private static boolean possibleIntersection(VarnodeTpl vn1, VarnodeTpl vn2) {
        boolean u2;
        if (vn1.getSpace().isConstSpace()) {
            return false;
        }
        if (vn2.getSpace().isConstSpace()) {
            return false;
        }
        boolean u1 = vn1.getSpace().isUniqueSpace();
        if (u1 != (u2 = vn2.getSpace().isUniqueSpace())) {
            return false;
        }
        if (vn1.getSpace().getType() != ConstTpl.const_type.spaceid) {
            return true;
        }
        if (vn2.getSpace().getType() != ConstTpl.const_type.spaceid) {
            return true;
        }
        AddrSpace spc = vn1.getSpace().getSpace();
        if (!spc.equals(vn2.getSpace().getSpace())) {
            return false;
        }
        if (vn2.getOffset().getType() != ConstTpl.const_type.real) {
            return true;
        }
        if (vn2.getSize().getType() != ConstTpl.const_type.real) {
            return true;
        }
        if (vn1.getOffset().getType() != ConstTpl.const_type.real) {
            return true;
        }
        if (vn1.getSize().getType() != ConstTpl.const_type.real) {
            return true;
        }
        long offset = vn1.getOffset().getReal();
        long size = vn1.getSize().getReal();
        long off = vn2.getOffset().getReal();
        if (off + vn2.getSize().getReal() - 1L < offset) {
            return false;
        }
        return off <= offset + size - 1L;
    }

    private boolean readWriteInterference(VarnodeTpl vn, OpTpl op, boolean checkread) {
        VarnodeTpl vn2;
        switch (op.getOpcode()) {
            case CPUI_CBRANCH: 
            case CPUI_LOAD: 
            case CPUI_STORE: 
            case CPUI_BRANCH: 
            case CPUI_BRANCHIND: 
            case CPUI_CALL: 
            case CPUI_CALLIND: 
            case CPUI_CALLOTHER: 
            case CPUI_RETURN: 
            case CPUI_MULTIEQUAL: 
            case CPUI_INDIRECT: 
            case CPUI_PTRSUB: 
            case CPUI_CAST: 
            case CPUI_PTRADD: {
                return true;
            }
        }
        if (checkread) {
            int numinputs = op.numInput();
            for (int i = 0; i < numinputs; ++i) {
                if (!ConsistencyChecker.possibleIntersection(vn, op.getIn(i))) continue;
                return true;
            }
        }
        return (vn2 = op.getOut()) != null && ConsistencyChecker.possibleIntersection(vn, vn2);
    }

    private void optimizeGather1(Constructor ct, UniqueState state, int secnum) {
        ConstructTpl tpl = secnum < 0 ? ct.getTempl() : ct.getNamedTempl(secnum);
        if (tpl == null) {
            return;
        }
        VectorSTL<OpTpl> ops = tpl.getOpvec();
        for (int i = 0; i < ops.size(); ++i) {
            OpTpl op = (OpTpl)ops.get(i);
            for (int j = 0; j < op.numInput(); ++j) {
                VarnodeTpl vnin = op.getIn(j);
                ConsistencyChecker.examineVn(state, vnin, i, j, secnum);
            }
            VarnodeTpl vn = op.getOut();
            ConsistencyChecker.examineVn(state, vn, i, -1, secnum);
        }
    }

    private void optimizeGather2(Constructor ct, UniqueState state, int secnum) {
        int size;
        long offset;
        ConstructTpl tpl = secnum < 0 ? ct.getTempl() : ct.getNamedTempl(secnum);
        if (tpl == null) {
            return;
        }
        HandleTpl hand = tpl.getResult();
        if (hand == null) {
            return;
        }
        if (hand.getPtrSpace().isUniqueSpace() && hand.getPtrOffset().getType() == ConstTpl.const_type.real) {
            offset = hand.getPtrOffset().getReal();
            size = (int)hand.getPtrSize().getReal();
            for (OptimizeRecord rec : state.getDefinitions(offset, size)) {
                rec.updateExport();
            }
        }
        if (hand.getSpace().isUniqueSpace() && hand.getPtrSpace().getType() == ConstTpl.const_type.real && hand.getPtrOffset().getType() == ConstTpl.const_type.real) {
            offset = hand.getPtrOffset().getReal();
            size = (int)hand.getPtrSize().getReal();
            for (OptimizeRecord rec : state.getDefinitions(offset, size)) {
                rec.updateExport();
            }
        }
    }

    private OptimizeRecord findValidRule(Constructor ct, UniqueState state) {
        for (Map.Entry ent : state.recs.entrySet()) {
            int i;
            VarnodeTpl vn;
            boolean saverecord;
            VarnodeTpl readvn;
            OptimizeRecord currec = (OptimizeRecord)ent.getValue();
            if (currec.writecount != 1 || currec.readcount != 1 || currec.readsection != currec.writesection) continue;
            ConstructTpl tpl = currec.readsection < 0 ? ct.getTempl() : ct.getNamedTempl(currec.readsection);
            VectorSTL<OpTpl> ops = tpl.getOpvec();
            OpTpl writeop = (OpTpl)ops.get(currec.writeop);
            OpTpl readop = (OpTpl)ops.get(currec.readop);
            if (currec.writeop >= currec.readop) {
                throw new SleighError("Read of temporary before write", ct.location);
            }
            VarnodeTpl writevn = writeop.getOut();
            if (!Objects.equals(writevn, readvn = readop.getIn(currec.inslot))) continue;
            if (readop.getOpcode() == OpCode.CPUI_COPY) {
                saverecord = true;
                currec.opttype = 0;
                vn = readop.getOut();
                for (i = currec.writeop + 1; i < currec.readop; ++i) {
                    if (!this.readWriteInterference(vn, (OpTpl)ops.get(i), true)) continue;
                    saverecord = false;
                    break;
                }
                if (saverecord) {
                    return currec;
                }
            }
            if (writeop.getOpcode() != OpCode.CPUI_COPY) continue;
            saverecord = true;
            currec.opttype = 1;
            vn = writeop.getIn(0);
            for (i = currec.writeop + 1; i < currec.readop; ++i) {
                if (!this.readWriteInterference(vn, (OpTpl)ops.get(i), false)) continue;
                saverecord = false;
                break;
            }
            if (!saverecord) continue;
            return currec;
        }
        return null;
    }

    private void applyOptimization(Constructor ct, OptimizeRecord rec) {
        VectorSTL deleteops = new VectorSTL();
        ConstructTpl ctempl = rec.readsection < 0 ? ct.getTempl() : ct.getNamedTempl(rec.readsection);
        if (rec.opttype == 0) {
            int readop = rec.readop;
            OpTpl op = (OpTpl)ctempl.getOpvec().get(readop);
            VarnodeTpl vnout = new VarnodeTpl(ct.location, op.getOut());
            ctempl.setOutput(vnout, rec.writeop);
            deleteops.push_back((Object)readop);
        } else if (rec.opttype == 1) {
            int writeop = rec.writeop;
            OpTpl op = (OpTpl)ctempl.getOpvec().get(writeop);
            VarnodeTpl vnin = new VarnodeTpl(ct.location, op.getIn(0));
            ctempl.setInput(vnin, rec.readop, rec.inslot);
            deleteops.push_back((Object)writeop);
        }
        ctempl.deleteOps((VectorSTL<Integer>)deleteops);
    }

    private void checkUnusedTemps(Constructor ct, UniqueState state) {
        for (OptimizeRecord currec : state.recs.values()) {
            if (currec.readcount == 0) {
                if (this.printdeadwarning) {
                    this.compiler.reportWarning(ct.location, "Temporary is written but not read");
                }
                ++this.writenoread;
                continue;
            }
            if (currec.writecount != 0) continue;
            this.compiler.reportError(ct.location, "Temporary is read but not written");
            ++this.readnowrite;
        }
    }

    private void checkLargeTemporaries(Constructor ct, ConstructTpl ctpl) {
        VectorSTL<OpTpl> ops = ctpl.getOpvec();
        IteratorSTL iter = ops.begin();
        while (!iter.isEnd()) {
            if (this.hasLargeTemporary((OpTpl)iter.get())) {
                this.compiler.reportError(ct.location, "Constructor uses temporary varnode larger than 256 bytes.");
                return;
            }
            iter.increment();
        }
    }

    private void optimize(Constructor ct) {
        OptimizeRecord currec;
        UniqueState state = new UniqueState();
        int numsections = ct.getNumSections();
        do {
            state.clear();
            for (int i = -1; i < numsections; ++i) {
                this.optimizeGather1(ct, state, i);
                this.optimizeGather2(ct, state, i);
            }
            currec = this.findValidRule(ct, state);
            if (currec == null) continue;
            this.applyOptimization(ct, currec);
        } while (currec != null);
        this.checkUnusedTemps(ct, state);
    }

    public ConsistencyChecker(SleighCompile cp, SubtableSymbol rt, boolean unnecessary, boolean warndead, boolean warnlargetemp) {
        this.compiler = cp;
        this.root_symbol = rt;
        this.unnecessarypcode = 0;
        this.readnowrite = 0;
        this.writenoread = 0;
        this.printextwarning = unnecessary;
        this.printdeadwarning = warndead;
    }

    public boolean testSizeRestrictions() {
        this.setPostOrder(this.root_symbol);
        boolean testresult = true;
        for (int i = 0; i < this.postorder.size(); ++i) {
            SubtableSymbol sym = this.postorder.get(i);
            if (this.checkSubtable(sym)) continue;
            testresult = false;
        }
        return testresult;
    }

    public boolean testTruncations() {
        boolean testresult = true;
        boolean isbigendian = this.compiler.isBigEndian();
        for (int i = 0; i < this.postorder.size(); ++i) {
            SubtableSymbol sym = this.postorder.get(i);
            int numconstruct = sym.getNumConstructors();
            for (int j = 0; j < numconstruct; ++j) {
                Constructor ct = sym.getConstructor(j);
                int numsections = ct.getNumSections();
                for (int k = -1; k < numsections; ++k) {
                    ConstructTpl tpl = k < 0 ? ct.getTempl() : ct.getNamedTempl(k);
                    if (tpl == null || this.checkSectionTruncations(ct, tpl, isbigendian)) continue;
                    testresult = false;
                }
            }
        }
        return testresult;
    }

    public void testLargeTemporary() {
        for (int i = 0; i < this.postorder.size(); ++i) {
            SubtableSymbol sym = this.postorder.get(i);
            int numconstruct = sym.getNumConstructors();
            for (int j = 0; j < numconstruct; ++j) {
                Constructor ct = sym.getConstructor(j);
                int numsections = ct.getNumSections();
                for (int k = -1; k < numsections; ++k) {
                    ConstructTpl tpl = k < 0 ? ct.getTempl() : ct.getNamedTempl(k);
                    if (tpl == null) continue;
                    this.checkLargeTemporaries(ct, tpl);
                }
            }
        }
    }

    public void optimizeAll() {
        for (int i = 0; i < this.postorder.size(); ++i) {
            SubtableSymbol sym = this.postorder.get(i);
            int numconstruct = sym.getNumConstructors();
            for (int j = 0; j < numconstruct; ++j) {
                Constructor ct = sym.getConstructor(j);
                this.optimize(ct);
            }
        }
    }

    public int getNumUnnecessaryPcode() {
        return this.unnecessarypcode;
    }

    public int getNumReadNoWrite() {
        return this.readnowrite;
    }

    public int getNumWriteNoRead() {
        return this.writenoread;
    }

    static class UniqueState {
        NavigableMap<Long, OptimizeRecord> recs = new TreeMap<Long, OptimizeRecord>();

        UniqueState() {
        }

        private static long endOf(Map.Entry<Long, OptimizeRecord> entry) {
            return entry.getKey() + (long)entry.getValue().size;
        }

        public void clear() {
            this.recs.clear();
        }

        private OptimizeRecord coalesce(List<OptimizeRecord> records) {
            long minOff = -1L;
            long maxOff = -1L;
            for (OptimizeRecord rec : records) {
                if (minOff == -1L || rec.offset < minOff) {
                    minOff = rec.offset;
                }
                if (maxOff != -1L && rec.offset + (long)rec.size <= maxOff) continue;
                maxOff = rec.offset + (long)rec.size;
            }
            OptimizeRecord result = new OptimizeRecord(minOff, (int)(maxOff - minOff));
            for (OptimizeRecord rec : records) {
                result.updateCombine(rec);
            }
            return result;
        }

        private void set(long offset, int size, OptimizeRecord rec) {
            List<OptimizeRecord> records = this.getDefinitions(offset, size);
            records.add(rec);
            OptimizeRecord coalesced = this.coalesce(records);
            this.recs.subMap(coalesced.offset, coalesced.offset + (long)coalesced.size).clear();
            this.recs.put(coalesced.offset, coalesced);
        }

        private List<OptimizeRecord> getDefinitions(long offset, int size) {
            if (size == 0) {
                size = 1;
            }
            ArrayList<OptimizeRecord> result = new ArrayList<OptimizeRecord>();
            Map.Entry<Long, OptimizeRecord> preEntry = this.recs.lowerEntry(offset);
            long cursor = offset;
            if (preEntry != null && UniqueState.endOf(preEntry) > offset) {
                OptimizeRecord preRec = preEntry.getValue();
                cursor = UniqueState.endOf(preEntry);
                result.add(preRec);
            }
            long end = offset + (long)size;
            HashMap<Long, OptimizeRecord> toPut = new HashMap<Long, OptimizeRecord>();
            for (Map.Entry<Long, OptimizeRecord> entry : this.recs.subMap(offset, end).entrySet()) {
                if (entry.getKey() > cursor) {
                    OptimizeRecord missing = new OptimizeRecord(cursor, (int)(entry.getKey() - cursor));
                    toPut.put(cursor, missing);
                    result.add(missing);
                }
                result.add(entry.getValue());
                cursor = UniqueState.endOf(entry);
            }
            if (end > cursor) {
                OptimizeRecord missing = new OptimizeRecord(cursor, (int)(end - cursor));
                toPut.put(cursor, missing);
                result.add(missing);
            }
            this.recs.putAll(toPut);
            assert (!result.isEmpty());
            return result;
        }
    }
}

