/************************************************************************
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the                        *
 * Free Software Foundation, Inc.,                                      *
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.             *
 ************************************************************************/

#ifndef __FCITX_MODULE_FCITX_XKB_API_H
#define __FCITX_MODULE_FCITX_XKB_API_H

#include <stdint.h>
#include <stdarg.h>
#include <fcitx-utils/utils.h>
#include <fcitx/instance.h>
#include <fcitx/addon.h>
#include <fcitx/module.h>
#include "xkb.h"

#ifdef __cplusplus
extern "C" {
#endif

DEFINE_GET_ADDON("fcitx-xkb", Xkb)

DEFINE_GET_AND_INVOKE_FUNC(Xkb, GetRules, 0)
static inline FcitxXkbRules*
FcitxXkbGetRules(FcitxInstance *instance)
{
    void *result = NULL;
    FCITX_DEF_MODULE_ARGS(args);
    result = FcitxXkbInvokeGetRules(instance, args);
    FCITX_RETURN_FROM_PTR(FcitxXkbRules*, result);
}

DEFINE_GET_AND_INVOKE_FUNC(Xkb, GetCurrentLayout, 1)
static inline void
FcitxXkbGetCurrentLayout(FcitxInstance *instance, char** _arg0, char** _arg1)
{
    FCITX_DEF_CAST_TO_PTR(arg0, char**, _arg0);
    FCITX_DEF_CAST_TO_PTR(arg1, char**, _arg1);
    FCITX_DEF_MODULE_ARGS(args, arg0, arg1);
    FcitxXkbInvokeGetCurrentLayout(instance, args);
}

DEFINE_GET_AND_INVOKE_FUNC(Xkb, LayoutExists, 2)
static inline void
FcitxXkbLayoutExists(FcitxInstance *instance, const char* _arg0, const char* _arg1, boolean* _arg2)
{
    FCITX_DEF_CAST_TO_PTR(arg0, const char*, _arg0);
    FCITX_DEF_CAST_TO_PTR(arg1, const char*, _arg1);
    FCITX_DEF_CAST_TO_PTR(arg2, boolean*, _arg2);
    FCITX_DEF_MODULE_ARGS(args, arg0, arg1, arg2);
    FcitxXkbInvokeLayoutExists(instance, args);
}

DEFINE_GET_AND_INVOKE_FUNC(Xkb, GetLayoutOverride, 3)
static inline void
FcitxXkbGetLayoutOverride(FcitxInstance *instance, const char* _arg0, char** _arg1, char** _arg2)
{
    FCITX_DEF_CAST_TO_PTR(arg0, const char*, _arg0);
    FCITX_DEF_CAST_TO_PTR(arg1, char**, _arg1);
    FCITX_DEF_CAST_TO_PTR(arg2, char**, _arg2);
    FCITX_DEF_MODULE_ARGS(args, arg0, arg1, arg2);
    FcitxXkbInvokeGetLayoutOverride(instance, args);
}

DEFINE_GET_AND_INVOKE_FUNC(Xkb, SetLayoutOverride, 4)
static inline void
FcitxXkbSetLayoutOverride(FcitxInstance *instance, const char* _arg0, const char* _arg1, const char* _arg2)
{
    FCITX_DEF_CAST_TO_PTR(arg0, const char*, _arg0);
    FCITX_DEF_CAST_TO_PTR(arg1, const char*, _arg1);
    FCITX_DEF_CAST_TO_PTR(arg2, const char*, _arg2);
    FCITX_DEF_MODULE_ARGS(args, arg0, arg1, arg2);
    FcitxXkbInvokeSetLayoutOverride(instance, args);
}

DEFINE_GET_AND_INVOKE_FUNC(Xkb, SetDefaultLayout, 5)
static inline void
FcitxXkbSetDefaultLayout(FcitxInstance *instance, const char* _arg0, const char* _arg1)
{
    FCITX_DEF_CAST_TO_PTR(arg0, const char*, _arg0);
    FCITX_DEF_CAST_TO_PTR(arg1, const char*, _arg1);
    FCITX_DEF_MODULE_ARGS(args, arg0, arg1);
    FcitxXkbInvokeSetDefaultLayout(instance, args);
}


#ifdef __cplusplus
}
#endif

#endif
