/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.erd;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.erd.ERDAssociation;
import org.jkiss.dbeaver.model.erd.ERDObject;
import org.jkiss.utils.CommonUtils;

public abstract class ERDElement<OBJECT>
extends ERDObject<OBJECT> {
    static final Log log = Log.getLog(ERDElement.class);
    private List<ERDAssociation> references;
    private List<ERDAssociation> associations;

    public ERDElement() {
        super(null);
    }

    public ERDElement(OBJECT entity) {
        super(entity);
    }

    public void addAssociation(ERDAssociation rel, boolean reflect) {
        if (this.associations == null) {
            this.associations = new ArrayList<ERDAssociation>();
        }
        this.associations.add(rel);
        if (reflect) {
            this.firePropertyChange("OUTPUT", null, rel);
        }
    }

    public void addReferenceAssociation(ERDAssociation table, boolean reflect) {
        if (this.references == null) {
            this.references = new ArrayList<ERDAssociation>();
        }
        this.references.add(table);
        if (reflect) {
            this.firePropertyChange("INPUT", null, table);
        }
    }

    public void removeAssociation(ERDAssociation table, boolean reflect) {
        this.associations.remove(table);
        if (reflect) {
            this.firePropertyChange("OUTPUT", table, null);
        }
    }

    public void removeReferenceAssociation(ERDAssociation table, boolean reflect) {
        this.references.remove(table);
        if (reflect) {
            this.firePropertyChange("INPUT", table, null);
        }
    }

    @NotNull
    public List<ERDAssociation> getAssociations() {
        return CommonUtils.safeList(this.associations);
    }

    @NotNull
    public List<ERDAssociation> getReferences() {
        return CommonUtils.safeList(this.references);
    }

    public boolean hasSelfLinks() {
        if (this.associations != null) {
            for (ERDAssociation association : this.associations) {
                if (association.getTargetEntity() != this) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasAssociationsWith(ERDElement entity) {
        if (this.associations != null) {
            for (ERDAssociation assoc : this.associations) {
                if (assoc.getTargetEntity() != entity) continue;
                return true;
            }
        }
        return false;
    }
}

