/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectPersistAction;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectType;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchemaObject;
import org.jkiss.dbeaver.ext.oracle.model.OracleSourceType;
import org.jkiss.dbeaver.ext.oracle.model.OracleUtils;
import org.jkiss.dbeaver.ext.oracle.model.source.OracleSourceObject;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectState;
import org.jkiss.utils.CommonUtils;

public class OracleJavaClass
extends OracleSchemaObject
implements OracleSourceObject,
DBPRefreshableObject {
    private final boolean isInner;
    private final boolean isAbstract;
    private final boolean isFinal;
    private final boolean isStatic;
    private final boolean isDebug;
    private final String sourceName;
    private final String superClass;
    private String sourceCode;
    private boolean isInterface;
    private Accessibility accessibility;

    protected OracleJavaClass(OracleSchema schema, ResultSet dbResult) {
        super(schema, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"NAME"), true);
        this.isInterface = "INTERFACE".equals(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"KIND"));
        this.accessibility = (Accessibility)CommonUtils.valueOf(Accessibility.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ACCESSIBILITY"));
        this.isInner = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"IS_INNER", (String)"YES");
        this.isAbstract = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"IS_ABSTRACT", (String)"YES");
        this.isFinal = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"IS_FINAL", (String)"YES");
        this.isStatic = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"IS_STATIC", (String)"YES");
        this.isDebug = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"IS_DEBUG", (String)"YES");
        this.sourceName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"NAME");
        this.superClass = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SUPER");
    }

    @Property(viewable=true, order=2)
    public Accessibility getAccessibility() {
        return this.accessibility;
    }

    @Property(viewable=true, order=3)
    public boolean isInterface() {
        return this.isInterface;
    }

    @Property(viewable=false, order=10)
    public boolean isInner() {
        return this.isInner;
    }

    @Property(viewable=true, order=11)
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Property(viewable=true, order=12)
    public boolean isFinal() {
        return this.isFinal;
    }

    @Property(viewable=true, order=13)
    public boolean isStatic() {
        return this.isStatic;
    }

    @Property(viewable=false, order=14)
    public boolean isDebug() {
        return this.isDebug;
    }

    @Property(viewable=true, order=15)
    public String getSuperClass() {
        return this.superClass;
    }

    @Override
    public OracleSourceType getSourceType() {
        return OracleSourceType.JAVA_SOURCE;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    @Override
    public DBEPersistAction[] getCompileActions(DBRProgressMonitor monitor) {
        return new DBEPersistAction[]{new OracleObjectPersistAction(OracleObjectType.JAVA_CLASS, "Compile Java class", "ALTER JAVA CLASS " + this.getFullyQualifiedName(DBPEvaluationContext.DDL) + " COMPILE")};
    }

    @NotNull
    public DBSObjectState getObjectState() {
        return DBSObjectState.NORMAL;
    }

    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) throws DBCException {
    }

    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
        if (this.sourceCode != null) {
            return this.sourceCode;
        }
        if (CommonUtils.isEmpty((String)this.sourceName)) {
            return "-- Source unavailable for " + this.getName();
        }
        this.sourceCode = OracleUtils.getSource(monitor, this, false, false);
        if (CommonUtils.isEmpty((String)this.sourceCode)) {
            this.sourceCode = "-- No source code found for Java class " + this.getName();
        }
        return this.sourceCode;
    }

    public void setObjectDefinitionText(String source) {
        this.sourceCode = source;
    }

    @Nullable
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.sourceCode = null;
        return this;
    }

    public static enum Accessibility {
        PUBLIC,
        PRIVATE,
        PROTECTED;

    }
}

