/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.dpi.model.client;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;

public class ConfigUtils {
    public static void storeProperties(BufferedWriter bw, @NotNull Map<String, String> properties) throws IOException {
        for (Map.Entry<String, String> e : properties.entrySet()) {
            String key = e.getKey();
            String val = e.getValue();
            bw.write(key + "=" + val);
            bw.newLine();
        }
        bw.flush();
    }

    @NotNull
    public static Map<String, String> readPropertiesFromFile(Path serverConfigFile) throws IOException {
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader br = Files.newBufferedReader(serverConfigFile);){
            br.lines().forEach(s -> {
                String[] lineValue = s.split("=");
                if (lineValue.length == 2) {
                    props.put(lineValue[0], lineValue[1]);
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return props;
    }
}

